# generated by datamodel-codegen:
#   filename:  configuration/aiPlatformConfiguration.json
#   timestamp: 2025-10-09T02:40:53+00:00

from __future__ import annotations

from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel


class GrpcConfiguration(BaseModel):
    port: Annotated[int, Field(description='Host for the gRPC server')]
    maxInboundMessageSize: Annotated[
        Optional[int], Field(None, description='Port for the gRPC server')
    ]
    keepAliveTime: Annotated[
        Optional[int], Field(None, description='Keep alive time for the gRPC server')
    ]
    keepAliveTimeout: Annotated[
        Optional[int], Field(None, description='Keep alive timeout for the gRPC server')
    ]


class AiPlatformConfiguration(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    enabled: Annotated[
        Optional[bool],
        Field(False, description='Indicates whether the AI Platform is enabled'),
    ]
    host: Annotated[str, Field(description='Host for the AI Platform server')]
    port: Annotated[int, Field(description='Port for the AI Platform server')]
    tlsCertPath: Annotated[
        Optional[str],
        Field(
            None, description='Path to the TLS certificate for the AI Platform server'
        ),
    ]
    tlsKeyPath: Annotated[
        Optional[str],
        Field(None, description='Path to the TLS key for the AI Platform server'),
    ]
    trustedCertsPath: Annotated[
        Optional[str],
        Field(
            None,
            description='Path to the trusted CA certificate for the AI Platform server',
        ),
    ]
    grpc: Annotated[
        GrpcConfiguration,
        Field(description='gRPC configuration for the AI Platform server'),
    ]
