# generated by datamodel-codegen:
#   filename:  dataInsight/custom/summaryCard.json
#   timestamp: 2025-10-09T02:40:53+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from . import dataInsightCustomChart


class Type(Enum):
    SummaryCard = 'SummaryCard'


class Metrics(BaseModel):
    name: Annotated[
        Optional[str],
        Field(None, description='Name of the metric for the data insight chart.'),
    ]
    function: Optional[dataInsightCustomChart.Function] = None
    field: Annotated[
        Optional[str],
        Field(None, description='Filter field for the data insight chart.'),
    ]
    filter: Annotated[
        Optional[str],
        Field(None, description='Filter value for the data insight chart.'),
    ]
    treeFilter: Annotated[
        Optional[str],
        Field(
            None,
            description='Tree filter value for the data insight chart. Needed for UI to recreate advance filter tree.',
        ),
    ]
    formula: Annotated[
        Optional[str],
        Field(None, description='Formula for the data insight chart calculation.'),
    ]


class SummaryCard(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[Type],
        Field(Type.SummaryCard, description='Type of the data insight chart.'),
    ]
    metrics: Annotated[
        Optional[List[Metrics]],
        Field(None, description='Metrics for the data insight chart.'),
    ]
