# generated by datamodel-codegen:
#   filename:  dataInsight/dataInsightChart.json
#   timestamp: 2025-10-09T02:40:53+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ..type import basic, entityHistory, entityReferenceList


class ChartDataType(Enum):
    NUMBER = 'NUMBER'
    INT = 'INT'
    FLOAT = 'FLOAT'
    DOUBLE = 'DOUBLE'
    DECIMAL = 'DECIMAL'
    TIMESTAMP = 'TIMESTAMP'
    TIME = 'TIME'
    DATE = 'DATE'
    DATETIME = 'DATETIME'
    ARRAY = 'ARRAY'
    MAP = 'MAP'
    SET = 'SET'
    STRING = 'STRING'
    BOOLEAN = 'BOOLEAN'
    PERCENTAGE = 'PERCENTAGE'


class ChartParameterValues(BaseModel):
    name: Annotated[Optional[str], Field(None, description='name of the parameter.')]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this parameter name.'),
    ]
    chartDataType: Annotated[
        Optional[ChartDataType],
        Field(None, description='Data type of the parameter (int, date etc.).'),
    ]


class DataReportIndex(Enum):
    entity_report_data_index = 'entity_report_data_index'
    web_analytic_entity_view_report_data_index = (
        'web_analytic_entity_view_report_data_index'
    )
    web_analytic_user_activity_report_data_index = (
        'web_analytic_user_activity_report_data_index'
    )
    raw_cost_analysis_report_data_index = 'raw_cost_analysis_report_data_index'
    aggregated_cost_analysis_report_data_index = (
        'aggregated_cost_analysis_report_data_index'
    )


class DataInsightChart(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        Optional[basic.Uuid],
        Field(None, description='Unique identifier of this table instance.'),
    ]
    name: Annotated[
        basic.EntityName,
        Field(description='Name that identifies this data insight chart.'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(
            None, description='Display Name that identifies this data insight chart.'
        ),
    ]
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(None, description='FullyQualifiedName same as `name`.'),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of the data insight chart.'),
    ]
    dataIndexType: Optional[DataReportIndex] = None
    dimensions: Optional[List[ChartParameterValues]] = None
    metrics: Optional[List[ChartParameterValues]] = None
    version: Annotated[
        Optional[entityHistory.EntityVersion],
        Field(None, description='Metadata version of the entity.'),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this Pipeline.'),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    href: Annotated[
        Optional[basic.Href],
        Field(None, description='Link to the resource corresponding to this entity.'),
    ]
    changeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    incrementalChangeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    deleted: Annotated[
        Optional[bool],
        Field(
            False, description='When `true` indicates the entity has been soft deleted.'
        ),
    ]
    domains: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(
            None,
            description='Domains the asset belongs to. When not set, the asset inherits the domain from the parent it belongs to.',
        ),
    ]
