# generated by datamodel-codegen:
#   filename:  entity/applications/configuration/external/automator/lineagePropagationAction.json
#   timestamp: 2025-10-09T02:40:53+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from . import propagationStopConfig


class LineagePropagationActionType(Enum):
    LineagePropagationAction = 'LineagePropagationAction'


class LineagePropagationAction(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        LineagePropagationActionType,
        Field(description='Application Type', title='Application Type'),
    ]
    propagateDescription: Annotated[
        Optional[bool],
        Field(
            True,
            description='Propagate description through lineage',
            title='Propagate Description',
        ),
    ]
    propagateTags: Annotated[
        Optional[bool],
        Field(
            True, description='Propagate tags through lineage', title='Propagate Tags'
        ),
    ]
    propagateGlossaryTerms: Annotated[
        Optional[bool],
        Field(
            True,
            description='Propagate glossary terms through lineage',
            title='Propagate Glossary Terms',
        ),
    ]
    propagateTier: Annotated[
        Optional[bool],
        Field(
            False, description='Propagate tier from the parent', title='Propagate Tier'
        ),
    ]
    propagateDomains: Annotated[
        Optional[bool],
        Field(
            False,
            description='Propagate domains from the parent through lineage',
            title='Propagate Domains',
        ),
    ]
    propagateOwner: Annotated[
        Optional[bool],
        Field(
            False,
            description='Propagate owner from the parent',
            title='Propagate Owner',
        ),
    ]
    propagateColumnLevel: Annotated[
        Optional[bool],
        Field(
            True,
            description='Propagate the metadata to columns via column-level lineage.',
            title='Propagate Column Level',
        ),
    ]
    propagateParent: Annotated[
        Optional[bool],
        Field(
            False,
            description='Propagate the metadata to the parents (e.g., tables) via lineage.',
            title='Propagate Parent',
        ),
    ]
    overwriteMetadata: Annotated[
        Optional[bool],
        Field(
            False,
            description='Update descriptions, tags and Glossary Terms via lineage even if they are already defined in the asset. By default, descriptions are only updated if they are not already defined in the asset, and incoming tags are merged with the existing ones.',
            title='Overwrite Metadata',
        ),
    ]
    propagationDepth: Annotated[
        Optional[int],
        Field(
            None,
            description='Number of levels to propagate lineage. If not set, it will propagate to all levels.',
            title='Propagation Depth',
        ),
    ]
    propagationStopConfigs: Annotated[
        Optional[List[propagationStopConfig.PropagationStopConfig]],
        Field(
            None,
            description='List of configurations to stop propagation based on conditions',
            title='Propagation Stop Configurations',
        ),
    ]
