# generated by datamodel-codegen:
#   filename:  entity/applications/configuration/external/metadataExporterConnectors/databricksConnection.json
#   timestamp: 2025-10-09T02:40:53+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .....services.connections import connectionBasicType


class DatabricksType(Enum):
    Databricks = 'Databricks'


class DatabricksScheme(Enum):
    databricks_connector = 'databricks+connector'


class DatabricksConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[DatabricksType],
        Field(
            DatabricksType.Databricks, description='Service Type', title='Service Type'
        ),
    ]
    scheme: Annotated[
        Optional[DatabricksScheme],
        Field(
            DatabricksScheme.databricks_connector,
            description='SQLAlchemy driver scheme options.',
            title='Connection Scheme',
        ),
    ]
    hostPort: Annotated[
        str,
        Field(
            description='Host and port of the Databricks service.',
            title='Host and Port',
        ),
    ]
    token: Annotated[
        CustomSecretStr,
        Field(description='Generated Token to connect to Databricks.', title='Token'),
    ]
    httpPath: Annotated[
        str, Field(description='Databricks compute resources URL.', title='Http Path')
    ]
    catalog: Annotated[
        Optional[str],
        Field(
            None,
            description='Catalog of the data source(Example: hive_metastore). This is optional parameter, if you would like to restrict the metadata reading to a single catalog. When left blank, OpenMetadata Ingestion attempts to scan all the catalog.',
            title='Catalog',
        ),
    ]
    databaseSchema: Annotated[
        Optional[str],
        Field(
            None,
            description='Database Schema of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single schema. When left blank, OpenMetadata Ingestion attempts to scan all the schemas.',
            title='Database Schema',
        ),
    ]
    connectionTimeout: Annotated[
        Optional[int],
        Field(
            120,
            description='The maximum amount of time (in seconds) to wait for a successful connection to the data source. If the connection attempt takes longer than this timeout period, an error will be returned.',
            title='Connection Timeout',
        ),
    ]
    connectionOptions: Annotated[
        Optional[connectionBasicType.ConnectionOptions],
        Field(None, title='Connection Options'),
    ]
    connectionArguments: Annotated[
        Optional[connectionBasicType.ConnectionArguments],
        Field(None, title='Connection Arguments'),
    ]
