# generated by datamodel-codegen:
#   filename:  entity/data/dashboardDataModel.json
#   timestamp: 2025-10-09T02:40:53+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import (
    assetCertification,
    basic,
    entityHistory,
    entityReference,
    entityReferenceList,
    lifeCycle,
    tagLabel,
    votes,
)
from ..services import dashboardService
from . import table


class DataModelType(Enum):
    TableauDataModel = 'TableauDataModel'
    TableauPublishedDatasource = 'TableauPublishedDatasource'
    TableauEmbeddedDatasource = 'TableauEmbeddedDatasource'
    SupersetDataModel = 'SupersetDataModel'
    MetabaseDataModel = 'MetabaseDataModel'
    LookMlView = 'LookMlView'
    LookMlExplore = 'LookMlExplore'
    PowerBIDataModel = 'PowerBIDataModel'
    QlikDataModel = 'QlikDataModel'
    QuickSightDataModel = 'QuickSightDataModel'
    SigmaDataModel = 'SigmaDataModel'
    PowerBIDataFlow = 'PowerBIDataFlow'
    MicroStrategyDataset = 'MicroStrategyDataset'
    ThoughtSpotDataModel = 'ThoughtSpotDataModel'


class DashboardDataModel(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        basic.Uuid, Field(description='Unique identifier of this data model instance.')
    ]
    name: Annotated[
        basic.EntityName,
        Field(
            description='Name of a data model. Expected to be unique within a Dashboard.'
        ),
    ]
    displayName: Annotated[
        Optional[str],
        Field(
            None,
            description='Display Name that identifies this data model. It could be title or label from the source.',
        ),
    ]
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(
            None,
            description='Fully qualified name of a data model in the form `serviceName.dashboardName.datamodel.datamodelName`.',
        ),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of a data model.'),
    ]
    version: Annotated[
        Optional[entityHistory.EntityVersion],
        Field(None, description='Metadata version of the entity.'),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    href: Annotated[
        Optional[basic.Href], Field(None, description='Link to this data model entity.')
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this data model.'),
    ]
    dataProducts: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='List of data products this entity is part of.'),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field([], description='Tags for this data model.'),
    ]
    changeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    incrementalChangeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    deleted: Annotated[
        Optional[bool],
        Field(
            False, description='When `true` indicates the entity has been soft deleted.'
        ),
    ]
    followers: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Followers of this dashboard.'),
    ]
    service: Annotated[
        Optional[entityReference.EntityReference],
        Field(None, description='Link to service where this data model is hosted in.'),
    ]
    serviceType: Annotated[
        Optional[dashboardService.DashboardServiceType],
        Field(None, description='Service type where this data model is hosted in.'),
    ]
    dataModelType: DataModelType
    sql: Annotated[
        Optional[basic.SqlQuery],
        Field(None, description='In case the Data Model is based on a SQL query.'),
    ]
    columns: Annotated[
        List[table.Column], Field(description='Columns from the data model.')
    ]
    project: Annotated[
        Optional[str],
        Field(
            None,
            description='Name of the project / workspace / collection in which the dataModel is contained',
        ),
    ]
    domains: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(
            None,
            description='Domains the Dashboard Data Model belongs to. When not set, the Dashboard model inherits the domain from the dashboard service it belongs to.',
        ),
    ]
    votes: Annotated[
        Optional[votes.Votes], Field(None, description='Votes on the entity.')
    ]
    lifeCycle: Annotated[
        Optional[lifeCycle.LifeCycle],
        Field(None, description='Life Cycle properties of the entity'),
    ]
    certification: Optional[assetCertification.AssetCertification] = None
    sourceHash: Annotated[
        Optional[str],
        Field(
            None, description='Source hash of the entity', max_length=32, min_length=1
        ),
    ]
    extension: Annotated[
        Optional[basic.EntityExtension],
        Field(
            None,
            description='Entity extension data with custom attributes added to the entity.',
        ),
    ]
