# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/cassandra/cloudConfig.json
#   timestamp: 2025-10-09T02:40:53+00:00

from __future__ import annotations

from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel


class CloudConfig1(BaseModel):
    connectTimeout: Annotated[
        Optional[int],
        Field(
            None,
            description='Timeout in seconds for establishing new connections to Cassandra.',
            title='Connect Timeout',
        ),
    ]
    requestTimeout: Annotated[
        Optional[int],
        Field(
            None,
            description='Timeout in seconds for individual Cassandra requests.',
            title='Request Timeout',
        ),
    ]
    token: Annotated[
        Optional[str],
        Field(
            None,
            description='The Astra DB application token used for authentication.',
            title='Token',
        ),
    ]
    secureConnectBundle: Annotated[
        Optional[str],
        Field(
            None,
            description='File path to the Secure Connect Bundle (.zip) used for a secure connection to DataStax Astra DB.',
            title='Secure Connect Bundle',
        ),
    ]


class CloudConfig(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    cloudConfig: Annotated[
        Optional[CloudConfig1],
        Field(
            None,
            description='Configuration for connecting to DataStax Astra DB in the cloud.',
            title='DataStax Astra DB Configuration',
        ),
    ]
