# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/mysqlConnection.json
#   timestamp: 2025-10-09T02:40:53+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from .....security.ssl import verifySSLConfig
from .....type import filterPattern
from .. import connectionBasicType
from .common import azureConfig, basicAuth, iamAuthConfig


class MySQLType(Enum):
    Mysql = 'Mysql'


class MySQLScheme(Enum):
    mysql_pymysql = 'mysql+pymysql'


class MysqlConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[MySQLType],
        Field(MySQLType.Mysql, description='Service Type', title='Service Type'),
    ]
    scheme: Annotated[
        Optional[MySQLScheme],
        Field(
            MySQLScheme.mysql_pymysql,
            description='SQLAlchemy driver scheme options.',
            title='Connection Scheme',
        ),
    ]
    username: Annotated[
        str,
        Field(
            description='Username to connect to MySQL. This user should have privileges to read all the metadata in Mysql.',
            title='Username',
        ),
    ]
    authType: Annotated[
        Optional[
            Union[
                basicAuth.BasicAuth,
                iamAuthConfig.IamAuthConfigurationSource,
                azureConfig.AzureConfigurationSource,
            ]
        ],
        Field(
            None,
            description='Choose Auth Config Type.',
            title='Auth Configuration Type',
        ),
    ]
    hostPort: Annotated[
        str,
        Field(description='Host and port of the MySQL service.', title='Host and Port'),
    ]
    databaseName: Annotated[
        Optional[str],
        Field(
            None,
            description='Optional name to give to the database in OpenMetadata. If left blank, we will use default as the database name.',
            title='Database Name',
        ),
    ]
    databaseSchema: Annotated[
        Optional[str],
        Field(
            None,
            description='Database Schema of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single schema. When left blank, OpenMetadata Ingestion attempts to scan all the schemas.',
            title='Database Schema',
        ),
    ]
    sslConfig: Annotated[
        Optional[verifySSLConfig.SslConfig],
        Field(None, description='SSL Configuration details.', title='SSL'),
    ]
    connectionOptions: Annotated[
        Optional[connectionBasicType.ConnectionOptions],
        Field(None, title='Connection Options'),
    ]
    connectionArguments: Annotated[
        Optional[connectionBasicType.ConnectionArguments],
        Field(None, title='Connection Arguments'),
    ]
    schemaFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            {
                'includes': [],
                'excludes': ['^information_schema$', '^performance_schema$'],
            },
            description='Regex to only include/exclude schemas that matches the pattern.',
            title='Default Schema Filter Pattern',
        ),
    ]
    tableFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude tables that matches the pattern.',
            title='Default Table Filter Pattern',
        ),
    ]
    databaseFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude databases that matches the pattern.',
            title='Default Database Filter Pattern',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
    supportsDBTExtraction: Optional[connectionBasicType.SupportsDBTExtraction] = None
    supportsProfiler: Annotated[
        Optional[connectionBasicType.SupportsProfiler],
        Field(None, title='Supports Profiler'),
    ]
    supportsQueryComment: Annotated[
        Optional[connectionBasicType.SupportsQueryComment],
        Field(None, title='Supports Query Comment'),
    ]
    sampleDataStorageConfig: Annotated[
        Optional[connectionBasicType.SampleDataStorageConfig],
        Field(None, title='Storage Config for Sample Data'),
    ]
    supportsDataDiff: Annotated[
        Optional[connectionBasicType.SupportsDataDiff],
        Field(None, title='Supports Data Diff Extraction.'),
    ]
    supportsUsageExtraction: Optional[
        connectionBasicType.SupportsUsageExtraction
    ] = None
    supportsLineageExtraction: Optional[
        connectionBasicType.SupportsLineageExtraction
    ] = None
    useSlowLogs: Annotated[
        Optional[bool],
        Field(
            False,
            description='Use slow logs to extract lineage.',
            title='Use Slow Logs for Lineage',
        ),
    ]
