# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/synapseConnection.json
#   timestamp: 2025-10-09T02:40:53+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .....type import filterPattern
from .. import connectionBasicType


class Authentication(Enum):
    ActiveDirectoryIntegrated = 'ActiveDirectoryIntegrated'
    ActiveDirectoryPassword = 'ActiveDirectoryPassword'
    ActiveDirectoryServicePrincipal = 'ActiveDirectoryServicePrincipal'


class AuthenticationMode(BaseModel):
    authentication: Annotated[
        Optional[Authentication],
        Field(
            None,
            description='Authentication from Connection String for Azure Synapse.',
            title='Authentication',
        ),
    ]
    encrypt: Annotated[
        Optional[bool],
        Field(
            None,
            description='Encrypt from Connection String for Azure Synapse.',
            title='Encrypt',
        ),
    ]
    trustServerCertificate: Annotated[
        Optional[bool],
        Field(
            None,
            description='Trust Server Certificate from Connection String for Azure Synapse.',
            title='Trust Server Certificate',
        ),
    ]
    connectionTimeout: Annotated[
        Optional[int],
        Field(
            30,
            description='Connection Timeout from Connection String for Azure Synapse.',
            title='Connection Timeout',
        ),
    ]


class SynapseType(Enum):
    Synapse = 'Synapse'


class SynapseScheme(Enum):
    mssql_pyodbc = 'mssql+pyodbc'


class SynapseConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[SynapseType],
        Field(SynapseType.Synapse, description='Service Type', title='Service Type'),
    ]
    scheme: Annotated[
        Optional[SynapseScheme],
        Field(
            SynapseScheme.mssql_pyodbc,
            description='SQLAlchemy driver scheme options.',
            title='Connection Scheme',
        ),
    ]
    username: Annotated[
        Optional[str],
        Field(
            None,
            description='Username to connect to Azure Synapse. This user should have privileges to read all the metadata in Azure Synapse.',
            title='Username',
        ),
    ]
    password: Annotated[
        Optional[CustomSecretStr],
        Field(
            None, description='Password to connect to Azure Synapse.', title='Password'
        ),
    ]
    hostPort: Annotated[
        str,
        Field(
            description='Host and port of the Azure Synapse service.',
            title='Host and Port',
        ),
    ]
    database: Annotated[
        str,
        Field(
            description='Database of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single database. When left blank, OpenMetadata Ingestion attempts to scan all the databases.',
            title='Database',
        ),
    ]
    driver: Annotated[
        Optional[str],
        Field(
            'ODBC Driver 18 for SQL Server',
            description='ODBC driver version in case of pyodbc connection.',
            title='Driver',
        ),
    ]
    clientId: Annotated[
        Optional[str],
        Field(
            None,
            description='Azure Application (client) ID for service principal authentication.',
            title='Client ID',
        ),
    ]
    clientSecret: Annotated[
        Optional[CustomSecretStr],
        Field(
            None,
            description='Azure Application client secret for service principal authentication.',
            title='Client Secret',
        ),
    ]
    tenantId: Annotated[
        Optional[str],
        Field(
            None,
            description='Azure Directory (tenant) ID for service principal authentication.',
            title='Tenant ID',
        ),
    ]
    authenticationMode: Annotated[
        Optional[AuthenticationMode],
        Field(
            None,
            description="This parameter determines the mode of authentication for connecting to Azure Synapse using ODBC. If 'Active Directory Password' is selected, you need to provide the password. If 'Active Directory Integrated' is selected, password is not required as it uses the logged-in user's credentials. If 'Active Directory Service Principal' is selected, you need to provide clientId, clientSecret and tenantId. This mode is useful for establishing secure and seamless connections with Azure Synapse.",
            title='Authentication Mode',
        ),
    ]
    ingestAllDatabases: Annotated[
        Optional[bool],
        Field(
            False,
            description='Ingest data from all databases in Azure Synapse. You can use databaseFilterPattern on top of this.',
            title='Ingest All Databases',
        ),
    ]
    connectionOptions: Annotated[
        Optional[connectionBasicType.ConnectionOptions],
        Field(None, title='Connection Options'),
    ]
    connectionArguments: Annotated[
        Optional[connectionBasicType.ConnectionArguments],
        Field(None, title='Connection Arguments'),
    ]
    schemaFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude schemas that matches the pattern.',
            title='Default Schema Filter Pattern',
        ),
    ]
    tableFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude tables that matches the pattern.',
            title='Default Table Filter Pattern',
        ),
    ]
    databaseFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude databases that matches the pattern.',
            title='Default Database Filter Pattern',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
    supportsDBTExtraction: Optional[connectionBasicType.SupportsDBTExtraction] = None
    supportsProfiler: Annotated[
        Optional[connectionBasicType.SupportsProfiler],
        Field(None, title='Supports Profiler'),
    ]
    supportsDatabase: Annotated[
        Optional[connectionBasicType.SupportsDatabase],
        Field(None, title='Supports Database'),
    ]
    supportsUsageExtraction: Optional[
        connectionBasicType.SupportsUsageExtraction
    ] = None
    supportsLineageExtraction: Optional[
        connectionBasicType.SupportsLineageExtraction
    ] = None
    sampleDataStorageConfig: Annotated[
        Optional[connectionBasicType.SampleDataStorageConfig],
        Field(None, title='Storage Config for Sample Data'),
    ]
    supportsQueryComment: Annotated[
        Optional[connectionBasicType.SupportsQueryComment],
        Field(None, title='Supports Query Comment'),
    ]
