# generated by datamodel-codegen:
#   filename:  entity/services/connections/messaging/customMessagingConnection.json
#   timestamp: 2025-10-09T02:40:53+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from .....type import filterPattern
from .. import connectionBasicType


class CustomMessagingType(Enum):
    CustomMessaging = 'CustomMessaging'


class CustomMessagingConnection(BaseModel):
    model_config = ConfigDict(
        extra='allow',
    )
    type: Annotated[
        CustomMessagingType,
        Field(description='Custom messaging service type', title='Service Type'),
    ]
    sourcePythonClass: Annotated[
        Optional[str],
        Field(
            None,
            description='Source Python Class Name to instantiated by the ingestion workflow',
            title='Source Python Class Name',
        ),
    ]
    connectionOptions: Annotated[
        Optional[connectionBasicType.ConnectionOptions],
        Field(None, title='Connection Options'),
    ]
    topicFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only fetch topics that matches the pattern.',
            title='Default Topic Filter Pattern',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
