# generated by datamodel-codegen:
#   filename:  entity/services/connections/pipeline/domoPipelineConnection.json
#   timestamp: 2025-10-09T02:40:53+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .....type import filterPattern
from .. import connectionBasicType


class DomoPipelineType(Enum):
    DomoPipeline = 'DomoPipeline'


class DomoPipelineConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[DomoPipelineType],
        Field(
            DomoPipelineType.DomoPipeline,
            description='Service Type',
            title='Service Type',
        ),
    ]
    clientId: Annotated[str, Field(description='Client ID for DOMO', title='Client ID')]
    secretToken: Annotated[
        CustomSecretStr,
        Field(description='Secret token to connect to DOMO', title='Secret Token'),
    ]
    accessToken: Annotated[
        Optional[str],
        Field(
            None, description='Access token to connect to DOMO', title='Access Token'
        ),
    ]
    apiHost: Annotated[
        Optional[str],
        Field(
            'api.domo.com',
            description='API Host to connect to DOMO instance',
            title='API Host',
        ),
    ]
    instanceDomain: Annotated[
        AnyUrl,
        Field(
            description='URL of your Domo instance, e.g., https://openmetadata.domo.com',
            title='Instance Domain',
        ),
    ]
    pipelineFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex exclude pipelines.',
            title='Default Pipeline Filter Pattern',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
