# generated by datamodel-codegen:
#   filename:  entity/services/connections/pipeline/openLineageConnection.json
#   timestamp: 2025-10-09T02:40:53+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from .....security.sasl import saslClientConfig
from .....security.ssl import verifySSLConfig
from .....type import filterPattern
from .. import connectionBasicType


class ConsumerOffsets(Enum):
    earliest = 'earliest'
    latest = 'latest'


class SecurityProtocol(Enum):
    PLAINTEXT = 'PLAINTEXT'
    SSL = 'SSL'
    SASL_SSL = 'SASL_SSL'


class OpenLineageType(Enum):
    OpenLineage = 'OpenLineage'


class OpenLineageConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[OpenLineageType],
        Field(OpenLineageType.OpenLineage, description='Service Type'),
    ]
    brokersUrl: Annotated[
        Optional[str],
        Field(
            None,
            description='service type of the messaging source',
            title='Kafka brokers list',
        ),
    ]
    topicName: Annotated[
        Optional[str],
        Field(
            None,
            description='topic from where Open lineage events will be pulled ',
            title='Topic Name',
        ),
    ]
    consumerGroupName: Annotated[
        Optional[str],
        Field(None, description='consumer group name ', title='Consumer Group'),
    ]
    consumerOffsets: Annotated[
        Optional[ConsumerOffsets],
        Field(
            ConsumerOffsets.earliest,
            description='initial Kafka consumer offset',
            title='Initial consumer offsets',
        ),
    ]
    poolTimeout: Annotated[
        Optional[float],
        Field(
            1.0, description='max allowed wait time', title='Single pool call timeout'
        ),
    ]
    sessionTimeout: Annotated[
        Optional[int],
        Field(
            30,
            description='max allowed inactivity time',
            title='Broker inactive session timeout',
        ),
    ]
    securityProtocol: Annotated[
        Optional[SecurityProtocol],
        Field(
            SecurityProtocol.PLAINTEXT,
            description='Kafka security protocol config',
            title='Kafka security protocol',
        ),
    ]
    sslConfig: Annotated[
        Optional[verifySSLConfig.SslConfig],
        Field(None, description='SSL Configuration details.', title='SSL'),
    ]
    saslConfig: Annotated[
        Optional[saslClientConfig.SaslClientConfig],
        Field(None, description='SASL Configuration details.', title='SASL'),
    ]
    pipelineFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex exclude pipelines.',
            title='Default Pipeline Filter Pattern',
        ),
    ]
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = None
