# generated by datamodel-codegen:
#   filename:  entity/services/dashboardService.json
#   timestamp: 2025-10-09T02:40:53+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Union

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import basic, entityHistory, entityReference, entityReferenceList, tagLabel
from .connections import testConnectionResult
from .connections.dashboard import (
    customDashboardConnection,
    domoDashboardConnection,
    grafanaConnection,
    lightdashConnection,
    lookerConnection,
    metabaseConnection,
    microStrategyConnection,
    modeConnection,
    powerBIConnection,
    powerBIReportServerConnection,
    qlikCloudConnection,
    qlikSenseConnection,
    quickSightConnection,
    redashConnection,
    sigmaConnection,
    supersetConnection,
    tableauConnection,
    thoughtSpotConnection,
)


class DashboardServiceType(Enum):
    Superset = 'Superset'
    Looker = 'Looker'
    Tableau = 'Tableau'
    Redash = 'Redash'
    Metabase = 'Metabase'
    PowerBI = 'PowerBI'
    PowerBIReportServer = 'PowerBIReportServer'
    Mode = 'Mode'
    CustomDashboard = 'CustomDashboard'
    DomoDashboard = 'DomoDashboard'
    QuickSight = 'QuickSight'
    QlikSense = 'QlikSense'
    Lightdash = 'Lightdash'
    MicroStrategy = 'MicroStrategy'
    QlikCloud = 'QlikCloud'
    Sigma = 'Sigma'
    ThoughtSpot = 'ThoughtSpot'
    Grafana = 'Grafana'


class DashboardConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    config: Optional[
        Union[
            lookerConnection.LookerConnection,
            metabaseConnection.MetabaseConnection,
            powerBIConnection.PowerBIConnection,
            powerBIReportServerConnection.PowerBIReportServerConnection,
            redashConnection.RedashConnection,
            supersetConnection.SupersetConnection,
            tableauConnection.TableauConnection,
            modeConnection.ModeConnection,
            customDashboardConnection.CustomDashboardConnection,
            domoDashboardConnection.DomoDashboardConnection,
            quickSightConnection.QuickSightConnection,
            qlikSenseConnection.QlikSenseConnection,
            lightdashConnection.LightdashConnection,
            microStrategyConnection.MicroStrategyConnection,
            qlikCloudConnection.QlikCloudConnection,
            sigmaConnection.SigmaConnection,
            thoughtSpotConnection.ThoughtSpotConnection,
            grafanaConnection.GrafanaConnection,
        ]
    ] = None


class DashboardService(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        basic.Uuid,
        Field(description='Unique identifier of this dashboard service instance.'),
    ]
    name: Annotated[
        basic.EntityName,
        Field(description='Name that identifies this dashboard service.'),
    ]
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(None, description='FullyQualifiedName same as `name`.'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this dashboard service.'),
    ]
    serviceType: Annotated[
        DashboardServiceType,
        Field(description='Type of dashboard service such as Looker or Superset...'),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of a dashboard service instance.'),
    ]
    connection: Optional[DashboardConnection] = None
    pipelines: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(
            None,
            description='References to pipelines deployed for this dashboard service.',
        ),
    ]
    testConnectionResult: Annotated[
        Optional[testConnectionResult.TestConnectionResult],
        Field(None, description='Last test connection results for this service'),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field([], description='Tags for this Dashboard Service.'),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this dashboard service.'),
    ]
    version: Annotated[
        Optional[entityHistory.EntityVersion],
        Field(None, description='Metadata version of the entity.'),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    href: Annotated[
        Optional[basic.Href],
        Field(
            None,
            description='Link to the resource corresponding to this dashboard service.',
        ),
    ]
    changeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    incrementalChangeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    deleted: Annotated[
        Optional[bool],
        Field(
            False, description='When `true` indicates the entity has been soft deleted.'
        ),
    ]
    dataProducts: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='List of data products this entity is part of.'),
    ]
    domains: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Domains the Dashboard service belongs to.'),
    ]
    followers: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Followers of this entity.'),
    ]
    ingestionRunner: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None,
            description='The ingestion agent responsible for executing the ingestion pipeline.',
        ),
    ]
