# generated by datamodel-codegen:
#   filename:  entity/type.json
#   timestamp: 2025-10-09T02:40:53+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import ConfigDict, Field, RootModel
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ..type import basic, customProperty, entityHistory, entityReferenceList


class EntityName(RootModel[str]):
    root: Annotated[
        str,
        Field(
            description='Name of the property or entity types. Note a property name must be unique for an entity. Property name must follow camelCase naming adopted by openMetadata - must start with lower case with no space, underscore, or dots.',
            pattern='(?u)^[\\w]+$',
        ),
    ]


class Category(Enum):
    field = 'field'
    entity = 'entity'


class Type(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        Optional[basic.Uuid],
        Field(None, description='Unique identifier of the type instance.'),
    ]
    name: Annotated[
        EntityName, Field(description='Unique name that identifies the type.')
    ]
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(None, description='FullyQualifiedName same as `name`.'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this type.'),
    ]
    description: Annotated[
        basic.Markdown, Field(description='Optional description of entity.')
    ]
    category: Optional[Category] = None
    nameSpace: Annotated[
        Optional[str],
        Field(
            'custom',
            description='Namespace or group to which this type belongs to. For example, some of the property types commonly used can come from `basic` namespace. Some of the entities such as `table`, `database`, etc. come from `data` namespace.',
        ),
    ]
    schema_: Annotated[
        Optional[basic.JsonSchema],
        Field(
            None,
            alias='schema',
            description='JSON schema encoded as string that defines the type. This will be used to validate the type values.',
        ),
    ]
    customProperties: Annotated[
        Optional[List[customProperty.CustomProperty]],
        Field(
            None,
            description='Custom properties added to extend the entity. Only available for entity type',
        ),
    ]
    version: Annotated[
        Optional[entityHistory.EntityVersion],
        Field(None, description='Metadata version of the entity.'),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    href: Annotated[
        Optional[basic.Href], Field(None, description='Link to this table resource.')
    ]
    changeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    incrementalChangeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    domains: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(
            None,
            description='Domains the asset belongs to. When not set, the asset inherits the domain from the parent it belongs to.',
        ),
    ]
    dataProducts: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='List of data products this entity is part of.'),
    ]
