# generated by datamodel-codegen:
#   filename:  governance/workflows/elements/nodes/userTask/userApprovalTask.json
#   timestamp: 2025-10-09T02:40:53+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ......type import basic


class Assignees(BaseModel):
    addReviewers: Annotated[
        Optional[bool],
        Field(False, description='Add the Reviewers to the assignees List.'),
    ]


class Config(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    assignees: Annotated[
        Assignees,
        Field(description='People/Teams assigned to the Task.', title='Assignees'),
    ]


class InputNamespaceMap(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    relatedEntity: str


class UserApprovalTaskDefinition(BaseModel):
    type: Optional[str] = 'userTask'
    subType: Optional[str] = 'userApprovalTask'
    name: Annotated[
        Optional[basic.EntityName],
        Field(None, description='Name that identifies this Node.', title='Name'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(
            None,
            description='Display Name that identifies this Node.',
            title='Display Name',
        ),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of the Node.', title='Description'),
    ]
    config: Annotated[Optional[Config], Field(None, title='Node Configuration')]
    input: Annotated[
        Optional[List[str]], Field(['relatedEntity'], max_length=1, min_length=1)
    ]
    inputNamespaceMap: Optional[InputNamespaceMap] = None
    output: Annotated[
        Optional[List[str]], Field(['updatedBy'], max_length=1, min_length=1)
    ]
    branches: Annotated[
        Optional[List[str]], Field(['true', 'false'], max_length=2, min_length=2)
    ]
