# generated by datamodel-codegen:
#   filename:  search/searchRequest.json
#   timestamp: 2025-10-09T02:40:53+00:00

from __future__ import annotations

from typing import Any, List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel


class SearchRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    query: Annotated[
        Optional[str], Field('*', description='Query to be send to Search Engine.')
    ]
    index: Annotated[
        Optional[str], Field('table_search_index', description='Index Name.')
    ]
    fieldName: Annotated[
        Optional[str], Field('suggest', description='Field Name to match.')
    ]
    from_: Annotated[
        Optional[int], Field(0, alias='from', description='Start Index for the req.')
    ]
    size: Annotated[
        Optional[int],
        Field(10, description='Size to limit the no.of results returned.'),
    ]
    queryFilter: Annotated[
        Optional[str],
        Field(
            None,
            description='Elasticsearch query that will be combined with the query_string query generator from the `query` arg',
        ),
    ]
    postFilter: Annotated[
        Optional[str],
        Field(
            None, description='Elasticsearch query that will be used as a post_filter'
        ),
    ]
    fetchSource: Annotated[
        Optional[bool], Field(True, description='Get document body for each hit')
    ]
    trackTotalHits: Annotated[
        Optional[bool], Field(False, description='Track Total Hits.')
    ]
    explain: Annotated[
        Optional[bool],
        Field(
            False,
            description='Explain the results of the query. Defaults to false. Only for debugging purposes.',
        ),
    ]
    deleted: Annotated[
        Optional[bool], Field(None, description='Filter documents by deleted param.')
    ]
    sortFieldParam: Annotated[
        Optional[str],
        Field(
            '_score',
            description='Sort the search results by field, available fields to sort weekly_stats daily_stats, monthly_stats, last_updated_timestamp.',
        ),
    ]
    sortOrder: Annotated[
        Optional[str],
        Field(
            'desc',
            description='Sort order asc for ascending or desc for descending, defaults to desc.',
        ),
    ]
    includeSourceFields: Annotated[
        Optional[List[str]],
        Field(
            None,
            description='Get only selected fields of the document body for each hit. Empty value will return all fields',
        ),
    ]
    excludeSourceFields: Annotated[
        Optional[List[str]],
        Field(
            None,
            description="Exclude specified fields from the document body for each hit. Use this to exclude heavy fields like 'columns' for better performance",
        ),
    ]
    searchAfter: Annotated[
        Optional[Any],
        Field(
            None,
            description='When paginating, specify the search_after values. Use it ass search_after=<val1>,<val2>,...',
        ),
    ]
    domains: Annotated[
        Optional[Any], Field(None, description='Internal Object to filter by Domains.')
    ]
    applyDomainFilter: Annotated[
        Optional[bool], Field(None, description='If Need to apply the domain filter.')
    ]
    isHierarchy: Annotated[
        Optional[bool],
        Field(
            False, description='If true it will try to get the hierarchy of the entity.'
        ),
    ]
    fieldValue: Annotated[
        Optional[str], Field(None, description='Field Value in case of Aggregations.')
    ]
