#!/usr/bin/env python3
# -*- coding: utf-8 -*-
# Copyright (c) 2020 FreeHackQuest Team <freehackquest@gmail.com>
"""This file was automatically generated by fhq-server
Version: v0.2.54
Date: 2025-08-21 14:05:35
"""

class FreeHackQuestApiQuests:
    """ API Group quests"""
    __client = None
    def __init__(self, client):
        self.__client = client

    def add(self, req):
        """Method will be create new quest
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                uuid (string,required):
                    Global Identificator of the quest
                gameid (integer,required):
                    Which game included this quest
                name (string,required):
                    Name of the quest
                text (string,required):
                    Description of the quest
                score (integer,required):
                    How much append to user score after solve quest by them
                author (string,required):
                    Author of the quest
                subject (string,required):
                    Subject must be one from types
                answer (string,required):
                    Answer for the quest
                answer_format (string,required):
                    Answer format for the quest
                state (string,required):
                    State of the quest
                description_state (string,required):
                    You can add some descriptions for quest state
                copyright (string,optional):
                    You can add some copyright information
        """
        if not self.__client.has_connection():
            return None
        request_json = self.__client.generate_base_command('quests.add')
        allowed_params = [
            'uuid',
            'gameid',
            'name',
            'text',
            'score',
            'author',
            'subject',
            'answer',
            'answer_format',
            'state',
            'description_state',
            'copyright',
        ]
        self.__client.check_on_excess_params(req, 'quests.add', allowed_params)
        required_params = [
            'uuid',
            'gameid',
            'name',
            'text',
            'score',
            'author',
            'subject',
            'answer',
            'answer_format',
            'state',
            'description_state',
        ]
        self.__client.check_on_required_params(req, 'quests.add', required_params)
        for param_name in required_params:
            if param_name not in req:
                raise Exception('Parameter "' + param_name + '" expected (lib)')
        if 'uuid' in req:
            request_json['uuid'] = req['uuid']
        if 'gameid' in req:
            request_json['gameid'] = req['gameid']
        if 'name' in req:
            request_json['name'] = req['name']
        if 'text' in req:
            request_json['text'] = req['text']
        if 'score' in req:
            request_json['score'] = req['score']
        if 'author' in req:
            request_json['author'] = req['author']
        if 'subject' in req:
            request_json['subject'] = req['subject']
        if 'answer' in req:
            request_json['answer'] = req['answer']
        if 'answer_format' in req:
            request_json['answer_format'] = req['answer_format']
        if 'state' in req:
            request_json['state'] = req['state']
        if 'description_state' in req:
            request_json['description_state'] = req['description_state']
        if 'copyright' in req:
            request_json['copyright'] = req['copyright']
        return self.__client.send_command(request_json)

