#!/usr/bin/env python3
# -*- coding: utf-8 -*-
# Copyright (c) 2020 FreeHackQuest Team <freehackquest@gmail.com>
"""This file was automatically generated by fhq-server
Version: v0.2.54
Date: 2025-08-21 14:05:35
"""

class FreeHackQuestApiServer:
    """ API Group server"""
    __client = None
    def __init__(self, client):
        self.__client = client

    def uuid_generate(self, req):
        """for generate new uuid
            Activated From Version: 0.2.52
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                typeobj (string,required):
                    type object of uuid for some
        """
        if not self.__client.has_connection():
            return None
        request_json = self.__client.generate_base_command('server.uuid_generate')
        allowed_params = [
            'typeobj',
        ]
        self.__client.check_on_excess_params(req, 'server.uuid_generate', allowed_params)
        required_params = [
            'typeobj',
        ]
        self.__client.check_on_required_params(req, 'server.uuid_generate', required_params)
        for param_name in required_params:
            if param_name not in req:
                raise Exception('Parameter "' + param_name + '" expected (lib)')
        if 'typeobj' in req:
            request_json['typeobj'] = req['typeobj']
        return self.__client.send_command(request_json)

    def uuid_info(self, req):
        """return info about uuid
            Activated From Version: 0.2.52
            Permissins:
                Allowed access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
                uuid (string,required):
                    uuid for some object
        """
        if not self.__client.has_connection():
            return None
        request_json = self.__client.generate_base_command('server.uuid_info')
        allowed_params = [
            'uuid',
        ]
        self.__client.check_on_excess_params(req, 'server.uuid_info', allowed_params)
        required_params = [
            'uuid',
        ]
        self.__client.check_on_required_params(req, 'server.uuid_info', required_params)
        for param_name in required_params:
            if param_name not in req:
                raise Exception('Parameter "' + param_name + '" expected (lib)')
        if 'uuid' in req:
            request_json['uuid'] = req['uuid']
        return self.__client.send_command(request_json)

