import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AdministrativeUnitMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * The object ID of the administrative unit
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/administrative_unit_member#administrative_unit_object_id AdministrativeUnitMember#administrative_unit_object_id}
    */
    readonly administrativeUnitObjectId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/administrative_unit_member#id AdministrativeUnitMember#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The object ID of the member
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/administrative_unit_member#member_object_id AdministrativeUnitMember#member_object_id}
    */
    readonly memberObjectId?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/administrative_unit_member#timeouts AdministrativeUnitMember#timeouts}
    */
    readonly timeouts?: AdministrativeUnitMemberTimeouts;
}
export interface AdministrativeUnitMemberTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/administrative_unit_member#create AdministrativeUnitMember#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/administrative_unit_member#delete AdministrativeUnitMember#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/administrative_unit_member#read AdministrativeUnitMember#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/administrative_unit_member#update AdministrativeUnitMember#update}
    */
    readonly update?: string;
}
export declare function administrativeUnitMemberTimeoutsToTerraform(struct?: AdministrativeUnitMemberTimeoutsOutputReference | AdministrativeUnitMemberTimeouts | cdktf.IResolvable): any;
export declare class AdministrativeUnitMemberTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AdministrativeUnitMemberTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AdministrativeUnitMemberTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azuread/r/administrative_unit_member azuread_administrative_unit_member}
*/
export declare class AdministrativeUnitMember extends cdktf.TerraformResource {
    static readonly tfResourceType = "azuread_administrative_unit_member";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azuread/r/administrative_unit_member azuread_administrative_unit_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AdministrativeUnitMemberConfig = {}
    */
    constructor(scope: Construct, id: string, config?: AdministrativeUnitMemberConfig);
    private _administrativeUnitObjectId?;
    get administrativeUnitObjectId(): string;
    set administrativeUnitObjectId(value: string);
    resetAdministrativeUnitObjectId(): void;
    get administrativeUnitObjectIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _memberObjectId?;
    get memberObjectId(): string;
    set memberObjectId(value: string);
    resetMemberObjectId(): void;
    get memberObjectIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): AdministrativeUnitMemberTimeoutsOutputReference;
    putTimeouts(value: AdministrativeUnitMemberTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AdministrativeUnitMemberTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
