import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApplicationPasswordConfig extends cdktf.TerraformMetaArguments {
    /**
    * The object ID of the application for which this password should be created
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_password#application_object_id ApplicationPassword#application_object_id}
    */
    readonly applicationObjectId: string;
    /**
    * A display name for the password
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_password#display_name ApplicationPassword#display_name}
    */
    readonly displayName?: string;
    /**
    * The end date until which the password is valid, formatted as an RFC3339 date string (e.g. `2018-01-01T01:02:03Z`)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_password#end_date ApplicationPassword#end_date}
    */
    readonly endDate?: string;
    /**
    * A relative duration for which the password is valid until, for example `240h` (10 days) or `2400h30m`. Changing this field forces a new resource to be created
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_password#end_date_relative ApplicationPassword#end_date_relative}
    */
    readonly endDateRelative?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_password#id ApplicationPassword#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Arbitrary map of values that, when changed, will trigger rotation of the password
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_password#rotate_when_changed ApplicationPassword#rotate_when_changed}
    */
    readonly rotateWhenChanged?: {
        [key: string]: string;
    };
    /**
    * The start date from which the password is valid, formatted as an RFC3339 date string (e.g. `2018-01-01T01:02:03Z`). If this isn't specified, the current date is used
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_password#start_date ApplicationPassword#start_date}
    */
    readonly startDate?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_password#timeouts ApplicationPassword#timeouts}
    */
    readonly timeouts?: ApplicationPasswordTimeouts;
}
export interface ApplicationPasswordTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_password#create ApplicationPassword#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_password#delete ApplicationPassword#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_password#read ApplicationPassword#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_password#update ApplicationPassword#update}
    */
    readonly update?: string;
}
export declare function applicationPasswordTimeoutsToTerraform(struct?: ApplicationPasswordTimeoutsOutputReference | ApplicationPasswordTimeouts | cdktf.IResolvable): any;
export declare class ApplicationPasswordTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApplicationPasswordTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationPasswordTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azuread/r/application_password azuread_application_password}
*/
export declare class ApplicationPassword extends cdktf.TerraformResource {
    static readonly tfResourceType = "azuread_application_password";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azuread/r/application_password azuread_application_password} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApplicationPasswordConfig
    */
    constructor(scope: Construct, id: string, config: ApplicationPasswordConfig);
    private _applicationObjectId?;
    get applicationObjectId(): string;
    set applicationObjectId(value: string);
    get applicationObjectIdInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _endDate?;
    get endDate(): string;
    set endDate(value: string);
    resetEndDate(): void;
    get endDateInput(): string | undefined;
    private _endDateRelative?;
    get endDateRelative(): string;
    set endDateRelative(value: string);
    resetEndDateRelative(): void;
    get endDateRelativeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get keyId(): string;
    private _rotateWhenChanged?;
    get rotateWhenChanged(): {
        [key: string]: string;
    };
    set rotateWhenChanged(value: {
        [key: string]: string;
    });
    resetRotateWhenChanged(): void;
    get rotateWhenChangedInput(): {
        [key: string]: string;
    } | undefined;
    private _startDate?;
    get startDate(): string;
    set startDate(value: string);
    resetStartDate(): void;
    get startDateInput(): string | undefined;
    get value(): string;
    private _timeouts;
    get timeouts(): ApplicationPasswordTimeoutsOutputReference;
    putTimeouts(value: ApplicationPasswordTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ApplicationPasswordTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
