import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApplicationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies whether this application supports device authentication without a user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#device_only_auth_enabled Application#device_only_auth_enabled}
    */
    readonly deviceOnlyAuthEnabled?: boolean | cdktf.IResolvable;
    /**
    * The display name for the application
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#display_name Application#display_name}
    */
    readonly displayName: string;
    /**
    * Specifies whether the application is a public client. Appropriate for apps using token grant flows that don't use a redirect URI
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#fallback_public_client_enabled Application#fallback_public_client_enabled}
    */
    readonly fallbackPublicClientEnabled?: boolean | cdktf.IResolvable;
    /**
    * Configures the `groups` claim issued in a user or OAuth 2.0 access token that the app expects
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#group_membership_claims Application#group_membership_claims}
    */
    readonly groupMembershipClaims?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#id Application#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The user-defined URI(s) that uniquely identify an application within its Azure AD tenant, or within a verified custom domain if the application is multi-tenant
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#identifier_uris Application#identifier_uris}
    */
    readonly identifierUris?: string[];
    /**
    * Base64 encoded logo image in gif, png or jpeg format
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#logo_image Application#logo_image}
    */
    readonly logoImage?: string;
    /**
    * URL of the application's marketing page
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#marketing_url Application#marketing_url}
    */
    readonly marketingUrl?: string;
    /**
    * Specifies whether, as part of OAuth 2.0 token requests, Azure AD allows POST requests, as opposed to GET requests.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#oauth2_post_response_required Application#oauth2_post_response_required}
    */
    readonly oauth2PostResponseRequired?: boolean | cdktf.IResolvable;
    /**
    * A list of object IDs of principals that will be granted ownership of the application
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#owners Application#owners}
    */
    readonly owners?: string[];
    /**
    * If `true`, will return an error if an existing application is found with the same name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#prevent_duplicate_names Application#prevent_duplicate_names}
    */
    readonly preventDuplicateNames?: boolean | cdktf.IResolvable;
    /**
    * URL of the application's privacy statement
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#privacy_statement_url Application#privacy_statement_url}
    */
    readonly privacyStatementUrl?: string;
    /**
    * The Microsoft account types that are supported for the current application
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#sign_in_audience Application#sign_in_audience}
    */
    readonly signInAudience?: string;
    /**
    * URL of the application's support page
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#support_url Application#support_url}
    */
    readonly supportUrl?: string;
    /**
    * A set of tags to apply to the application
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#tags Application#tags}
    */
    readonly tags?: string[];
    /**
    * Unique ID of the application template from which this application is created
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#template_id Application#template_id}
    */
    readonly templateId?: string;
    /**
    * URL of the application's terms of service statement
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#terms_of_service_url Application#terms_of_service_url}
    */
    readonly termsOfServiceUrl?: string;
    /**
    * api block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#api Application#api}
    */
    readonly api?: ApplicationApi;
    /**
    * app_role block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#app_role Application#app_role}
    */
    readonly appRole?: ApplicationAppRole[] | cdktf.IResolvable;
    /**
    * feature_tags block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#feature_tags Application#feature_tags}
    */
    readonly featureTags?: ApplicationFeatureTags[] | cdktf.IResolvable;
    /**
    * optional_claims block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#optional_claims Application#optional_claims}
    */
    readonly optionalClaims?: ApplicationOptionalClaims;
    /**
    * public_client block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#public_client Application#public_client}
    */
    readonly publicClient?: ApplicationPublicClient;
    /**
    * required_resource_access block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#required_resource_access Application#required_resource_access}
    */
    readonly requiredResourceAccess?: ApplicationRequiredResourceAccess[] | cdktf.IResolvable;
    /**
    * single_page_application block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#single_page_application Application#single_page_application}
    */
    readonly singlePageApplication?: ApplicationSinglePageApplication;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#timeouts Application#timeouts}
    */
    readonly timeouts?: ApplicationTimeouts;
    /**
    * web block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#web Application#web}
    */
    readonly web?: ApplicationWeb;
}
export interface ApplicationApiOauth2PermissionScope {
    /**
    * Delegated permission description that appears in all tenant-wide admin consent experiences, intended to be read by an administrator granting the permission on behalf of all users
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#admin_consent_description Application#admin_consent_description}
    */
    readonly adminConsentDescription?: string;
    /**
    * Display name for the delegated permission, intended to be read by an administrator granting the permission on behalf of all users
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#admin_consent_display_name Application#admin_consent_display_name}
    */
    readonly adminConsentDisplayName?: string;
    /**
    * Determines if the permission scope is enabled
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#enabled Application#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * The unique identifier of the delegated permission
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#id Application#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
    /**
    * Whether this delegated permission should be considered safe for non-admin users to consent to on behalf of themselves, or whether an administrator should be required for consent to the permissions
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#type Application#type}
    */
    readonly type?: string;
    /**
    * Delegated permission description that appears in the end user consent experience, intended to be read by a user consenting on their own behalf
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#user_consent_description Application#user_consent_description}
    */
    readonly userConsentDescription?: string;
    /**
    * Display name for the delegated permission that appears in the end user consent experience
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#user_consent_display_name Application#user_consent_display_name}
    */
    readonly userConsentDisplayName?: string;
    /**
    * The value that is used for the `scp` claim in OAuth 2.0 access tokens
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#value Application#value}
    */
    readonly value?: string;
}
export declare function applicationApiOauth2PermissionScopeToTerraform(struct?: ApplicationApiOauth2PermissionScope | cdktf.IResolvable): any;
export declare class ApplicationApiOauth2PermissionScopeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApplicationApiOauth2PermissionScope | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationApiOauth2PermissionScope | cdktf.IResolvable | undefined);
    private _adminConsentDescription?;
    get adminConsentDescription(): string;
    set adminConsentDescription(value: string);
    resetAdminConsentDescription(): void;
    get adminConsentDescriptionInput(): string | undefined;
    private _adminConsentDisplayName?;
    get adminConsentDisplayName(): string;
    set adminConsentDisplayName(value: string);
    resetAdminConsentDisplayName(): void;
    get adminConsentDisplayNameInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _userConsentDescription?;
    get userConsentDescription(): string;
    set userConsentDescription(value: string);
    resetUserConsentDescription(): void;
    get userConsentDescriptionInput(): string | undefined;
    private _userConsentDisplayName?;
    get userConsentDisplayName(): string;
    set userConsentDisplayName(value: string);
    resetUserConsentDisplayName(): void;
    get userConsentDisplayNameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class ApplicationApiOauth2PermissionScopeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApplicationApiOauth2PermissionScope[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApplicationApiOauth2PermissionScopeOutputReference;
}
export interface ApplicationApi {
    /**
    * Used for bundling consent if you have a solution that contains two parts: a client app and a custom web API app
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#known_client_applications Application#known_client_applications}
    */
    readonly knownClientApplications?: string[];
    /**
    * Allows an application to use claims mapping without specifying a custom signing key
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#mapped_claims_enabled Application#mapped_claims_enabled}
    */
    readonly mappedClaimsEnabled?: boolean | cdktf.IResolvable;
    /**
    * The access token version expected by this resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#requested_access_token_version Application#requested_access_token_version}
    */
    readonly requestedAccessTokenVersion?: number;
    /**
    * oauth2_permission_scope block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#oauth2_permission_scope Application#oauth2_permission_scope}
    */
    readonly oauth2PermissionScope?: ApplicationApiOauth2PermissionScope[] | cdktf.IResolvable;
}
export declare function applicationApiToTerraform(struct?: ApplicationApiOutputReference | ApplicationApi): any;
export declare class ApplicationApiOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApplicationApi | undefined;
    set internalValue(value: ApplicationApi | undefined);
    private _knownClientApplications?;
    get knownClientApplications(): string[];
    set knownClientApplications(value: string[]);
    resetKnownClientApplications(): void;
    get knownClientApplicationsInput(): string[] | undefined;
    private _mappedClaimsEnabled?;
    get mappedClaimsEnabled(): boolean | cdktf.IResolvable;
    set mappedClaimsEnabled(value: boolean | cdktf.IResolvable);
    resetMappedClaimsEnabled(): void;
    get mappedClaimsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _requestedAccessTokenVersion?;
    get requestedAccessTokenVersion(): number;
    set requestedAccessTokenVersion(value: number);
    resetRequestedAccessTokenVersion(): void;
    get requestedAccessTokenVersionInput(): number | undefined;
    private _oauth2PermissionScope;
    get oauth2PermissionScope(): ApplicationApiOauth2PermissionScopeList;
    putOauth2PermissionScope(value: ApplicationApiOauth2PermissionScope[] | cdktf.IResolvable): void;
    resetOauth2PermissionScope(): void;
    get oauth2PermissionScopeInput(): cdktf.IResolvable | ApplicationApiOauth2PermissionScope[] | undefined;
}
export interface ApplicationAppRole {
    /**
    * Specifies whether this app role definition can be assigned to users and groups by setting to `User`, or to other applications (that are accessing this application in a standalone scenario) by setting to `Application`, or to both
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#allowed_member_types Application#allowed_member_types}
    */
    readonly allowedMemberTypes: string[];
    /**
    * Description of the app role that appears when the role is being assigned and, if the role functions as an application permissions, during the consent experiences
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#description Application#description}
    */
    readonly description: string;
    /**
    * Display name for the app role that appears during app role assignment and in consent experiences
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#display_name Application#display_name}
    */
    readonly displayName: string;
    /**
    * Determines if the app role is enabled
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#enabled Application#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * The unique identifier of the app role
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#id Application#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
    /**
    * The value that is used for the `roles` claim in ID tokens and OAuth 2.0 access tokens that are authenticating an assigned service or user principal
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#value Application#value}
    */
    readonly value?: string;
}
export declare function applicationAppRoleToTerraform(struct?: ApplicationAppRole | cdktf.IResolvable): any;
export declare class ApplicationAppRoleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApplicationAppRole | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationAppRole | cdktf.IResolvable | undefined);
    private _allowedMemberTypes?;
    get allowedMemberTypes(): string[];
    set allowedMemberTypes(value: string[]);
    get allowedMemberTypesInput(): string[] | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class ApplicationAppRoleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApplicationAppRole[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApplicationAppRoleOutputReference;
}
export interface ApplicationFeatureTags {
    /**
    * Whether this application represents a custom SAML application for linked service principals
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#custom_single_sign_on Application#custom_single_sign_on}
    */
    readonly customSingleSignOn?: boolean | cdktf.IResolvable;
    /**
    * Whether this application represents an Enterprise Application for linked service principals
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#enterprise Application#enterprise}
    */
    readonly enterprise?: boolean | cdktf.IResolvable;
    /**
    * Whether this application represents a gallery application for linked service principals
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#gallery Application#gallery}
    */
    readonly gallery?: boolean | cdktf.IResolvable;
    /**
    * Whether this application is invisible to users in My Apps and Office 365 Launcher
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#hide Application#hide}
    */
    readonly hide?: boolean | cdktf.IResolvable;
}
export declare function applicationFeatureTagsToTerraform(struct?: ApplicationFeatureTags | cdktf.IResolvable): any;
export declare class ApplicationFeatureTagsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApplicationFeatureTags | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationFeatureTags | cdktf.IResolvable | undefined);
    private _customSingleSignOn?;
    get customSingleSignOn(): boolean | cdktf.IResolvable;
    set customSingleSignOn(value: boolean | cdktf.IResolvable);
    resetCustomSingleSignOn(): void;
    get customSingleSignOnInput(): boolean | cdktf.IResolvable | undefined;
    private _enterprise?;
    get enterprise(): boolean | cdktf.IResolvable;
    set enterprise(value: boolean | cdktf.IResolvable);
    resetEnterprise(): void;
    get enterpriseInput(): boolean | cdktf.IResolvable | undefined;
    private _gallery?;
    get gallery(): boolean | cdktf.IResolvable;
    set gallery(value: boolean | cdktf.IResolvable);
    resetGallery(): void;
    get galleryInput(): boolean | cdktf.IResolvable | undefined;
    private _hide?;
    get hide(): boolean | cdktf.IResolvable;
    set hide(value: boolean | cdktf.IResolvable);
    resetHide(): void;
    get hideInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class ApplicationFeatureTagsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApplicationFeatureTags[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApplicationFeatureTagsOutputReference;
}
export interface ApplicationOptionalClaimsAccessToken {
    /**
    * List of additional properties of the claim. If a property exists in this list, it modifies the behaviour of the optional claim
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#additional_properties Application#additional_properties}
    */
    readonly additionalProperties?: string[];
    /**
    * Whether the claim specified by the client is necessary to ensure a smooth authorization experience
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#essential Application#essential}
    */
    readonly essential?: boolean | cdktf.IResolvable;
    /**
    * The name of the optional claim
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#name Application#name}
    */
    readonly name: string;
    /**
    * The source of the claim. If `source` is absent, the claim is a predefined optional claim. If `source` is `user`, the value of `name` is the extension property from the user object
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#source Application#source}
    */
    readonly source?: string;
}
export declare function applicationOptionalClaimsAccessTokenToTerraform(struct?: ApplicationOptionalClaimsAccessToken | cdktf.IResolvable): any;
export declare class ApplicationOptionalClaimsAccessTokenOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApplicationOptionalClaimsAccessToken | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationOptionalClaimsAccessToken | cdktf.IResolvable | undefined);
    private _additionalProperties?;
    get additionalProperties(): string[];
    set additionalProperties(value: string[]);
    resetAdditionalProperties(): void;
    get additionalPropertiesInput(): string[] | undefined;
    private _essential?;
    get essential(): boolean | cdktf.IResolvable;
    set essential(value: boolean | cdktf.IResolvable);
    resetEssential(): void;
    get essentialInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    resetSource(): void;
    get sourceInput(): string | undefined;
}
export declare class ApplicationOptionalClaimsAccessTokenList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApplicationOptionalClaimsAccessToken[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApplicationOptionalClaimsAccessTokenOutputReference;
}
export interface ApplicationOptionalClaimsIdToken {
    /**
    * List of additional properties of the claim. If a property exists in this list, it modifies the behaviour of the optional claim
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#additional_properties Application#additional_properties}
    */
    readonly additionalProperties?: string[];
    /**
    * Whether the claim specified by the client is necessary to ensure a smooth authorization experience
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#essential Application#essential}
    */
    readonly essential?: boolean | cdktf.IResolvable;
    /**
    * The name of the optional claim
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#name Application#name}
    */
    readonly name: string;
    /**
    * The source of the claim. If `source` is absent, the claim is a predefined optional claim. If `source` is `user`, the value of `name` is the extension property from the user object
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#source Application#source}
    */
    readonly source?: string;
}
export declare function applicationOptionalClaimsIdTokenToTerraform(struct?: ApplicationOptionalClaimsIdToken | cdktf.IResolvable): any;
export declare class ApplicationOptionalClaimsIdTokenOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApplicationOptionalClaimsIdToken | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationOptionalClaimsIdToken | cdktf.IResolvable | undefined);
    private _additionalProperties?;
    get additionalProperties(): string[];
    set additionalProperties(value: string[]);
    resetAdditionalProperties(): void;
    get additionalPropertiesInput(): string[] | undefined;
    private _essential?;
    get essential(): boolean | cdktf.IResolvable;
    set essential(value: boolean | cdktf.IResolvable);
    resetEssential(): void;
    get essentialInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    resetSource(): void;
    get sourceInput(): string | undefined;
}
export declare class ApplicationOptionalClaimsIdTokenList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApplicationOptionalClaimsIdToken[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApplicationOptionalClaimsIdTokenOutputReference;
}
export interface ApplicationOptionalClaimsSaml2Token {
    /**
    * List of additional properties of the claim. If a property exists in this list, it modifies the behaviour of the optional claim
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#additional_properties Application#additional_properties}
    */
    readonly additionalProperties?: string[];
    /**
    * Whether the claim specified by the client is necessary to ensure a smooth authorization experience
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#essential Application#essential}
    */
    readonly essential?: boolean | cdktf.IResolvable;
    /**
    * The name of the optional claim
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#name Application#name}
    */
    readonly name: string;
    /**
    * The source of the claim. If `source` is absent, the claim is a predefined optional claim. If `source` is `user`, the value of `name` is the extension property from the user object
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#source Application#source}
    */
    readonly source?: string;
}
export declare function applicationOptionalClaimsSaml2TokenToTerraform(struct?: ApplicationOptionalClaimsSaml2Token | cdktf.IResolvable): any;
export declare class ApplicationOptionalClaimsSaml2TokenOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApplicationOptionalClaimsSaml2Token | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationOptionalClaimsSaml2Token | cdktf.IResolvable | undefined);
    private _additionalProperties?;
    get additionalProperties(): string[];
    set additionalProperties(value: string[]);
    resetAdditionalProperties(): void;
    get additionalPropertiesInput(): string[] | undefined;
    private _essential?;
    get essential(): boolean | cdktf.IResolvable;
    set essential(value: boolean | cdktf.IResolvable);
    resetEssential(): void;
    get essentialInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    resetSource(): void;
    get sourceInput(): string | undefined;
}
export declare class ApplicationOptionalClaimsSaml2TokenList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApplicationOptionalClaimsSaml2Token[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApplicationOptionalClaimsSaml2TokenOutputReference;
}
export interface ApplicationOptionalClaims {
    /**
    * access_token block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#access_token Application#access_token}
    */
    readonly accessToken?: ApplicationOptionalClaimsAccessToken[] | cdktf.IResolvable;
    /**
    * id_token block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#id_token Application#id_token}
    */
    readonly idToken?: ApplicationOptionalClaimsIdToken[] | cdktf.IResolvable;
    /**
    * saml2_token block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#saml2_token Application#saml2_token}
    */
    readonly saml2Token?: ApplicationOptionalClaimsSaml2Token[] | cdktf.IResolvable;
}
export declare function applicationOptionalClaimsToTerraform(struct?: ApplicationOptionalClaimsOutputReference | ApplicationOptionalClaims): any;
export declare class ApplicationOptionalClaimsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApplicationOptionalClaims | undefined;
    set internalValue(value: ApplicationOptionalClaims | undefined);
    private _accessToken;
    get accessToken(): ApplicationOptionalClaimsAccessTokenList;
    putAccessToken(value: ApplicationOptionalClaimsAccessToken[] | cdktf.IResolvable): void;
    resetAccessToken(): void;
    get accessTokenInput(): cdktf.IResolvable | ApplicationOptionalClaimsAccessToken[] | undefined;
    private _idToken;
    get idToken(): ApplicationOptionalClaimsIdTokenList;
    putIdToken(value: ApplicationOptionalClaimsIdToken[] | cdktf.IResolvable): void;
    resetIdToken(): void;
    get idTokenInput(): cdktf.IResolvable | ApplicationOptionalClaimsIdToken[] | undefined;
    private _saml2Token;
    get saml2Token(): ApplicationOptionalClaimsSaml2TokenList;
    putSaml2Token(value: ApplicationOptionalClaimsSaml2Token[] | cdktf.IResolvable): void;
    resetSaml2Token(): void;
    get saml2TokenInput(): cdktf.IResolvable | ApplicationOptionalClaimsSaml2Token[] | undefined;
}
export interface ApplicationPublicClient {
    /**
    * The URLs where user tokens are sent for sign-in, or the redirect URIs where OAuth 2.0 authorization codes and access tokens are sent
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#redirect_uris Application#redirect_uris}
    */
    readonly redirectUris?: string[];
}
export declare function applicationPublicClientToTerraform(struct?: ApplicationPublicClientOutputReference | ApplicationPublicClient): any;
export declare class ApplicationPublicClientOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApplicationPublicClient | undefined;
    set internalValue(value: ApplicationPublicClient | undefined);
    private _redirectUris?;
    get redirectUris(): string[];
    set redirectUris(value: string[]);
    resetRedirectUris(): void;
    get redirectUrisInput(): string[] | undefined;
}
export interface ApplicationRequiredResourceAccessResourceAccess {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#id Application#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#type Application#type}
    */
    readonly type: string;
}
export declare function applicationRequiredResourceAccessResourceAccessToTerraform(struct?: ApplicationRequiredResourceAccessResourceAccess | cdktf.IResolvable): any;
export declare class ApplicationRequiredResourceAccessResourceAccessOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApplicationRequiredResourceAccessResourceAccess | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationRequiredResourceAccessResourceAccess | cdktf.IResolvable | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class ApplicationRequiredResourceAccessResourceAccessList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApplicationRequiredResourceAccessResourceAccess[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApplicationRequiredResourceAccessResourceAccessOutputReference;
}
export interface ApplicationRequiredResourceAccess {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#resource_app_id Application#resource_app_id}
    */
    readonly resourceAppId: string;
    /**
    * resource_access block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#resource_access Application#resource_access}
    */
    readonly resourceAccess: ApplicationRequiredResourceAccessResourceAccess[] | cdktf.IResolvable;
}
export declare function applicationRequiredResourceAccessToTerraform(struct?: ApplicationRequiredResourceAccess | cdktf.IResolvable): any;
export declare class ApplicationRequiredResourceAccessOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApplicationRequiredResourceAccess | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationRequiredResourceAccess | cdktf.IResolvable | undefined);
    private _resourceAppId?;
    get resourceAppId(): string;
    set resourceAppId(value: string);
    get resourceAppIdInput(): string | undefined;
    private _resourceAccess;
    get resourceAccess(): ApplicationRequiredResourceAccessResourceAccessList;
    putResourceAccess(value: ApplicationRequiredResourceAccessResourceAccess[] | cdktf.IResolvable): void;
    get resourceAccessInput(): cdktf.IResolvable | ApplicationRequiredResourceAccessResourceAccess[] | undefined;
}
export declare class ApplicationRequiredResourceAccessList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApplicationRequiredResourceAccess[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApplicationRequiredResourceAccessOutputReference;
}
export interface ApplicationSinglePageApplication {
    /**
    * The URLs where user tokens are sent for sign-in, or the redirect URIs where OAuth 2.0 authorization codes and access tokens are sent
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#redirect_uris Application#redirect_uris}
    */
    readonly redirectUris?: string[];
}
export declare function applicationSinglePageApplicationToTerraform(struct?: ApplicationSinglePageApplicationOutputReference | ApplicationSinglePageApplication): any;
export declare class ApplicationSinglePageApplicationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApplicationSinglePageApplication | undefined;
    set internalValue(value: ApplicationSinglePageApplication | undefined);
    private _redirectUris?;
    get redirectUris(): string[];
    set redirectUris(value: string[]);
    resetRedirectUris(): void;
    get redirectUrisInput(): string[] | undefined;
}
export interface ApplicationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#create Application#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#delete Application#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#read Application#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#update Application#update}
    */
    readonly update?: string;
}
export declare function applicationTimeoutsToTerraform(struct?: ApplicationTimeoutsOutputReference | ApplicationTimeouts | cdktf.IResolvable): any;
export declare class ApplicationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApplicationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface ApplicationWebImplicitGrant {
    /**
    * Whether this web application can request an access token using OAuth 2.0 implicit flow
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#access_token_issuance_enabled Application#access_token_issuance_enabled}
    */
    readonly accessTokenIssuanceEnabled?: boolean | cdktf.IResolvable;
    /**
    * Whether this web application can request an ID token using OAuth 2.0 implicit flow
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#id_token_issuance_enabled Application#id_token_issuance_enabled}
    */
    readonly idTokenIssuanceEnabled?: boolean | cdktf.IResolvable;
}
export declare function applicationWebImplicitGrantToTerraform(struct?: ApplicationWebImplicitGrantOutputReference | ApplicationWebImplicitGrant): any;
export declare class ApplicationWebImplicitGrantOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApplicationWebImplicitGrant | undefined;
    set internalValue(value: ApplicationWebImplicitGrant | undefined);
    private _accessTokenIssuanceEnabled?;
    get accessTokenIssuanceEnabled(): boolean | cdktf.IResolvable;
    set accessTokenIssuanceEnabled(value: boolean | cdktf.IResolvable);
    resetAccessTokenIssuanceEnabled(): void;
    get accessTokenIssuanceEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _idTokenIssuanceEnabled?;
    get idTokenIssuanceEnabled(): boolean | cdktf.IResolvable;
    set idTokenIssuanceEnabled(value: boolean | cdktf.IResolvable);
    resetIdTokenIssuanceEnabled(): void;
    get idTokenIssuanceEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ApplicationWeb {
    /**
    * Home page or landing page of the application
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#homepage_url Application#homepage_url}
    */
    readonly homepageUrl?: string;
    /**
    * The URL that will be used by Microsoft's authorization service to sign out a user using front-channel, back-channel or SAML logout protocols
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#logout_url Application#logout_url}
    */
    readonly logoutUrl?: string;
    /**
    * The URLs where user tokens are sent for sign-in, or the redirect URIs where OAuth 2.0 authorization codes and access tokens are sent
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#redirect_uris Application#redirect_uris}
    */
    readonly redirectUris?: string[];
    /**
    * implicit_grant block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application#implicit_grant Application#implicit_grant}
    */
    readonly implicitGrant?: ApplicationWebImplicitGrant;
}
export declare function applicationWebToTerraform(struct?: ApplicationWebOutputReference | ApplicationWeb): any;
export declare class ApplicationWebOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApplicationWeb | undefined;
    set internalValue(value: ApplicationWeb | undefined);
    private _homepageUrl?;
    get homepageUrl(): string;
    set homepageUrl(value: string);
    resetHomepageUrl(): void;
    get homepageUrlInput(): string | undefined;
    private _logoutUrl?;
    get logoutUrl(): string;
    set logoutUrl(value: string);
    resetLogoutUrl(): void;
    get logoutUrlInput(): string | undefined;
    private _redirectUris?;
    get redirectUris(): string[];
    set redirectUris(value: string[]);
    resetRedirectUris(): void;
    get redirectUrisInput(): string[] | undefined;
    private _implicitGrant;
    get implicitGrant(): ApplicationWebImplicitGrantOutputReference;
    putImplicitGrant(value: ApplicationWebImplicitGrant): void;
    resetImplicitGrant(): void;
    get implicitGrantInput(): ApplicationWebImplicitGrant | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azuread/r/application azuread_application}
*/
export declare class Application extends cdktf.TerraformResource {
    static readonly tfResourceType = "azuread_application";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azuread/r/application azuread_application} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApplicationConfig
    */
    constructor(scope: Construct, id: string, config: ApplicationConfig);
    private _appRoleIds;
    get appRoleIds(): cdktf.StringMap;
    get applicationId(): string;
    private _deviceOnlyAuthEnabled?;
    get deviceOnlyAuthEnabled(): boolean | cdktf.IResolvable;
    set deviceOnlyAuthEnabled(value: boolean | cdktf.IResolvable);
    resetDeviceOnlyAuthEnabled(): void;
    get deviceOnlyAuthEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get disabledByMicrosoft(): string;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _fallbackPublicClientEnabled?;
    get fallbackPublicClientEnabled(): boolean | cdktf.IResolvable;
    set fallbackPublicClientEnabled(value: boolean | cdktf.IResolvable);
    resetFallbackPublicClientEnabled(): void;
    get fallbackPublicClientEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _groupMembershipClaims?;
    get groupMembershipClaims(): string[];
    set groupMembershipClaims(value: string[]);
    resetGroupMembershipClaims(): void;
    get groupMembershipClaimsInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identifierUris?;
    get identifierUris(): string[];
    set identifierUris(value: string[]);
    resetIdentifierUris(): void;
    get identifierUrisInput(): string[] | undefined;
    private _logoImage?;
    get logoImage(): string;
    set logoImage(value: string);
    resetLogoImage(): void;
    get logoImageInput(): string | undefined;
    get logoUrl(): string;
    private _marketingUrl?;
    get marketingUrl(): string;
    set marketingUrl(value: string);
    resetMarketingUrl(): void;
    get marketingUrlInput(): string | undefined;
    private _oauth2PermissionScopeIds;
    get oauth2PermissionScopeIds(): cdktf.StringMap;
    private _oauth2PostResponseRequired?;
    get oauth2PostResponseRequired(): boolean | cdktf.IResolvable;
    set oauth2PostResponseRequired(value: boolean | cdktf.IResolvable);
    resetOauth2PostResponseRequired(): void;
    get oauth2PostResponseRequiredInput(): boolean | cdktf.IResolvable | undefined;
    get objectId(): string;
    private _owners?;
    get owners(): string[];
    set owners(value: string[]);
    resetOwners(): void;
    get ownersInput(): string[] | undefined;
    private _preventDuplicateNames?;
    get preventDuplicateNames(): boolean | cdktf.IResolvable;
    set preventDuplicateNames(value: boolean | cdktf.IResolvable);
    resetPreventDuplicateNames(): void;
    get preventDuplicateNamesInput(): boolean | cdktf.IResolvable | undefined;
    private _privacyStatementUrl?;
    get privacyStatementUrl(): string;
    set privacyStatementUrl(value: string);
    resetPrivacyStatementUrl(): void;
    get privacyStatementUrlInput(): string | undefined;
    get publisherDomain(): string;
    private _signInAudience?;
    get signInAudience(): string;
    set signInAudience(value: string);
    resetSignInAudience(): void;
    get signInAudienceInput(): string | undefined;
    private _supportUrl?;
    get supportUrl(): string;
    set supportUrl(value: string);
    resetSupportUrl(): void;
    get supportUrlInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _templateId?;
    get templateId(): string;
    set templateId(value: string);
    resetTemplateId(): void;
    get templateIdInput(): string | undefined;
    private _termsOfServiceUrl?;
    get termsOfServiceUrl(): string;
    set termsOfServiceUrl(value: string);
    resetTermsOfServiceUrl(): void;
    get termsOfServiceUrlInput(): string | undefined;
    private _api;
    get api(): ApplicationApiOutputReference;
    putApi(value: ApplicationApi): void;
    resetApi(): void;
    get apiInput(): ApplicationApi | undefined;
    private _appRole;
    get appRole(): ApplicationAppRoleList;
    putAppRole(value: ApplicationAppRole[] | cdktf.IResolvable): void;
    resetAppRole(): void;
    get appRoleInput(): cdktf.IResolvable | ApplicationAppRole[] | undefined;
    private _featureTags;
    get featureTags(): ApplicationFeatureTagsList;
    putFeatureTags(value: ApplicationFeatureTags[] | cdktf.IResolvable): void;
    resetFeatureTags(): void;
    get featureTagsInput(): cdktf.IResolvable | ApplicationFeatureTags[] | undefined;
    private _optionalClaims;
    get optionalClaims(): ApplicationOptionalClaimsOutputReference;
    putOptionalClaims(value: ApplicationOptionalClaims): void;
    resetOptionalClaims(): void;
    get optionalClaimsInput(): ApplicationOptionalClaims | undefined;
    private _publicClient;
    get publicClient(): ApplicationPublicClientOutputReference;
    putPublicClient(value: ApplicationPublicClient): void;
    resetPublicClient(): void;
    get publicClientInput(): ApplicationPublicClient | undefined;
    private _requiredResourceAccess;
    get requiredResourceAccess(): ApplicationRequiredResourceAccessList;
    putRequiredResourceAccess(value: ApplicationRequiredResourceAccess[] | cdktf.IResolvable): void;
    resetRequiredResourceAccess(): void;
    get requiredResourceAccessInput(): cdktf.IResolvable | ApplicationRequiredResourceAccess[] | undefined;
    private _singlePageApplication;
    get singlePageApplication(): ApplicationSinglePageApplicationOutputReference;
    putSinglePageApplication(value: ApplicationSinglePageApplication): void;
    resetSinglePageApplication(): void;
    get singlePageApplicationInput(): ApplicationSinglePageApplication | undefined;
    private _timeouts;
    get timeouts(): ApplicationTimeoutsOutputReference;
    putTimeouts(value: ApplicationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ApplicationTimeouts | undefined;
    private _web;
    get web(): ApplicationWebOutputReference;
    putWeb(value: ApplicationWeb): void;
    resetWeb(): void;
    get webInput(): ApplicationWeb | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
