import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ConditionalAccessPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#display_name ConditionalAccessPolicy#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#id ConditionalAccessPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#state ConditionalAccessPolicy#state}
    */
    readonly state: string;
    /**
    * conditions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#conditions ConditionalAccessPolicy#conditions}
    */
    readonly conditions: ConditionalAccessPolicyConditions;
    /**
    * grant_controls block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#grant_controls ConditionalAccessPolicy#grant_controls}
    */
    readonly grantControls: ConditionalAccessPolicyGrantControls;
    /**
    * session_controls block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#session_controls ConditionalAccessPolicy#session_controls}
    */
    readonly sessionControls?: ConditionalAccessPolicySessionControls;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#timeouts ConditionalAccessPolicy#timeouts}
    */
    readonly timeouts?: ConditionalAccessPolicyTimeouts;
}
export interface ConditionalAccessPolicyConditionsApplications {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#excluded_applications ConditionalAccessPolicy#excluded_applications}
    */
    readonly excludedApplications?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#included_applications ConditionalAccessPolicy#included_applications}
    */
    readonly includedApplications?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#included_user_actions ConditionalAccessPolicy#included_user_actions}
    */
    readonly includedUserActions?: string[];
}
export declare function conditionalAccessPolicyConditionsApplicationsToTerraform(struct?: ConditionalAccessPolicyConditionsApplicationsOutputReference | ConditionalAccessPolicyConditionsApplications): any;
export declare class ConditionalAccessPolicyConditionsApplicationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ConditionalAccessPolicyConditionsApplications | undefined;
    set internalValue(value: ConditionalAccessPolicyConditionsApplications | undefined);
    private _excludedApplications?;
    get excludedApplications(): string[];
    set excludedApplications(value: string[]);
    resetExcludedApplications(): void;
    get excludedApplicationsInput(): string[] | undefined;
    private _includedApplications?;
    get includedApplications(): string[];
    set includedApplications(value: string[]);
    resetIncludedApplications(): void;
    get includedApplicationsInput(): string[] | undefined;
    private _includedUserActions?;
    get includedUserActions(): string[];
    set includedUserActions(value: string[]);
    resetIncludedUserActions(): void;
    get includedUserActionsInput(): string[] | undefined;
}
export interface ConditionalAccessPolicyConditionsDevicesFilter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#mode ConditionalAccessPolicy#mode}
    */
    readonly mode: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#rule ConditionalAccessPolicy#rule}
    */
    readonly rule: string;
}
export declare function conditionalAccessPolicyConditionsDevicesFilterToTerraform(struct?: ConditionalAccessPolicyConditionsDevicesFilterOutputReference | ConditionalAccessPolicyConditionsDevicesFilter): any;
export declare class ConditionalAccessPolicyConditionsDevicesFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ConditionalAccessPolicyConditionsDevicesFilter | undefined;
    set internalValue(value: ConditionalAccessPolicyConditionsDevicesFilter | undefined);
    private _mode?;
    get mode(): string;
    set mode(value: string);
    get modeInput(): string | undefined;
    private _rule?;
    get rule(): string;
    set rule(value: string);
    get ruleInput(): string | undefined;
}
export interface ConditionalAccessPolicyConditionsDevices {
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#filter ConditionalAccessPolicy#filter}
    */
    readonly filter?: ConditionalAccessPolicyConditionsDevicesFilter;
}
export declare function conditionalAccessPolicyConditionsDevicesToTerraform(struct?: ConditionalAccessPolicyConditionsDevicesOutputReference | ConditionalAccessPolicyConditionsDevices): any;
export declare class ConditionalAccessPolicyConditionsDevicesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ConditionalAccessPolicyConditionsDevices | undefined;
    set internalValue(value: ConditionalAccessPolicyConditionsDevices | undefined);
    private _filter;
    get filter(): ConditionalAccessPolicyConditionsDevicesFilterOutputReference;
    putFilter(value: ConditionalAccessPolicyConditionsDevicesFilter): void;
    resetFilter(): void;
    get filterInput(): ConditionalAccessPolicyConditionsDevicesFilter | undefined;
}
export interface ConditionalAccessPolicyConditionsLocations {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#excluded_locations ConditionalAccessPolicy#excluded_locations}
    */
    readonly excludedLocations?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#included_locations ConditionalAccessPolicy#included_locations}
    */
    readonly includedLocations: string[];
}
export declare function conditionalAccessPolicyConditionsLocationsToTerraform(struct?: ConditionalAccessPolicyConditionsLocationsOutputReference | ConditionalAccessPolicyConditionsLocations): any;
export declare class ConditionalAccessPolicyConditionsLocationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ConditionalAccessPolicyConditionsLocations | undefined;
    set internalValue(value: ConditionalAccessPolicyConditionsLocations | undefined);
    private _excludedLocations?;
    get excludedLocations(): string[];
    set excludedLocations(value: string[]);
    resetExcludedLocations(): void;
    get excludedLocationsInput(): string[] | undefined;
    private _includedLocations?;
    get includedLocations(): string[];
    set includedLocations(value: string[]);
    get includedLocationsInput(): string[] | undefined;
}
export interface ConditionalAccessPolicyConditionsPlatforms {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#excluded_platforms ConditionalAccessPolicy#excluded_platforms}
    */
    readonly excludedPlatforms?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#included_platforms ConditionalAccessPolicy#included_platforms}
    */
    readonly includedPlatforms: string[];
}
export declare function conditionalAccessPolicyConditionsPlatformsToTerraform(struct?: ConditionalAccessPolicyConditionsPlatformsOutputReference | ConditionalAccessPolicyConditionsPlatforms): any;
export declare class ConditionalAccessPolicyConditionsPlatformsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ConditionalAccessPolicyConditionsPlatforms | undefined;
    set internalValue(value: ConditionalAccessPolicyConditionsPlatforms | undefined);
    private _excludedPlatforms?;
    get excludedPlatforms(): string[];
    set excludedPlatforms(value: string[]);
    resetExcludedPlatforms(): void;
    get excludedPlatformsInput(): string[] | undefined;
    private _includedPlatforms?;
    get includedPlatforms(): string[];
    set includedPlatforms(value: string[]);
    get includedPlatformsInput(): string[] | undefined;
}
export interface ConditionalAccessPolicyConditionsUsers {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#excluded_groups ConditionalAccessPolicy#excluded_groups}
    */
    readonly excludedGroups?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#excluded_roles ConditionalAccessPolicy#excluded_roles}
    */
    readonly excludedRoles?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#excluded_users ConditionalAccessPolicy#excluded_users}
    */
    readonly excludedUsers?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#included_groups ConditionalAccessPolicy#included_groups}
    */
    readonly includedGroups?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#included_roles ConditionalAccessPolicy#included_roles}
    */
    readonly includedRoles?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#included_users ConditionalAccessPolicy#included_users}
    */
    readonly includedUsers?: string[];
}
export declare function conditionalAccessPolicyConditionsUsersToTerraform(struct?: ConditionalAccessPolicyConditionsUsersOutputReference | ConditionalAccessPolicyConditionsUsers): any;
export declare class ConditionalAccessPolicyConditionsUsersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ConditionalAccessPolicyConditionsUsers | undefined;
    set internalValue(value: ConditionalAccessPolicyConditionsUsers | undefined);
    private _excludedGroups?;
    get excludedGroups(): string[];
    set excludedGroups(value: string[]);
    resetExcludedGroups(): void;
    get excludedGroupsInput(): string[] | undefined;
    private _excludedRoles?;
    get excludedRoles(): string[];
    set excludedRoles(value: string[]);
    resetExcludedRoles(): void;
    get excludedRolesInput(): string[] | undefined;
    private _excludedUsers?;
    get excludedUsers(): string[];
    set excludedUsers(value: string[]);
    resetExcludedUsers(): void;
    get excludedUsersInput(): string[] | undefined;
    private _includedGroups?;
    get includedGroups(): string[];
    set includedGroups(value: string[]);
    resetIncludedGroups(): void;
    get includedGroupsInput(): string[] | undefined;
    private _includedRoles?;
    get includedRoles(): string[];
    set includedRoles(value: string[]);
    resetIncludedRoles(): void;
    get includedRolesInput(): string[] | undefined;
    private _includedUsers?;
    get includedUsers(): string[];
    set includedUsers(value: string[]);
    resetIncludedUsers(): void;
    get includedUsersInput(): string[] | undefined;
}
export interface ConditionalAccessPolicyConditions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#client_app_types ConditionalAccessPolicy#client_app_types}
    */
    readonly clientAppTypes: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#sign_in_risk_levels ConditionalAccessPolicy#sign_in_risk_levels}
    */
    readonly signInRiskLevels?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#user_risk_levels ConditionalAccessPolicy#user_risk_levels}
    */
    readonly userRiskLevels?: string[];
    /**
    * applications block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#applications ConditionalAccessPolicy#applications}
    */
    readonly applications: ConditionalAccessPolicyConditionsApplications;
    /**
    * devices block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#devices ConditionalAccessPolicy#devices}
    */
    readonly devices?: ConditionalAccessPolicyConditionsDevices;
    /**
    * locations block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#locations ConditionalAccessPolicy#locations}
    */
    readonly locations?: ConditionalAccessPolicyConditionsLocations;
    /**
    * platforms block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#platforms ConditionalAccessPolicy#platforms}
    */
    readonly platforms?: ConditionalAccessPolicyConditionsPlatforms;
    /**
    * users block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#users ConditionalAccessPolicy#users}
    */
    readonly users: ConditionalAccessPolicyConditionsUsers;
}
export declare function conditionalAccessPolicyConditionsToTerraform(struct?: ConditionalAccessPolicyConditionsOutputReference | ConditionalAccessPolicyConditions): any;
export declare class ConditionalAccessPolicyConditionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ConditionalAccessPolicyConditions | undefined;
    set internalValue(value: ConditionalAccessPolicyConditions | undefined);
    private _clientAppTypes?;
    get clientAppTypes(): string[];
    set clientAppTypes(value: string[]);
    get clientAppTypesInput(): string[] | undefined;
    private _signInRiskLevels?;
    get signInRiskLevels(): string[];
    set signInRiskLevels(value: string[]);
    resetSignInRiskLevels(): void;
    get signInRiskLevelsInput(): string[] | undefined;
    private _userRiskLevels?;
    get userRiskLevels(): string[];
    set userRiskLevels(value: string[]);
    resetUserRiskLevels(): void;
    get userRiskLevelsInput(): string[] | undefined;
    private _applications;
    get applications(): ConditionalAccessPolicyConditionsApplicationsOutputReference;
    putApplications(value: ConditionalAccessPolicyConditionsApplications): void;
    get applicationsInput(): ConditionalAccessPolicyConditionsApplications | undefined;
    private _devices;
    get devices(): ConditionalAccessPolicyConditionsDevicesOutputReference;
    putDevices(value: ConditionalAccessPolicyConditionsDevices): void;
    resetDevices(): void;
    get devicesInput(): ConditionalAccessPolicyConditionsDevices | undefined;
    private _locations;
    get locations(): ConditionalAccessPolicyConditionsLocationsOutputReference;
    putLocations(value: ConditionalAccessPolicyConditionsLocations): void;
    resetLocations(): void;
    get locationsInput(): ConditionalAccessPolicyConditionsLocations | undefined;
    private _platforms;
    get platforms(): ConditionalAccessPolicyConditionsPlatformsOutputReference;
    putPlatforms(value: ConditionalAccessPolicyConditionsPlatforms): void;
    resetPlatforms(): void;
    get platformsInput(): ConditionalAccessPolicyConditionsPlatforms | undefined;
    private _users;
    get users(): ConditionalAccessPolicyConditionsUsersOutputReference;
    putUsers(value: ConditionalAccessPolicyConditionsUsers): void;
    get usersInput(): ConditionalAccessPolicyConditionsUsers | undefined;
}
export interface ConditionalAccessPolicyGrantControls {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#built_in_controls ConditionalAccessPolicy#built_in_controls}
    */
    readonly builtInControls: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#custom_authentication_factors ConditionalAccessPolicy#custom_authentication_factors}
    */
    readonly customAuthenticationFactors?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#operator ConditionalAccessPolicy#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#terms_of_use ConditionalAccessPolicy#terms_of_use}
    */
    readonly termsOfUse?: string[];
}
export declare function conditionalAccessPolicyGrantControlsToTerraform(struct?: ConditionalAccessPolicyGrantControlsOutputReference | ConditionalAccessPolicyGrantControls): any;
export declare class ConditionalAccessPolicyGrantControlsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ConditionalAccessPolicyGrantControls | undefined;
    set internalValue(value: ConditionalAccessPolicyGrantControls | undefined);
    private _builtInControls?;
    get builtInControls(): string[];
    set builtInControls(value: string[]);
    get builtInControlsInput(): string[] | undefined;
    private _customAuthenticationFactors?;
    get customAuthenticationFactors(): string[];
    set customAuthenticationFactors(value: string[]);
    resetCustomAuthenticationFactors(): void;
    get customAuthenticationFactorsInput(): string[] | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _termsOfUse?;
    get termsOfUse(): string[];
    set termsOfUse(value: string[]);
    resetTermsOfUse(): void;
    get termsOfUseInput(): string[] | undefined;
}
export interface ConditionalAccessPolicySessionControls {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#application_enforced_restrictions_enabled ConditionalAccessPolicy#application_enforced_restrictions_enabled}
    */
    readonly applicationEnforcedRestrictionsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#cloud_app_security_policy ConditionalAccessPolicy#cloud_app_security_policy}
    */
    readonly cloudAppSecurityPolicy?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#persistent_browser_mode ConditionalAccessPolicy#persistent_browser_mode}
    */
    readonly persistentBrowserMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#sign_in_frequency ConditionalAccessPolicy#sign_in_frequency}
    */
    readonly signInFrequency?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#sign_in_frequency_period ConditionalAccessPolicy#sign_in_frequency_period}
    */
    readonly signInFrequencyPeriod?: string;
}
export declare function conditionalAccessPolicySessionControlsToTerraform(struct?: ConditionalAccessPolicySessionControlsOutputReference | ConditionalAccessPolicySessionControls): any;
export declare class ConditionalAccessPolicySessionControlsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ConditionalAccessPolicySessionControls | undefined;
    set internalValue(value: ConditionalAccessPolicySessionControls | undefined);
    private _applicationEnforcedRestrictionsEnabled?;
    get applicationEnforcedRestrictionsEnabled(): boolean | cdktf.IResolvable;
    set applicationEnforcedRestrictionsEnabled(value: boolean | cdktf.IResolvable);
    resetApplicationEnforcedRestrictionsEnabled(): void;
    get applicationEnforcedRestrictionsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _cloudAppSecurityPolicy?;
    get cloudAppSecurityPolicy(): string;
    set cloudAppSecurityPolicy(value: string);
    resetCloudAppSecurityPolicy(): void;
    get cloudAppSecurityPolicyInput(): string | undefined;
    private _persistentBrowserMode?;
    get persistentBrowserMode(): string;
    set persistentBrowserMode(value: string);
    resetPersistentBrowserMode(): void;
    get persistentBrowserModeInput(): string | undefined;
    private _signInFrequency?;
    get signInFrequency(): number;
    set signInFrequency(value: number);
    resetSignInFrequency(): void;
    get signInFrequencyInput(): number | undefined;
    private _signInFrequencyPeriod?;
    get signInFrequencyPeriod(): string;
    set signInFrequencyPeriod(value: string);
    resetSignInFrequencyPeriod(): void;
    get signInFrequencyPeriodInput(): string | undefined;
}
export interface ConditionalAccessPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#create ConditionalAccessPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#delete ConditionalAccessPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#read ConditionalAccessPolicy#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy#update ConditionalAccessPolicy#update}
    */
    readonly update?: string;
}
export declare function conditionalAccessPolicyTimeoutsToTerraform(struct?: ConditionalAccessPolicyTimeoutsOutputReference | ConditionalAccessPolicyTimeouts | cdktf.IResolvable): any;
export declare class ConditionalAccessPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ConditionalAccessPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ConditionalAccessPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy azuread_conditional_access_policy}
*/
export declare class ConditionalAccessPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "azuread_conditional_access_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy azuread_conditional_access_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ConditionalAccessPolicyConfig
    */
    constructor(scope: Construct, id: string, config: ConditionalAccessPolicyConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _state?;
    get state(): string;
    set state(value: string);
    get stateInput(): string | undefined;
    private _conditions;
    get conditions(): ConditionalAccessPolicyConditionsOutputReference;
    putConditions(value: ConditionalAccessPolicyConditions): void;
    get conditionsInput(): ConditionalAccessPolicyConditions | undefined;
    private _grantControls;
    get grantControls(): ConditionalAccessPolicyGrantControlsOutputReference;
    putGrantControls(value: ConditionalAccessPolicyGrantControls): void;
    get grantControlsInput(): ConditionalAccessPolicyGrantControls | undefined;
    private _sessionControls;
    get sessionControls(): ConditionalAccessPolicySessionControlsOutputReference;
    putSessionControls(value: ConditionalAccessPolicySessionControls): void;
    resetSessionControls(): void;
    get sessionControlsInput(): ConditionalAccessPolicySessionControls | undefined;
    private _timeouts;
    get timeouts(): ConditionalAccessPolicyTimeoutsOutputReference;
    putTimeouts(value: ConditionalAccessPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ConditionalAccessPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
