"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConditionalAccessPolicy = exports.ConditionalAccessPolicyTimeoutsOutputReference = exports.conditionalAccessPolicyTimeoutsToTerraform = exports.ConditionalAccessPolicySessionControlsOutputReference = exports.conditionalAccessPolicySessionControlsToTerraform = exports.ConditionalAccessPolicyGrantControlsOutputReference = exports.conditionalAccessPolicyGrantControlsToTerraform = exports.ConditionalAccessPolicyConditionsOutputReference = exports.conditionalAccessPolicyConditionsToTerraform = exports.ConditionalAccessPolicyConditionsUsersOutputReference = exports.conditionalAccessPolicyConditionsUsersToTerraform = exports.ConditionalAccessPolicyConditionsPlatformsOutputReference = exports.conditionalAccessPolicyConditionsPlatformsToTerraform = exports.ConditionalAccessPolicyConditionsLocationsOutputReference = exports.conditionalAccessPolicyConditionsLocationsToTerraform = exports.ConditionalAccessPolicyConditionsDevicesOutputReference = exports.conditionalAccessPolicyConditionsDevicesToTerraform = exports.ConditionalAccessPolicyConditionsDevicesFilterOutputReference = exports.conditionalAccessPolicyConditionsDevicesFilterToTerraform = exports.ConditionalAccessPolicyConditionsApplicationsOutputReference = exports.conditionalAccessPolicyConditionsApplicationsToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function conditionalAccessPolicyConditionsApplicationsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        excluded_applications: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.excludedApplications),
        included_applications: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.includedApplications),
        included_user_actions: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.includedUserActions),
    };
}
exports.conditionalAccessPolicyConditionsApplicationsToTerraform = conditionalAccessPolicyConditionsApplicationsToTerraform;
class ConditionalAccessPolicyConditionsApplicationsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._excludedApplications !== undefined) {
            hasAnyValues = true;
            internalValueResult.excludedApplications = this._excludedApplications;
        }
        if (this._includedApplications !== undefined) {
            hasAnyValues = true;
            internalValueResult.includedApplications = this._includedApplications;
        }
        if (this._includedUserActions !== undefined) {
            hasAnyValues = true;
            internalValueResult.includedUserActions = this._includedUserActions;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._excludedApplications = undefined;
            this._includedApplications = undefined;
            this._includedUserActions = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._excludedApplications = value.excludedApplications;
            this._includedApplications = value.includedApplications;
            this._includedUserActions = value.includedUserActions;
        }
    }
    get excludedApplications() {
        return this.getListAttribute('excluded_applications');
    }
    set excludedApplications(value) {
        this._excludedApplications = value;
    }
    resetExcludedApplications() {
        this._excludedApplications = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get excludedApplicationsInput() {
        return this._excludedApplications;
    }
    get includedApplications() {
        return this.getListAttribute('included_applications');
    }
    set includedApplications(value) {
        this._includedApplications = value;
    }
    resetIncludedApplications() {
        this._includedApplications = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get includedApplicationsInput() {
        return this._includedApplications;
    }
    get includedUserActions() {
        return this.getListAttribute('included_user_actions');
    }
    set includedUserActions(value) {
        this._includedUserActions = value;
    }
    resetIncludedUserActions() {
        this._includedUserActions = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get includedUserActionsInput() {
        return this._includedUserActions;
    }
}
exports.ConditionalAccessPolicyConditionsApplicationsOutputReference = ConditionalAccessPolicyConditionsApplicationsOutputReference;
_a = JSII_RTTI_SYMBOL_1;
ConditionalAccessPolicyConditionsApplicationsOutputReference[_a] = { fqn: "@cdktf/provider-azuread.ConditionalAccessPolicyConditionsApplicationsOutputReference", version: "2.0.41" };
function conditionalAccessPolicyConditionsDevicesFilterToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        mode: cdktf.stringToTerraform(struct.mode),
        rule: cdktf.stringToTerraform(struct.rule),
    };
}
exports.conditionalAccessPolicyConditionsDevicesFilterToTerraform = conditionalAccessPolicyConditionsDevicesFilterToTerraform;
class ConditionalAccessPolicyConditionsDevicesFilterOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._mode !== undefined) {
            hasAnyValues = true;
            internalValueResult.mode = this._mode;
        }
        if (this._rule !== undefined) {
            hasAnyValues = true;
            internalValueResult.rule = this._rule;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._mode = undefined;
            this._rule = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._mode = value.mode;
            this._rule = value.rule;
        }
    }
    get mode() {
        return this.getStringAttribute('mode');
    }
    set mode(value) {
        this._mode = value;
    }
    // Temporarily expose input value. Use with caution.
    get modeInput() {
        return this._mode;
    }
    get rule() {
        return this.getStringAttribute('rule');
    }
    set rule(value) {
        this._rule = value;
    }
    // Temporarily expose input value. Use with caution.
    get ruleInput() {
        return this._rule;
    }
}
exports.ConditionalAccessPolicyConditionsDevicesFilterOutputReference = ConditionalAccessPolicyConditionsDevicesFilterOutputReference;
_b = JSII_RTTI_SYMBOL_1;
ConditionalAccessPolicyConditionsDevicesFilterOutputReference[_b] = { fqn: "@cdktf/provider-azuread.ConditionalAccessPolicyConditionsDevicesFilterOutputReference", version: "2.0.41" };
function conditionalAccessPolicyConditionsDevicesToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        filter: conditionalAccessPolicyConditionsDevicesFilterToTerraform(struct.filter),
    };
}
exports.conditionalAccessPolicyConditionsDevicesToTerraform = conditionalAccessPolicyConditionsDevicesToTerraform;
class ConditionalAccessPolicyConditionsDevicesOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
        // filter - computed: false, optional: true, required: false
        this._filter = new ConditionalAccessPolicyConditionsDevicesFilterOutputReference(this, "filter");
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._filter?.internalValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.filter = this._filter?.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._filter.internalValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._filter.internalValue = value.filter;
        }
    }
    get filter() {
        return this._filter;
    }
    putFilter(value) {
        this._filter.internalValue = value;
    }
    resetFilter() {
        this._filter.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get filterInput() {
        return this._filter.internalValue;
    }
}
exports.ConditionalAccessPolicyConditionsDevicesOutputReference = ConditionalAccessPolicyConditionsDevicesOutputReference;
_c = JSII_RTTI_SYMBOL_1;
ConditionalAccessPolicyConditionsDevicesOutputReference[_c] = { fqn: "@cdktf/provider-azuread.ConditionalAccessPolicyConditionsDevicesOutputReference", version: "2.0.41" };
function conditionalAccessPolicyConditionsLocationsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        excluded_locations: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.excludedLocations),
        included_locations: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.includedLocations),
    };
}
exports.conditionalAccessPolicyConditionsLocationsToTerraform = conditionalAccessPolicyConditionsLocationsToTerraform;
class ConditionalAccessPolicyConditionsLocationsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._excludedLocations !== undefined) {
            hasAnyValues = true;
            internalValueResult.excludedLocations = this._excludedLocations;
        }
        if (this._includedLocations !== undefined) {
            hasAnyValues = true;
            internalValueResult.includedLocations = this._includedLocations;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._excludedLocations = undefined;
            this._includedLocations = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._excludedLocations = value.excludedLocations;
            this._includedLocations = value.includedLocations;
        }
    }
    get excludedLocations() {
        return this.getListAttribute('excluded_locations');
    }
    set excludedLocations(value) {
        this._excludedLocations = value;
    }
    resetExcludedLocations() {
        this._excludedLocations = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get excludedLocationsInput() {
        return this._excludedLocations;
    }
    get includedLocations() {
        return this.getListAttribute('included_locations');
    }
    set includedLocations(value) {
        this._includedLocations = value;
    }
    // Temporarily expose input value. Use with caution.
    get includedLocationsInput() {
        return this._includedLocations;
    }
}
exports.ConditionalAccessPolicyConditionsLocationsOutputReference = ConditionalAccessPolicyConditionsLocationsOutputReference;
_d = JSII_RTTI_SYMBOL_1;
ConditionalAccessPolicyConditionsLocationsOutputReference[_d] = { fqn: "@cdktf/provider-azuread.ConditionalAccessPolicyConditionsLocationsOutputReference", version: "2.0.41" };
function conditionalAccessPolicyConditionsPlatformsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        excluded_platforms: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.excludedPlatforms),
        included_platforms: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.includedPlatforms),
    };
}
exports.conditionalAccessPolicyConditionsPlatformsToTerraform = conditionalAccessPolicyConditionsPlatformsToTerraform;
class ConditionalAccessPolicyConditionsPlatformsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._excludedPlatforms !== undefined) {
            hasAnyValues = true;
            internalValueResult.excludedPlatforms = this._excludedPlatforms;
        }
        if (this._includedPlatforms !== undefined) {
            hasAnyValues = true;
            internalValueResult.includedPlatforms = this._includedPlatforms;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._excludedPlatforms = undefined;
            this._includedPlatforms = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._excludedPlatforms = value.excludedPlatforms;
            this._includedPlatforms = value.includedPlatforms;
        }
    }
    get excludedPlatforms() {
        return this.getListAttribute('excluded_platforms');
    }
    set excludedPlatforms(value) {
        this._excludedPlatforms = value;
    }
    resetExcludedPlatforms() {
        this._excludedPlatforms = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get excludedPlatformsInput() {
        return this._excludedPlatforms;
    }
    get includedPlatforms() {
        return this.getListAttribute('included_platforms');
    }
    set includedPlatforms(value) {
        this._includedPlatforms = value;
    }
    // Temporarily expose input value. Use with caution.
    get includedPlatformsInput() {
        return this._includedPlatforms;
    }
}
exports.ConditionalAccessPolicyConditionsPlatformsOutputReference = ConditionalAccessPolicyConditionsPlatformsOutputReference;
_e = JSII_RTTI_SYMBOL_1;
ConditionalAccessPolicyConditionsPlatformsOutputReference[_e] = { fqn: "@cdktf/provider-azuread.ConditionalAccessPolicyConditionsPlatformsOutputReference", version: "2.0.41" };
function conditionalAccessPolicyConditionsUsersToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        excluded_groups: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.excludedGroups),
        excluded_roles: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.excludedRoles),
        excluded_users: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.excludedUsers),
        included_groups: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.includedGroups),
        included_roles: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.includedRoles),
        included_users: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.includedUsers),
    };
}
exports.conditionalAccessPolicyConditionsUsersToTerraform = conditionalAccessPolicyConditionsUsersToTerraform;
class ConditionalAccessPolicyConditionsUsersOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._excludedGroups !== undefined) {
            hasAnyValues = true;
            internalValueResult.excludedGroups = this._excludedGroups;
        }
        if (this._excludedRoles !== undefined) {
            hasAnyValues = true;
            internalValueResult.excludedRoles = this._excludedRoles;
        }
        if (this._excludedUsers !== undefined) {
            hasAnyValues = true;
            internalValueResult.excludedUsers = this._excludedUsers;
        }
        if (this._includedGroups !== undefined) {
            hasAnyValues = true;
            internalValueResult.includedGroups = this._includedGroups;
        }
        if (this._includedRoles !== undefined) {
            hasAnyValues = true;
            internalValueResult.includedRoles = this._includedRoles;
        }
        if (this._includedUsers !== undefined) {
            hasAnyValues = true;
            internalValueResult.includedUsers = this._includedUsers;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._excludedGroups = undefined;
            this._excludedRoles = undefined;
            this._excludedUsers = undefined;
            this._includedGroups = undefined;
            this._includedRoles = undefined;
            this._includedUsers = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._excludedGroups = value.excludedGroups;
            this._excludedRoles = value.excludedRoles;
            this._excludedUsers = value.excludedUsers;
            this._includedGroups = value.includedGroups;
            this._includedRoles = value.includedRoles;
            this._includedUsers = value.includedUsers;
        }
    }
    get excludedGroups() {
        return this.getListAttribute('excluded_groups');
    }
    set excludedGroups(value) {
        this._excludedGroups = value;
    }
    resetExcludedGroups() {
        this._excludedGroups = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get excludedGroupsInput() {
        return this._excludedGroups;
    }
    get excludedRoles() {
        return this.getListAttribute('excluded_roles');
    }
    set excludedRoles(value) {
        this._excludedRoles = value;
    }
    resetExcludedRoles() {
        this._excludedRoles = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get excludedRolesInput() {
        return this._excludedRoles;
    }
    get excludedUsers() {
        return this.getListAttribute('excluded_users');
    }
    set excludedUsers(value) {
        this._excludedUsers = value;
    }
    resetExcludedUsers() {
        this._excludedUsers = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get excludedUsersInput() {
        return this._excludedUsers;
    }
    get includedGroups() {
        return this.getListAttribute('included_groups');
    }
    set includedGroups(value) {
        this._includedGroups = value;
    }
    resetIncludedGroups() {
        this._includedGroups = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get includedGroupsInput() {
        return this._includedGroups;
    }
    get includedRoles() {
        return this.getListAttribute('included_roles');
    }
    set includedRoles(value) {
        this._includedRoles = value;
    }
    resetIncludedRoles() {
        this._includedRoles = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get includedRolesInput() {
        return this._includedRoles;
    }
    get includedUsers() {
        return this.getListAttribute('included_users');
    }
    set includedUsers(value) {
        this._includedUsers = value;
    }
    resetIncludedUsers() {
        this._includedUsers = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get includedUsersInput() {
        return this._includedUsers;
    }
}
exports.ConditionalAccessPolicyConditionsUsersOutputReference = ConditionalAccessPolicyConditionsUsersOutputReference;
_f = JSII_RTTI_SYMBOL_1;
ConditionalAccessPolicyConditionsUsersOutputReference[_f] = { fqn: "@cdktf/provider-azuread.ConditionalAccessPolicyConditionsUsersOutputReference", version: "2.0.41" };
function conditionalAccessPolicyConditionsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        client_app_types: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.clientAppTypes),
        sign_in_risk_levels: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.signInRiskLevels),
        user_risk_levels: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.userRiskLevels),
        applications: conditionalAccessPolicyConditionsApplicationsToTerraform(struct.applications),
        devices: conditionalAccessPolicyConditionsDevicesToTerraform(struct.devices),
        locations: conditionalAccessPolicyConditionsLocationsToTerraform(struct.locations),
        platforms: conditionalAccessPolicyConditionsPlatformsToTerraform(struct.platforms),
        users: conditionalAccessPolicyConditionsUsersToTerraform(struct.users),
    };
}
exports.conditionalAccessPolicyConditionsToTerraform = conditionalAccessPolicyConditionsToTerraform;
class ConditionalAccessPolicyConditionsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
        // applications - computed: false, optional: false, required: true
        this._applications = new ConditionalAccessPolicyConditionsApplicationsOutputReference(this, "applications");
        // devices - computed: false, optional: true, required: false
        this._devices = new ConditionalAccessPolicyConditionsDevicesOutputReference(this, "devices");
        // locations - computed: false, optional: true, required: false
        this._locations = new ConditionalAccessPolicyConditionsLocationsOutputReference(this, "locations");
        // platforms - computed: false, optional: true, required: false
        this._platforms = new ConditionalAccessPolicyConditionsPlatformsOutputReference(this, "platforms");
        // users - computed: false, optional: false, required: true
        this._users = new ConditionalAccessPolicyConditionsUsersOutputReference(this, "users");
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._clientAppTypes !== undefined) {
            hasAnyValues = true;
            internalValueResult.clientAppTypes = this._clientAppTypes;
        }
        if (this._signInRiskLevels !== undefined) {
            hasAnyValues = true;
            internalValueResult.signInRiskLevels = this._signInRiskLevels;
        }
        if (this._userRiskLevels !== undefined) {
            hasAnyValues = true;
            internalValueResult.userRiskLevels = this._userRiskLevels;
        }
        if (this._applications?.internalValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.applications = this._applications?.internalValue;
        }
        if (this._devices?.internalValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.devices = this._devices?.internalValue;
        }
        if (this._locations?.internalValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.locations = this._locations?.internalValue;
        }
        if (this._platforms?.internalValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.platforms = this._platforms?.internalValue;
        }
        if (this._users?.internalValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.users = this._users?.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._clientAppTypes = undefined;
            this._signInRiskLevels = undefined;
            this._userRiskLevels = undefined;
            this._applications.internalValue = undefined;
            this._devices.internalValue = undefined;
            this._locations.internalValue = undefined;
            this._platforms.internalValue = undefined;
            this._users.internalValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._clientAppTypes = value.clientAppTypes;
            this._signInRiskLevels = value.signInRiskLevels;
            this._userRiskLevels = value.userRiskLevels;
            this._applications.internalValue = value.applications;
            this._devices.internalValue = value.devices;
            this._locations.internalValue = value.locations;
            this._platforms.internalValue = value.platforms;
            this._users.internalValue = value.users;
        }
    }
    get clientAppTypes() {
        return this.getListAttribute('client_app_types');
    }
    set clientAppTypes(value) {
        this._clientAppTypes = value;
    }
    // Temporarily expose input value. Use with caution.
    get clientAppTypesInput() {
        return this._clientAppTypes;
    }
    get signInRiskLevels() {
        return this.getListAttribute('sign_in_risk_levels');
    }
    set signInRiskLevels(value) {
        this._signInRiskLevels = value;
    }
    resetSignInRiskLevels() {
        this._signInRiskLevels = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get signInRiskLevelsInput() {
        return this._signInRiskLevels;
    }
    get userRiskLevels() {
        return this.getListAttribute('user_risk_levels');
    }
    set userRiskLevels(value) {
        this._userRiskLevels = value;
    }
    resetUserRiskLevels() {
        this._userRiskLevels = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userRiskLevelsInput() {
        return this._userRiskLevels;
    }
    get applications() {
        return this._applications;
    }
    putApplications(value) {
        this._applications.internalValue = value;
    }
    // Temporarily expose input value. Use with caution.
    get applicationsInput() {
        return this._applications.internalValue;
    }
    get devices() {
        return this._devices;
    }
    putDevices(value) {
        this._devices.internalValue = value;
    }
    resetDevices() {
        this._devices.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get devicesInput() {
        return this._devices.internalValue;
    }
    get locations() {
        return this._locations;
    }
    putLocations(value) {
        this._locations.internalValue = value;
    }
    resetLocations() {
        this._locations.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get locationsInput() {
        return this._locations.internalValue;
    }
    get platforms() {
        return this._platforms;
    }
    putPlatforms(value) {
        this._platforms.internalValue = value;
    }
    resetPlatforms() {
        this._platforms.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get platformsInput() {
        return this._platforms.internalValue;
    }
    get users() {
        return this._users;
    }
    putUsers(value) {
        this._users.internalValue = value;
    }
    // Temporarily expose input value. Use with caution.
    get usersInput() {
        return this._users.internalValue;
    }
}
exports.ConditionalAccessPolicyConditionsOutputReference = ConditionalAccessPolicyConditionsOutputReference;
_g = JSII_RTTI_SYMBOL_1;
ConditionalAccessPolicyConditionsOutputReference[_g] = { fqn: "@cdktf/provider-azuread.ConditionalAccessPolicyConditionsOutputReference", version: "2.0.41" };
function conditionalAccessPolicyGrantControlsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        built_in_controls: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.builtInControls),
        custom_authentication_factors: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.customAuthenticationFactors),
        operator: cdktf.stringToTerraform(struct.operator),
        terms_of_use: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.termsOfUse),
    };
}
exports.conditionalAccessPolicyGrantControlsToTerraform = conditionalAccessPolicyGrantControlsToTerraform;
class ConditionalAccessPolicyGrantControlsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._builtInControls !== undefined) {
            hasAnyValues = true;
            internalValueResult.builtInControls = this._builtInControls;
        }
        if (this._customAuthenticationFactors !== undefined) {
            hasAnyValues = true;
            internalValueResult.customAuthenticationFactors = this._customAuthenticationFactors;
        }
        if (this._operator !== undefined) {
            hasAnyValues = true;
            internalValueResult.operator = this._operator;
        }
        if (this._termsOfUse !== undefined) {
            hasAnyValues = true;
            internalValueResult.termsOfUse = this._termsOfUse;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._builtInControls = undefined;
            this._customAuthenticationFactors = undefined;
            this._operator = undefined;
            this._termsOfUse = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._builtInControls = value.builtInControls;
            this._customAuthenticationFactors = value.customAuthenticationFactors;
            this._operator = value.operator;
            this._termsOfUse = value.termsOfUse;
        }
    }
    get builtInControls() {
        return this.getListAttribute('built_in_controls');
    }
    set builtInControls(value) {
        this._builtInControls = value;
    }
    // Temporarily expose input value. Use with caution.
    get builtInControlsInput() {
        return this._builtInControls;
    }
    get customAuthenticationFactors() {
        return this.getListAttribute('custom_authentication_factors');
    }
    set customAuthenticationFactors(value) {
        this._customAuthenticationFactors = value;
    }
    resetCustomAuthenticationFactors() {
        this._customAuthenticationFactors = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get customAuthenticationFactorsInput() {
        return this._customAuthenticationFactors;
    }
    get operator() {
        return this.getStringAttribute('operator');
    }
    set operator(value) {
        this._operator = value;
    }
    // Temporarily expose input value. Use with caution.
    get operatorInput() {
        return this._operator;
    }
    get termsOfUse() {
        return this.getListAttribute('terms_of_use');
    }
    set termsOfUse(value) {
        this._termsOfUse = value;
    }
    resetTermsOfUse() {
        this._termsOfUse = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get termsOfUseInput() {
        return this._termsOfUse;
    }
}
exports.ConditionalAccessPolicyGrantControlsOutputReference = ConditionalAccessPolicyGrantControlsOutputReference;
_h = JSII_RTTI_SYMBOL_1;
ConditionalAccessPolicyGrantControlsOutputReference[_h] = { fqn: "@cdktf/provider-azuread.ConditionalAccessPolicyGrantControlsOutputReference", version: "2.0.41" };
function conditionalAccessPolicySessionControlsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        application_enforced_restrictions_enabled: cdktf.booleanToTerraform(struct.applicationEnforcedRestrictionsEnabled),
        cloud_app_security_policy: cdktf.stringToTerraform(struct.cloudAppSecurityPolicy),
        persistent_browser_mode: cdktf.stringToTerraform(struct.persistentBrowserMode),
        sign_in_frequency: cdktf.numberToTerraform(struct.signInFrequency),
        sign_in_frequency_period: cdktf.stringToTerraform(struct.signInFrequencyPeriod),
    };
}
exports.conditionalAccessPolicySessionControlsToTerraform = conditionalAccessPolicySessionControlsToTerraform;
class ConditionalAccessPolicySessionControlsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._applicationEnforcedRestrictionsEnabled !== undefined) {
            hasAnyValues = true;
            internalValueResult.applicationEnforcedRestrictionsEnabled = this._applicationEnforcedRestrictionsEnabled;
        }
        if (this._cloudAppSecurityPolicy !== undefined) {
            hasAnyValues = true;
            internalValueResult.cloudAppSecurityPolicy = this._cloudAppSecurityPolicy;
        }
        if (this._persistentBrowserMode !== undefined) {
            hasAnyValues = true;
            internalValueResult.persistentBrowserMode = this._persistentBrowserMode;
        }
        if (this._signInFrequency !== undefined) {
            hasAnyValues = true;
            internalValueResult.signInFrequency = this._signInFrequency;
        }
        if (this._signInFrequencyPeriod !== undefined) {
            hasAnyValues = true;
            internalValueResult.signInFrequencyPeriod = this._signInFrequencyPeriod;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._applicationEnforcedRestrictionsEnabled = undefined;
            this._cloudAppSecurityPolicy = undefined;
            this._persistentBrowserMode = undefined;
            this._signInFrequency = undefined;
            this._signInFrequencyPeriod = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._applicationEnforcedRestrictionsEnabled = value.applicationEnforcedRestrictionsEnabled;
            this._cloudAppSecurityPolicy = value.cloudAppSecurityPolicy;
            this._persistentBrowserMode = value.persistentBrowserMode;
            this._signInFrequency = value.signInFrequency;
            this._signInFrequencyPeriod = value.signInFrequencyPeriod;
        }
    }
    get applicationEnforcedRestrictionsEnabled() {
        return this.getBooleanAttribute('application_enforced_restrictions_enabled');
    }
    set applicationEnforcedRestrictionsEnabled(value) {
        this._applicationEnforcedRestrictionsEnabled = value;
    }
    resetApplicationEnforcedRestrictionsEnabled() {
        this._applicationEnforcedRestrictionsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get applicationEnforcedRestrictionsEnabledInput() {
        return this._applicationEnforcedRestrictionsEnabled;
    }
    get cloudAppSecurityPolicy() {
        return this.getStringAttribute('cloud_app_security_policy');
    }
    set cloudAppSecurityPolicy(value) {
        this._cloudAppSecurityPolicy = value;
    }
    resetCloudAppSecurityPolicy() {
        this._cloudAppSecurityPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudAppSecurityPolicyInput() {
        return this._cloudAppSecurityPolicy;
    }
    get persistentBrowserMode() {
        return this.getStringAttribute('persistent_browser_mode');
    }
    set persistentBrowserMode(value) {
        this._persistentBrowserMode = value;
    }
    resetPersistentBrowserMode() {
        this._persistentBrowserMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get persistentBrowserModeInput() {
        return this._persistentBrowserMode;
    }
    get signInFrequency() {
        return this.getNumberAttribute('sign_in_frequency');
    }
    set signInFrequency(value) {
        this._signInFrequency = value;
    }
    resetSignInFrequency() {
        this._signInFrequency = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get signInFrequencyInput() {
        return this._signInFrequency;
    }
    get signInFrequencyPeriod() {
        return this.getStringAttribute('sign_in_frequency_period');
    }
    set signInFrequencyPeriod(value) {
        this._signInFrequencyPeriod = value;
    }
    resetSignInFrequencyPeriod() {
        this._signInFrequencyPeriod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get signInFrequencyPeriodInput() {
        return this._signInFrequencyPeriod;
    }
}
exports.ConditionalAccessPolicySessionControlsOutputReference = ConditionalAccessPolicySessionControlsOutputReference;
_j = JSII_RTTI_SYMBOL_1;
ConditionalAccessPolicySessionControlsOutputReference[_j] = { fqn: "@cdktf/provider-azuread.ConditionalAccessPolicySessionControlsOutputReference", version: "2.0.41" };
function conditionalAccessPolicyTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
        read: cdktf.stringToTerraform(struct.read),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.conditionalAccessPolicyTimeoutsToTerraform = conditionalAccessPolicyTimeoutsToTerraform;
class ConditionalAccessPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete !== undefined) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        if (this._read !== undefined) {
            hasAnyValues = true;
            internalValueResult.read = this._read;
        }
        if (this._update !== undefined) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._create = undefined;
            this._delete = undefined;
            this._read = undefined;
            this._update = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._create = value.create;
            this._delete = value.delete;
            this._read = value.read;
            this._update = value.update;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get delete() {
        return this.getStringAttribute('delete');
    }
    set delete(value) {
        this._delete = value;
    }
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteInput() {
        return this._delete;
    }
    get read() {
        return this.getStringAttribute('read');
    }
    set read(value) {
        this._read = value;
    }
    resetRead() {
        this._read = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get readInput() {
        return this._read;
    }
    get update() {
        return this.getStringAttribute('update');
    }
    set update(value) {
        this._update = value;
    }
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updateInput() {
        return this._update;
    }
}
exports.ConditionalAccessPolicyTimeoutsOutputReference = ConditionalAccessPolicyTimeoutsOutputReference;
_k = JSII_RTTI_SYMBOL_1;
ConditionalAccessPolicyTimeoutsOutputReference[_k] = { fqn: "@cdktf/provider-azuread.ConditionalAccessPolicyTimeoutsOutputReference", version: "2.0.41" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy azuread_conditional_access_policy}
*/
class ConditionalAccessPolicy extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azuread/r/conditional_access_policy azuread_conditional_access_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ConditionalAccessPolicyConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'azuread_conditional_access_policy',
            terraformGeneratorMetadata: {
                providerName: 'azuread',
                providerVersion: '2.28.0',
                providerVersionConstraint: '~> 2.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // conditions - computed: false, optional: false, required: true
        this._conditions = new ConditionalAccessPolicyConditionsOutputReference(this, "conditions");
        // grant_controls - computed: false, optional: false, required: true
        this._grantControls = new ConditionalAccessPolicyGrantControlsOutputReference(this, "grant_controls");
        // session_controls - computed: false, optional: true, required: false
        this._sessionControls = new ConditionalAccessPolicySessionControlsOutputReference(this, "session_controls");
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new ConditionalAccessPolicyTimeoutsOutputReference(this, "timeouts");
        this._displayName = config.displayName;
        this._id = config.id;
        this._state = config.state;
        this._conditions.internalValue = config.conditions;
        this._grantControls.internalValue = config.grantControls;
        this._sessionControls.internalValue = config.sessionControls;
        this._timeouts.internalValue = config.timeouts;
    }
    get displayName() {
        return this.getStringAttribute('display_name');
    }
    set displayName(value) {
        this._displayName = value;
    }
    // Temporarily expose input value. Use with caution.
    get displayNameInput() {
        return this._displayName;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get state() {
        return this.getStringAttribute('state');
    }
    set state(value) {
        this._state = value;
    }
    // Temporarily expose input value. Use with caution.
    get stateInput() {
        return this._state;
    }
    get conditions() {
        return this._conditions;
    }
    putConditions(value) {
        this._conditions.internalValue = value;
    }
    // Temporarily expose input value. Use with caution.
    get conditionsInput() {
        return this._conditions.internalValue;
    }
    get grantControls() {
        return this._grantControls;
    }
    putGrantControls(value) {
        this._grantControls.internalValue = value;
    }
    // Temporarily expose input value. Use with caution.
    get grantControlsInput() {
        return this._grantControls.internalValue;
    }
    get sessionControls() {
        return this._sessionControls;
    }
    putSessionControls(value) {
        this._sessionControls.internalValue = value;
    }
    resetSessionControls() {
        this._sessionControls.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sessionControlsInput() {
        return this._sessionControls.internalValue;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            display_name: cdktf.stringToTerraform(this._displayName),
            id: cdktf.stringToTerraform(this._id),
            state: cdktf.stringToTerraform(this._state),
            conditions: conditionalAccessPolicyConditionsToTerraform(this._conditions.internalValue),
            grant_controls: conditionalAccessPolicyGrantControlsToTerraform(this._grantControls.internalValue),
            session_controls: conditionalAccessPolicySessionControlsToTerraform(this._sessionControls.internalValue),
            timeouts: conditionalAccessPolicyTimeoutsToTerraform(this._timeouts.internalValue),
        };
    }
}
exports.ConditionalAccessPolicy = ConditionalAccessPolicy;
_l = JSII_RTTI_SYMBOL_1;
ConditionalAccessPolicy[_l] = { fqn: "@cdktf/provider-azuread.ConditionalAccessPolicy", version: "2.0.41" };
// =================
// STATIC PROPERTIES
// =================
ConditionalAccessPolicy.tfResourceType = "azuread_conditional_access_policy";
//# sourceMappingURL=data:application/json;base64,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