import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzureadApplicationPublishedAppIdsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/application_published_app_ids#id DataAzureadApplicationPublishedAppIds#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/application_published_app_ids#timeouts DataAzureadApplicationPublishedAppIds#timeouts}
    */
    readonly timeouts?: DataAzureadApplicationPublishedAppIdsTimeouts;
}
export interface DataAzureadApplicationPublishedAppIdsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/application_published_app_ids#read DataAzureadApplicationPublishedAppIds#read}
    */
    readonly read?: string;
}
export declare function dataAzureadApplicationPublishedAppIdsTimeoutsToTerraform(struct?: DataAzureadApplicationPublishedAppIdsTimeoutsOutputReference | DataAzureadApplicationPublishedAppIdsTimeouts | cdktf.IResolvable): any;
export declare class DataAzureadApplicationPublishedAppIdsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzureadApplicationPublishedAppIdsTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzureadApplicationPublishedAppIdsTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azuread/d/application_published_app_ids azuread_application_published_app_ids}
*/
export declare class DataAzureadApplicationPublishedAppIds extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azuread_application_published_app_ids";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azuread/d/application_published_app_ids azuread_application_published_app_ids} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzureadApplicationPublishedAppIdsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAzureadApplicationPublishedAppIdsConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _result;
    get result(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzureadApplicationPublishedAppIdsTimeoutsOutputReference;
    putTimeouts(value: DataAzureadApplicationPublishedAppIdsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzureadApplicationPublishedAppIdsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
