import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzureadApplicationConfig extends cdktf.TerraformMetaArguments {
    /**
    * The Application ID (also called Client ID)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/application#application_id DataAzureadApplication#application_id}
    */
    readonly applicationId?: string;
    /**
    * The display name for the application
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/application#display_name DataAzureadApplication#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/application#id DataAzureadApplication#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The application's object ID
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/application#object_id DataAzureadApplication#object_id}
    */
    readonly objectId?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/application#timeouts DataAzureadApplication#timeouts}
    */
    readonly timeouts?: DataAzureadApplicationTimeouts;
}
export interface DataAzureadApplicationApiOauth2PermissionScopes {
}
export declare function dataAzureadApplicationApiOauth2PermissionScopesToTerraform(struct?: DataAzureadApplicationApiOauth2PermissionScopes): any;
export declare class DataAzureadApplicationApiOauth2PermissionScopesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzureadApplicationApiOauth2PermissionScopes | undefined;
    set internalValue(value: DataAzureadApplicationApiOauth2PermissionScopes | undefined);
    get adminConsentDescription(): string;
    get adminConsentDisplayName(): string;
    get enabled(): cdktf.IResolvable;
    get id(): string;
    get type(): string;
    get userConsentDescription(): string;
    get userConsentDisplayName(): string;
    get value(): string;
}
export declare class DataAzureadApplicationApiOauth2PermissionScopesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzureadApplicationApiOauth2PermissionScopesOutputReference;
}
export interface DataAzureadApplicationApi {
}
export declare function dataAzureadApplicationApiToTerraform(struct?: DataAzureadApplicationApi): any;
export declare class DataAzureadApplicationApiOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzureadApplicationApi | undefined;
    set internalValue(value: DataAzureadApplicationApi | undefined);
    get knownClientApplications(): string[];
    get mappedClaimsEnabled(): cdktf.IResolvable;
    private _oauth2PermissionScopes;
    get oauth2PermissionScopes(): DataAzureadApplicationApiOauth2PermissionScopesList;
    get requestedAccessTokenVersion(): number;
}
export declare class DataAzureadApplicationApiList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzureadApplicationApiOutputReference;
}
export interface DataAzureadApplicationAppRoles {
}
export declare function dataAzureadApplicationAppRolesToTerraform(struct?: DataAzureadApplicationAppRoles): any;
export declare class DataAzureadApplicationAppRolesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzureadApplicationAppRoles | undefined;
    set internalValue(value: DataAzureadApplicationAppRoles | undefined);
    get allowedMemberTypes(): string[];
    get description(): string;
    get displayName(): string;
    get enabled(): cdktf.IResolvable;
    get id(): string;
    get value(): string;
}
export declare class DataAzureadApplicationAppRolesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzureadApplicationAppRolesOutputReference;
}
export interface DataAzureadApplicationFeatureTags {
}
export declare function dataAzureadApplicationFeatureTagsToTerraform(struct?: DataAzureadApplicationFeatureTags): any;
export declare class DataAzureadApplicationFeatureTagsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzureadApplicationFeatureTags | undefined;
    set internalValue(value: DataAzureadApplicationFeatureTags | undefined);
    get customSingleSignOn(): cdktf.IResolvable;
    get enterprise(): cdktf.IResolvable;
    get gallery(): cdktf.IResolvable;
    get hide(): cdktf.IResolvable;
}
export declare class DataAzureadApplicationFeatureTagsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzureadApplicationFeatureTagsOutputReference;
}
export interface DataAzureadApplicationOptionalClaimsAccessToken {
}
export declare function dataAzureadApplicationOptionalClaimsAccessTokenToTerraform(struct?: DataAzureadApplicationOptionalClaimsAccessToken): any;
export declare class DataAzureadApplicationOptionalClaimsAccessTokenOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzureadApplicationOptionalClaimsAccessToken | undefined;
    set internalValue(value: DataAzureadApplicationOptionalClaimsAccessToken | undefined);
    get additionalProperties(): string[];
    get essential(): cdktf.IResolvable;
    get name(): string;
    get source(): string;
}
export declare class DataAzureadApplicationOptionalClaimsAccessTokenList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzureadApplicationOptionalClaimsAccessTokenOutputReference;
}
export interface DataAzureadApplicationOptionalClaimsIdToken {
}
export declare function dataAzureadApplicationOptionalClaimsIdTokenToTerraform(struct?: DataAzureadApplicationOptionalClaimsIdToken): any;
export declare class DataAzureadApplicationOptionalClaimsIdTokenOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzureadApplicationOptionalClaimsIdToken | undefined;
    set internalValue(value: DataAzureadApplicationOptionalClaimsIdToken | undefined);
    get additionalProperties(): string[];
    get essential(): cdktf.IResolvable;
    get name(): string;
    get source(): string;
}
export declare class DataAzureadApplicationOptionalClaimsIdTokenList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzureadApplicationOptionalClaimsIdTokenOutputReference;
}
export interface DataAzureadApplicationOptionalClaimsSaml2Token {
}
export declare function dataAzureadApplicationOptionalClaimsSaml2TokenToTerraform(struct?: DataAzureadApplicationOptionalClaimsSaml2Token): any;
export declare class DataAzureadApplicationOptionalClaimsSaml2TokenOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzureadApplicationOptionalClaimsSaml2Token | undefined;
    set internalValue(value: DataAzureadApplicationOptionalClaimsSaml2Token | undefined);
    get additionalProperties(): string[];
    get essential(): cdktf.IResolvable;
    get name(): string;
    get source(): string;
}
export declare class DataAzureadApplicationOptionalClaimsSaml2TokenList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzureadApplicationOptionalClaimsSaml2TokenOutputReference;
}
export interface DataAzureadApplicationOptionalClaims {
}
export declare function dataAzureadApplicationOptionalClaimsToTerraform(struct?: DataAzureadApplicationOptionalClaims): any;
export declare class DataAzureadApplicationOptionalClaimsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzureadApplicationOptionalClaims | undefined;
    set internalValue(value: DataAzureadApplicationOptionalClaims | undefined);
    private _accessToken;
    get accessToken(): DataAzureadApplicationOptionalClaimsAccessTokenList;
    private _idToken;
    get idToken(): DataAzureadApplicationOptionalClaimsIdTokenList;
    private _saml2Token;
    get saml2Token(): DataAzureadApplicationOptionalClaimsSaml2TokenList;
}
export declare class DataAzureadApplicationOptionalClaimsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzureadApplicationOptionalClaimsOutputReference;
}
export interface DataAzureadApplicationPublicClient {
}
export declare function dataAzureadApplicationPublicClientToTerraform(struct?: DataAzureadApplicationPublicClient): any;
export declare class DataAzureadApplicationPublicClientOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzureadApplicationPublicClient | undefined;
    set internalValue(value: DataAzureadApplicationPublicClient | undefined);
    get redirectUris(): string[];
}
export declare class DataAzureadApplicationPublicClientList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzureadApplicationPublicClientOutputReference;
}
export interface DataAzureadApplicationRequiredResourceAccessResourceAccess {
}
export declare function dataAzureadApplicationRequiredResourceAccessResourceAccessToTerraform(struct?: DataAzureadApplicationRequiredResourceAccessResourceAccess): any;
export declare class DataAzureadApplicationRequiredResourceAccessResourceAccessOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzureadApplicationRequiredResourceAccessResourceAccess | undefined;
    set internalValue(value: DataAzureadApplicationRequiredResourceAccessResourceAccess | undefined);
    get id(): string;
    get type(): string;
}
export declare class DataAzureadApplicationRequiredResourceAccessResourceAccessList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzureadApplicationRequiredResourceAccessResourceAccessOutputReference;
}
export interface DataAzureadApplicationRequiredResourceAccess {
}
export declare function dataAzureadApplicationRequiredResourceAccessToTerraform(struct?: DataAzureadApplicationRequiredResourceAccess): any;
export declare class DataAzureadApplicationRequiredResourceAccessOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzureadApplicationRequiredResourceAccess | undefined;
    set internalValue(value: DataAzureadApplicationRequiredResourceAccess | undefined);
    private _resourceAccess;
    get resourceAccess(): DataAzureadApplicationRequiredResourceAccessResourceAccessList;
    get resourceAppId(): string;
}
export declare class DataAzureadApplicationRequiredResourceAccessList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzureadApplicationRequiredResourceAccessOutputReference;
}
export interface DataAzureadApplicationSinglePageApplication {
}
export declare function dataAzureadApplicationSinglePageApplicationToTerraform(struct?: DataAzureadApplicationSinglePageApplication): any;
export declare class DataAzureadApplicationSinglePageApplicationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzureadApplicationSinglePageApplication | undefined;
    set internalValue(value: DataAzureadApplicationSinglePageApplication | undefined);
    get redirectUris(): string[];
}
export declare class DataAzureadApplicationSinglePageApplicationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzureadApplicationSinglePageApplicationOutputReference;
}
export interface DataAzureadApplicationWebImplicitGrant {
}
export declare function dataAzureadApplicationWebImplicitGrantToTerraform(struct?: DataAzureadApplicationWebImplicitGrant): any;
export declare class DataAzureadApplicationWebImplicitGrantOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzureadApplicationWebImplicitGrant | undefined;
    set internalValue(value: DataAzureadApplicationWebImplicitGrant | undefined);
    get accessTokenIssuanceEnabled(): cdktf.IResolvable;
    get idTokenIssuanceEnabled(): cdktf.IResolvable;
}
export declare class DataAzureadApplicationWebImplicitGrantList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzureadApplicationWebImplicitGrantOutputReference;
}
export interface DataAzureadApplicationWeb {
}
export declare function dataAzureadApplicationWebToTerraform(struct?: DataAzureadApplicationWeb): any;
export declare class DataAzureadApplicationWebOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzureadApplicationWeb | undefined;
    set internalValue(value: DataAzureadApplicationWeb | undefined);
    get homepageUrl(): string;
    private _implicitGrant;
    get implicitGrant(): DataAzureadApplicationWebImplicitGrantList;
    get logoutUrl(): string;
    get redirectUris(): string[];
}
export declare class DataAzureadApplicationWebList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzureadApplicationWebOutputReference;
}
export interface DataAzureadApplicationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/application#read DataAzureadApplication#read}
    */
    readonly read?: string;
}
export declare function dataAzureadApplicationTimeoutsToTerraform(struct?: DataAzureadApplicationTimeoutsOutputReference | DataAzureadApplicationTimeouts | cdktf.IResolvable): any;
export declare class DataAzureadApplicationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzureadApplicationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzureadApplicationTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azuread/d/application azuread_application}
*/
export declare class DataAzureadApplication extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azuread_application";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azuread/d/application azuread_application} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzureadApplicationConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAzureadApplicationConfig);
    private _api;
    get api(): DataAzureadApplicationApiList;
    private _appRoleIds;
    get appRoleIds(): cdktf.StringMap;
    private _appRoles;
    get appRoles(): DataAzureadApplicationAppRolesList;
    private _applicationId?;
    get applicationId(): string;
    set applicationId(value: string);
    resetApplicationId(): void;
    get applicationIdInput(): string | undefined;
    get deviceOnlyAuthEnabled(): cdktf.IResolvable;
    get disabledByMicrosoft(): string;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    get fallbackPublicClientEnabled(): cdktf.IResolvable;
    private _featureTags;
    get featureTags(): DataAzureadApplicationFeatureTagsList;
    get groupMembershipClaims(): string[];
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get identifierUris(): string[];
    get logoUrl(): string;
    get marketingUrl(): string;
    private _oauth2PermissionScopeIds;
    get oauth2PermissionScopeIds(): cdktf.StringMap;
    get oauth2PostResponseRequired(): cdktf.IResolvable;
    private _objectId?;
    get objectId(): string;
    set objectId(value: string);
    resetObjectId(): void;
    get objectIdInput(): string | undefined;
    private _optionalClaims;
    get optionalClaims(): DataAzureadApplicationOptionalClaimsList;
    get owners(): string[];
    get privacyStatementUrl(): string;
    private _publicClient;
    get publicClient(): DataAzureadApplicationPublicClientList;
    get publisherDomain(): string;
    private _requiredResourceAccess;
    get requiredResourceAccess(): DataAzureadApplicationRequiredResourceAccessList;
    get signInAudience(): string;
    private _singlePageApplication;
    get singlePageApplication(): DataAzureadApplicationSinglePageApplicationList;
    get supportUrl(): string;
    get tags(): string[];
    get termsOfServiceUrl(): string;
    private _web;
    get web(): DataAzureadApplicationWebList;
    private _timeouts;
    get timeouts(): DataAzureadApplicationTimeoutsOutputReference;
    putTimeouts(value: DataAzureadApplicationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzureadApplicationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
