import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzureadDirectoryObjectConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/directory_object#id DataAzureadDirectoryObject#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The object ID of the principal
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/directory_object#object_id DataAzureadDirectoryObject#object_id}
    */
    readonly objectId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/directory_object#timeouts DataAzureadDirectoryObject#timeouts}
    */
    readonly timeouts?: DataAzureadDirectoryObjectTimeouts;
}
export interface DataAzureadDirectoryObjectTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/directory_object#read DataAzureadDirectoryObject#read}
    */
    readonly read?: string;
}
export declare function dataAzureadDirectoryObjectTimeoutsToTerraform(struct?: DataAzureadDirectoryObjectTimeoutsOutputReference | DataAzureadDirectoryObjectTimeouts | cdktf.IResolvable): any;
export declare class DataAzureadDirectoryObjectTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzureadDirectoryObjectTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzureadDirectoryObjectTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azuread/d/directory_object azuread_directory_object}
*/
export declare class DataAzureadDirectoryObject extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azuread_directory_object";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azuread/d/directory_object azuread_directory_object} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzureadDirectoryObjectConfig
    */
    constructor(scope: Construct, id: string, config: DataAzureadDirectoryObjectConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _objectId?;
    get objectId(): string;
    set objectId(value: string);
    get objectIdInput(): string | undefined;
    get type(): string;
    private _timeouts;
    get timeouts(): DataAzureadDirectoryObjectTimeoutsOutputReference;
    putTimeouts(value: DataAzureadDirectoryObjectTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzureadDirectoryObjectTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
