import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzureadDomainsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Set to `true` to only return domains whose DNS is managed by Microsoft 365
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/domains#admin_managed DataAzureadDomains#admin_managed}
    */
    readonly adminManaged?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/domains#id DataAzureadDomains#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Set to `true` if unverified Azure AD domains should be included
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/domains#include_unverified DataAzureadDomains#include_unverified}
    */
    readonly includeUnverified?: boolean | cdktf.IResolvable;
    /**
    * Set to `true` to only return the default domain
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/domains#only_default DataAzureadDomains#only_default}
    */
    readonly onlyDefault?: boolean | cdktf.IResolvable;
    /**
    * Set to `true` to only return the initial domain, which is your primary Azure Active Directory tenant domain
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/domains#only_initial DataAzureadDomains#only_initial}
    */
    readonly onlyInitial?: boolean | cdktf.IResolvable;
    /**
    * Set to `true` to only return verified root domains. Excludes subdomains and unverified domains
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/domains#only_root DataAzureadDomains#only_root}
    */
    readonly onlyRoot?: boolean | cdktf.IResolvable;
    /**
    * A list of supported services that must be supported by a domain
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/domains#supports_services DataAzureadDomains#supports_services}
    */
    readonly supportsServices?: string[];
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/domains#timeouts DataAzureadDomains#timeouts}
    */
    readonly timeouts?: DataAzureadDomainsTimeouts;
}
export interface DataAzureadDomainsDomains {
}
export declare function dataAzureadDomainsDomainsToTerraform(struct?: DataAzureadDomainsDomains): any;
export declare class DataAzureadDomainsDomainsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzureadDomainsDomains | undefined;
    set internalValue(value: DataAzureadDomainsDomains | undefined);
    get adminManaged(): cdktf.IResolvable;
    get authenticationType(): string;
    get default(): cdktf.IResolvable;
    get domainName(): string;
    get initial(): cdktf.IResolvable;
    get root(): cdktf.IResolvable;
    get supportedServices(): string[];
    get verified(): cdktf.IResolvable;
}
export declare class DataAzureadDomainsDomainsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzureadDomainsDomainsOutputReference;
}
export interface DataAzureadDomainsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/domains#read DataAzureadDomains#read}
    */
    readonly read?: string;
}
export declare function dataAzureadDomainsTimeoutsToTerraform(struct?: DataAzureadDomainsTimeoutsOutputReference | DataAzureadDomainsTimeouts | cdktf.IResolvable): any;
export declare class DataAzureadDomainsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzureadDomainsTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzureadDomainsTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azuread/d/domains azuread_domains}
*/
export declare class DataAzureadDomains extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azuread_domains";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azuread/d/domains azuread_domains} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzureadDomainsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAzureadDomainsConfig);
    private _adminManaged?;
    get adminManaged(): boolean | cdktf.IResolvable;
    set adminManaged(value: boolean | cdktf.IResolvable);
    resetAdminManaged(): void;
    get adminManagedInput(): boolean | cdktf.IResolvable | undefined;
    private _domains;
    get domains(): DataAzureadDomainsDomainsList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _includeUnverified?;
    get includeUnverified(): boolean | cdktf.IResolvable;
    set includeUnverified(value: boolean | cdktf.IResolvable);
    resetIncludeUnverified(): void;
    get includeUnverifiedInput(): boolean | cdktf.IResolvable | undefined;
    private _onlyDefault?;
    get onlyDefault(): boolean | cdktf.IResolvable;
    set onlyDefault(value: boolean | cdktf.IResolvable);
    resetOnlyDefault(): void;
    get onlyDefaultInput(): boolean | cdktf.IResolvable | undefined;
    private _onlyInitial?;
    get onlyInitial(): boolean | cdktf.IResolvable;
    set onlyInitial(value: boolean | cdktf.IResolvable);
    resetOnlyInitial(): void;
    get onlyInitialInput(): boolean | cdktf.IResolvable | undefined;
    private _onlyRoot?;
    get onlyRoot(): boolean | cdktf.IResolvable;
    set onlyRoot(value: boolean | cdktf.IResolvable);
    resetOnlyRoot(): void;
    get onlyRootInput(): boolean | cdktf.IResolvable | undefined;
    private _supportsServices?;
    get supportsServices(): string[];
    set supportsServices(value: string[]);
    resetSupportsServices(): void;
    get supportsServicesInput(): string[] | undefined;
    private _timeouts;
    get timeouts(): DataAzureadDomainsTimeoutsOutputReference;
    putTimeouts(value: DataAzureadDomainsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzureadDomainsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
