import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzureadUserConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/user#id DataAzureadUser#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The email alias of the user
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/user#mail_nickname DataAzureadUser#mail_nickname}
    */
    readonly mailNickname?: string;
    /**
    * The object ID of the user
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/user#object_id DataAzureadUser#object_id}
    */
    readonly objectId?: string;
    /**
    * The user principal name (UPN) of the user
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/user#user_principal_name DataAzureadUser#user_principal_name}
    */
    readonly userPrincipalName?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/user#timeouts DataAzureadUser#timeouts}
    */
    readonly timeouts?: DataAzureadUserTimeouts;
}
export interface DataAzureadUserTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/user#read DataAzureadUser#read}
    */
    readonly read?: string;
}
export declare function dataAzureadUserTimeoutsToTerraform(struct?: DataAzureadUserTimeoutsOutputReference | DataAzureadUserTimeouts | cdktf.IResolvable): any;
export declare class DataAzureadUserTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzureadUserTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzureadUserTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azuread/d/user azuread_user}
*/
export declare class DataAzureadUser extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azuread_user";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azuread/d/user azuread_user} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzureadUserConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAzureadUserConfig);
    get accountEnabled(): cdktf.IResolvable;
    get ageGroup(): string;
    get businessPhones(): string[];
    get city(): string;
    get companyName(): string;
    get consentProvidedForMinor(): string;
    get costCenter(): string;
    get country(): string;
    get creationType(): string;
    get department(): string;
    get displayName(): string;
    get division(): string;
    get employeeId(): string;
    get employeeType(): string;
    get externalUserState(): string;
    get faxNumber(): string;
    get givenName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get imAddresses(): string[];
    get jobTitle(): string;
    get mail(): string;
    private _mailNickname?;
    get mailNickname(): string;
    set mailNickname(value: string);
    resetMailNickname(): void;
    get mailNicknameInput(): string | undefined;
    get managerId(): string;
    get mobilePhone(): string;
    private _objectId?;
    get objectId(): string;
    set objectId(value: string);
    resetObjectId(): void;
    get objectIdInput(): string | undefined;
    get officeLocation(): string;
    get onpremisesDistinguishedName(): string;
    get onpremisesDomainName(): string;
    get onpremisesImmutableId(): string;
    get onpremisesSamAccountName(): string;
    get onpremisesSecurityIdentifier(): string;
    get onpremisesSyncEnabled(): cdktf.IResolvable;
    get onpremisesUserPrincipalName(): string;
    get otherMails(): string[];
    get postalCode(): string;
    get preferredLanguage(): string;
    get proxyAddresses(): string[];
    get showInAddressList(): cdktf.IResolvable;
    get state(): string;
    get streetAddress(): string;
    get surname(): string;
    get usageLocation(): string;
    private _userPrincipalName?;
    get userPrincipalName(): string;
    set userPrincipalName(value: string);
    resetUserPrincipalName(): void;
    get userPrincipalNameInput(): string | undefined;
    get userType(): string;
    private _timeouts;
    get timeouts(): DataAzureadUserTimeoutsOutputReference;
    putTimeouts(value: DataAzureadUserTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzureadUserTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
