import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DirectoryRoleAssignmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Identifier of the app-specific scope when the assignment scope is app-specific
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/directory_role_assignment#app_scope_id DirectoryRoleAssignment#app_scope_id}
    */
    readonly appScopeId?: string;
    /**
    * Identifier of the app-specific scope when the assignment scope is app-specific
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/directory_role_assignment#app_scope_object_id DirectoryRoleAssignment#app_scope_object_id}
    */
    readonly appScopeObjectId?: string;
    /**
    * Identifier of the directory object representing the scope of the assignment
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/directory_role_assignment#directory_scope_id DirectoryRoleAssignment#directory_scope_id}
    */
    readonly directoryScopeId?: string;
    /**
    * Identifier of the directory object representing the scope of the assignment
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/directory_role_assignment#directory_scope_object_id DirectoryRoleAssignment#directory_scope_object_id}
    */
    readonly directoryScopeObjectId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/directory_role_assignment#id DirectoryRoleAssignment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The object ID of the member principal
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/directory_role_assignment#principal_object_id DirectoryRoleAssignment#principal_object_id}
    */
    readonly principalObjectId: string;
    /**
    * The object ID of the directory role for this assignment
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/directory_role_assignment#role_id DirectoryRoleAssignment#role_id}
    */
    readonly roleId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/directory_role_assignment#timeouts DirectoryRoleAssignment#timeouts}
    */
    readonly timeouts?: DirectoryRoleAssignmentTimeouts;
}
export interface DirectoryRoleAssignmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/directory_role_assignment#create DirectoryRoleAssignment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/directory_role_assignment#delete DirectoryRoleAssignment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/directory_role_assignment#read DirectoryRoleAssignment#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/directory_role_assignment#update DirectoryRoleAssignment#update}
    */
    readonly update?: string;
}
export declare function directoryRoleAssignmentTimeoutsToTerraform(struct?: DirectoryRoleAssignmentTimeoutsOutputReference | DirectoryRoleAssignmentTimeouts | cdktf.IResolvable): any;
export declare class DirectoryRoleAssignmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DirectoryRoleAssignmentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DirectoryRoleAssignmentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azuread/r/directory_role_assignment azuread_directory_role_assignment}
*/
export declare class DirectoryRoleAssignment extends cdktf.TerraformResource {
    static readonly tfResourceType = "azuread_directory_role_assignment";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azuread/r/directory_role_assignment azuread_directory_role_assignment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DirectoryRoleAssignmentConfig
    */
    constructor(scope: Construct, id: string, config: DirectoryRoleAssignmentConfig);
    private _appScopeId?;
    get appScopeId(): string;
    set appScopeId(value: string);
    resetAppScopeId(): void;
    get appScopeIdInput(): string | undefined;
    private _appScopeObjectId?;
    get appScopeObjectId(): string;
    set appScopeObjectId(value: string);
    resetAppScopeObjectId(): void;
    get appScopeObjectIdInput(): string | undefined;
    private _directoryScopeId?;
    get directoryScopeId(): string;
    set directoryScopeId(value: string);
    resetDirectoryScopeId(): void;
    get directoryScopeIdInput(): string | undefined;
    private _directoryScopeObjectId?;
    get directoryScopeObjectId(): string;
    set directoryScopeObjectId(value: string);
    resetDirectoryScopeObjectId(): void;
    get directoryScopeObjectIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _principalObjectId?;
    get principalObjectId(): string;
    set principalObjectId(value: string);
    get principalObjectIdInput(): string | undefined;
    private _roleId?;
    get roleId(): string;
    set roleId(value: string);
    get roleIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): DirectoryRoleAssignmentTimeoutsOutputReference;
    putTimeouts(value: DirectoryRoleAssignmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DirectoryRoleAssignmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
