import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DirectoryRoleMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/directory_role_member#id DirectoryRoleMember#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The object ID of the member
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/directory_role_member#member_object_id DirectoryRoleMember#member_object_id}
    */
    readonly memberObjectId?: string;
    /**
    * The object ID of the directory role
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/directory_role_member#role_object_id DirectoryRoleMember#role_object_id}
    */
    readonly roleObjectId?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/directory_role_member#timeouts DirectoryRoleMember#timeouts}
    */
    readonly timeouts?: DirectoryRoleMemberTimeouts;
}
export interface DirectoryRoleMemberTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/directory_role_member#create DirectoryRoleMember#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/directory_role_member#delete DirectoryRoleMember#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/directory_role_member#read DirectoryRoleMember#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/directory_role_member#update DirectoryRoleMember#update}
    */
    readonly update?: string;
}
export declare function directoryRoleMemberTimeoutsToTerraform(struct?: DirectoryRoleMemberTimeoutsOutputReference | DirectoryRoleMemberTimeouts | cdktf.IResolvable): any;
export declare class DirectoryRoleMemberTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DirectoryRoleMemberTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DirectoryRoleMemberTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azuread/r/directory_role_member azuread_directory_role_member}
*/
export declare class DirectoryRoleMember extends cdktf.TerraformResource {
    static readonly tfResourceType = "azuread_directory_role_member";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azuread/r/directory_role_member azuread_directory_role_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DirectoryRoleMemberConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DirectoryRoleMemberConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _memberObjectId?;
    get memberObjectId(): string;
    set memberObjectId(value: string);
    resetMemberObjectId(): void;
    get memberObjectIdInput(): string | undefined;
    private _roleObjectId?;
    get roleObjectId(): string;
    set roleObjectId(value: string);
    resetRoleObjectId(): void;
    get roleObjectIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): DirectoryRoleMemberTimeoutsOutputReference;
    putTimeouts(value: DirectoryRoleMemberTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DirectoryRoleMemberTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
