import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Indicates whether this group can be assigned to an Azure Active Directory role. This property can only be `true` for security-enabled groups.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#assignable_to_role Group#assignable_to_role}
    */
    readonly assignableToRole?: boolean | cdktf.IResolvable;
    /**
    * Indicates whether new members added to the group will be auto-subscribed to receive email notifications.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#auto_subscribe_new_members Group#auto_subscribe_new_members}
    */
    readonly autoSubscribeNewMembers?: boolean | cdktf.IResolvable;
    /**
    * The group behaviours for a Microsoft 365 group
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#behaviors Group#behaviors}
    */
    readonly behaviors?: string[];
    /**
    * The description for the group
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#description Group#description}
    */
    readonly description?: string;
    /**
    * The display name for the group
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#display_name Group#display_name}
    */
    readonly displayName: string;
    /**
    * Indicates whether people external to the organization can send messages to the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#external_senders_allowed Group#external_senders_allowed}
    */
    readonly externalSendersAllowed?: boolean | cdktf.IResolvable;
    /**
    * Indicates whether the group is displayed in certain parts of the Outlook user interface: in the Address Book, in address lists for selecting message recipients, and in the Browse Groups dialog for searching groups.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#hide_from_address_lists Group#hide_from_address_lists}
    */
    readonly hideFromAddressLists?: boolean | cdktf.IResolvable;
    /**
    * Indicates whether the group is displayed in Outlook clients, such as Outlook for Windows and Outlook on the web.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#hide_from_outlook_clients Group#hide_from_outlook_clients}
    */
    readonly hideFromOutlookClients?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#id Group#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Whether the group is a mail enabled, with a shared group mailbox. At least one of `mail_enabled` or `security_enabled` must be specified. A group can be mail enabled _and_ security enabled
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#mail_enabled Group#mail_enabled}
    */
    readonly mailEnabled?: boolean | cdktf.IResolvable;
    /**
    * The mail alias for the group, unique in the organisation
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#mail_nickname Group#mail_nickname}
    */
    readonly mailNickname?: string;
    /**
    * A set of members who should be present in this group. Supported object types are Users, Groups or Service Principals
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#members Group#members}
    */
    readonly members?: string[];
    /**
    * A set of owners who own this group. Supported object types are Users or Service Principals
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#owners Group#owners}
    */
    readonly owners?: string[];
    /**
    * If `true`, will return an error if an existing group is found with the same name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#prevent_duplicate_names Group#prevent_duplicate_names}
    */
    readonly preventDuplicateNames?: boolean | cdktf.IResolvable;
    /**
    * The group provisioning options for a Microsoft 365 group
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#provisioning_options Group#provisioning_options}
    */
    readonly provisioningOptions?: string[];
    /**
    * Whether the group is a security group for controlling access to in-app resources. At least one of `security_enabled` or `mail_enabled` must be specified. A group can be security enabled _and_ mail enabled
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#security_enabled Group#security_enabled}
    */
    readonly securityEnabled?: boolean | cdktf.IResolvable;
    /**
    * The colour theme for a Microsoft 365 group
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#theme Group#theme}
    */
    readonly theme?: string;
    /**
    * A set of group types to configure for the group. `Unified` specifies a Microsoft 365 group. Required when `mail_enabled` is true
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#types Group#types}
    */
    readonly types?: string[];
    /**
    * Specifies the group join policy and group content visibility
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#visibility Group#visibility}
    */
    readonly visibility?: string;
    /**
    * dynamic_membership block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#dynamic_membership Group#dynamic_membership}
    */
    readonly dynamicMembership?: GroupDynamicMembership;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#timeouts Group#timeouts}
    */
    readonly timeouts?: GroupTimeouts;
}
export interface GroupDynamicMembership {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#enabled Group#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Rule to determine members for a dynamic group. Required when `group_types` contains 'DynamicMembership'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#rule Group#rule}
    */
    readonly rule: string;
}
export declare function groupDynamicMembershipToTerraform(struct?: GroupDynamicMembershipOutputReference | GroupDynamicMembership): any;
export declare class GroupDynamicMembershipOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GroupDynamicMembership | undefined;
    set internalValue(value: GroupDynamicMembership | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _rule?;
    get rule(): string;
    set rule(value: string);
    get ruleInput(): string | undefined;
}
export interface GroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#create Group#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#delete Group#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#read Group#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group#update Group#update}
    */
    readonly update?: string;
}
export declare function groupTimeoutsToTerraform(struct?: GroupTimeoutsOutputReference | GroupTimeouts | cdktf.IResolvable): any;
export declare class GroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GroupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GroupTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azuread/r/group azuread_group}
*/
export declare class Group extends cdktf.TerraformResource {
    static readonly tfResourceType = "azuread_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azuread/r/group azuread_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GroupConfig
    */
    constructor(scope: Construct, id: string, config: GroupConfig);
    private _assignableToRole?;
    get assignableToRole(): boolean | cdktf.IResolvable;
    set assignableToRole(value: boolean | cdktf.IResolvable);
    resetAssignableToRole(): void;
    get assignableToRoleInput(): boolean | cdktf.IResolvable | undefined;
    private _autoSubscribeNewMembers?;
    get autoSubscribeNewMembers(): boolean | cdktf.IResolvable;
    set autoSubscribeNewMembers(value: boolean | cdktf.IResolvable);
    resetAutoSubscribeNewMembers(): void;
    get autoSubscribeNewMembersInput(): boolean | cdktf.IResolvable | undefined;
    private _behaviors?;
    get behaviors(): string[];
    set behaviors(value: string[]);
    resetBehaviors(): void;
    get behaviorsInput(): string[] | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _externalSendersAllowed?;
    get externalSendersAllowed(): boolean | cdktf.IResolvable;
    set externalSendersAllowed(value: boolean | cdktf.IResolvable);
    resetExternalSendersAllowed(): void;
    get externalSendersAllowedInput(): boolean | cdktf.IResolvable | undefined;
    private _hideFromAddressLists?;
    get hideFromAddressLists(): boolean | cdktf.IResolvable;
    set hideFromAddressLists(value: boolean | cdktf.IResolvable);
    resetHideFromAddressLists(): void;
    get hideFromAddressListsInput(): boolean | cdktf.IResolvable | undefined;
    private _hideFromOutlookClients?;
    get hideFromOutlookClients(): boolean | cdktf.IResolvable;
    set hideFromOutlookClients(value: boolean | cdktf.IResolvable);
    resetHideFromOutlookClients(): void;
    get hideFromOutlookClientsInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get mail(): string;
    private _mailEnabled?;
    get mailEnabled(): boolean | cdktf.IResolvable;
    set mailEnabled(value: boolean | cdktf.IResolvable);
    resetMailEnabled(): void;
    get mailEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _mailNickname?;
    get mailNickname(): string;
    set mailNickname(value: string);
    resetMailNickname(): void;
    get mailNicknameInput(): string | undefined;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    resetMembers(): void;
    get membersInput(): string[] | undefined;
    get objectId(): string;
    get onpremisesDomainName(): string;
    get onpremisesNetbiosName(): string;
    get onpremisesSamAccountName(): string;
    get onpremisesSecurityIdentifier(): string;
    get onpremisesSyncEnabled(): cdktf.IResolvable;
    private _owners?;
    get owners(): string[];
    set owners(value: string[]);
    resetOwners(): void;
    get ownersInput(): string[] | undefined;
    get preferredLanguage(): string;
    private _preventDuplicateNames?;
    get preventDuplicateNames(): boolean | cdktf.IResolvable;
    set preventDuplicateNames(value: boolean | cdktf.IResolvable);
    resetPreventDuplicateNames(): void;
    get preventDuplicateNamesInput(): boolean | cdktf.IResolvable | undefined;
    private _provisioningOptions?;
    get provisioningOptions(): string[];
    set provisioningOptions(value: string[]);
    resetProvisioningOptions(): void;
    get provisioningOptionsInput(): string[] | undefined;
    get proxyAddresses(): string[];
    private _securityEnabled?;
    get securityEnabled(): boolean | cdktf.IResolvable;
    set securityEnabled(value: boolean | cdktf.IResolvable);
    resetSecurityEnabled(): void;
    get securityEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _theme?;
    get theme(): string;
    set theme(value: string);
    resetTheme(): void;
    get themeInput(): string | undefined;
    private _types?;
    get types(): string[];
    set types(value: string[]);
    resetTypes(): void;
    get typesInput(): string[] | undefined;
    private _visibility?;
    get visibility(): string;
    set visibility(value: string);
    resetVisibility(): void;
    get visibilityInput(): string | undefined;
    private _dynamicMembership;
    get dynamicMembership(): GroupDynamicMembershipOutputReference;
    putDynamicMembership(value: GroupDynamicMembership): void;
    resetDynamicMembership(): void;
    get dynamicMembershipInput(): GroupDynamicMembership | undefined;
    private _timeouts;
    get timeouts(): GroupTimeoutsOutputReference;
    putTimeouts(value: GroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
