import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NamedLocationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/named_location#display_name NamedLocation#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/named_location#id NamedLocation#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * country block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/named_location#country NamedLocation#country}
    */
    readonly country?: NamedLocationCountry;
    /**
    * ip block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/named_location#ip NamedLocation#ip}
    */
    readonly ip?: NamedLocationIp;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/named_location#timeouts NamedLocation#timeouts}
    */
    readonly timeouts?: NamedLocationTimeouts;
}
export interface NamedLocationCountry {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/named_location#countries_and_regions NamedLocation#countries_and_regions}
    */
    readonly countriesAndRegions: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/named_location#include_unknown_countries_and_regions NamedLocation#include_unknown_countries_and_regions}
    */
    readonly includeUnknownCountriesAndRegions?: boolean | cdktf.IResolvable;
}
export declare function namedLocationCountryToTerraform(struct?: NamedLocationCountryOutputReference | NamedLocationCountry): any;
export declare class NamedLocationCountryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NamedLocationCountry | undefined;
    set internalValue(value: NamedLocationCountry | undefined);
    private _countriesAndRegions?;
    get countriesAndRegions(): string[];
    set countriesAndRegions(value: string[]);
    get countriesAndRegionsInput(): string[] | undefined;
    private _includeUnknownCountriesAndRegions?;
    get includeUnknownCountriesAndRegions(): boolean | cdktf.IResolvable;
    set includeUnknownCountriesAndRegions(value: boolean | cdktf.IResolvable);
    resetIncludeUnknownCountriesAndRegions(): void;
    get includeUnknownCountriesAndRegionsInput(): boolean | cdktf.IResolvable | undefined;
}
export interface NamedLocationIp {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/named_location#ip_ranges NamedLocation#ip_ranges}
    */
    readonly ipRanges: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/named_location#trusted NamedLocation#trusted}
    */
    readonly trusted?: boolean | cdktf.IResolvable;
}
export declare function namedLocationIpToTerraform(struct?: NamedLocationIpOutputReference | NamedLocationIp): any;
export declare class NamedLocationIpOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NamedLocationIp | undefined;
    set internalValue(value: NamedLocationIp | undefined);
    private _ipRanges?;
    get ipRanges(): string[];
    set ipRanges(value: string[]);
    get ipRangesInput(): string[] | undefined;
    private _trusted?;
    get trusted(): boolean | cdktf.IResolvable;
    set trusted(value: boolean | cdktf.IResolvable);
    resetTrusted(): void;
    get trustedInput(): boolean | cdktf.IResolvable | undefined;
}
export interface NamedLocationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/named_location#create NamedLocation#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/named_location#delete NamedLocation#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/named_location#read NamedLocation#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/named_location#update NamedLocation#update}
    */
    readonly update?: string;
}
export declare function namedLocationTimeoutsToTerraform(struct?: NamedLocationTimeoutsOutputReference | NamedLocationTimeouts | cdktf.IResolvable): any;
export declare class NamedLocationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NamedLocationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: NamedLocationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azuread/r/named_location azuread_named_location}
*/
export declare class NamedLocation extends cdktf.TerraformResource {
    static readonly tfResourceType = "azuread_named_location";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azuread/r/named_location azuread_named_location} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NamedLocationConfig
    */
    constructor(scope: Construct, id: string, config: NamedLocationConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _country;
    get country(): NamedLocationCountryOutputReference;
    putCountry(value: NamedLocationCountry): void;
    resetCountry(): void;
    get countryInput(): NamedLocationCountry | undefined;
    private _ip;
    get ip(): NamedLocationIpOutputReference;
    putIp(value: NamedLocationIp): void;
    resetIp(): void;
    get ipInput(): NamedLocationIp | undefined;
    private _timeouts;
    get timeouts(): NamedLocationTimeoutsOutputReference;
    putTimeouts(value: NamedLocationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | NamedLocationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
