import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServicePrincipalCertificateConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies the encoding used for the supplied certificate data
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_certificate#encoding ServicePrincipalCertificate#encoding}
    */
    readonly encoding?: string;
    /**
    * The end date until which the certificate is valid, formatted as an RFC3339 date string (e.g. `2018-01-01T01:02:03Z`)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_certificate#end_date ServicePrincipalCertificate#end_date}
    */
    readonly endDate?: string;
    /**
    * A relative duration for which the certificate is valid until, for example `240h` (10 days) or `2400h30m`. Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h"
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_certificate#end_date_relative ServicePrincipalCertificate#end_date_relative}
    */
    readonly endDateRelative?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_certificate#id ServicePrincipalCertificate#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A UUID used to uniquely identify this certificate. If not specified a UUID will be automatically generated
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_certificate#key_id ServicePrincipalCertificate#key_id}
    */
    readonly keyId?: string;
    /**
    * The object ID of the service principal for which this certificate should be created
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_certificate#service_principal_id ServicePrincipalCertificate#service_principal_id}
    */
    readonly servicePrincipalId: string;
    /**
    * The start date from which the certificate is valid, formatted as an RFC3339 date string (e.g. `2018-01-01T01:02:03Z`). If this isn't specified, the current date is used
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_certificate#start_date ServicePrincipalCertificate#start_date}
    */
    readonly startDate?: string;
    /**
    * The type of key/certificate
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_certificate#type ServicePrincipalCertificate#type}
    */
    readonly type?: string;
    /**
    * The certificate data, which can be PEM encoded, base64 encoded DER or hexadecimal encoded DER
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_certificate#value ServicePrincipalCertificate#value}
    */
    readonly value: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_certificate#timeouts ServicePrincipalCertificate#timeouts}
    */
    readonly timeouts?: ServicePrincipalCertificateTimeouts;
}
export interface ServicePrincipalCertificateTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_certificate#create ServicePrincipalCertificate#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_certificate#delete ServicePrincipalCertificate#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_certificate#read ServicePrincipalCertificate#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_certificate#update ServicePrincipalCertificate#update}
    */
    readonly update?: string;
}
export declare function servicePrincipalCertificateTimeoutsToTerraform(struct?: ServicePrincipalCertificateTimeoutsOutputReference | ServicePrincipalCertificateTimeouts | cdktf.IResolvable): any;
export declare class ServicePrincipalCertificateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServicePrincipalCertificateTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ServicePrincipalCertificateTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_certificate azuread_service_principal_certificate}
*/
export declare class ServicePrincipalCertificate extends cdktf.TerraformResource {
    static readonly tfResourceType = "azuread_service_principal_certificate";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_certificate azuread_service_principal_certificate} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServicePrincipalCertificateConfig
    */
    constructor(scope: Construct, id: string, config: ServicePrincipalCertificateConfig);
    private _encoding?;
    get encoding(): string;
    set encoding(value: string);
    resetEncoding(): void;
    get encodingInput(): string | undefined;
    private _endDate?;
    get endDate(): string;
    set endDate(value: string);
    resetEndDate(): void;
    get endDateInput(): string | undefined;
    private _endDateRelative?;
    get endDateRelative(): string;
    set endDateRelative(value: string);
    resetEndDateRelative(): void;
    get endDateRelativeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _keyId?;
    get keyId(): string;
    set keyId(value: string);
    resetKeyId(): void;
    get keyIdInput(): string | undefined;
    private _servicePrincipalId?;
    get servicePrincipalId(): string;
    set servicePrincipalId(value: string);
    get servicePrincipalIdInput(): string | undefined;
    private _startDate?;
    get startDate(): string;
    set startDate(value: string);
    resetStartDate(): void;
    get startDateInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
    private _timeouts;
    get timeouts(): ServicePrincipalCertificateTimeoutsOutputReference;
    putTimeouts(value: ServicePrincipalCertificateTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ServicePrincipalCertificateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
