import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServicePrincipalClaimsMappingPolicyAssignmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * ID of the claims mapping policy to assign
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_claims_mapping_policy_assignment#claims_mapping_policy_id ServicePrincipalClaimsMappingPolicyAssignment#claims_mapping_policy_id}
    */
    readonly claimsMappingPolicyId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_claims_mapping_policy_assignment#id ServicePrincipalClaimsMappingPolicyAssignment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Object ID of the service principal for which to assign the policy
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_claims_mapping_policy_assignment#service_principal_id ServicePrincipalClaimsMappingPolicyAssignment#service_principal_id}
    */
    readonly servicePrincipalId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_claims_mapping_policy_assignment azuread_service_principal_claims_mapping_policy_assignment}
*/
export declare class ServicePrincipalClaimsMappingPolicyAssignment extends cdktf.TerraformResource {
    static readonly tfResourceType = "azuread_service_principal_claims_mapping_policy_assignment";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_claims_mapping_policy_assignment azuread_service_principal_claims_mapping_policy_assignment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServicePrincipalClaimsMappingPolicyAssignmentConfig
    */
    constructor(scope: Construct, id: string, config: ServicePrincipalClaimsMappingPolicyAssignmentConfig);
    private _claimsMappingPolicyId?;
    get claimsMappingPolicyId(): string;
    set claimsMappingPolicyId(value: string);
    get claimsMappingPolicyIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _servicePrincipalId?;
    get servicePrincipalId(): string;
    set servicePrincipalId(value: string);
    get servicePrincipalIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
