import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServicePrincipalDelegatedPermissionGrantConfig extends cdktf.TerraformMetaArguments {
    /**
    * A set of claim values for delegated permission scopes which should be included in access tokens for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_delegated_permission_grant#claim_values ServicePrincipalDelegatedPermissionGrant#claim_values}
    */
    readonly claimValues: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_delegated_permission_grant#id ServicePrincipalDelegatedPermissionGrant#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The object ID of the service principal representing the resource to be accessed
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_delegated_permission_grant#resource_service_principal_object_id ServicePrincipalDelegatedPermissionGrant#resource_service_principal_object_id}
    */
    readonly resourceServicePrincipalObjectId: string;
    /**
    * The object ID of the service principal for which this delegated permission grant should be created
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_delegated_permission_grant#service_principal_object_id ServicePrincipalDelegatedPermissionGrant#service_principal_object_id}
    */
    readonly servicePrincipalObjectId: string;
    /**
    * The object ID of the user on behalf of whom the service principal is authorized to access the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_delegated_permission_grant#user_object_id ServicePrincipalDelegatedPermissionGrant#user_object_id}
    */
    readonly userObjectId?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_delegated_permission_grant#timeouts ServicePrincipalDelegatedPermissionGrant#timeouts}
    */
    readonly timeouts?: ServicePrincipalDelegatedPermissionGrantTimeouts;
}
export interface ServicePrincipalDelegatedPermissionGrantTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_delegated_permission_grant#create ServicePrincipalDelegatedPermissionGrant#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_delegated_permission_grant#delete ServicePrincipalDelegatedPermissionGrant#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_delegated_permission_grant#read ServicePrincipalDelegatedPermissionGrant#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_delegated_permission_grant#update ServicePrincipalDelegatedPermissionGrant#update}
    */
    readonly update?: string;
}
export declare function servicePrincipalDelegatedPermissionGrantTimeoutsToTerraform(struct?: ServicePrincipalDelegatedPermissionGrantTimeoutsOutputReference | ServicePrincipalDelegatedPermissionGrantTimeouts | cdktf.IResolvable): any;
export declare class ServicePrincipalDelegatedPermissionGrantTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServicePrincipalDelegatedPermissionGrantTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ServicePrincipalDelegatedPermissionGrantTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_delegated_permission_grant azuread_service_principal_delegated_permission_grant}
*/
export declare class ServicePrincipalDelegatedPermissionGrant extends cdktf.TerraformResource {
    static readonly tfResourceType = "azuread_service_principal_delegated_permission_grant";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_delegated_permission_grant azuread_service_principal_delegated_permission_grant} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServicePrincipalDelegatedPermissionGrantConfig
    */
    constructor(scope: Construct, id: string, config: ServicePrincipalDelegatedPermissionGrantConfig);
    private _claimValues?;
    get claimValues(): string[];
    set claimValues(value: string[]);
    get claimValuesInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _resourceServicePrincipalObjectId?;
    get resourceServicePrincipalObjectId(): string;
    set resourceServicePrincipalObjectId(value: string);
    get resourceServicePrincipalObjectIdInput(): string | undefined;
    private _servicePrincipalObjectId?;
    get servicePrincipalObjectId(): string;
    set servicePrincipalObjectId(value: string);
    get servicePrincipalObjectIdInput(): string | undefined;
    private _userObjectId?;
    get userObjectId(): string;
    set userObjectId(value: string);
    resetUserObjectId(): void;
    get userObjectIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): ServicePrincipalDelegatedPermissionGrantTimeoutsOutputReference;
    putTimeouts(value: ServicePrincipalDelegatedPermissionGrantTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ServicePrincipalDelegatedPermissionGrantTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
