import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface UserConfig extends cdktf.TerraformMetaArguments {
    /**
    * Whether or not the account should be enabled
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#account_enabled User#account_enabled}
    */
    readonly accountEnabled?: boolean | cdktf.IResolvable;
    /**
    * The age group of the user
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#age_group User#age_group}
    */
    readonly ageGroup?: string;
    /**
    * The telephone numbers for the user. Only one number can be set for this property. Read-only for users synced with Azure AD Connect
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#business_phones User#business_phones}
    */
    readonly businessPhones?: string[];
    /**
    * The city in which the user is located
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#city User#city}
    */
    readonly city?: string;
    /**
    * The company name which the user is associated. This property can be useful for describing the company that an external user comes from
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#company_name User#company_name}
    */
    readonly companyName?: string;
    /**
    * Whether consent has been obtained for minors
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#consent_provided_for_minor User#consent_provided_for_minor}
    */
    readonly consentProvidedForMinor?: string;
    /**
    * The cost center associated with the user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#cost_center User#cost_center}
    */
    readonly costCenter?: string;
    /**
    * The country/region in which the user is located, e.g. `US` or `UK`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#country User#country}
    */
    readonly country?: string;
    /**
    * The name for the department in which the user works
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#department User#department}
    */
    readonly department?: string;
    /**
    * Whether the users password is exempt from expiring
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#disable_password_expiration User#disable_password_expiration}
    */
    readonly disablePasswordExpiration?: boolean | cdktf.IResolvable;
    /**
    * Whether the user is allowed weaker passwords than the default policy to be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#disable_strong_password User#disable_strong_password}
    */
    readonly disableStrongPassword?: boolean | cdktf.IResolvable;
    /**
    * The name to display in the address book for the user
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#display_name User#display_name}
    */
    readonly displayName: string;
    /**
    * The name of the division in which the user works.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#division User#division}
    */
    readonly division?: string;
    /**
    * The employee identifier assigned to the user by the organisation
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#employee_id User#employee_id}
    */
    readonly employeeId?: string;
    /**
    * Captures enterprise worker type. For example, Employee, Contractor, Consultant, or Vendor.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#employee_type User#employee_type}
    */
    readonly employeeType?: string;
    /**
    * The fax number of the user
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#fax_number User#fax_number}
    */
    readonly faxNumber?: string;
    /**
    * Whether the user is forced to change the password during the next sign-in. Only takes effect when also changing the password
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#force_password_change User#force_password_change}
    */
    readonly forcePasswordChange?: boolean | cdktf.IResolvable;
    /**
    * The given name (first name) of the user
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#given_name User#given_name}
    */
    readonly givenName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#id User#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The user’s job title
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#job_title User#job_title}
    */
    readonly jobTitle?: string;
    /**
    * The SMTP address for the user. Cannot be unset.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#mail User#mail}
    */
    readonly mail?: string;
    /**
    * The mail alias for the user. Defaults to the user name part of the user principal name (UPN)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#mail_nickname User#mail_nickname}
    */
    readonly mailNickname?: string;
    /**
    * The object ID of the user's manager
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#manager_id User#manager_id}
    */
    readonly managerId?: string;
    /**
    * The primary cellular telephone number for the user
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#mobile_phone User#mobile_phone}
    */
    readonly mobilePhone?: string;
    /**
    * The office location in the user's place of business
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#office_location User#office_location}
    */
    readonly officeLocation?: string;
    /**
    * The value used to associate an on-premise Active Directory user account with their Azure AD user object. This must be specified if you are using a federated domain for the user's `user_principal_name` property when creating a new user account
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#onpremises_immutable_id User#onpremises_immutable_id}
    */
    readonly onpremisesImmutableId?: string;
    /**
    * Additional email addresses for the user
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#other_mails User#other_mails}
    */
    readonly otherMails?: string[];
    /**
    * The password for the user. The password must satisfy minimum requirements as specified by the password policy. The maximum length is 256 characters. This property is required when creating a new user
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#password User#password}
    */
    readonly password?: string;
    /**
    * The postal code for the user's postal address. The postal code is specific to the user's country/region. In the United States of America, this attribute contains the ZIP code
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#postal_code User#postal_code}
    */
    readonly postalCode?: string;
    /**
    * The user's preferred language, in ISO 639-1 notation
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#preferred_language User#preferred_language}
    */
    readonly preferredLanguage?: string;
    /**
    * Whether or not the Outlook global address list should include this user
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#show_in_address_list User#show_in_address_list}
    */
    readonly showInAddressList?: boolean | cdktf.IResolvable;
    /**
    * The state or province in the user's address
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#state User#state}
    */
    readonly state?: string;
    /**
    * The street address of the user's place of business
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#street_address User#street_address}
    */
    readonly streetAddress?: string;
    /**
    * The user's surname (family name or last name)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#surname User#surname}
    */
    readonly surname?: string;
    /**
    * The usage location of the user. Required for users that will be assigned licenses due to legal requirement to check for availability of services in countries. The usage location is a two letter country code (ISO standard 3166). Examples include: `NO`, `JP`, and `GB`. Cannot be reset to null once set
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#usage_location User#usage_location}
    */
    readonly usageLocation?: string;
    /**
    * The user principal name (UPN) of the user
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#user_principal_name User#user_principal_name}
    */
    readonly userPrincipalName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#timeouts User#timeouts}
    */
    readonly timeouts?: UserTimeouts;
}
export interface UserTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#create User#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#delete User#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#read User#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#update User#update}
    */
    readonly update?: string;
}
export declare function userTimeoutsToTerraform(struct?: UserTimeoutsOutputReference | UserTimeouts | cdktf.IResolvable): any;
export declare class UserTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): UserTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: UserTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azuread/r/user azuread_user}
*/
export declare class User extends cdktf.TerraformResource {
    static readonly tfResourceType = "azuread_user";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azuread/r/user azuread_user} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options UserConfig
    */
    constructor(scope: Construct, id: string, config: UserConfig);
    get aboutMe(): string;
    private _accountEnabled?;
    get accountEnabled(): boolean | cdktf.IResolvable;
    set accountEnabled(value: boolean | cdktf.IResolvable);
    resetAccountEnabled(): void;
    get accountEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _ageGroup?;
    get ageGroup(): string;
    set ageGroup(value: string);
    resetAgeGroup(): void;
    get ageGroupInput(): string | undefined;
    private _businessPhones?;
    get businessPhones(): string[];
    set businessPhones(value: string[]);
    resetBusinessPhones(): void;
    get businessPhonesInput(): string[] | undefined;
    private _city?;
    get city(): string;
    set city(value: string);
    resetCity(): void;
    get cityInput(): string | undefined;
    private _companyName?;
    get companyName(): string;
    set companyName(value: string);
    resetCompanyName(): void;
    get companyNameInput(): string | undefined;
    private _consentProvidedForMinor?;
    get consentProvidedForMinor(): string;
    set consentProvidedForMinor(value: string);
    resetConsentProvidedForMinor(): void;
    get consentProvidedForMinorInput(): string | undefined;
    private _costCenter?;
    get costCenter(): string;
    set costCenter(value: string);
    resetCostCenter(): void;
    get costCenterInput(): string | undefined;
    private _country?;
    get country(): string;
    set country(value: string);
    resetCountry(): void;
    get countryInput(): string | undefined;
    get creationType(): string;
    private _department?;
    get department(): string;
    set department(value: string);
    resetDepartment(): void;
    get departmentInput(): string | undefined;
    private _disablePasswordExpiration?;
    get disablePasswordExpiration(): boolean | cdktf.IResolvable;
    set disablePasswordExpiration(value: boolean | cdktf.IResolvable);
    resetDisablePasswordExpiration(): void;
    get disablePasswordExpirationInput(): boolean | cdktf.IResolvable | undefined;
    private _disableStrongPassword?;
    get disableStrongPassword(): boolean | cdktf.IResolvable;
    set disableStrongPassword(value: boolean | cdktf.IResolvable);
    resetDisableStrongPassword(): void;
    get disableStrongPasswordInput(): boolean | cdktf.IResolvable | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _division?;
    get division(): string;
    set division(value: string);
    resetDivision(): void;
    get divisionInput(): string | undefined;
    private _employeeId?;
    get employeeId(): string;
    set employeeId(value: string);
    resetEmployeeId(): void;
    get employeeIdInput(): string | undefined;
    private _employeeType?;
    get employeeType(): string;
    set employeeType(value: string);
    resetEmployeeType(): void;
    get employeeTypeInput(): string | undefined;
    get externalUserState(): string;
    private _faxNumber?;
    get faxNumber(): string;
    set faxNumber(value: string);
    resetFaxNumber(): void;
    get faxNumberInput(): string | undefined;
    private _forcePasswordChange?;
    get forcePasswordChange(): boolean | cdktf.IResolvable;
    set forcePasswordChange(value: boolean | cdktf.IResolvable);
    resetForcePasswordChange(): void;
    get forcePasswordChangeInput(): boolean | cdktf.IResolvable | undefined;
    private _givenName?;
    get givenName(): string;
    set givenName(value: string);
    resetGivenName(): void;
    get givenNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get imAddresses(): string[];
    private _jobTitle?;
    get jobTitle(): string;
    set jobTitle(value: string);
    resetJobTitle(): void;
    get jobTitleInput(): string | undefined;
    private _mail?;
    get mail(): string;
    set mail(value: string);
    resetMail(): void;
    get mailInput(): string | undefined;
    private _mailNickname?;
    get mailNickname(): string;
    set mailNickname(value: string);
    resetMailNickname(): void;
    get mailNicknameInput(): string | undefined;
    private _managerId?;
    get managerId(): string;
    set managerId(value: string);
    resetManagerId(): void;
    get managerIdInput(): string | undefined;
    private _mobilePhone?;
    get mobilePhone(): string;
    set mobilePhone(value: string);
    resetMobilePhone(): void;
    get mobilePhoneInput(): string | undefined;
    get objectId(): string;
    private _officeLocation?;
    get officeLocation(): string;
    set officeLocation(value: string);
    resetOfficeLocation(): void;
    get officeLocationInput(): string | undefined;
    get onpremisesDistinguishedName(): string;
    get onpremisesDomainName(): string;
    private _onpremisesImmutableId?;
    get onpremisesImmutableId(): string;
    set onpremisesImmutableId(value: string);
    resetOnpremisesImmutableId(): void;
    get onpremisesImmutableIdInput(): string | undefined;
    get onpremisesSamAccountName(): string;
    get onpremisesSecurityIdentifier(): string;
    get onpremisesSyncEnabled(): cdktf.IResolvable;
    get onpremisesUserPrincipalName(): string;
    private _otherMails?;
    get otherMails(): string[];
    set otherMails(value: string[]);
    resetOtherMails(): void;
    get otherMailsInput(): string[] | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _postalCode?;
    get postalCode(): string;
    set postalCode(value: string);
    resetPostalCode(): void;
    get postalCodeInput(): string | undefined;
    private _preferredLanguage?;
    get preferredLanguage(): string;
    set preferredLanguage(value: string);
    resetPreferredLanguage(): void;
    get preferredLanguageInput(): string | undefined;
    get proxyAddresses(): string[];
    private _showInAddressList?;
    get showInAddressList(): boolean | cdktf.IResolvable;
    set showInAddressList(value: boolean | cdktf.IResolvable);
    resetShowInAddressList(): void;
    get showInAddressListInput(): boolean | cdktf.IResolvable | undefined;
    private _state?;
    get state(): string;
    set state(value: string);
    resetState(): void;
    get stateInput(): string | undefined;
    private _streetAddress?;
    get streetAddress(): string;
    set streetAddress(value: string);
    resetStreetAddress(): void;
    get streetAddressInput(): string | undefined;
    private _surname?;
    get surname(): string;
    set surname(value: string);
    resetSurname(): void;
    get surnameInput(): string | undefined;
    private _usageLocation?;
    get usageLocation(): string;
    set usageLocation(value: string);
    resetUsageLocation(): void;
    get usageLocationInput(): string | undefined;
    private _userPrincipalName?;
    get userPrincipalName(): string;
    set userPrincipalName(value: string);
    get userPrincipalNameInput(): string | undefined;
    get userType(): string;
    private _timeouts;
    get timeouts(): UserTimeoutsOutputReference;
    putTimeouts(value: UserTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | UserTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
