# Integration

集成测试，并不会纳入单元测试，但是依旧需要保留在项目中，以保证可复现性。

> 不纳入单元测试的原因是集成测试需要使用一些外部资源，如数据集等，这些资源不适合在单元测试中使用。

有几个要点需要注意：

1. 通过框架名称区分不同的集成测试，如`fastai`等，如果框架名称和包同名，也应该取一个类似的名称来区分。
2. 所有的框加测试云端版使用开发环境
3. 测试的代码尽量简单，如果存在数据集，需附上数据集的下载链接并提供下载脚本
4. 测试代码应该使用框架自带的经典网络，不应该使用自定义的网络
5. 如果网络包含预训练模型，应该提供预训练模型的下载链接，如果网络本身需要下载，也应该提供下载链接
6. 每一个测试需包含requirements.txt文件，以便于安装所需依赖
7. 测试代码应该包含使用说明，例如README.md或者在主文件中使用头部注释——具体取决于测试的复杂程度

---

所有数据集、预训练模型等资源放在集成内的`temp`目录下，此目录不纳入版本控制。
