"""
// @author: ComPleHN
// @file: boxplot.vue
// @time: 2025/5/27 13:14
// @description: 这个是对于echarts的BoxPlot测试
"""
# ---------------------------------------------- Boxplot - Boxplot_light_velocity ----------------------------------------------
import pyecharts.options as opts
from pyecharts.charts import Grid, Boxplot, Scatter


y_data = [
    [
        850,
        740,
        900,
        1070,
        930,
        850,
        950,
        980,
        980,
        880,
        1000,
        980,
        930,
        650,
        760,
        810,
        1000,
        1000,
        960,
        960,
    ],
    [
        960,
        940,
        960,
        940,
        880,
        800,
        850,
        880,
        900,
        840,
        830,
        790,
        810,
        880,
        880,
        830,
        800,
        790,
        760,
        800,
    ],
    [
        880,
        880,
        880,
        860,
        720,
        720,
        620,
        860,
        970,
        950,
        880,
        910,
        850,
        870,
        840,
        840,
        850,
        840,
        840,
        840,
    ],
    [
        890,
        810,
        810,
        820,
        800,
        770,
        760,
        740,
        750,
        760,
        910,
        920,
        890,
        860,
        880,
        720,
        840,
        850,
        850,
        780,
    ],
    [
        890,
        840,
        780,
        810,
        760,
        810,
        790,
        810,
        820,
        850,
        870,
        870,
        810,
        740,
        810,
        940,
        950,
        800,
        810,
        870,
    ],
]
scatter_data = [650, 620, 720, 720, 950, 970]

box_plot = Boxplot()

box_plot = (
    box_plot.add_xaxis(xaxis_data=["expr 0", "expr 1", "expr 2", "expr 3", "expr 4"])
    .add_yaxis(series_name="", y_axis=box_plot.prepare_data(y_data))
    .set_global_opts(
        title_opts=opts.TitleOpts(
            pos_left="center", title="Michelson-Morley Experiment"
        ),
        tooltip_opts=opts.TooltipOpts(trigger="item", axis_pointer_type="shadow"),
        xaxis_opts=opts.AxisOpts(
            type_="category",
            boundary_gap=True,
            splitarea_opts=opts.SplitAreaOpts(is_show=False),
            axislabel_opts=opts.LabelOpts(formatter="expr {value}"),
            splitline_opts=opts.SplitLineOpts(is_show=False),
        ),
        yaxis_opts=opts.AxisOpts(
            type_="value",
            name="km/s minus 299,000",
            splitarea_opts=opts.SplitAreaOpts(
                is_show=True, areastyle_opts=opts.AreaStyleOpts(opacity=1)
            ),
        ),
    )
    .set_series_opts(tooltip_opts=opts.TooltipOpts(formatter="{b}: {c}"))
)

scatter = (
    Scatter()
    .add_xaxis(xaxis_data=["expr 0", "expr 1", "expr 2", "expr 3", "expr 4"])
    .add_yaxis(series_name="", y_axis=scatter_data)
    .set_global_opts(
        title_opts=opts.TitleOpts(
            pos_left="10%",
            pos_top="90%",
            title="upper: Q3 + 1.5 * IQR \nlower: Q1 - 1.5 * IQR",
            title_textstyle_opts=opts.TextStyleOpts(
                border_color="#999", border_width=1, font_size=14
            ),
        ),
        yaxis_opts=opts.AxisOpts(
            axislabel_opts=opts.LabelOpts(is_show=False),
            axistick_opts=opts.AxisTickOpts(is_show=False),
        ),
    )
)

c1 = (
    Grid()
    .add(
        box_plot,
        grid_opts=opts.GridOpts(pos_left="10%", pos_right="10%", pos_bottom="15%"),
    )
    .add(
        scatter,
        grid_opts=opts.GridOpts(pos_left="10%", pos_right="10%", pos_bottom="15%"),
    )
)

# ---------------------------------------------- Boxplot - Boxplot_base ---------------------------------------------- 
from pyecharts import options as opts
from pyecharts.charts import Boxplot

v1 = [
    [850, 740, 900, 1070, 930, 850, 950, 980, 980, 880, 1000, 980],
    [960, 940, 960, 940, 880, 800, 850, 880, 900, 840, 830, 790],
]
v2 = [
    [890, 810, 810, 820, 800, 770, 760, 740, 750, 760, 910, 920],
    [890, 840, 780, 810, 760, 810, 790, 810, 820, 850, 870, 870],
]
c2 = Boxplot()
c2.add_xaxis(["expr1", "expr2"])
c2.add_yaxis("A", c2.prepare_data(v1))
c2.add_yaxis("B", c2.prepare_data(v2))
c2.set_global_opts(title_opts=opts.TitleOpts(title="BoxPlot-基本示例"))

# ---------------------------------------------- Boxplot - Multiple_categories ---------------------------------------------- 
import pyecharts.options as opts
from pyecharts.charts import Boxplot
from pyecharts.commons.utils import JsCode

axis_data = [
    "0",
    "1",
    "2",
    "3",
    "4",
    "5",
    "6",
    "7",
    "8",
    "9",
    "10",
    "11",
    "12",
    "13",
    "14",
    "15",
    "16",
    "17",
]

data = [
    {
        "axisData": axis_data,
        "boxData": [
            [
                3.8888578346043534,
                55.82692798765428,
                98.71608835477272,
                149.50917642877687,
                196.31621070646452,
            ],
            [
                0.5174326704765253,
                47.52990128406776,
                103.66600287106233,
                160.1380046605997,
                194.8294269298398,
            ],
            [
                2.843900448603165,
                51.773788199388605,
                90.66830693679475,
                152.19938074181786,
                196.18172012742428,
            ],
            [
                2.6752702891334135,
                42.85051429480143,
                98.54433643572133,
                166.81852013033875,
                199.7400516615198,
            ],
            [
                1.665511467481906,
                63.069856326089585,
                123.20638438572043,
                164.0932194814393,
                199.56631692214057,
            ],
            [
                0.3597414263118992,
                52.84424125860876,
                108.14491539985673,
                154.42390255012828,
                199.39872381823812,
            ],
            [
                1.3380322954592128,
                41.989379994726335,
                100.39118095266713,
                160.38742881881478,
                197.8251968350275,
            ],
            [
                1.7005873932608662,
                43.88170786936796,
                92.29415890464293,
                140.7858956683471,
                197.50510824352313,
            ],
            [
                1.7017445023542965,
                52.55872982785781,
                90.26972335102536,
                155.43082163069883,
                198.31679368721197,
            ],
            [
                0.45657888665799895,
                47.60747957375436,
                95.53917053451289,
                162.55256484073354,
                199.78317232079928,
            ],
            [
                1.745438082254136,
                53.450845301261964,
                95.8847297380051,
                143.99885640751006,
                195.1863502057908,
            ],
            [
                2.5631287114048273,
                56.04486879215165,
                110.01592256847306,
                155.33508398386462,
                195.90291395560985,
            ],
            [
                3.4380745785991262,
                58.07888602010247,
                105.64925213947652,
                165.50126442985191,
                199.75877487248675,
            ],
            [
                0.03322930419802361,
                53.363159200883985,
                95.32936635574816,
                151.39772626598614,
                198.20394907387762,
            ],
            [
                0.7063564158257929,
                73.89369564248534,
                116.6947935806626,
                152.93983211466667,
                197.1481400480321,
            ],
            [
                0.9611585600880268,
                46.64283650085793,
                102.32004406296502,
                148.64094149067978,
                199.59803470854715,
            ],
            [
                1.4310036755643463,
                50.15631363530299,
                102.68128938225942,
                147.52573154872948,
                197.6018158750086,
            ],
            [
                0.492994684970105,
                43.23619663302313,
                99.60815322547333,
                140.00299600143438,
                198.97693156537883,
            ],
        ],
        "outliers": [],
    },
    {
        "axisData": axis_data,
        "boxData": [
            [
                1.3866777918670525,
                52.723984144413805,
                112.16068484025186,
                148.07060013196633,
                196.6493886555634,
            ],
            [
                0.8675025485252785,
                41.94008605353009,
                90.4944101654473,
                134.34314089904032,
                199.57411732908722,
            ],
            [
                2.109917782227244,
                47.361245156921306,
                98.03121935506474,
                152.57304498745683,
                199.6655667235125,
            ],
            [
                0.835914742081334,
                45.90386054869363,
                110.8008994981315,
                153.77050147012113,
                198.17687983907325,
            ],
            [
                0.09929780808608513,
                55.313979741487245,
                80.36049651385588,
                144.5076321261422,
                198.71007594348265,
            ],
            [
                4.3591904343687204,
                53.098201381124454,
                88.8716562277704,
                134.2243571501588,
                197.86166497124387,
            ],
            [
                1.4751642002043486,
                52.87727910767818,
                98.1167484613283,
                129.123794134296,
                199.26128215126036,
            ],
            [
                1.0208468961246275,
                59.72883452828452,
                93.7117188714775,
                133.6955646934541,
                199.04002574913483,
            ],
            [
                5.700580454086168,
                62.30214699943758,
                109.4858546359291,
                144.37435834128183,
                196.80025087232633,
            ],
            [
                3.8776389962399627,
                47.07485197991684,
                108.77911010272065,
                143.55929331063112,
                199.78963194031576,
            ],
            [
                0.9206486824532956,
                56.531536633466786,
                103.22722183226676,
                153.71850265606832,
                199.26707930050713,
            ],
            [
                1.2238397462105866,
                42.37213742602606,
                85.0161099008823,
                144.6618761115177,
                195.68883739488717,
            ],
            [
                1.383845313528731,
                55.58975449585246,
                101.2502031542653,
                155.4651069256266,
                198.51896538541257,
            ],
            [
                2.460600698918336,
                45.35279677561122,
                86.22855211501036,
                142.2985968944624,
                196.88095181245973,
            ],
            [
                1.5771786133238486,
                47.74919144071982,
                98.25948642595273,
                143.6080569193598,
                199.35657813436302,
            ],
            [
                1.679597195618454,
                54.03099324959242,
                93.24925248108138,
                156.2197398880975,
                199.96087190538344,
            ],
            [
                0.09445769268561222,
                62.987289799985746,
                93.5536375308287,
                146.10299624484736,
                198.89381360902073,
            ],
            [
                0.5074418255246016,
                43.16902467382945,
                97.5036007943674,
                150.07249687988744,
                197.1438186145631,
            ],
        ],
        "outliers": [],
    },
    {
        "axisData": axis_data,
        "boxData": [
            [
                0.17336583192690824,
                38.89251480694969,
                95.24827036951726,
                144.42455874548153,
                199.4034309165705,
            ],
            [
                3.676663641014155,
                56.915752270243615,
                116.52533365244228,
                154.9613826361874,
                199.45242610474344,
            ],
            [
                0.2637149176087039,
                39.10809721270764,
                83.11646124189903,
                145.85305644883107,
                199.4425993969723,
            ],
            [
                0.9435517891188017,
                59.34726771939571,
                116.9100457332774,
                154.6830501745436,
                197.360203327316,
            ],
            [
                3.979089227580568,
                59.55958857930115,
                106.50956069508263,
                154.19233153204274,
                198.27863048295953,
            ],
            [
                0.2254389425328185,
                45.14272916122666,
                101.99744565544017,
                158.20585382578935,
                199.87918467096276,
            ],
            [
                0.4981747166813655,
                55.07500323828029,
                98.06775843874871,
                142.6740673515219,
                196.17733451641203,
            ],
            [
                3.459413844168191,
                48.45434370508197,
                90.08287035261958,
                144.44636703035508,
                196.7330418635301,
            ],
            [
                5.491046107788211,
                51.726853187011294,
                102.73451029578627,
                144.81711164442441,
                198.8867176824325,
            ],
            [
                0.7550472434538769,
                52.51096431201062,
                107.88318214869264,
                159.26961432919137,
                199.61830476130777,
            ],
            [
                0.2752001848587593,
                48.7398963427885,
                89.75616732426943,
                142.05594236584855,
                198.3147751483816,
            ],
            [
                1.4946063684317945,
                47.50894653631401,
                98.11186814575922,
                138.51943571666908,
                193.3052139732351,
            ],
            [
                0.20882224269564986,
                51.28631550804623,
                107.81597798598389,
                160.02354609263347,
                199.2878557923929,
            ],
            [
                0.8976637474841898,
                43.66029575375894,
                100.62231619788403,
                139.9661197041632,
                192.54845617677,
            ],
            [
                5.859745717489284,
                47.03805156535355,
                108.41470873842098,
                157.096784096105,
                199.9179863824041,
            ],
            [
                3.7257707586363598,
                42.231249941095996,
                97.356821000705,
                142.79191220154834,
                198.84036692134,
            ],
            [
                1.8454208635465985,
                44.91333687646406,
                98.65350096972611,
                143.39018022926803,
                199.87483964263296,
            ],
            [
                0.5514923538800787,
                45.85216189462081,
                99.9806157446917,
                153.32082407525542,
                198.2776454910153,
            ],
        ],
        "outliers": [],
    },
    {
        "axisData": axis_data,
        "boxData": [
            [
                0.7168805200240325,
                46.53681449735687,
                97.29254353668016,
                156.63006806530143,
                199.3015739378797,
            ],
            [
                1.7193486665883828,
                62.95172603462959,
                112.02740143118092,
                156.0538383864632,
                199.26142301676774,
            ],
            [
                2.1369256823901672,
                57.21732276358834,
                103.36834727083514,
                153.72092303549277,
                198.79539179393552,
            ],
            [
                0.032880351113817596,
                47.562260234793726,
                96.26764103515997,
                145.73458375286407,
                199.06617414977254,
            ],
            [
                0.4401537603581307,
                43.865273442582165,
                94.93675834281308,
                146.35738146359748,
                193.64127816517245,
            ],
            [
                0.3961689590249673,
                50.96909350725202,
                104.73604524329194,
                148.23414082526403,
                198.8856874527377,
            ],
            [
                0.21937305368529003,
                49.59183574690416,
                102.85949468466653,
                163.6266324963084,
                199.69745130954797,
            ],
            [
                0.6248639849676607,
                43.65587924550377,
                98.38900488209111,
                152.00850019757138,
                197.66849547068205,
            ],
            [
                0.8836653304501674,
                51.715354680095054,
                106.27634207918453,
                152.75520182409605,
                198.7026018674421,
            ],
            [
                7.037170236614809,
                60.499053468218285,
                99.70265208133726,
                145.547153860169,
                197.56589704383606,
            ],
            [
                0.191005947981715,
                36.77501191389064,
                78.79138996882105,
                138.31773623910374,
                199.5549011391389,
            ],
            [
                2.085660638228548,
                50.85562917320624,
                100.31437027035244,
                144.07227532917557,
                199.9671689855977,
            ],
            [
                2.8329465269889997,
                46.64735576556238,
                95.58042897665536,
                150.95016495791145,
                199.01002263253537,
            ],
            [
                2.9140730838620232,
                55.8981643150491,
                99.12490122897461,
                138.35381332244458,
                197.89764340001602,
            ],
            [
                0.6900722343886834,
                61.20627193426343,
                108.73896996351209,
                152.38197094149575,
                199.49695739258172,
            ],
            [
                0.3519848056308117,
                51.38799178079926,
                108.74191700174138,
                146.60812022274987,
                198.09008264810322,
            ],
            [
                0.2761553645218129,
                56.388967149570455,
                104.8697135719724,
                153.5049030271958,
                199.5731857965878,
            ],
            [
                3.5557869592812708,
                46.14828237062535,
                108.66363220203428,
                160.07663258712037,
                199.1028921688903,
            ],
        ],
        "outliers": [],
    },
    {
        "axisData": axis_data,
        "boxData": [
            [
                2.979477505147443,
                39.75713406508555,
                94.53079422141971,
                156.08283690923398,
                199.44795240229735,
            ],
            [
                2.6484190473881064,
                39.93623770385512,
                77.27669464380185,
                128.4315475425753,
                199.56482718369725,
            ],
            [
                0.027555734890816197,
                57.0338837796717,
                108.81399073964846,
                148.06814743102228,
                199.60110925244555,
            ],
            [
                5.095524117378636,
                61.306047315630614,
                110.93776130670011,
                156.1408460056575,
                195.24807037634693,
            ],
            [
                2.728611345602383,
                44.56605304153001,
                82.24512299722713,
                147.52018338217582,
                197.4401254594119,
            ],
            [
                3.2844003726598903,
                31.22917030540313,
                98.82341804522095,
                147.37909270120065,
                195.31234405750303,
            ],
            [
                0.18212434446978065,
                59.703454603359305,
                103.67261216911498,
                144.78603398715182,
                197.894221292169,
            ],
            [
                2.0723859910971587,
                65.62630968779271,
                108.08425190082599,
                153.04828999176155,
                198.71953877580813,
            ],
            [
                0.9675695750262392,
                52.06976077477188,
                106.44774448853506,
                153.71491587328123,
                199.9367145735771,
            ],
            [
                2.5328359424461766,
                54.040914797213425,
                98.74095548976766,
                156.68297214273787,
                199.54362057796757,
            ],
            [
                1.1331529861684952,
                44.39864814947693,
                88.34657630798353,
                137.22778263394855,
                198.83623456218217,
            ],
            [
                0.03400372259445561,
                39.0412178839992,
                82.44989003395962,
                142.39781316172628,
                198.66240858068616,
            ],
            [
                3.3739669830866514,
                51.553716623716575,
                113.01026058884891,
                165.92964939460416,
                198.22988431223231,
            ],
            [
                1.7144280578984095,
                52.52972703008254,
                97.47299182400204,
                134.9644807802092,
                198.46967348342878,
            ],
            [
                1.7893968468841948,
                43.87294943558785,
                90.42735899685948,
                143.0586276081752,
                197.6798595904976,
            ],
            [
                4.299131337916773,
                50.29192506963852,
                104.5869339834448,
                163.2705302681331,
                199.10157077449355,
            ],
            [
                0.6740610620747933,
                54.02651804107089,
                86.12616850846155,
                137.7008290515613,
                199.78999859299336,
            ],
            [
                0.5370189113081292,
                50.44519588101707,
                98.08928065026996,
                139.8482090057953,
                197.20820681141507,
            ],
        ],
        "outliers": [],
    },
]

c3 = (
    Boxplot()
    .add_xaxis(xaxis_data=axis_data)
    .add_yaxis(
        series_name="category0",
        y_axis=data[0]["boxData"],
        tooltip_opts=opts.TooltipOpts(
            formatter=JsCode(
                """function(param) { return [
                            'Experiment ' + param.name + ': ',
                            'upper: ' + param.data[0],
                            'Q1: ' + param.data[1],
                            'median: ' + param.data[2],
                            'Q3: ' + param.data[3],
                            'lower: ' + param.data[4]
                        ].join('<br/>') }"""
            )
        ),
    )
    .add_yaxis(
        series_name="category1",
        y_axis=data[1]["boxData"],
        tooltip_opts=opts.TooltipOpts(
            formatter=JsCode(
                """function(param) { return [
                            'Experiment ' + param.name + ': ',
                            'upper: ' + param.data[0],
                            'Q1: ' + param.data[1],
                            'median: ' + param.data[2],
                            'Q3: ' + param.data[3],
                            'lower: ' + param.data[4]
                        ].join('<br/>') }"""
            )
        ),
    )
    .add_yaxis(
        series_name="category2",
        y_axis=data[2]["boxData"],
        tooltip_opts=opts.TooltipOpts(
            formatter=JsCode(
                """function(param) { return [
                            'Experiment ' + param.name + ': ',
                            'upper: ' + param.data[0],
                            'Q1: ' + param.data[1],
                            'median: ' + param.data[2],
                            'Q3: ' + param.data[3],
                            'lower: ' + param.data[4]
                        ].join('<br/>') }"""
            )
        ),
    )
    .set_global_opts(
        title_opts=opts.TitleOpts(title="Multiple Categories", pos_left="center"),
        legend_opts=opts.LegendOpts(pos_top="3%"),
        tooltip_opts=opts.TooltipOpts(trigger="item", axis_pointer_type="shadow"),
        xaxis_opts=opts.AxisOpts(
            name_gap=30,
            boundary_gap=True,
            splitarea_opts=opts.SplitAreaOpts(
                areastyle_opts=opts.AreaStyleOpts(opacity=1)
            ),
            axislabel_opts=opts.LabelOpts(formatter="expr {value}"),
            splitline_opts=opts.SplitLineOpts(is_show=False),
        ),
        yaxis_opts=opts.AxisOpts(
            type_="value",
            min_=-400,
            max_=600,
            splitarea_opts=opts.SplitAreaOpts(is_show=False),
        ),
        datazoom_opts=[
            opts.DataZoomOpts(type_="inside", range_start=0, range_end=20),
            opts.DataZoomOpts(type_="slider", xaxis_index=0, is_show=True),
        ],
    )
)


import swanlab

swanlab.init(
    project="echarts-test",
    experiment_name="boxplot",
    public=True,
)

swanlab.log(
    {
        "Boxplot - Boxplot_light_velocity": c1,
        "Boxplot - Boxplot_base": c2,
        "Boxplot - Multiple_categories": c3
    }
)
