"""
// @author: ComPleHN
// @file: candlestick.vue
// @time: 2025/5/27 14:05
// @description: 本文件是对于echarts的 K线图 图表的测试
"""
# ---------------------------------------------- Candlestick - Professional_kline_chart ----------------------------------------------
"""
复刻的 Echarts 的 demo 链接
https://gallery.echartsjs.com/editor.html?c=xByOFPcjBe

@Author: sunhailin-Leo
@Time: 2019年7月14日
"""
from typing import List, Sequence, Union

from pyecharts import options as opts
from pyecharts.commons.utils import JsCode
from pyecharts.charts import Kline, Line, Bar, Grid

# 数据
echarts_data = [
    ["2015-10-16", 18.4, 18.58, 18.33, 18.79, 67.00, 1, 0.04, 0.11, 0.09],
    ["2015-10-19", 18.56, 18.25, 18.19, 18.56, 55.00, 0, -0.00, 0.08, 0.09],
    ["2015-10-20", 18.3, 18.22, 18.05, 18.41, 37.00, 0, 0.01, 0.09, 0.09],
    ["2015-10-21", 18.18, 18.69, 18.02, 18.98, 89.00, 0, 0.03, 0.10, 0.08],
    ["2015-10-22", 18.42, 18.29, 18.22, 18.48, 43.00, 0, -0.06, 0.05, 0.08],
    ["2015-10-23", 18.26, 18.19, 18.08, 18.36, 46.00, 0, -0.10, 0.03, 0.09],
    ["2015-10-26", 18.33, 18.07, 17.98, 18.35, 65.00, 0, -0.15, 0.03, 0.10],
    ["2015-10-27", 18.08, 18.04, 17.88, 18.13, 37.00, 0, -0.19, 0.03, 0.12],
    ["2015-10-28", 17.96, 17.86, 17.82, 17.99, 35.00, 0, -0.24, 0.03, 0.15],
    ["2015-10-29", 17.85, 17.81, 17.8, 17.93, 27.00, 0, -0.24, 0.06, 0.18],
    ["2015-10-30", 17.79, 17.93, 17.78, 18.08, 43.00, 0, -0.22, 0.11, 0.22],
    ["2015-11-02", 17.78, 17.83, 17.78, 18.04, 27.00, 0, -0.20, 0.15, 0.25],
    ["2015-11-03", 17.84, 17.9, 17.84, 18.06, 34.00, 0, -0.12, 0.22, 0.28],
    ["2015-11-04", 17.97, 18.36, 17.85, 18.39, 62.00, 0, -0.00, 0.30, 0.30],
    ["2015-11-05", 18.3, 18.57, 18.18, 19.08, 177.00, 0, 0.07, 0.33, 0.30],
    ["2015-11-06", 18.53, 18.68, 18.3, 18.71, 95.00, 0, 0.12, 0.35, 0.29],
    ["2015-11-09", 18.75, 19.08, 18.75, 19.98, 202.00, 1, 0.16, 0.35, 0.27],
    ["2015-11-10", 18.85, 18.64, 18.56, 18.99, 85.00, 0, 0.09, 0.29, 0.25],
    ["2015-11-11", 18.64, 18.44, 18.31, 18.64, 50.00, 0, 0.06, 0.27, 0.23],
    ["2015-11-12", 18.55, 18.27, 18.17, 18.57, 43.00, 0, 0.05, 0.25, 0.23],
    ["2015-11-13", 18.13, 18.14, 18.09, 18.34, 35.00, 0, 0.05, 0.24, 0.22],
    ["2015-11-16", 18.01, 18.1, 17.93, 18.17, 34.00, 0, 0.07, 0.25, 0.21],
    ["2015-11-17", 18.2, 18.14, 18.08, 18.45, 58.00, 0, 0.11, 0.25, 0.20],
    ["2015-11-18", 18.23, 18.16, 18.0, 18.45, 47.00, 0, 0.13, 0.25, 0.19],
    ["2015-11-19", 18.08, 18.2, 18.05, 18.25, 32.00, 0, 0.15, 0.24, 0.17],
    ["2015-11-20", 18.15, 18.15, 18.11, 18.29, 36.00, 0, 0.13, 0.21, 0.15],
    ["2015-11-23", 18.16, 18.19, 18.12, 18.34, 47.00, 0, 0.11, 0.18, 0.13],
    ["2015-11-24", 18.23, 17.88, 17.7, 18.23, 62.00, 0, 0.03, 0.13, 0.11],
    ["2015-11-25", 17.85, 17.73, 17.56, 17.85, 66.00, 0, -0.03, 0.09, 0.11],
    ["2015-11-26", 17.79, 17.53, 17.5, 17.92, 63.00, 0, -0.10, 0.06, 0.11],
    ["2015-11-27", 17.51, 17.04, 16.9, 17.51, 67.00, 0, -0.16, 0.05, 0.13],
    ["2015-11-30", 17.07, 17.2, 16.98, 17.32, 55.00, 0, -0.12, 0.09, 0.15],
    ["2015-12-01", 17.28, 17.11, 16.91, 17.28, 39.00, 0, -0.09, 0.12, 0.16],
    ["2015-12-02", 17.13, 17.91, 17.05, 17.99, 102.00, 0, -0.01, 0.17, 0.18],
    ["2015-12-03", 17.8, 17.78, 17.61, 17.98, 71.00, 0, -0.09, 0.14, 0.18],
    ["2015-12-04", 17.6, 17.25, 17.13, 17.69, 51.00, 0, -0.18, 0.10, 0.19],
    ["2015-12-07", 17.2, 17.39, 17.15, 17.45, 43.00, 0, -0.19, 0.12, 0.22],
    ["2015-12-08", 17.3, 17.42, 17.18, 17.62, 45.00, 0, -0.23, 0.13, 0.24],
    ["2015-12-09", 17.33, 17.39, 17.32, 17.59, 44.00, 0, -0.29, 0.13, 0.28],
    ["2015-12-10", 17.39, 17.26, 17.21, 17.65, 44.00, 0, -0.37, 0.13, 0.32],
    ["2015-12-11", 17.23, 16.92, 16.66, 17.26, 114.00, 1, -0.44, 0.15, 0.37],
    ["2015-12-14", 16.75, 17.06, 16.5, 17.09, 94.00, 0, -0.44, 0.21, 0.44],
    ["2015-12-15", 17.03, 17.03, 16.9, 17.06, 46.00, 0, -0.44, 0.28, 0.50],
    ["2015-12-16", 17.08, 16.96, 16.87, 17.09, 30.00, 0, -0.40, 0.36, 0.56],
    ["2015-12-17", 17.0, 17.1, 16.95, 17.12, 50.00, 0, -0.30, 0.47, 0.62],
    ["2015-12-18", 17.09, 17.52, 17.04, 18.06, 156.00, 0, -0.14, 0.59, 0.66],
    ["2015-12-21", 17.43, 18.23, 17.35, 18.45, 152.00, 1, 0.02, 0.69, 0.68],
    ["2015-12-22", 18.14, 18.27, 18.06, 18.32, 94.00, 0, 0.08, 0.72, 0.68],
    ["2015-12-23", 18.28, 18.19, 18.17, 18.71, 108.00, 0, 0.13, 0.73, 0.67],
    ["2015-12-24", 18.18, 18.14, 18.01, 18.31, 37.00, 0, 0.19, 0.74, 0.65],
    ["2015-12-25", 18.22, 18.33, 18.2, 18.36, 48.00, 0, 0.26, 0.75, 0.62],
    ["2015-12-28", 18.35, 17.84, 17.8, 18.39, 48.00, 0, 0.27, 0.72, 0.59],
    ["2015-12-29", 17.83, 17.94, 17.71, 17.97, 36.00, 0, 0.36, 0.73, 0.55],
    ["2015-12-30", 17.9, 18.26, 17.55, 18.3, 71.00, 1, 0.43, 0.71, 0.50],
    ["2015-12-31", 18.12, 17.99, 17.91, 18.33, 72.00, 0, 0.40, 0.63, 0.43],
    ["2016-01-04", 17.91, 17.28, 17.16, 17.95, 37.00, 1, 0.34, 0.55, 0.38],
    ["2016-01-05", 17.17, 17.23, 17.0, 17.55, 51.00, 0, 0.37, 0.51, 0.33],
    ["2016-01-06", 17.2, 17.31, 17.06, 17.33, 31.00, 0, 0.37, 0.46, 0.28],
    ["2016-01-07", 17.15, 16.67, 16.51, 17.15, 19.00, 0, 0.30, 0.37, 0.22],
    ["2016-01-08", 16.8, 16.81, 16.61, 17.06, 60.00, 0, 0.29, 0.32, 0.18],
    ["2016-01-11", 16.68, 16.04, 16.0, 16.68, 65.00, 0, 0.20, 0.24, 0.14],
    ["2016-01-12", 16.03, 15.98, 15.88, 16.25, 46.00, 0, 0.20, 0.21, 0.11],
    ["2016-01-13", 16.21, 15.87, 15.78, 16.21, 57.00, 0, 0.20, 0.18, 0.08],
    ["2016-01-14", 15.55, 15.89, 15.52, 15.96, 42.00, 0, 0.20, 0.16, 0.05],
    ["2016-01-15", 15.87, 15.48, 15.45, 15.92, 34.00, 1, 0.17, 0.11, 0.02],
    ["2016-01-18", 15.39, 15.42, 15.36, 15.7, 26.00, 0, 0.21, 0.10, -0.00],
    ["2016-01-19", 15.58, 15.71, 15.35, 15.77, 38.00, 0, 0.25, 0.09, -0.03],
    ["2016-01-20", 15.56, 15.52, 15.24, 15.68, 38.00, 0, 0.23, 0.05, -0.07],
    ["2016-01-21", 15.41, 15.3, 15.28, 15.68, 35.00, 0, 0.21, 0.00, -0.10],
    ["2016-01-22", 15.48, 15.28, 15.13, 15.49, 30.00, 0, 0.21, -0.02, -0.13],
    ["2016-01-25", 15.29, 15.48, 15.2, 15.49, 21.00, 0, 0.20, -0.06, -0.16],
    ["2016-01-26", 15.33, 14.86, 14.78, 15.39, 30.00, 0, 0.12, -0.13, -0.19],
    ["2016-01-27", 14.96, 15.0, 14.84, 15.22, 51.00, 0, 0.13, -0.14, -0.20],
    ["2016-01-28", 14.96, 14.72, 14.62, 15.06, 25.00, 0, 0.10, -0.17, -0.22],
    ["2016-01-29", 14.75, 14.99, 14.62, 15.08, 36.00, 0, 0.13, -0.17, -0.24],
    ["2016-02-01", 14.98, 14.72, 14.48, 15.18, 27.00, 0, 0.10, -0.21, -0.26],
    ["2016-02-02", 14.65, 14.85, 14.65, 14.95, 18.00, 0, 0.11, -0.21, -0.27],
    ["2016-02-03", 14.72, 14.67, 14.55, 14.8, 23.00, 0, 0.10, -0.24, -0.29],
    ["2016-02-04", 14.79, 14.88, 14.69, 14.93, 22.00, 0, 0.13, -0.24, -0.30],
    ["2016-02-05", 14.9, 14.86, 14.78, 14.93, 16.00, 0, 0.12, -0.26, -0.32],
    ["2016-02-15", 14.5, 14.66, 14.47, 14.82, 19.00, 0, 0.11, -0.28, -0.34],
    ["2016-02-16", 14.77, 14.94, 14.72, 15.05, 26.00, 0, 0.14, -0.28, -0.35],
    ["2016-02-17", 14.95, 15.03, 14.88, 15.07, 38.00, 0, 0.12, -0.31, -0.37],
    ["2016-02-18", 14.95, 14.9, 14.87, 15.06, 28.00, 0, 0.07, -0.35, -0.39],
    ["2016-02-19", 14.9, 14.75, 14.68, 14.94, 22.00, 0, 0.03, -0.38, -0.40],
    ["2016-02-22", 14.88, 15.01, 14.79, 15.11, 38.00, 1, 0.01, -0.40, -0.40],
    ["2016-02-23", 15.01, 14.83, 14.72, 15.01, 24.00, 0, -0.09, -0.45, -0.40],
    ["2016-02-24", 14.75, 14.81, 14.67, 14.87, 21.00, 0, -0.17, -0.48, -0.39],
    ["2016-02-25", 14.81, 14.25, 14.21, 14.81, 51.00, 1, -0.27, -0.50, -0.37],
    ["2016-02-26", 14.35, 14.45, 14.28, 14.57, 28.00, 0, -0.26, -0.46, -0.33],
    ["2016-02-29", 14.43, 14.56, 14.04, 14.6, 48.00, 0, -0.25, -0.41, -0.29],
    ["2016-03-01", 14.56, 14.65, 14.36, 14.78, 32.00, 0, -0.21, -0.36, -0.25],
    ["2016-03-02", 14.79, 14.96, 14.72, 14.97, 60.00, 0, -0.13, -0.29, -0.22],
    ["2016-03-03", 14.95, 15.15, 14.91, 15.19, 53.00, 1, -0.05, -0.23, -0.21],
    ["2016-03-04", 15.14, 15.97, 15.02, 16.02, 164.00, 1, 0.06, -0.17, -0.20],
    ["2016-03-07", 15.9, 15.78, 15.65, 16.0, 41.00, 0, 0.04, -0.19, -0.21],
    ["2016-03-08", 15.78, 15.96, 15.21, 15.99, 45.00, 0, 0.05, -0.19, -0.21],
    ["2016-03-09", 15.73, 16.05, 15.41, 16.08, 74.00, 0, 0.03, -0.20, -0.22],
    ["2016-03-10", 15.82, 15.66, 15.65, 15.98, 19.00, 0, -0.02, -0.23, -0.22],
    ["2016-03-11", 15.59, 15.76, 15.42, 15.78, 32.00, 0, 0.01, -0.22, -0.22],
    ["2016-03-14", 15.78, 15.72, 15.65, 16.04, 31.00, 0, 0.03, -0.20, -0.22],
    ["2016-03-15", 15.81, 15.86, 15.6, 15.99, 35.00, 0, 0.10, -0.18, -0.23],
    ["2016-03-16", 15.88, 16.42, 15.79, 16.45, 123.00, 0, 0.17, -0.16, -0.24],
    ["2016-03-17", 16.39, 16.23, 16.11, 16.4, 46.00, 0, 0.14, -0.20, -0.26],
    ["2016-03-18", 16.39, 16.17, 16.04, 16.4, 59.00, 0, 0.13, -0.22, -0.28],
    ["2016-03-21", 16.21, 16.22, 16.11, 16.44, 50.00, 0, 0.12, -0.24, -0.30],
    ["2016-03-22", 16.27, 16.19, 16.16, 16.42, 33.00, 0, 0.10, -0.27, -0.32],
    ["2016-03-23", 16.26, 16.18, 16.18, 16.29, 19.00, 0, 0.08, -0.30, -0.33],
    ["2016-03-24", 16.18, 16.11, 16.01, 16.23, 23.00, 0, 0.04, -0.33, -0.35],
    ["2016-03-25", 16.12, 16.13, 16.1, 16.2, 15.00, 0, 0.00, -0.35, -0.35],
    ["2016-03-28", 16.15, 15.85, 15.81, 16.2, 22.00, 0, -0.06, -0.38, -0.35],
    ["2016-03-29", 15.9, 15.79, 15.76, 16.05, 19.00, 0, -0.06, -0.37, -0.34],
    ["2016-03-30", 15.79, 16.24, 15.78, 16.3, 29.00, 0, -0.03, -0.35, -0.33],
    ["2016-03-31", 16.3, 16.09, 16.02, 16.35, 25.00, 0, -0.07, -0.37, -0.33],
    ["2016-04-01", 16.18, 16.27, 15.98, 16.3, 38.00, 0, -0.08, -0.36, -0.32],
    ["2016-04-05", 16.13, 16.34, 16.07, 16.37, 39.00, 0, -0.13, -0.37, -0.31],
    ["2016-04-06", 16.21, 16.26, 16.19, 16.35, 30.00, 0, -0.20, -0.39, -0.29],
    ["2016-04-07", 16.32, 16.1, 16.05, 16.35, 29.00, 1, -0.26, -0.39, -0.26],
    ["2016-04-08", 16.0, 16.16, 15.98, 16.21, 22.00, 0, -0.28, -0.37, -0.23],
    ["2016-04-11", 16.16, 16.31, 16.15, 16.57, 31.00, 0, -0.30, -0.33, -0.19],
    ["2016-04-12", 16.41, 16.29, 16.12, 16.41, 17.00, 0, -0.31, -0.30, -0.14],
    ["2016-04-13", 16.39, 16.48, 16.0, 16.68, 40.00, 0, -0.30, -0.25, -0.10],
    ["2016-04-14", 16.5, 16.46, 16.37, 16.68, 22.00, 0, -0.27, -0.19, -0.06],
    ["2016-04-15", 16.56, 16.93, 16.46, 17.04, 58.00, 0, -0.20, -0.12, -0.02],
    ["2016-04-18", 16.76, 17.06, 16.72, 17.27, 50.00, 0, -0.16, -0.07, 0.01],
    ["2016-04-19", 17.21, 17.11, 17.02, 17.23, 30.00, 0, -0.12, -0.02, 0.03],
    ["2016-04-20", 17.11, 17.33, 16.8, 17.36, 78.00, 0, -0.04, 0.03, 0.05],
    ["2016-04-21", 17.27, 17.69, 17.17, 17.93, 79.00, 0, 0.05, 0.08, 0.06],
    ["2016-04-22", 17.6, 17.87, 17.56, 18.02, 55.00, 0, 0.09, 0.10, 0.05],
    ["2016-04-25", 17.75, 17.9, 17.41, 17.96, 39.00, 1, 0.11, 0.09, 0.04],
    ["2016-04-26", 17.81, 17.91, 17.6, 17.95, 39.00, 0, 0.12, 0.08, 0.02],
    ["2016-04-27", 17.9, 17.88, 17.81, 17.95, 25.00, 0, 0.12, 0.06, 0.00],
    ["2016-04-28", 17.93, 17.88, 17.67, 17.93, 28.00, 0, 0.11, 0.04, -0.01],
    ["2016-04-29", 17.87, 17.75, 17.73, 17.92, 19.00, 0, 0.08, 0.01, -0.03],
    ["2016-05-03", 17.79, 17.7, 17.56, 17.85, 35.00, 0, 0.05, -0.01, -0.04],
    ["2016-05-04", 17.7, 17.65, 17.59, 17.71, 24.00, 0, 0.02, -0.04, -0.05],
    ["2016-05-05", 17.65, 17.62, 17.46, 17.7, 20.00, 0, -0.03, -0.06, -0.05],
    ["2016-05-06", 17.62, 17.32, 17.3, 17.65, 29.00, 0, -0.10, -0.09, -0.05],
    ["2016-05-09", 17.33, 17.3, 17.21, 17.45, 23.00, 0, -0.13, -0.10, -0.03],
    ["2016-05-10", 17.11, 17.04, 16.98, 17.41, 28.00, 0, -0.15, -0.09, -0.01],
    ["2016-05-11", 17.06, 17.15, 17.06, 17.32, 20.00, 0, -0.12, -0.05, 0.01],
    ["2016-05-12", 17.02, 17.46, 17.02, 17.58, 26.00, 0, -0.07, -0.01, 0.03],
    ["2016-05-13", 17.41, 17.57, 17.34, 17.62, 23.00, 0, -0.06, 0.01, 0.03],
    ["2016-05-16", 17.55, 17.5, 17.48, 17.64, 37.00, 0, -0.06, 0.01, 0.04],
    ["2016-05-17", 17.49, 17.48, 17.39, 17.53, 13.00, 0, -0.03, 0.03, 0.05],
    ["2016-05-18", 17.41, 17.82, 17.39, 17.87, 46.00, 0, 0.01, 0.06, 0.06],
    ["2016-05-19", 17.74, 17.81, 17.67, 17.86, 17.00, 0, -0.01, 0.05, 0.05],
    ["2016-05-20", 17.76, 17.88, 17.7, 17.93, 14.00, 0, -0.03, 0.04, 0.06],
    ["2016-05-23", 17.88, 17.52, 17.48, 17.97, 16.00, 0, -0.09, 0.02, 0.06],
    ["2016-05-24", 17.51, 17.33, 17.32, 17.51, 8.00, 0, -0.09, 0.03, 0.07],
    ["2016-05-25", 17.59, 17.55, 17.44, 17.59, 10.00, 0, -0.03, 0.07, 0.08],
    ["2016-05-26", 17.5, 17.69, 17.5, 17.8, 12.00, 0, 0.00, 0.09, 0.09],
    ["2016-05-27", 17.77, 17.66, 17.62, 17.77, 7.00, 0, 0.03, 0.10, 0.09],
    ["2016-05-30", 17.75, 17.84, 17.62, 17.87, 20.00, 0, 0.08, 0.12, 0.08],
    ["2016-05-31", 17.88, 18.0, 17.81, 18.03, 41.00, 0, 0.10, 0.12, 0.07],
    ["2016-06-01", 18.09, 17.83, 17.73, 18.09, 22.00, 0, 0.08, 0.10, 0.06],
    ["2016-06-02", 17.82, 17.73, 17.66, 17.88, 10.00, 0, 0.07, 0.08, 0.05],
    ["2016-06-03", 17.8, 17.78, 17.71, 17.83, 9.00, 0, 0.08, 0.08, 0.04],
    ["2016-06-06", 17.73, 17.64, 17.56, 17.83, 12.00, 0, 0.07, 0.06, 0.03],
    ["2016-06-07", 17.76, 17.8, 17.59, 17.87, 11.00, 0, 0.08, 0.06, 0.02],
    ["2016-06-08", 17.75, 17.77, 17.65, 17.84, 9.00, 0, 0.04, 0.03, 0.01],
    ["2016-06-13", 17.58, 17.32, 17.29, 17.79, 16.00, 0, -0.02, -0.01, 0.00],
    ["2016-06-14", 17.33, 17.38, 17.29, 17.5, 10.00, 0, -0.01, 0.00, 0.00],
    ["2016-06-15", 17.25, 17.39, 17.25, 17.46, 18.00, 0, 0.00, 0.01, 0.00],
    ["2016-06-16", 17.26, 17.4, 17.26, 17.46, 22.00, 0, 0.01, 0.01, 0.00],
    ["2016-06-17", 17.38, 17.5, 17.37, 17.67, 13.00, 0, 0.03, 0.02, 0.00],
    ["2016-06-20", 17.62, 17.51, 17.42, 17.63, 15.00, 0, 0.03, 0.01, -0.00],
    ["2016-06-21", 17.53, 17.54, 17.5, 17.7, 11.00, 0, 0.02, 0.00, -0.01],
    ["2016-06-22", 17.5, 17.5, 17.46, 17.6, 10.00, 0, -0.01, -0.01, -0.01],
    ["2016-06-23", 17.52, 17.26, 17.24, 17.53, 16.00, 0, -0.04, -0.03, -0.01],
    ["2016-06-24", 17.26, 17.25, 17.18, 17.38, 60.00, 0, -0.03, -0.02, -0.00],
    ["2016-06-27", 17.25, 17.28, 17.18, 17.33, 19.00, 0, -0.01, -0.00, 0.00],
    ["2016-06-28", 17.25, 17.29, 17.21, 17.32, 13.00, 0, 0.02, 0.01, 0.00],
    ["2016-06-29", 17.31, 17.45, 17.27, 17.49, 21.00, 0, 0.07, 0.04, 0.00],
    ["2016-06-30", 17.47, 17.5, 17.39, 17.55, 17.00, 0, 0.11, 0.04, -0.01],
    ["2016-07-01", 17.5, 17.63, 17.49, 17.66, 10.00, 0, 0.14, 0.05, -0.03],
    ["2016-07-04", 17.63, 17.72, 17.63, 17.92, 17.00, 0, 0.16, 0.03, -0.05],
    ["2016-07-05", 17.79, 17.56, 17.45, 17.79, 18.00, 0, 0.14, 0.00, -0.07],
    ["2016-07-06", 17.53, 17.42, 17.31, 17.54, 20.00, 0, 0.14, -0.02, -0.09],
    ["2016-07-07", 17.41, 17.51, 17.35, 17.52, 15.00, 0, 0.16, -0.03, -0.11],
    ["2016-07-08", 17.5, 17.39, 17.35, 17.51, 15.00, 0, 0.16, -0.05, -0.13],
    ["2016-07-11", 17.49, 17.48, 17.4, 17.55, 16.00, 0, 0.17, -0.07, -0.15],
    ["2016-07-12", 17.48, 17.71, 17.46, 17.75, 25.00, 0, 0.16, -0.10, -0.18],
    ["2016-07-13", 17.13, 17.05, 17.02, 17.39, 28.00, 0, 0.07, -0.17, -0.20],
    ["2016-07-14", 17.07, 17.09, 17.0, 17.16, 12.00, 0, 0.08, -0.17, -0.21],
    ["2016-07-15", 17.08, 17.14, 17.08, 17.17, 11.00, 0, 0.09, -0.18, -0.22],
    ["2016-07-18", 17.15, 17.26, 17.13, 17.49, 24.00, 0, 0.10, -0.19, -0.23],
    ["2016-07-19", 17.26, 17.12, 17.09, 17.33, 13.00, 0, 0.07, -0.21, -0.25],
    ["2016-07-20", 17.1, 17.07, 17.02, 17.14, 11.00, 0, 0.06, -0.23, -0.26],
    ["2016-07-21", 17.07, 17.24, 17.07, 17.27, 14.00, 0, 0.07, -0.23, -0.27],
    ["2016-07-22", 17.25, 17.08, 17.03, 17.25, 10.00, 0, 0.04, -0.26, -0.28],
    ["2016-07-25", 17.09, 17.12, 17.01, 17.18, 8.00, 0, 0.04, -0.26, -0.28],
    ["2016-07-26", 17.05, 17.17, 17.05, 17.2, 11.00, 0, 0.04, -0.27, -0.29],
    ["2016-07-27", 17.2, 17.37, 16.89, 17.38, 32.00, 0, 0.02, -0.28, -0.29],
    ["2016-07-28", 17.19, 17.14, 17.09, 17.29, 19.00, 0, -0.04, -0.32, -0.30],
    ["2016-07-29", 17.15, 17.16, 17.04, 17.23, 12.00, 0, -0.08, -0.33, -0.29],
    ["2016-08-01", 17.15, 17.18, 17.1, 17.24, 19.00, 0, -0.13, -0.34, -0.28],
    ["2016-08-02", 17.21, 17.15, 17.12, 17.25, 9.00, 0, -0.19, -0.36, -0.26],
    ["2016-08-03", 17.08, 17.07, 17.01, 17.16, 9.00, 0, -0.25, -0.36, -0.24],
    ["2016-08-04", 17.11, 17.06, 16.98, 17.12, 11.00, 1, -0.29, -0.35, -0.20],
    ["2016-08-05", 17.06, 17.1, 17.05, 17.15, 16.00, 0, -0.33, -0.32, -0.16],
    ["2016-08-08", 17.14, 17.13, 17.07, 17.15, 13.00, 0, -0.35, -0.29, -0.11],
    ["2016-08-09", 17.13, 17.17, 17.1, 17.2, 25.00, 0, -0.35, -0.24, -0.06],
    ["2016-08-10", 17.17, 17.28, 17.15, 17.29, 18.00, 0, -0.31, -0.17, -0.01],
    ["2016-08-11", 17.3, 17.45, 17.26, 17.87, 31.00, 0, -0.24, -0.09, 0.03],
    ["2016-08-12", 17.51, 17.99, 17.47, 18.0, 44.00, 0, -0.14, -0.00, 0.07],
    ["2016-08-15", 18.1, 18.42, 18.02, 18.99, 81.00, 0, -0.09, 0.04, 0.09],
    ["2016-08-16", 18.64, 18.31, 18.12, 18.87, 60.00, 0, -0.10, 0.05, 0.10],
    ["2016-08-17", 18.43, 18.4, 18.31, 18.68, 21.00, 0, -0.08, 0.08, 0.11],
    ["2016-08-18", 18.33, 18.23, 18.13, 18.65, 32.00, 0, -0.07, 0.09, 0.13],
    ["2016-08-19", 18.34, 18.62, 18.31, 18.75, 39.00, 0, 0.00, 0.14, 0.14],
    ["2016-08-22", 18.62, 18.69, 18.51, 18.8, 20.00, 0, 0.01, 0.14, 0.13],
    ["2016-08-23", 18.61, 18.66, 18.52, 19.0, 28.00, 0, 0.01, 0.14, 0.13],
    ["2016-08-24", 18.66, 18.62, 18.43, 18.7, 19.00, 0, 0.00, 0.13, 0.13],
    ["2016-08-25", 18.57, 18.51, 18.19, 18.64, 19.00, 0, -0.00, 0.13, 0.13],
    ["2016-08-26", 18.49, 18.55, 18.44, 18.6, 16.00, 0, 0.01, 0.13, 0.13],
    ["2016-08-29", 18.46, 18.27, 18.03, 18.48, 20.00, 0, 0.01, 0.13, 0.13],
    ["2016-08-30", 18.24, 18.44, 18.23, 18.52, 19.00, 0, 0.07, 0.17, 0.13],
    ["2016-08-31", 18.36, 18.63, 18.36, 18.76, 15.00, 0, 0.13, 0.18, 0.12],
    ["2016-09-01", 18.6, 18.62, 18.55, 18.78, 15.00, 0, 0.16, 0.18, 0.10],
    ["2016-09-02", 18.52, 18.68, 18.48, 18.72, 17.00, 0, 0.19, 0.17, 0.08],
    ["2016-09-05", 18.68, 18.75, 18.57, 18.82, 19.00, 0, 0.20, 0.15, 0.05],
    ["2016-09-06", 18.75, 18.51, 18.43, 18.78, 17.00, 0, 0.18, 0.11, 0.02],
    ["2016-09-07", 18.51, 18.56, 18.4, 18.62, 17.00, 0, 0.17, 0.08, -0.00],
    ["2016-09-08", 18.58, 18.53, 18.48, 18.63, 8.00, 0, 0.13, 0.04, -0.03],
    ["2016-09-09", 18.52, 18.33, 18.31, 18.57, 8.00, 0, 0.06, -0.02, -0.05],
    ["2016-09-12", 18.16, 17.9, 17.81, 18.18, 28.00, 0, -0.02, -0.07, -0.06],
    ["2016-09-13", 17.91, 17.91, 17.9, 18.08, 13.00, 0, -0.05, -0.08, -0.05],
    ["2016-09-14", 17.99, 17.54, 17.48, 17.99, 22.00, 0, -0.09, -0.09, -0.05],
    ["2016-09-19", 17.55, 17.81, 17.55, 17.88, 16.00, 0, -0.06, -0.06, -0.03],
    ["2016-09-20", 17.8, 17.74, 17.67, 17.85, 10.00, 0, -0.06, -0.05, -0.02],
    ["2016-09-21", 17.75, 17.88, 17.75, 17.95, 7.00, 0, -0.03, -0.03, -0.02],
    ["2016-09-22", 17.99, 17.97, 17.88, 18.17, 12.00, 0, -0.02, -0.02, -0.01],
    ["2016-09-23", 17.99, 17.98, 17.93, 18.09, 13.00, 0, -0.01, -0.01, -0.01],
    ["2016-09-26", 17.91, 18.0, 17.85, 18.09, 14.00, 0, -0.00, -0.01, -0.01],
    ["2016-09-27", 17.97, 18.07, 17.94, 18.1, 10.00, 0, 0.00, -0.01, -0.01],
    ["2016-09-28", 18.06, 17.89, 17.83, 18.06, 10.00, 0, -0.00, -0.01, -0.01],
    ["2016-09-29", 17.96, 18.0, 17.92, 18.07, 10.00, 0, 0.03, 0.01, -0.01],
    ["2016-09-30", 17.96, 18.0, 17.95, 18.1, 8.00, 0, 0.06, 0.02, -0.01],
    ["2016-10-10", 18.03, 18.3, 18.03, 18.38, 19.00, 0, 0.11, 0.04, -0.02],
    ["2016-10-11", 18.33, 18.33, 18.26, 18.49, 12.00, 0, 0.10, 0.02, -0.04],
    ["2016-10-12", 18.28, 18.15, 18.1, 18.31, 10.00, 0, 0.07, -0.02, -0.05],
    ["2016-10-13", 18.15, 18.09, 18.05, 18.21, 10.00, 0, 0.06, -0.03, -0.06],
    ["2016-10-14", 18.1, 18.1, 18.0, 18.15, 12.00, 0, 0.04, -0.05, -0.07],
    ["2016-10-17", 18.07, 17.86, 17.83, 18.1, 12.00, 0, 0.01, -0.07, -0.08],
    ["2016-10-18", 17.86, 17.93, 17.84, 17.99, 14.00, 0, 0.03, -0.07, -0.08],
    ["2016-10-19", 17.93, 17.88, 17.83, 18.05, 11.00, 0, 0.03, -0.07, -0.08],
    ["2016-10-20", 17.9, 17.89, 17.83, 17.98, 12.00, 0, 0.05, -0.06, -0.09],
    ["2016-10-21", 17.91, 17.91, 17.82, 17.93, 12.00, 0, 0.07, -0.06, -0.09],
    ["2016-10-24", 17.93, 18.31, 17.86, 18.42, 29.00, 0, 0.11, -0.05, -0.10],
    ["2016-10-25", 18.31, 18.13, 18.09, 18.46, 19.00, 0, 0.06, -0.09, -0.12],
    ["2016-10-26", 18.12, 17.97, 17.95, 18.15, 14.00, 0, 0.02, -0.12, -0.13],
    ["2016-10-27", 18.06, 17.81, 17.77, 18.06, 21.00, 0, -0.01, -0.13, -0.13],
    ["2016-10-28", 17.8, 17.9, 17.8, 18.05, 20.00, 0, -0.01, -0.13, -0.13],
    ["2016-10-31", 17.87, 17.86, 17.72, 17.96, 12.00, 0, -0.02, -0.14, -0.13],
    ["2016-11-01", 17.87, 17.98, 17.79, 17.99, 18.00, 0, -0.03, -0.14, -0.12],
    ["2016-11-02", 17.86, 17.84, 17.76, 17.94, 30.00, 0, -0.06, -0.15, -0.12],
    ["2016-11-03", 17.83, 17.93, 17.79, 17.97, 27.00, 0, -0.07, -0.14, -0.11],
    ["2016-11-04", 17.9, 17.91, 17.87, 18.0, 26.00, 0, -0.09, -0.15, -0.10],
    ["2016-11-07", 17.91, 17.89, 17.85, 17.93, 20.00, 0, -0.11, -0.14, -0.09],
    ["2016-11-08", 17.92, 17.99, 17.89, 18.06, 26.00, 0, -0.12, -0.13, -0.07],
    ["2016-11-09", 18.0, 17.89, 17.77, 18.08, 34.00, 0, -0.15, -0.13, -0.06],
    ["2016-11-10", 17.95, 18.0, 17.94, 18.11, 27.00, 0, -0.15, -0.11, -0.03],
    ["2016-11-11", 17.95, 18.02, 17.93, 18.08, 27.00, 0, -0.17, -0.10, -0.01],
    ["2016-11-14", 18.0, 18.04, 17.95, 18.25, 35.00, 0, -0.18, -0.08, 0.01],
    ["2016-11-15", 18.1, 18.18, 18.03, 18.24, 25.00, 0, -0.18, -0.06, 0.04],
    ["2016-11-16", 18.23, 18.12, 18.05, 18.29, 23.00, 0, -0.21, -0.04, 0.06],
    ["2016-11-17", 18.11, 18.12, 18.01, 18.14, 27.00, 0, -0.21, -0.01, 0.09],
    ["2016-11-18", 18.12, 18.1, 18.03, 18.16, 18.00, 0, -0.19, 0.03, 0.12],
    ["2016-11-21", 18.08, 18.34, 18.08, 18.68, 41.00, 0, -0.13, 0.08, 0.15],
    ["2016-11-22", 18.37, 18.37, 18.28, 18.49, 52.00, 0, -0.09, 0.12, 0.17],
    ["2016-11-23", 18.4, 18.84, 18.37, 18.9, 66.00, 0, -0.02, 0.17, 0.18],
    ["2016-11-24", 18.77, 18.74, 18.61, 18.97, 26.00, 0, -0.02, 0.17, 0.18],
    ["2016-11-25", 18.8, 18.99, 18.66, 19.02, 40.00, 0, -0.01, 0.18, 0.19],
    ["2016-11-28", 19.1, 18.65, 18.52, 19.2, 85.00, 0, -0.06, 0.16, 0.19],
    ["2016-11-29", 18.65, 18.75, 18.51, 18.76, 49.00, 0, -0.06, 0.17, 0.20],
    ["2016-11-30", 18.76, 18.55, 18.47, 18.82, 39.00, 0, -0.08, 0.17, 0.21],
    ["2016-12-01", 18.55, 18.49, 18.41, 18.64, 53.00, 0, -0.06, 0.19, 0.22],
    ["2016-12-02", 18.53, 18.49, 18.24, 18.54, 48.00, 0, -0.02, 0.21, 0.23],
    ["2016-12-05", 18.39, 18.66, 18.34, 18.67, 50.00, 0, 0.03, 0.25, 0.23],
    ["2016-12-06", 18.66, 18.6, 18.57, 18.78, 31.00, 0, 0.08, 0.26, 0.23],
    ["2016-12-07", 18.65, 18.62, 18.58, 18.71, 12.00, 0, 0.15, 0.29, 0.21],
    ["2016-12-08", 18.67, 18.76, 18.62, 18.88, 26.00, 0, 0.25, 0.32, 0.19],
    ["2016-12-09", 18.76, 19.2, 18.75, 19.34, 62.00, 0, 0.34, 0.33, 0.16],
    ["2016-12-12", 19.16, 19.25, 18.9, 19.65, 79.00, 1, 0.34, 0.28, 0.11],
    ["2016-12-13", 19.09, 18.88, 18.81, 19.2, 24.00, 0, 0.27, 0.20, 0.06],
    ["2016-12-14", 18.8, 18.82, 18.8, 19.14, 32.00, 0, 0.23, 0.13, 0.02],
    ["2016-12-15", 18.73, 18.24, 18.2, 18.73, 36.00, 0, 0.13, 0.05, -0.01],
    ["2016-12-16", 18.24, 18.18, 18.12, 18.4, 24.00, 0, 0.10, 0.02, -0.03],
    ["2016-12-19", 18.15, 18.01, 17.93, 18.18, 24.00, 0, 0.06, -0.02, -0.05],
    ["2016-12-20", 17.99, 17.79, 17.7, 17.99, 29.00, 1, 0.02, -0.05, -0.05],
    ["2016-12-21", 17.83, 17.81, 17.77, 17.98, 30.00, 0, 0.00, -0.05, -0.06],
    ["2016-12-22", 17.85, 17.72, 17.65, 17.85, 21.00, 0, -0.03, -0.07, -0.06],
    ["2016-12-23", 17.77, 17.6, 17.54, 17.77, 18.00, 0, -0.04, -0.08, -0.05],
    ["2016-12-26", 17.56, 17.75, 17.39, 17.77, 16.00, 0, -0.04, -0.07, -0.05],
    ["2016-12-27", 17.73, 17.71, 17.65, 17.82, 10.00, 0, -0.06, -0.07, -0.04],
    ["2016-12-28", 17.72, 17.62, 17.49, 17.77, 26.00, 0, -0.09, -0.07, -0.03],
    ["2016-12-29", 17.6, 17.49, 17.43, 17.62, 28.00, 0, -0.09, -0.06, -0.02],
    ["2016-12-30", 17.53, 17.6, 17.47, 17.61, 22.00, 0, -0.05, -0.03, -0.01],
    ["2017-01-03", 17.6, 17.92, 17.57, 17.98, 28.00, 1, 0.00, 0.00, 0.00],
]

def split_data(origin_data=echarts_data) -> dict:
    datas = []
    times = []
    vols = []
    macds = []
    difs = []
    deas = []

    for i in range(len(origin_data)):
        datas.append(origin_data[i][1:])
        times.append(origin_data[i][0:1][0])
        vols.append(origin_data[i][5])
        macds.append(origin_data[i][7])
        difs.append(origin_data[i][8])
        deas.append(origin_data[i][9])
    vols = [int(v) for v in vols]

    return {
        "datas": datas,
        "times": times,
        "vols": vols,
        "macds": macds,
        "difs": difs,
        "deas": deas,
    }

data = split_data()

def split_data_part() -> Sequence:
    mark_line_data = []
    idx = 0
    tag = 0
    vols = 0
    for i in range(len(data["times"])):
        if data["datas"][i][5] != 0 and tag == 0:
            idx = i
            vols = data["datas"][i][4]
            tag = 1
        if tag == 1:
            vols += data["datas"][i][4]
        if data["datas"][i][5] != 0 or tag == 1:
            mark_line_data.append(
                [
                    {
                        "xAxis": idx,
                        "yAxis": float("%.2f" % data["datas"][idx][3])
                        if data["datas"][idx][1] > data["datas"][idx][0]
                        else float("%.2f" % data["datas"][idx][2]),
                        "value": vols,
                    },
                    {
                        "xAxis": i,
                        "yAxis": float("%.2f" % data["datas"][i][3])
                        if data["datas"][i][1] > data["datas"][i][0]
                        else float("%.2f" % data["datas"][i][2]),
                    },
                ]
            )
            idx = i
            vols = data["datas"][i][4]
            tag = 2
        if tag == 2:
            vols += data["datas"][i][4]
        if data["datas"][i][5] != 0 and tag == 2:
            mark_line_data.append(
                [
                    {
                        "xAxis": idx,
                        "yAxis": float("%.2f" % data["datas"][idx][3])
                        if data["datas"][i][1] > data["datas"][i][0]
                        else float("%.2f" % data["datas"][i][2]),
                        "value": str(float("%.2f" % (vols / (i - idx + 1)))) + " M",
                    },
                    {
                        "xAxis": i,
                        "yAxis": float("%.2f" % data["datas"][i][3])
                        if data["datas"][i][1] > data["datas"][i][0]
                        else float("%.2f" % data["datas"][i][2]),
                    },
                ]
            )
            idx = i
            vols = data["datas"][i][4]
    return mark_line_data


def calculate_ma(day_count: int):
    result: List[Union[float, str]] = []

    for i in range(len(data["times"])):
        if i < day_count:
            result.append("-")
            continue
        sum_total = 0.0
        for j in range(day_count):
            sum_total += float(data["datas"][i - j][1])
        result.append(abs(float("%.2f" % (sum_total / day_count))))
    return result


def draw_chart():
    kline = (
        Kline()
        .add_xaxis(xaxis_data=data["times"])
        .add_yaxis(
            series_name="",
            y_axis=data["datas"],
            itemstyle_opts=opts.ItemStyleOpts(
                color="#ef232a",
                color0="#14b143",
                border_color="#ef232a",
                border_color0="#14b143",
            ),
            markpoint_opts=opts.MarkPointOpts(
                data=[
                    opts.MarkPointItem(type_="max", name="最大值"),
                    opts.MarkPointItem(type_="min", name="最小值"),
                ]
            ),
            markline_opts=opts.MarkLineOpts(
                label_opts=opts.LabelOpts(
                    position="middle", color="blue", font_size=15
                ),
                data=split_data_part(),
                symbol=["circle", "none"],
            ),
        )
        .set_series_opts(
            markarea_opts=opts.MarkAreaOpts(is_silent=True, data=split_data_part())
        )
        .set_global_opts(
            title_opts=opts.TitleOpts(title="K线周期图表", pos_left="0"),
            xaxis_opts=opts.AxisOpts(
                type_="category",
                is_scale=True,
                boundary_gap=False,
                axisline_opts=opts.AxisLineOpts(is_on_zero=False),
                splitline_opts=opts.SplitLineOpts(is_show=False),
                split_number=20,
                min_="dataMin",
                max_="dataMax",
            ),
            yaxis_opts=opts.AxisOpts(
                is_scale=True, splitline_opts=opts.SplitLineOpts(is_show=True)
            ),
            tooltip_opts=opts.TooltipOpts(trigger="axis", axis_pointer_type="line"),
            datazoom_opts=[
                opts.DataZoomOpts(
                    is_show=False, type_="inside", xaxis_index=[0, 0], range_end=100
                ),
                opts.DataZoomOpts(
                    is_show=True, xaxis_index=[0, 1], pos_top="97%", range_end=100
                ),
                opts.DataZoomOpts(is_show=False, xaxis_index=[0, 2], range_end=100),
            ],
            # 三个图的 axis 连在一块
            # axispointer_opts=opts.AxisPointerOpts(
            #     is_show=True,
            #     link=[{"xAxisIndex": "all"}],
            #     label=opts.LabelOpts(background_color="#777"),
            # ),
        )
    )

    kline_line = (
        Line()
        .add_xaxis(xaxis_data=data["times"])
        .add_yaxis(
            series_name="MA5",
            y_axis=calculate_ma(day_count=5),
            is_smooth=True,
            linestyle_opts=opts.LineStyleOpts(opacity=0.5),
            label_opts=opts.LabelOpts(is_show=False),
        )
        .set_global_opts(
            xaxis_opts=opts.AxisOpts(
                type_="category",
                grid_index=1,
                axislabel_opts=opts.LabelOpts(is_show=False),
            ),
            yaxis_opts=opts.AxisOpts(
                grid_index=1,
                split_number=3,
                axisline_opts=opts.AxisLineOpts(is_on_zero=False),
                axistick_opts=opts.AxisTickOpts(is_show=False),
                splitline_opts=opts.SplitLineOpts(is_show=False),
                axislabel_opts=opts.LabelOpts(is_show=True),
            ),
        )
    )
    # Overlap Kline + Line
    overlap_kline_line = kline.overlap(kline_line)

    # Bar-1
    bar_1 = (
        Bar()
        .add_xaxis(xaxis_data=data["times"])
        .add_yaxis(
            series_name="Volumn",
            y_axis=data["vols"],
            xaxis_index=1,
            yaxis_index=1,
            label_opts=opts.LabelOpts(is_show=False),
            # 根据 echarts demo 的原版是这么写的
            # itemstyle_opts=opts.ItemStyleOpts(
            #     color=JsCode("""
            #     function(params) {
            #         var colorList;
            #         if (data.datas[params.dataIndex][1]>data.datas[params.dataIndex][0]) {
            #           colorList = '#ef232a';
            #         } else {
            #           colorList = '#14b143';
            #         }
            #         return colorList;
            #     }
            #     """)
            # )
            # 改进后在 grid 中 add_js_funcs 后变成如下
            itemstyle_opts=opts.ItemStyleOpts(
                color=JsCode(
                    """
                function(params) {
                    var colorList;
                    if (barData[params.dataIndex][1] > barData[params.dataIndex][0]) {
                        colorList = '#ef232a';
                    } else {
                        colorList = '#14b143';
                    }
                    return colorList;
                }
                """
                )
            ),
        )
        .set_global_opts(
            xaxis_opts=opts.AxisOpts(
                type_="category",
                grid_index=1,
                axislabel_opts=opts.LabelOpts(is_show=False),
            ),
            legend_opts=opts.LegendOpts(is_show=False),
        )
    )

    # Bar-2 (Overlap Bar + Line)
    bar_2 = (
        Bar()
        .add_xaxis(xaxis_data=data["times"])
        .add_yaxis(
            series_name="MACD",
            y_axis=data["macds"],
            xaxis_index=2,
            yaxis_index=2,
            label_opts=opts.LabelOpts(is_show=False),
            itemstyle_opts=opts.ItemStyleOpts(
                color=JsCode(
                    """
                        function(params) {
                            var colorList;
                            if (params.data >= 0) {
                              colorList = '#ef232a';
                            } else {
                              colorList = '#14b143';
                            }
                            return colorList;
                        }
                        """
                )
            ),
        )
        .set_global_opts(
            xaxis_opts=opts.AxisOpts(
                type_="category",
                grid_index=2,
                axislabel_opts=opts.LabelOpts(is_show=False),
            ),
            yaxis_opts=opts.AxisOpts(
                grid_index=2,
                split_number=4,
                axisline_opts=opts.AxisLineOpts(is_on_zero=False),
                axistick_opts=opts.AxisTickOpts(is_show=False),
                splitline_opts=opts.SplitLineOpts(is_show=False),
                axislabel_opts=opts.LabelOpts(is_show=True),
            ),
            legend_opts=opts.LegendOpts(is_show=False),
        )
    )

    line_2 = (
        Line()
        .add_xaxis(xaxis_data=data["times"])
        .add_yaxis(
            series_name="DIF",
            y_axis=data["difs"],
            xaxis_index=2,
            yaxis_index=2,
            label_opts=opts.LabelOpts(is_show=False),
        )
        .add_yaxis(
            series_name="DIF",
            y_axis=data["deas"],
            xaxis_index=2,
            yaxis_index=2,
            label_opts=opts.LabelOpts(is_show=False),
        )
        .set_global_opts(legend_opts=opts.LegendOpts(is_show=False))
    )
    # 最下面的柱状图和折线图
    overlap_bar_line = bar_2.overlap(line_2)

    # 最后的 Grid
    grid_chart = Grid()

    # 这个是为了把 data.datas 这个数据写入到 html 中,还没想到怎么跨 series 传值
    # demo 中的代码也是用全局变量传的
    grid_chart.add_js_funcs("var barData = {}".format(data["datas"]))

    # K线图和 MA5 的折线图
    grid_chart.add(
        overlap_kline_line,
        grid_opts=opts.GridOpts(pos_left="3%", pos_right="1%", height="60%"),
    )
    # Volumn 柱状图
    grid_chart.add(
        bar_1,
        grid_opts=opts.GridOpts(
            pos_left="3%", pos_right="1%", pos_top="71%", height="10%"
        ),
    )
    # MACD DIFS DEAS
    grid_chart.add(
        overlap_bar_line,
        grid_opts=opts.GridOpts(
            pos_left="3%", pos_right="1%", pos_top="82%", height="14%"
        ),
    )

    return grid_chart

c1 = draw_chart()

# ---------------------------------------------- Candlestick - Kline_itemstyle ----------------------------------------------
from pyecharts import options as opts
from pyecharts.charts import Kline

data = [
    [2320.26, 2320.26, 2287.3, 2362.94],
    [2300, 2291.3, 2288.26, 2308.38],
    [2295.35, 2346.5, 2295.35, 2345.92],
    [2347.22, 2358.98, 2337.35, 2363.8],
    [2360.75, 2382.48, 2347.89, 2383.76],
    [2383.43, 2385.42, 2371.23, 2391.82],
    [2377.41, 2419.02, 2369.57, 2421.15],
    [2425.92, 2428.15, 2417.58, 2440.38],
    [2411, 2433.13, 2403.3, 2437.42],
    [2432.68, 2334.48, 2427.7, 2441.73],
    [2430.69, 2418.53, 2394.22, 2433.89],
    [2416.62, 2432.4, 2414.4, 2443.03],
    [2441.91, 2421.56, 2418.43, 2444.8],
    [2420.26, 2382.91, 2373.53, 2427.07],
    [2383.49, 2397.18, 2370.61, 2397.94],
    [2378.82, 2325.95, 2309.17, 2378.82],
    [2322.94, 2314.16, 2308.76, 2330.88],
    [2320.62, 2325.82, 2315.01, 2338.78],
    [2313.74, 2293.34, 2289.89, 2340.71],
    [2297.77, 2313.22, 2292.03, 2324.63],
    [2322.32, 2365.59, 2308.92, 2366.16],
    [2364.54, 2359.51, 2330.86, 2369.65],
    [2332.08, 2273.4, 2259.25, 2333.54],
    [2274.81, 2326.31, 2270.1, 2328.14],
    [2333.61, 2347.18, 2321.6, 2351.44],
    [2340.44, 2324.29, 2304.27, 2352.02],
    [2326.42, 2318.61, 2314.59, 2333.67],
    [2314.68, 2310.59, 2296.58, 2320.96],
    [2309.16, 2286.6, 2264.83, 2333.29],
    [2282.17, 2263.97, 2253.25, 2286.33],
    [2255.77, 2270.28, 2253.31, 2276.22],
]


c2 = (
    Kline()
    .add_xaxis(["2017/7/{}".format(i + 1) for i in range(31)])
    .add_yaxis(
        "kline",
        data,
        itemstyle_opts=opts.ItemStyleOpts(
            color="#ec0000",
            color0="#00da3c",
            border_color="#8A0000",
            border_color0="#008F28",
        ),
    )
    .set_global_opts(
        xaxis_opts=opts.AxisOpts(is_scale=True),
        yaxis_opts=opts.AxisOpts(
            is_scale=True,
            splitarea_opts=opts.SplitAreaOpts(
                is_show=True, areastyle_opts=opts.AreaStyleOpts(opacity=1)
            ),
        ),
        datazoom_opts=[opts.DataZoomOpts(type_="inside")],
        title_opts=opts.TitleOpts(title="Kline-ItemStyle"),
    )
)

# ---------------------------------------------- Candlestick - Basic_candlestick ----------------------------------------------
import pyecharts.options as opts
from pyecharts.charts import Candlestick

x_data = ["2017-10-24", "2017-10-25", "2017-10-26", "2017-10-27"]
y_data = [[20, 30, 10, 35], [40, 35, 30, 55], [33, 38, 33, 40], [40, 40, 32, 42]]

c3 = (
    Candlestick()
    .add_xaxis(xaxis_data=x_data)
    .add_yaxis(series_name="", y_axis=y_data)
    .set_series_opts()
    .set_global_opts(
        yaxis_opts=opts.AxisOpts(
            splitline_opts=opts.SplitLineOpts(
                is_show=True, linestyle_opts=opts.LineStyleOpts(width=1)
            )
        )
    )
)

# ---------------------------------------------- Candlestick - Kline_markline ----------------------------------------------
from pyecharts import options as opts
from pyecharts.charts import Kline

data = [
    [2320.26, 2320.26, 2287.3, 2362.94],
    [2300, 2291.3, 2288.26, 2308.38],
    [2295.35, 2346.5, 2295.35, 2345.92],
    [2347.22, 2358.98, 2337.35, 2363.8],
    [2360.75, 2382.48, 2347.89, 2383.76],
    [2383.43, 2385.42, 2371.23, 2391.82],
    [2377.41, 2419.02, 2369.57, 2421.15],
    [2425.92, 2428.15, 2417.58, 2440.38],
    [2411, 2433.13, 2403.3, 2437.42],
    [2432.68, 2334.48, 2427.7, 2441.73],
    [2430.69, 2418.53, 2394.22, 2433.89],
    [2416.62, 2432.4, 2414.4, 2443.03],
    [2441.91, 2421.56, 2418.43, 2444.8],
    [2420.26, 2382.91, 2373.53, 2427.07],
    [2383.49, 2397.18, 2370.61, 2397.94],
    [2378.82, 2325.95, 2309.17, 2378.82],
    [2322.94, 2314.16, 2308.76, 2330.88],
    [2320.62, 2325.82, 2315.01, 2338.78],
    [2313.74, 2293.34, 2289.89, 2340.71],
    [2297.77, 2313.22, 2292.03, 2324.63],
    [2322.32, 2365.59, 2308.92, 2366.16],
    [2364.54, 2359.51, 2330.86, 2369.65],
    [2332.08, 2273.4, 2259.25, 2333.54],
    [2274.81, 2326.31, 2270.1, 2328.14],
    [2333.61, 2347.18, 2321.6, 2351.44],
    [2340.44, 2324.29, 2304.27, 2352.02],
    [2326.42, 2318.61, 2314.59, 2333.67],
    [2314.68, 2310.59, 2296.58, 2320.96],
    [2309.16, 2286.6, 2264.83, 2333.29],
    [2282.17, 2263.97, 2253.25, 2286.33],
    [2255.77, 2270.28, 2253.31, 2276.22],
]

c4 = (
    Kline()
    .add_xaxis(["2017/7/{}".format(i + 1) for i in range(31)])
    .add_yaxis(
        "kline",
        data,
        markline_opts=opts.MarkLineOpts(
            data=[opts.MarkLineItem(type_="max", value_dim="close")]
        ),
    )
    .set_global_opts(
        xaxis_opts=opts.AxisOpts(is_scale=True),
        yaxis_opts=opts.AxisOpts(
            is_scale=True,
            splitarea_opts=opts.SplitAreaOpts(
                is_show=True, areastyle_opts=opts.AreaStyleOpts(opacity=1)
            ),
        ),
        title_opts=opts.TitleOpts(title="Kline-MarkLine"),
    )
)

# ---------------------------------------------- Candlestick - Kline_base ----------------------------------------------
from pyecharts import options as opts
from pyecharts.charts import Kline

data = [
    [2320.26, 2320.26, 2287.3, 2362.94],
    [2300, 2291.3, 2288.26, 2308.38],
    [2295.35, 2346.5, 2295.35, 2345.92],
    [2347.22, 2358.98, 2337.35, 2363.8],
    [2360.75, 2382.48, 2347.89, 2383.76],
    [2383.43, 2385.42, 2371.23, 2391.82],
    [2377.41, 2419.02, 2369.57, 2421.15],
    [2425.92, 2428.15, 2417.58, 2440.38],
    [2411, 2433.13, 2403.3, 2437.42],
    [2432.68, 2334.48, 2427.7, 2441.73],
    [2430.69, 2418.53, 2394.22, 2433.89],
    [2416.62, 2432.4, 2414.4, 2443.03],
    [2441.91, 2421.56, 2418.43, 2444.8],
    [2420.26, 2382.91, 2373.53, 2427.07],
    [2383.49, 2397.18, 2370.61, 2397.94],
    [2378.82, 2325.95, 2309.17, 2378.82],
    [2322.94, 2314.16, 2308.76, 2330.88],
    [2320.62, 2325.82, 2315.01, 2338.78],
    [2313.74, 2293.34, 2289.89, 2340.71],
    [2297.77, 2313.22, 2292.03, 2324.63],
    [2322.32, 2365.59, 2308.92, 2366.16],
    [2364.54, 2359.51, 2330.86, 2369.65],
    [2332.08, 2273.4, 2259.25, 2333.54],
    [2274.81, 2326.31, 2270.1, 2328.14],
    [2333.61, 2347.18, 2321.6, 2351.44],
    [2340.44, 2324.29, 2304.27, 2352.02],
    [2326.42, 2318.61, 2314.59, 2333.67],
    [2314.68, 2310.59, 2296.58, 2320.96],
    [2309.16, 2286.6, 2264.83, 2333.29],
    [2282.17, 2263.97, 2253.25, 2286.33],
    [2255.77, 2270.28, 2253.31, 2276.22],
]


c5 = (
    Kline()
    .add_xaxis(["2017/7/{}".format(i + 1) for i in range(31)])
    .add_yaxis("kline", data)
    .set_global_opts(
        yaxis_opts=opts.AxisOpts(is_scale=True),
        xaxis_opts=opts.AxisOpts(is_scale=True),
        title_opts=opts.TitleOpts(title="Kline-基本示例"),
    )
)

# ---------------------------------------------- Candlestick - Kline_datazoom_inside ----------------------------------------------
from pyecharts import options as opts
from pyecharts.charts import Kline

data = [
    [2320.26, 2320.26, 2287.3, 2362.94],
    [2300, 2291.3, 2288.26, 2308.38],
    [2295.35, 2346.5, 2295.35, 2345.92],
    [2347.22, 2358.98, 2337.35, 2363.8],
    [2360.75, 2382.48, 2347.89, 2383.76],
    [2383.43, 2385.42, 2371.23, 2391.82],
    [2377.41, 2419.02, 2369.57, 2421.15],
    [2425.92, 2428.15, 2417.58, 2440.38],
    [2411, 2433.13, 2403.3, 2437.42],
    [2432.68, 2334.48, 2427.7, 2441.73],
    [2430.69, 2418.53, 2394.22, 2433.89],
    [2416.62, 2432.4, 2414.4, 2443.03],
    [2441.91, 2421.56, 2418.43, 2444.8],
    [2420.26, 2382.91, 2373.53, 2427.07],
    [2383.49, 2397.18, 2370.61, 2397.94],
    [2378.82, 2325.95, 2309.17, 2378.82],
    [2322.94, 2314.16, 2308.76, 2330.88],
    [2320.62, 2325.82, 2315.01, 2338.78],
    [2313.74, 2293.34, 2289.89, 2340.71],
    [2297.77, 2313.22, 2292.03, 2324.63],
    [2322.32, 2365.59, 2308.92, 2366.16],
    [2364.54, 2359.51, 2330.86, 2369.65],
    [2332.08, 2273.4, 2259.25, 2333.54],
    [2274.81, 2326.31, 2270.1, 2328.14],
    [2333.61, 2347.18, 2321.6, 2351.44],
    [2340.44, 2324.29, 2304.27, 2352.02],
    [2326.42, 2318.61, 2314.59, 2333.67],
    [2314.68, 2310.59, 2296.58, 2320.96],
    [2309.16, 2286.6, 2264.83, 2333.29],
    [2282.17, 2263.97, 2253.25, 2286.33],
    [2255.77, 2270.28, 2253.31, 2276.22],
]

c6 = (
    Kline()
    .add_xaxis(["2017/7/{}".format(i + 1) for i in range(31)])
    .add_yaxis("kline", data)
    .set_global_opts(
        xaxis_opts=opts.AxisOpts(is_scale=True),
        yaxis_opts=opts.AxisOpts(
            is_scale=True,
            splitarea_opts=opts.SplitAreaOpts(
                is_show=True, areastyle_opts=opts.AreaStyleOpts(opacity=1)
            ),
        ),
        datazoom_opts=[opts.DataZoomOpts(type_="inside")],
        title_opts=opts.TitleOpts(title="Kline-DataZoom-inside"),
    )
)

# ---------------------------------------------- Candlestick - Kline_datazoom_slider_position ----------------------------------------------
from pyecharts import options as opts
from pyecharts.charts import Kline

data = [
    [2320.26, 2320.26, 2287.3, 2362.94],
    [2300, 2291.3, 2288.26, 2308.38],
    [2295.35, 2346.5, 2295.35, 2345.92],
    [2347.22, 2358.98, 2337.35, 2363.8],
    [2360.75, 2382.48, 2347.89, 2383.76],
    [2383.43, 2385.42, 2371.23, 2391.82],
    [2377.41, 2419.02, 2369.57, 2421.15],
    [2425.92, 2428.15, 2417.58, 2440.38],
    [2411, 2433.13, 2403.3, 2437.42],
    [2432.68, 2334.48, 2427.7, 2441.73],
    [2430.69, 2418.53, 2394.22, 2433.89],
    [2416.62, 2432.4, 2414.4, 2443.03],
    [2441.91, 2421.56, 2418.43, 2444.8],
    [2420.26, 2382.91, 2373.53, 2427.07],
    [2383.49, 2397.18, 2370.61, 2397.94],
    [2378.82, 2325.95, 2309.17, 2378.82],
    [2322.94, 2314.16, 2308.76, 2330.88],
    [2320.62, 2325.82, 2315.01, 2338.78],
    [2313.74, 2293.34, 2289.89, 2340.71],
    [2297.77, 2313.22, 2292.03, 2324.63],
    [2322.32, 2365.59, 2308.92, 2366.16],
    [2364.54, 2359.51, 2330.86, 2369.65],
    [2332.08, 2273.4, 2259.25, 2333.54],
    [2274.81, 2326.31, 2270.1, 2328.14],
    [2333.61, 2347.18, 2321.6, 2351.44],
    [2340.44, 2324.29, 2304.27, 2352.02],
    [2326.42, 2318.61, 2314.59, 2333.67],
    [2314.68, 2310.59, 2296.58, 2320.96],
    [2309.16, 2286.6, 2264.83, 2333.29],
    [2282.17, 2263.97, 2253.25, 2286.33],
    [2255.77, 2270.28, 2253.31, 2276.22],
]

c7 = (
    Kline()
    .add_xaxis(["2017/7/{}".format(i + 1) for i in range(31)])
    .add_yaxis("kline", data)
    .set_global_opts(
        xaxis_opts=opts.AxisOpts(is_scale=True),
        yaxis_opts=opts.AxisOpts(
            is_scale=True,
            splitarea_opts=opts.SplitAreaOpts(
                is_show=True, areastyle_opts=opts.AreaStyleOpts(opacity=1)
            ),
        ),
        datazoom_opts=[opts.DataZoomOpts(pos_bottom="-2%")],
        title_opts=opts.TitleOpts(title="Kline-DataZoom-slider-Position"),
    )
)

# ---------------------------------------------- Candlestick - Professional_kline_brush ----------------------------------------------
import requests
from typing import List, Union

from pyecharts import options as opts
from pyecharts.charts import Kline, Line, Bar, Grid


def get_data():
    response = requests.get(
        url="https://echarts.apache.org/examples/data/asset/data/stock-DJI.json"
    )
    json_response = response.json()
    # 解析数据
    return split_data(data=json_response)

def split_data(data):
    category_data = []
    values = []
    volumes = []

    for i, tick in enumerate(data):
        category_data.append(tick[0])
        values.append(tick)
        volumes.append([i, tick[4], 1 if tick[1] > tick[2] else -1])
    return {"categoryData": category_data, "values": values, "volumes": volumes}


def calculate_ma(day_count: int, data):
    result: List[Union[float, str]] = []
    for i in range(len(data["values"])):
        if i < day_count:
            result.append("-")
            continue
        sum_total = 0.0
        for j in range(day_count):
            sum_total += float(data["values"][i - j][1])
        result.append(abs(float("%.3f" % (sum_total / day_count))))
    return result


def draw_charts():
    kline_data = [data[1:-1] for data in chart_data["values"]]
    kline = (
        Kline()
        .add_xaxis(xaxis_data=chart_data["categoryData"])
        .add_yaxis(
            series_name="Dow-Jones index",
            y_axis=kline_data,
            itemstyle_opts=opts.ItemStyleOpts(color="#ec0000", color0="#00da3c"),
        )
        .set_global_opts(
            legend_opts=opts.LegendOpts(
                is_show=False, pos_bottom=10, pos_left="center"
            ),
            datazoom_opts=[
                opts.DataZoomOpts(
                    is_show=False,
                    type_="inside",
                    xaxis_index=[0, 1],
                    range_start=98,
                    range_end=100,
                ),
                opts.DataZoomOpts(
                    is_show=True,
                    xaxis_index=[0, 1],
                    type_="slider",
                    pos_top="85%",
                    range_start=98,
                    range_end=100,
                ),
            ],
            yaxis_opts=opts.AxisOpts(
                is_scale=True,
                splitarea_opts=opts.SplitAreaOpts(
                    is_show=True, areastyle_opts=opts.AreaStyleOpts(opacity=1)
                ),
            ),
            tooltip_opts=opts.TooltipOpts(
                trigger="axis",
                axis_pointer_type="cross",
                background_color="rgba(245, 245, 245, 0.8)",
                border_width=1,
                border_color="#ccc",
                textstyle_opts=opts.TextStyleOpts(color="#000"),
            ),
            visualmap_opts=opts.VisualMapOpts(
                is_show=False,
                dimension=2,
                series_index=5,
                is_piecewise=True,
                pieces=[
                    {"value": 1, "color": "#00da3c"},
                    {"value": -1, "color": "#ec0000"},
                ],
            ),
            axispointer_opts=opts.AxisPointerOpts(
                is_show=True,
                link=[{"xAxisIndex": "all"}],
                label=opts.LabelOpts(background_color="#777"),
            ),
            brush_opts=opts.BrushOpts(
                x_axis_index="all",
                brush_link="all",
                out_of_brush={"colorAlpha": 0.1},
                brush_type="lineX",
            ),
        )
    )

    line = (
        Line()
        .add_xaxis(xaxis_data=chart_data["categoryData"])
        .add_yaxis(
            series_name="MA5",
            y_axis=calculate_ma(day_count=5, data=chart_data),
            is_smooth=True,
            is_hover_animation=False,
            linestyle_opts=opts.LineStyleOpts(width=3, opacity=0.5),
            label_opts=opts.LabelOpts(is_show=False),
        )
        .add_yaxis(
            series_name="MA10",
            y_axis=calculate_ma(day_count=10, data=chart_data),
            is_smooth=True,
            is_hover_animation=False,
            linestyle_opts=opts.LineStyleOpts(width=3, opacity=0.5),
            label_opts=opts.LabelOpts(is_show=False),
        )
        .add_yaxis(
            series_name="MA20",
            y_axis=calculate_ma(day_count=20, data=chart_data),
            is_smooth=True,
            is_hover_animation=False,
            linestyle_opts=opts.LineStyleOpts(width=3, opacity=0.5),
            label_opts=opts.LabelOpts(is_show=False),
        )
        .add_yaxis(
            series_name="MA30",
            y_axis=calculate_ma(day_count=30, data=chart_data),
            is_smooth=True,
            is_hover_animation=False,
            linestyle_opts=opts.LineStyleOpts(width=3, opacity=0.5),
            label_opts=opts.LabelOpts(is_show=False),
        )
        .set_global_opts(xaxis_opts=opts.AxisOpts(type_="category"))
    )

    bar = (
        Bar()
        .add_xaxis(xaxis_data=chart_data["categoryData"])
        .add_yaxis(
            series_name="Volume",
            y_axis=chart_data["volumes"],
            xaxis_index=1,
            yaxis_index=1,
            label_opts=opts.LabelOpts(is_show=False),
        )
        .set_global_opts(
            xaxis_opts=opts.AxisOpts(
                type_="category",
                is_scale=True,
                grid_index=1,
                boundary_gap=False,
                axisline_opts=opts.AxisLineOpts(is_on_zero=False),
                axistick_opts=opts.AxisTickOpts(is_show=False),
                splitline_opts=opts.SplitLineOpts(is_show=False),
                axislabel_opts=opts.LabelOpts(is_show=False),
                split_number=20,
                min_="dataMin",
                max_="dataMax",
            ),
            yaxis_opts=opts.AxisOpts(
                grid_index=1,
                is_scale=True,
                split_number=2,
                axislabel_opts=opts.LabelOpts(is_show=False),
                axisline_opts=opts.AxisLineOpts(is_show=False),
                axistick_opts=opts.AxisTickOpts(is_show=False),
                splitline_opts=opts.SplitLineOpts(is_show=False),
            ),
            legend_opts=opts.LegendOpts(is_show=False),
        )
    )

    # Kline And Line
    overlap_kline_line = kline.overlap(line)

    # Grid Overlap + Bar
    grid_chart = Grid(
        init_opts=opts.InitOpts(
            width="1000px",
            height="800px",
            animation_opts=opts.AnimationOpts(animation=False),
        )
    )
    grid_chart.add(
        overlap_kline_line,
        grid_opts=opts.GridOpts(pos_left="10%", pos_right="8%", height="50%"),
    )
    grid_chart.add(
        bar,
        grid_opts=opts.GridOpts(
            pos_left="10%", pos_right="8%", pos_top="63%", height="16%"
        ),
    )

    return grid_chart

chart_data = get_data()
c8 = draw_charts()

# ---------------------------------------------- Candlestick - Kline_datazoom_slider ----------------------------------------------
from pyecharts import options as opts
from pyecharts.charts import Kline

data = [
    [2320.26, 2320.26, 2287.3, 2362.94],
    [2300, 2291.3, 2288.26, 2308.38],
    [2295.35, 2346.5, 2295.35, 2345.92],
    [2347.22, 2358.98, 2337.35, 2363.8],
    [2360.75, 2382.48, 2347.89, 2383.76],
    [2383.43, 2385.42, 2371.23, 2391.82],
    [2377.41, 2419.02, 2369.57, 2421.15],
    [2425.92, 2428.15, 2417.58, 2440.38],
    [2411, 2433.13, 2403.3, 2437.42],
    [2432.68, 2334.48, 2427.7, 2441.73],
    [2430.69, 2418.53, 2394.22, 2433.89],
    [2416.62, 2432.4, 2414.4, 2443.03],
    [2441.91, 2421.56, 2418.43, 2444.8],
    [2420.26, 2382.91, 2373.53, 2427.07],
    [2383.49, 2397.18, 2370.61, 2397.94],
    [2378.82, 2325.95, 2309.17, 2378.82],
    [2322.94, 2314.16, 2308.76, 2330.88],
    [2320.62, 2325.82, 2315.01, 2338.78],
    [2313.74, 2293.34, 2289.89, 2340.71],
    [2297.77, 2313.22, 2292.03, 2324.63],
    [2322.32, 2365.59, 2308.92, 2366.16],
    [2364.54, 2359.51, 2330.86, 2369.65],
    [2332.08, 2273.4, 2259.25, 2333.54],
    [2274.81, 2326.31, 2270.1, 2328.14],
    [2333.61, 2347.18, 2321.6, 2351.44],
    [2340.44, 2324.29, 2304.27, 2352.02],
    [2326.42, 2318.61, 2314.59, 2333.67],
    [2314.68, 2310.59, 2296.58, 2320.96],
    [2309.16, 2286.6, 2264.83, 2333.29],
    [2282.17, 2263.97, 2253.25, 2286.33],
    [2255.77, 2270.28, 2253.31, 2276.22],
]

c9 = (
    Kline()
    .add_xaxis(["2017/7/{}".format(i + 1) for i in range(31)])
    .add_yaxis("kline", data)
    .set_global_opts(
        xaxis_opts=opts.AxisOpts(is_scale=True),
        yaxis_opts=opts.AxisOpts(
            is_scale=True,
            splitarea_opts=opts.SplitAreaOpts(
                is_show=True, areastyle_opts=opts.AreaStyleOpts(opacity=1)
            ),
        ),
        datazoom_opts=[opts.DataZoomOpts()],
        title_opts=opts.TitleOpts(title="Kline-DataZoom-slider"),
    )
)

# ---------------------------------------------- Candlestick - Kline_split_area ----------------------------------------------
from pyecharts import options as opts
from pyecharts.charts import Kline

data = [
    [2320.26, 2320.26, 2287.3, 2362.94],
    [2300, 2291.3, 2288.26, 2308.38],
    [2295.35, 2346.5, 2295.35, 2345.92],
    [2347.22, 2358.98, 2337.35, 2363.8],
    [2360.75, 2382.48, 2347.89, 2383.76],
    [2383.43, 2385.42, 2371.23, 2391.82],
    [2377.41, 2419.02, 2369.57, 2421.15],
    [2425.92, 2428.15, 2417.58, 2440.38],
    [2411, 2433.13, 2403.3, 2437.42],
    [2432.68, 2334.48, 2427.7, 2441.73],
    [2430.69, 2418.53, 2394.22, 2433.89],
    [2416.62, 2432.4, 2414.4, 2443.03],
    [2441.91, 2421.56, 2418.43, 2444.8],
    [2420.26, 2382.91, 2373.53, 2427.07],
    [2383.49, 2397.18, 2370.61, 2397.94],
    [2378.82, 2325.95, 2309.17, 2378.82],
    [2322.94, 2314.16, 2308.76, 2330.88],
    [2320.62, 2325.82, 2315.01, 2338.78],
    [2313.74, 2293.34, 2289.89, 2340.71],
    [2297.77, 2313.22, 2292.03, 2324.63],
    [2322.32, 2365.59, 2308.92, 2366.16],
    [2364.54, 2359.51, 2330.86, 2369.65],
    [2332.08, 2273.4, 2259.25, 2333.54],
    [2274.81, 2326.31, 2270.1, 2328.14],
    [2333.61, 2347.18, 2321.6, 2351.44],
    [2340.44, 2324.29, 2304.27, 2352.02],
    [2326.42, 2318.61, 2314.59, 2333.67],
    [2314.68, 2310.59, 2296.58, 2320.96],
    [2309.16, 2286.6, 2264.83, 2333.29],
    [2282.17, 2263.97, 2253.25, 2286.33],
    [2255.77, 2270.28, 2253.31, 2276.22],
]


c10 = (
    Kline()
    .add_xaxis(["2017/7/{}".format(i + 1) for i in range(31)])
    .add_yaxis("kline", data)
    .set_global_opts(
        xaxis_opts=opts.AxisOpts(is_scale=True),
        yaxis_opts=opts.AxisOpts(
            is_scale=True,
            splitarea_opts=opts.SplitAreaOpts(
                is_show=True, areastyle_opts=opts.AreaStyleOpts(opacity=1)
            ),
        ),
        title_opts=opts.TitleOpts(title="Kline-显示分割区域"),
    )
)






import swanlab

swanlab.init(
    project="echarts-test",
    experiment_name="candlestick",
    public=True,
)

swanlab.log(
    {
        "Candlestick - Professional_kline_chart": c1,
        "Candlestick - Kline_itemstyle": c2,
        "Candlestick - Basic_candlestick": c3,
        "Candlestick - Kline_markline": c4,
        "Candlestick - Kline_base": c5,
        "Candlestick - Kline_datazoom_inside": c6,
        "Candlestick - Kline_datazoom_slider_position": c7,
        "Candlestick - Professional_kline_brush": c8,
        "Candlestick - Kline_datazoom_slider": c9,
        "Candlestick - Kline_split_area": c10
    }
)
