"""
// @author: ComPleHN
// @file: map.vue
// @time: 2025/5/27 18:58
// @description: 本文件是对于echarts的 地图 图表测试 
"""
# ---------------------------------------------- Map - Map_base ----------------------------------------------
from pyecharts import options as opts
from pyecharts.charts import Map
from pyecharts.faker import Faker

c1 = (
    Map()
    .add("商家A", [list(z) for z in zip(Faker.provinces, Faker.values())], "china")
    .set_global_opts(title_opts=opts.TitleOpts(title="Map-基本示例"))
)

# ---------------------------------------------- Map - Map_guangdong ----------------------------------------------
from pyecharts import options as opts
from pyecharts.charts import Map
from pyecharts.faker import Faker

c2 = (
    Map()
    .add("商家A", [list(z) for z in zip(Faker.guangdong_city, Faker.values())], "广东")
    .set_global_opts(
        title_opts=opts.TitleOpts(title="Map-广东地图"), visualmap_opts=opts.VisualMapOpts()
    )
)

# ---------------------------------------------- Map - Map_china_cities ----------------------------------------------
from pyecharts import options as opts
from pyecharts.charts import Map
from pyecharts.faker import Faker

c3 = (
    Map()
    .add(
        "商家A",
        [list(z) for z in zip(Faker.guangdong_city, Faker.values())],
        "china-cities",
        label_opts=opts.LabelOpts(is_show=False),
    )
    .set_global_opts(
        title_opts=opts.TitleOpts(title="Map-中国地图（带城市）"),
        visualmap_opts=opts.VisualMapOpts(),
    )
)

# ---------------------------------------------- Map - Map_visualmap_piecewise ----------------------------------------------
from pyecharts import options as opts
from pyecharts.charts import Map
from pyecharts.faker import Faker

c4 = (
    Map()
    .add("商家A", [list(z) for z in zip(Faker.provinces, Faker.values())], "china")
    .set_global_opts(
        title_opts=opts.TitleOpts(title="Map-VisualMap（分段型）"),
        visualmap_opts=opts.VisualMapOpts(max_=200, is_piecewise=True),
    )
)

# ---------------------------------------------- Map - Map_world ----------------------------------------------
from pyecharts import options as opts
from pyecharts.charts import Map
from pyecharts.faker import Faker

c5 = (
    Map()
    .add("商家A", [list(z) for z in zip(Faker.country, Faker.values())], "world")
    .set_series_opts(label_opts=opts.LabelOpts(is_show=False))
    .set_global_opts(
        title_opts=opts.TitleOpts(title="Map-世界地图"),
        visualmap_opts=opts.VisualMapOpts(max_=200),
    )
)

# ---------------------------------------------- Map - China_gdp_from_1993_to_2018 ----------------------------------------------
from typing import List

import pyecharts.options as opts
from pyecharts.globals import ThemeType
from pyecharts.commons.utils import JsCode
from pyecharts.charts import Timeline, Grid, Bar, Map, Pie, Line

"""
Gallery 使用 pyecharts 1.3.0
From pyecharts 交流分享群 -- 郭昱
"""
data = [
    {
        "time": "1993年",
        "data": [
            {"name": "广东省", "value": [3469.0, 10.12, "广东省"]},
            {"name": "江苏省", "value": [2998.0, 8.75, "江苏省"]},
            {"name": "山东省", "value": [2770.0, 8.08, "山东省"]},
            {"name": "辽宁省", "value": [2011.0, 5.87, "辽宁省"]},
            {"name": "浙江省", "value": [1926.0, 5.62, "浙江省"]},
            {"name": "河北省", "value": [1691.0, 4.93, "河北省"]},
            {"name": "河南省", "value": [1660.0, 4.84, "河南省"]},
            {"name": "上海市", "value": [1519.0, 4.43, "上海市"]},
            {"name": "四川省", "value": [1486.0, 4.34, "四川省"]},
            {"name": "湖北省", "value": [1326.0, 3.87, "湖北省"]},
            {"name": "湖南省", "value": [1245.0, 3.63, "湖南省"]},
            {"name": "黑龙江省", "value": [1198.0, 3.5, "黑龙江省"]},
            {"name": "福建省", "value": [1114.0, 3.25, "福建省"]},
            {"name": "安徽省", "value": [1037.0, 3.03, "安徽省"]},
            {"name": "北京市", "value": [886.0, 2.59, "北京市"]},
            {"name": "广西壮族自治区", "value": [872.0, 2.54, "广西壮族自治区"]},
            {"name": "云南省", "value": [783.0, 2.28, "云南省"]},
            {"name": "江西省", "value": [723.0, 2.11, "江西省"]},
            {"name": "吉林省", "value": [719.0, 2.1, "吉林省"]},
            {"name": "山西省", "value": [680.0, 1.98, "山西省"]},
            {"name": "陕西省", "value": [678.0, 1.98, "陕西省"]},
            {"name": "重庆市", "value": [609.0, 1.78, "重庆市"]},
            {"name": "天津市", "value": [539.0, 1.57, "天津市"]},
            {"name": "内蒙古", "value": [538.0, 1.57, "内蒙古"]},
            {"name": "新疆维吾尔自治区", "value": [495.0, 1.44, "新疆维吾尔自治区"]},
            {"name": "贵州省", "value": [418.0, 1.22, "贵州省"]},
            {"name": "甘肃省", "value": [372.0, 1.09, "甘肃省"]},
            {"name": "海南省", "value": [260.0, 0.76, "海南省"]},
            {"name": "青海省", "value": [110.0, 0.32, "青海省"]},
            {"name": "宁夏回族自治区", "value": [104.0, 0.3, "宁夏回族自治区"]},
            {"name": "西藏自治区", "value": [37.0, 0.11, "西藏自治区"]},
        ],
    },
    {
        "time": "1994年",
        "data": [
            {"name": "广东省", "value": [4619.0, 10.17, "广东省"]},
            {"name": "江苏省", "value": [4057.0, 8.93, "江苏省"]},
            {"name": "山东省", "value": [3845.0, 8.47, "山东省"]},
            {"name": "浙江省", "value": [2689.0, 5.92, "浙江省"]},
            {"name": "辽宁省", "value": [2462.0, 5.42, "辽宁省"]},
            {"name": "河南省", "value": [2217.0, 4.88, "河南省"]},
            {"name": "河北省", "value": [2187.0, 4.81, "河北省"]},
            {"name": "四川省", "value": [2001.0, 4.41, "四川省"]},
            {"name": "上海市", "value": [1991.0, 4.38, "上海市"]},
            {"name": "湖北省", "value": [1701.0, 3.74, "湖北省"]},
            {"name": "湖南省", "value": [1650.0, 3.63, "湖南省"]},
            {"name": "福建省", "value": [1644.0, 3.62, "福建省"]},
            {"name": "黑龙江省", "value": [1605.0, 3.53, "黑龙江省"]},
            {"name": "安徽省", "value": [1320.0, 2.91, "安徽省"]},
            {"name": "广西壮族自治区", "value": [1198.0, 2.64, "广西壮族自治区"]},
            {"name": "北京市", "value": [1145.0, 2.52, "北京市"]},
            {"name": "云南省", "value": [984.0, 2.17, "云南省"]},
            {"name": "江西省", "value": [948.0, 2.09, "江西省"]},
            {"name": "吉林省", "value": [938.0, 2.07, "吉林省"]},
            {"name": "陕西省", "value": [839.0, 1.85, "陕西省"]},
            {"name": "重庆市", "value": [834.0, 1.84, "重庆市"]},
            {"name": "山西省", "value": [827.0, 1.82, "山西省"]},
            {"name": "天津市", "value": [733.0, 1.61, "天津市"]},
            {"name": "内蒙古", "value": [695.0, 1.53, "内蒙古"]},
            {"name": "新疆维吾尔自治区", "value": [662.0, 1.46, "新疆维吾尔自治区"]},
            {"name": "贵州省", "value": [524.0, 1.15, "贵州省"]},
            {"name": "甘肃省", "value": [454.0, 1.0, "甘肃省"]},
            {"name": "海南省", "value": [332.0, 0.73, "海南省"]},
            {"name": "青海省", "value": [138.0, 0.3, "青海省"]},
            {"name": "宁夏回族自治区", "value": [136.0, 0.3, "宁夏回族自治区"]},
            {"name": "西藏自治区", "value": [46.0, 0.1, "西藏自治区"]},
        ],
    },
    {
        "time": "1995年",
        "data": [
            {"name": "广东省", "value": [5933.0, 10.29, "广东省"]},
            {"name": "江苏省", "value": [5155.0, 8.94, "江苏省"]},
            {"name": "山东省", "value": [4953.0, 8.59, "山东省"]},
            {"name": "浙江省", "value": [3558.0, 6.17, "浙江省"]},
            {"name": "河南省", "value": [2988.0, 5.18, "河南省"]},
            {"name": "河北省", "value": [2850.0, 4.94, "河北省"]},
            {"name": "辽宁省", "value": [2793.0, 4.85, "辽宁省"]},
            {"name": "上海市", "value": [2499.0, 4.34, "上海市"]},
            {"name": "四川省", "value": [2443.0, 4.24, "四川省"]},
            {"name": "湖南省", "value": [2132.0, 3.7, "湖南省"]},
            {"name": "湖北省", "value": [2109.0, 3.66, "湖北省"]},
            {"name": "福建省", "value": [2095.0, 3.63, "福建省"]},
            {"name": "黑龙江省", "value": [1991.0, 3.45, "黑龙江省"]},
            {"name": "安徽省", "value": [1811.0, 3.14, "安徽省"]},
            {"name": "北京市", "value": [1508.0, 2.62, "北京市"]},
            {"name": "广西壮族自治区", "value": [1498.0, 2.6, "广西壮族自治区"]},
            {"name": "云南省", "value": [1222.0, 2.12, "云南省"]},
            {"name": "江西省", "value": [1170.0, 2.03, "江西省"]},
            {"name": "吉林省", "value": [1137.0, 1.97, "吉林省"]},
            {"name": "重庆市", "value": [1123.0, 1.95, "重庆市"]},
            {"name": "山西省", "value": [1076.0, 1.87, "山西省"]},
            {"name": "陕西省", "value": [1037.0, 1.8, "陕西省"]},
            {"name": "天津市", "value": [932.0, 1.62, "天津市"]},
            {"name": "内蒙古", "value": [857.0, 1.49, "内蒙古"]},
            {"name": "新疆维吾尔自治区", "value": [815.0, 1.41, "新疆维吾尔自治区"]},
            {"name": "贵州省", "value": [636.0, 1.1, "贵州省"]},
            {"name": "甘肃省", "value": [558.0, 0.97, "甘肃省"]},
            {"name": "海南省", "value": [363.0, 0.63, "海南省"]},
            {"name": "宁夏回族自治区", "value": [175.0, 0.3, "宁夏回族自治区"]},
            {"name": "青海省", "value": [168.0, 0.29, "青海省"]},
            {"name": "西藏自治区", "value": [56.0, 0.1, "西藏自治区"]},
        ],
    },
    {
        "time": "1996年",
        "data": [
            {"name": "广东省", "value": [6835.0, 10.07, "广东省"]},
            {"name": "江苏省", "value": [6004.0, 8.84, "江苏省"]},
            {"name": "山东省", "value": [5884.0, 8.67, "山东省"]},
            {"name": "浙江省", "value": [4189.0, 6.17, "浙江省"]},
            {"name": "河南省", "value": [3635.0, 5.35, "河南省"]},
            {"name": "河北省", "value": [3453.0, 5.09, "河北省"]},
            {"name": "辽宁省", "value": [3158.0, 4.65, "辽宁省"]},
            {"name": "上海市", "value": [2958.0, 4.36, "上海市"]},
            {"name": "四川省", "value": [2872.0, 4.23, "四川省"]},
            {"name": "湖南省", "value": [2540.0, 3.74, "湖南省"]},
            {"name": "湖北省", "value": [2500.0, 3.68, "湖北省"]},
            {"name": "福建省", "value": [2484.0, 3.66, "福建省"]},
            {"name": "黑龙江省", "value": [2371.0, 3.49, "黑龙江省"]},
            {"name": "安徽省", "value": [2093.0, 3.08, "安徽省"]},
            {"name": "北京市", "value": [1789.0, 2.63, "北京市"]},
            {"name": "广西壮族自治区", "value": [1698.0, 2.5, "广西壮族自治区"]},
            {"name": "云南省", "value": [1518.0, 2.24, "云南省"]},
            {"name": "江西省", "value": [1410.0, 2.08, "江西省"]},
            {"name": "吉林省", "value": [1347.0, 1.98, "吉林省"]},
            {"name": "重庆市", "value": [1315.0, 1.94, "重庆市"]},
            {"name": "山西省", "value": [1292.0, 1.9, "山西省"]},
            {"name": "陕西省", "value": [1216.0, 1.79, "陕西省"]},
            {"name": "天津市", "value": [1122.0, 1.65, "天津市"]},
            {"name": "内蒙古", "value": [1023.0, 1.51, "内蒙古"]},
            {"name": "新疆维吾尔自治区", "value": [901.0, 1.33, "新疆维吾尔自治区"]},
            {"name": "贵州省", "value": [723.0, 1.06, "贵州省"]},
            {"name": "甘肃省", "value": [723.0, 1.06, "甘肃省"]},
            {"name": "海南省", "value": [390.0, 0.57, "海南省"]},
            {"name": "宁夏回族自治区", "value": [203.0, 0.3, "宁夏回族自治区"]},
            {"name": "青海省", "value": [184.0, 0.27, "青海省"]},
            {"name": "西藏自治区", "value": [65.0, 0.1, "西藏自治区"]},
        ],
    },
    {
        "time": "1997年",
        "data": [
            {"name": "广东省", "value": [7775.0, 10.16, "广东省"]},
            {"name": "江苏省", "value": [6680.0, 8.73, "江苏省"]},
            {"name": "山东省", "value": [6537.0, 8.55, "山东省"]},
            {"name": "浙江省", "value": [4686.0, 6.13, "浙江省"]},
            {"name": "河南省", "value": [4041.0, 5.28, "河南省"]},
            {"name": "河北省", "value": [3954.0, 5.17, "河北省"]},
            {"name": "辽宁省", "value": [3582.0, 4.68, "辽宁省"]},
            {"name": "上海市", "value": [3439.0, 4.5, "上海市"]},
            {"name": "四川省", "value": [3241.0, 4.24, "四川省"]},
            {"name": "福建省", "value": [2871.0, 3.75, "福建省"]},
            {"name": "湖北省", "value": [2856.0, 3.73, "湖北省"]},
            {"name": "湖南省", "value": [2849.0, 3.72, "湖南省"]},
            {"name": "黑龙江省", "value": [2668.0, 3.49, "黑龙江省"]},
            {"name": "安徽省", "value": [2347.0, 3.07, "安徽省"]},
            {"name": "北京市", "value": [2077.0, 2.72, "北京市"]},
            {"name": "广西壮族自治区", "value": [1817.0, 2.38, "广西壮族自治区"]},
            {"name": "云南省", "value": [1676.0, 2.19, "云南省"]},
            {"name": "江西省", "value": [1606.0, 2.1, "江西省"]},
            {"name": "重庆市", "value": [1510.0, 1.97, "重庆市"]},
            {"name": "山西省", "value": [1476.0, 1.93, "山西省"]},
            {"name": "吉林省", "value": [1464.0, 1.91, "吉林省"]},
            {"name": "陕西省", "value": [1364.0, 1.78, "陕西省"]},
            {"name": "天津市", "value": [1265.0, 1.65, "天津市"]},
            {"name": "内蒙古", "value": [1154.0, 1.51, "内蒙古"]},
            {"name": "新疆维吾尔自治区", "value": [1040.0, 1.36, "新疆维吾尔自治区"]},
            {"name": "贵州省", "value": [806.0, 1.05, "贵州省"]},
            {"name": "甘肃省", "value": [794.0, 1.04, "甘肃省"]},
            {"name": "海南省", "value": [411.0, 0.54, "海南省"]},
            {"name": "宁夏回族自治区", "value": [225.0, 0.29, "宁夏回族自治区"]},
            {"name": "青海省", "value": [203.0, 0.27, "青海省"]},
            {"name": "西藏自治区", "value": [77.0, 0.1, "西藏自治区"]},
        ],
    },
    {
        "time": "1998年",
        "data": [
            {"name": "广东省", "value": [8531.0, 10.31, "广东省"]},
            {"name": "江苏省", "value": [7200.0, 8.7, "江苏省"]},
            {"name": "山东省", "value": [7021.0, 8.49, "山东省"]},
            {"name": "浙江省", "value": [5053.0, 6.11, "浙江省"]},
            {"name": "河南省", "value": [4308.0, 5.21, "河南省"]},
            {"name": "河北省", "value": [4256.0, 5.15, "河北省"]},
            {"name": "辽宁省", "value": [3882.0, 4.69, "辽宁省"]},
            {"name": "上海市", "value": [3801.0, 4.59, "上海市"]},
            {"name": "四川省", "value": [3474.0, 4.2, "四川省"]},
            {"name": "福建省", "value": [3160.0, 3.82, "福建省"]},
            {"name": "湖北省", "value": [3114.0, 3.76, "湖北省"]},
            {"name": "湖南省", "value": [3026.0, 3.66, "湖南省"]},
            {"name": "黑龙江省", "value": [2774.0, 3.35, "黑龙江省"]},
            {"name": "安徽省", "value": [2543.0, 3.07, "安徽省"]},
            {"name": "北京市", "value": [2377.0, 2.87, "北京市"]},
            {"name": "广西壮族自治区", "value": [1911.0, 2.31, "广西壮族自治区"]},
            {"name": "云南省", "value": [1831.0, 2.21, "云南省"]},
            {"name": "江西省", "value": [1720.0, 2.08, "江西省"]},
            {"name": "山西省", "value": [1611.0, 1.95, "山西省"]},
            {"name": "重庆市", "value": [1602.0, 1.94, "重庆市"]},
            {"name": "吉林省", "value": [1577.0, 1.91, "吉林省"]},
            {"name": "陕西省", "value": [1458.0, 1.76, "陕西省"]},
            {"name": "天津市", "value": [1375.0, 1.66, "天津市"]},
            {"name": "内蒙古", "value": [1263.0, 1.53, "内蒙古"]},
            {"name": "新疆维吾尔自治区", "value": [1107.0, 1.34, "新疆维吾尔自治区"]},
            {"name": "甘肃省", "value": [888.0, 1.07, "甘肃省"]},
            {"name": "贵州省", "value": [858.0, 1.04, "贵州省"]},
            {"name": "海南省", "value": [442.0, 0.53, "海南省"]},
            {"name": "宁夏回族自治区", "value": [245.0, 0.3, "宁夏回族自治区"]},
            {"name": "青海省", "value": [221.0, 0.27, "青海省"]},
            {"name": "西藏自治区", "value": [92.0, 0.11, "西藏自治区"]},
        ],
    },
    {
        "time": "1999年",
        "data": [
            {"name": "广东省", "value": [9251.0, 10.47, "广东省"]},
            {"name": "江苏省", "value": [7698.0, 8.71, "江苏省"]},
            {"name": "山东省", "value": [7494.0, 8.48, "山东省"]},
            {"name": "浙江省", "value": [5444.0, 6.16, "浙江省"]},
            {"name": "河南省", "value": [4518.0, 5.11, "河南省"]},
            {"name": "河北省", "value": [4514.0, 5.11, "河北省"]},
            {"name": "上海市", "value": [4189.0, 4.74, "上海市"]},
            {"name": "辽宁省", "value": [4172.0, 4.72, "辽宁省"]},
            {"name": "四川省", "value": [3649.0, 4.13, "四川省"]},
            {"name": "福建省", "value": [3414.0, 3.86, "福建省"]},
            {"name": "湖北省", "value": [3229.0, 3.65, "湖北省"]},
            {"name": "湖南省", "value": [3215.0, 3.64, "湖南省"]},
            {"name": "黑龙江省", "value": [2866.0, 3.24, "黑龙江省"]},
            {"name": "安徽省", "value": [2712.0, 3.07, "安徽省"]},
            {"name": "北京市", "value": [2679.0, 3.03, "北京市"]},
            {"name": "广西壮族自治区", "value": [1971.0, 2.23, "广西壮族自治区"]},
            {"name": "云南省", "value": [1900.0, 2.15, "云南省"]},
            {"name": "江西省", "value": [1854.0, 2.1, "江西省"]},
            {"name": "吉林省", "value": [1673.0, 1.89, "吉林省"]},
            {"name": "山西省", "value": [1667.0, 1.89, "山西省"]},
            {"name": "重庆市", "value": [1663.0, 1.88, "重庆市"]},
            {"name": "陕西省", "value": [1593.0, 1.8, "陕西省"]},
            {"name": "天津市", "value": [1501.0, 1.7, "天津市"]},
            {"name": "内蒙古", "value": [1379.0, 1.56, "内蒙古"]},
            {"name": "新疆维吾尔自治区", "value": [1163.0, 1.32, "新疆维吾尔自治区"]},
            {"name": "甘肃省", "value": [956.0, 1.08, "甘肃省"]},
            {"name": "贵州省", "value": [938.0, 1.06, "贵州省"]},
            {"name": "海南省", "value": [477.0, 0.54, "海南省"]},
            {"name": "宁夏回族自治区", "value": [265.0, 0.3, "宁夏回族自治区"]},
            {"name": "青海省", "value": [239.0, 0.27, "青海省"]},
            {"name": "西藏自治区", "value": [106.0, 0.12, "西藏自治区"]},
        ],
    },
    {
        "time": "2000年",
        "data": [
            {"name": "广东省", "value": [10741.0, 10.88, "广东省"]},
            {"name": "江苏省", "value": [8554.0, 8.67, "江苏省"]},
            {"name": "山东省", "value": [8337.0, 8.45, "山东省"]},
            {"name": "浙江省", "value": [6141.0, 6.22, "浙江省"]},
            {"name": "河南省", "value": [5053.0, 5.12, "河南省"]},
            {"name": "河北省", "value": [5044.0, 5.11, "河北省"]},
            {"name": "上海市", "value": [4771.0, 4.83, "上海市"]},
            {"name": "辽宁省", "value": [4669.0, 4.73, "辽宁省"]},
            {"name": "四川省", "value": [3928.0, 3.98, "四川省"]},
            {"name": "福建省", "value": [3765.0, 3.81, "福建省"]},
            {"name": "湖南省", "value": [3551.0, 3.6, "湖南省"]},
            {"name": "湖北省", "value": [3545.0, 3.59, "湖北省"]},
            {"name": "北京市", "value": [3162.0, 3.2, "北京市"]},
            {"name": "黑龙江省", "value": [3151.0, 3.19, "黑龙江省"]},
            {"name": "安徽省", "value": [2902.0, 2.94, "安徽省"]},
            {"name": "广西壮族自治区", "value": [2080.0, 2.11, "广西壮族自治区"]},
            {"name": "云南省", "value": [2011.0, 2.04, "云南省"]},
            {"name": "江西省", "value": [2003.0, 2.03, "江西省"]},
            {"name": "吉林省", "value": [1952.0, 1.98, "吉林省"]},
            {"name": "山西省", "value": [1846.0, 1.87, "山西省"]},
            {"name": "陕西省", "value": [1804.0, 1.83, "陕西省"]},
            {"name": "重庆市", "value": [1791.0, 1.81, "重庆市"]},
            {"name": "天津市", "value": [1702.0, 1.72, "天津市"]},
            {"name": "内蒙古", "value": [1539.0, 1.56, "内蒙古"]},
            {"name": "新疆维吾尔自治区", "value": [1364.0, 1.38, "新疆维吾尔自治区"]},
            {"name": "甘肃省", "value": [1053.0, 1.07, "甘肃省"]},
            {"name": "贵州省", "value": [1030.0, 1.04, "贵州省"]},
            {"name": "海南省", "value": [527.0, 0.53, "海南省"]},
            {"name": "宁夏回族自治区", "value": [295.0, 0.3, "宁夏回族自治区"]},
            {"name": "青海省", "value": [264.0, 0.27, "青海省"]},
            {"name": "西藏自治区", "value": [118.0, 0.12, "西藏自治区"]},
        ],
    },
    {
        "time": "2001年",
        "data": [
            {"name": "广东省", "value": [12039.0, 11.07, "广东省"]},
            {"name": "江苏省", "value": [9457.0, 8.69, "江苏省"]},
            {"name": "山东省", "value": [9195.0, 8.45, "山东省"]},
            {"name": "浙江省", "value": [6898.0, 6.34, "浙江省"]},
            {"name": "河南省", "value": [5533.0, 5.09, "河南省"]},
            {"name": "河北省", "value": [5517.0, 5.07, "河北省"]},
            {"name": "上海市", "value": [5210.0, 4.79, "上海市"]},
            {"name": "辽宁省", "value": [5033.0, 4.63, "辽宁省"]},
            {"name": "四川省", "value": [4293.0, 3.95, "四川省"]},
            {"name": "福建省", "value": [4073.0, 3.74, "福建省"]},
            {"name": "湖北省", "value": [3881.0, 3.57, "湖北省"]},
            {"name": "湖南省", "value": [3832.0, 3.52, "湖南省"]},
            {"name": "北京市", "value": [3708.0, 3.41, "北京市"]},
            {"name": "黑龙江省", "value": [3390.0, 3.12, "黑龙江省"]},
            {"name": "安徽省", "value": [3247.0, 2.99, "安徽省"]},
            {"name": "广西壮族自治区", "value": [2279.0, 2.1, "广西壮族自治区"]},
            {"name": "江西省", "value": [2176.0, 2.0, "江西省"]},
            {"name": "云南省", "value": [2138.0, 1.97, "云南省"]},
            {"name": "吉林省", "value": [2120.0, 1.95, "吉林省"]},
            {"name": "山西省", "value": [2030.0, 1.87, "山西省"]},
            {"name": "陕西省", "value": [2011.0, 1.85, "陕西省"]},
            {"name": "重庆市", "value": [1977.0, 1.82, "重庆市"]},
            {"name": "天津市", "value": [1919.0, 1.76, "天津市"]},
            {"name": "内蒙古", "value": [1714.0, 1.58, "内蒙古"]},
            {"name": "新疆维吾尔自治区", "value": [1492.0, 1.37, "新疆维吾尔自治区"]},
            {"name": "贵州省", "value": [1133.0, 1.04, "贵州省"]},
            {"name": "甘肃省", "value": [1125.0, 1.03, "甘肃省"]},
            {"name": "海南省", "value": [579.0, 0.53, "海南省"]},
            {"name": "宁夏回族自治区", "value": [337.0, 0.31, "宁夏回族自治区"]},
            {"name": "青海省", "value": [300.0, 0.28, "青海省"]},
            {"name": "西藏自治区", "value": [139.0, 0.13, "西藏自治区"]},
        ],
    },
    {
        "time": "2002年",
        "data": [
            {"name": "广东省", "value": [13502.0, 11.18, "广东省"]},
            {"name": "江苏省", "value": [10607.0, 8.78, "江苏省"]},
            {"name": "山东省", "value": [10276.0, 8.51, "山东省"]},
            {"name": "浙江省", "value": [8004.0, 6.62, "浙江省"]},
            {"name": "河南省", "value": [6035.0, 4.99, "河南省"]},
            {"name": "河北省", "value": [6018.0, 4.98, "河北省"]},
            {"name": "上海市", "value": [5741.0, 4.75, "上海市"]},
            {"name": "辽宁省", "value": [5458.0, 4.52, "辽宁省"]},
            {"name": "四川省", "value": [4725.0, 3.91, "四川省"]},
            {"name": "福建省", "value": [4468.0, 3.7, "福建省"]},
            {"name": "北京市", "value": [4315.0, 3.57, "北京市"]},
            {"name": "湖北省", "value": [4213.0, 3.49, "湖北省"]},
            {"name": "湖南省", "value": [4152.0, 3.44, "湖南省"]},
            {"name": "黑龙江省", "value": [3637.0, 3.01, "黑龙江省"]},
            {"name": "安徽省", "value": [3520.0, 2.91, "安徽省"]},
            {"name": "广西壮族自治区", "value": [2524.0, 2.09, "广西壮族自治区"]},
            {"name": "江西省", "value": [2450.0, 2.03, "江西省"]},
            {"name": "吉林省", "value": [2349.0, 1.94, "吉林省"]},
            {"name": "山西省", "value": [2325.0, 1.92, "山西省"]},
            {"name": "云南省", "value": [2313.0, 1.91, "云南省"]},
            {"name": "陕西省", "value": [2253.0, 1.86, "陕西省"]},
            {"name": "重庆市", "value": [2233.0, 1.85, "重庆市"]},
            {"name": "天津市", "value": [2151.0, 1.78, "天津市"]},
            {"name": "内蒙古", "value": [1941.0, 1.61, "内蒙古"]},
            {"name": "新疆维吾尔自治区", "value": [1613.0, 1.34, "新疆维吾尔自治区"]},
            {"name": "贵州省", "value": [1243.0, 1.03, "贵州省"]},
            {"name": "甘肃省", "value": [1232.0, 1.02, "甘肃省"]},
            {"name": "海南省", "value": [643.0, 0.53, "海南省"]},
            {"name": "宁夏回族自治区", "value": [377.0, 0.31, "宁夏回族自治区"]},
            {"name": "青海省", "value": [341.0, 0.28, "青海省"]},
            {"name": "西藏自治区", "value": [162.0, 0.13, "西藏自治区"]},
        ],
    },
    {
        "time": "2003年",
        "data": [
            {"name": "广东省", "value": [15845.0, 11.36, "广东省"]},
            {"name": "江苏省", "value": [12443.0, 8.92, "江苏省"]},
            {"name": "山东省", "value": [12078.0, 8.66, "山东省"]},
            {"name": "浙江省", "value": [9705.0, 6.96, "浙江省"]},
            {"name": "河北省", "value": [6921.0, 4.96, "河北省"]},
            {"name": "河南省", "value": [6868.0, 4.92, "河南省"]},
            {"name": "上海市", "value": [6694.0, 4.8, "上海市"]},
            {"name": "辽宁省", "value": [6003.0, 4.3, "辽宁省"]},
            {"name": "四川省", "value": [5333.0, 3.82, "四川省"]},
            {"name": "北京市", "value": [5007.0, 3.59, "北京市"]},
            {"name": "福建省", "value": [4984.0, 3.57, "福建省"]},
            {"name": "湖北省", "value": [4757.0, 3.41, "湖北省"]},
            {"name": "湖南省", "value": [4660.0, 3.34, "湖南省"]},
            {"name": "黑龙江省", "value": [4057.0, 2.91, "黑龙江省"]},
            {"name": "安徽省", "value": [3923.0, 2.81, "安徽省"]},
            {"name": "山西省", "value": [2855.0, 2.05, "山西省"]},
            {"name": "广西壮族自治区", "value": [2821.0, 2.02, "广西壮族自治区"]},
            {"name": "江西省", "value": [2807.0, 2.01, "江西省"]},
            {"name": "吉林省", "value": [2662.0, 1.91, "吉林省"]},
            {"name": "陕西省", "value": [2588.0, 1.85, "陕西省"]},
            {"name": "天津市", "value": [2578.0, 1.85, "天津市"]},
            {"name": "云南省", "value": [2556.0, 1.83, "云南省"]},
            {"name": "重庆市", "value": [2556.0, 1.83, "重庆市"]},
            {"name": "内蒙古", "value": [2388.0, 1.71, "内蒙古"]},
            {"name": "新疆维吾尔自治区", "value": [1886.0, 1.35, "新疆维吾尔自治区"]},
            {"name": "贵州省", "value": [1426.0, 1.02, "贵州省"]},
            {"name": "甘肃省", "value": [1400.0, 1.0, "甘肃省"]},
            {"name": "海南省", "value": [714.0, 0.51, "海南省"]},
            {"name": "宁夏回族自治区", "value": [445.0, 0.32, "宁夏回族自治区"]},
            {"name": "青海省", "value": [390.0, 0.28, "青海省"]},
            {"name": "西藏自治区", "value": [185.0, 0.13, "西藏自治区"]},
        ],
    },
    {
        "time": "2004年",
        "data": [
            {"name": "广东省", "value": [18865.0, 11.23, "广东省"]},
            {"name": "山东省", "value": [15022.0, 8.95, "山东省"]},
            {"name": "江苏省", "value": [15004.0, 8.93, "江苏省"]},
            {"name": "浙江省", "value": [11649.0, 6.94, "浙江省"]},
            {"name": "河南省", "value": [8554.0, 5.09, "河南省"]},
            {"name": "河北省", "value": [8478.0, 5.05, "河北省"]},
            {"name": "上海市", "value": [8073.0, 4.81, "上海市"]},
            {"name": "辽宁省", "value": [6672.0, 3.97, "辽宁省"]},
            {"name": "四川省", "value": [6380.0, 3.8, "四川省"]},
            {"name": "北京市", "value": [6033.0, 3.59, "北京市"]},
            {"name": "福建省", "value": [5763.0, 3.43, "福建省"]},
            {"name": "湖南省", "value": [5642.0, 3.36, "湖南省"]},
            {"name": "湖北省", "value": [5633.0, 3.35, "湖北省"]},
            {"name": "安徽省", "value": [4759.0, 2.83, "安徽省"]},
            {"name": "黑龙江省", "value": [4751.0, 2.83, "黑龙江省"]},
            {"name": "山西省", "value": [3571.0, 2.13, "山西省"]},
            {"name": "江西省", "value": [3457.0, 2.06, "江西省"]},
            {"name": "广西壮族自治区", "value": [3434.0, 2.04, "广西壮族自治区"]},
            {"name": "陕西省", "value": [3176.0, 1.89, "陕西省"]},
            {"name": "吉林省", "value": [3122.0, 1.86, "吉林省"]},
            {"name": "天津市", "value": [3111.0, 1.85, "天津市"]},
            {"name": "云南省", "value": [3082.0, 1.84, "云南省"]},
            {"name": "内蒙古", "value": [3041.0, 1.81, "内蒙古"]},
            {"name": "重庆市", "value": [3035.0, 1.81, "重庆市"]},
            {"name": "新疆维吾尔自治区", "value": [2209.0, 1.32, "新疆维吾尔自治区"]},
            {"name": "甘肃省", "value": [1688.0, 1.01, "甘肃省"]},
            {"name": "贵州省", "value": [1678.0, 1.0, "贵州省"]},
            {"name": "海南省", "value": [820.0, 0.49, "海南省"]},
            {"name": "宁夏回族自治区", "value": [537.0, 0.32, "宁夏回族自治区"]},
            {"name": "青海省", "value": [466.0, 0.28, "青海省"]},
            {"name": "西藏自治区", "value": [220.0, 0.13, "西藏自治区"]},
        ],
    },
    {
        "time": "2005年",
        "data": [
            {"name": "广东省", "value": [22557.0, 11.32, "广东省"]},
            {"name": "江苏省", "value": [18599.0, 9.34, "江苏省"]},
            {"name": "山东省", "value": [18367.0, 9.22, "山东省"]},
            {"name": "浙江省", "value": [13418.0, 6.73, "浙江省"]},
            {"name": "河南省", "value": [10587.0, 5.31, "河南省"]},
            {"name": "河北省", "value": [10012.0, 5.03, "河北省"]},
            {"name": "上海市", "value": [9248.0, 4.64, "上海市"]},
            {"name": "辽宁省", "value": [8047.0, 4.04, "辽宁省"]},
            {"name": "四川省", "value": [7385.0, 3.71, "四川省"]},
            {"name": "北京市", "value": [6970.0, 3.5, "北京市"]},
            {"name": "湖南省", "value": [6596.0, 3.31, "湖南省"]},
            {"name": "湖北省", "value": [6590.0, 3.31, "湖北省"]},
            {"name": "福建省", "value": [6555.0, 3.29, "福建省"]},
            {"name": "黑龙江省", "value": [5514.0, 2.77, "黑龙江省"]},
            {"name": "安徽省", "value": [5350.0, 2.69, "安徽省"]},
            {"name": "山西省", "value": [4231.0, 2.12, "山西省"]},
            {"name": "江西省", "value": [4057.0, 2.04, "江西省"]},
            {"name": "广西壮族自治区", "value": [3984.0, 2.0, "广西壮族自治区"]},
            {"name": "陕西省", "value": [3934.0, 1.97, "陕西省"]},
            {"name": "天津市", "value": [3906.0, 1.96, "天津市"]},
            {"name": "内蒙古", "value": [3905.0, 1.96, "内蒙古"]},
            {"name": "吉林省", "value": [3620.0, 1.82, "吉林省"]},
            {"name": "重庆市", "value": [3468.0, 1.74, "重庆市"]},
            {"name": "云南省", "value": [3463.0, 1.74, "云南省"]},
            {"name": "新疆维吾尔自治区", "value": [2604.0, 1.31, "新疆维吾尔自治区"]},
            {"name": "贵州省", "value": [2005.0, 1.01, "贵州省"]},
            {"name": "甘肃省", "value": [1934.0, 0.97, "甘肃省"]},
            {"name": "海南省", "value": [919.0, 0.46, "海南省"]},
            {"name": "宁夏回族自治区", "value": [613.0, 0.31, "宁夏回族自治区"]},
            {"name": "青海省", "value": [543.0, 0.27, "青海省"]},
            {"name": "西藏自治区", "value": [249.0, 0.12, "西藏自治区"]},
        ],
    },
    {
        "time": "2006年",
        "data": [
            {"name": "广东省", "value": [26588.0, 11.42, "广东省"]},
            {"name": "山东省", "value": [21900.0, 9.41, "山东省"]},
            {"name": "江苏省", "value": [21742.0, 9.34, "江苏省"]},
            {"name": "浙江省", "value": [15718.0, 6.75, "浙江省"]},
            {"name": "河南省", "value": [12363.0, 5.31, "河南省"]},
            {"name": "河北省", "value": [11468.0, 4.93, "河北省"]},
            {"name": "上海市", "value": [10572.0, 4.54, "上海市"]},
            {"name": "辽宁省", "value": [9305.0, 4.0, "辽宁省"]},
            {"name": "四川省", "value": [8690.0, 3.73, "四川省"]},
            {"name": "北京市", "value": [8118.0, 3.49, "北京市"]},
            {"name": "湖南省", "value": [7689.0, 3.3, "湖南省"]},
            {"name": "湖北省", "value": [7617.0, 3.27, "湖北省"]},
            {"name": "福建省", "value": [7584.0, 3.26, "福建省"]},
            {"name": "黑龙江省", "value": [6212.0, 2.67, "黑龙江省"]},
            {"name": "安徽省", "value": [6113.0, 2.63, "安徽省"]},
            {"name": "内蒙古", "value": [4944.0, 2.12, "内蒙古"]},
            {"name": "山西省", "value": [4879.0, 2.1, "山西省"]},
            {"name": "江西省", "value": [4821.0, 2.07, "江西省"]},
            {"name": "广西壮族自治区", "value": [4746.0, 2.04, "广西壮族自治区"]},
            {"name": "陕西省", "value": [4744.0, 2.04, "陕西省"]},
            {"name": "天津市", "value": [4463.0, 1.92, "天津市"]},
            {"name": "吉林省", "value": [4275.0, 1.84, "吉林省"]},
            {"name": "云南省", "value": [3988.0, 1.71, "云南省"]},
            {"name": "重庆市", "value": [3907.0, 1.68, "重庆市"]},
            {"name": "新疆维吾尔自治区", "value": [3045.0, 1.31, "新疆维吾尔自治区"]},
            {"name": "贵州省", "value": [2339.0, 1.0, "贵州省"]},
            {"name": "甘肃省", "value": [2277.0, 0.98, "甘肃省"]},
            {"name": "海南省", "value": [1066.0, 0.46, "海南省"]},
            {"name": "宁夏回族自治区", "value": [726.0, 0.31, "宁夏回族自治区"]},
            {"name": "青海省", "value": [649.0, 0.28, "青海省"]},
            {"name": "西藏自治区", "value": [291.0, 0.12, "西藏自治区"]},
        ],
    },
    {
        "time": "2007年",
        "data": [
            {"name": "广东省", "value": [31777.0, 11.36, "广东省"]},
            {"name": "江苏省", "value": [26018.0, 9.3, "江苏省"]},
            {"name": "山东省", "value": [25777.0, 9.21, "山东省"]},
            {"name": "浙江省", "value": [18754.0, 6.7, "浙江省"]},
            {"name": "河南省", "value": [15012.0, 5.37, "河南省"]},
            {"name": "河北省", "value": [13607.0, 4.86, "河北省"]},
            {"name": "上海市", "value": [12494.0, 4.47, "上海市"]},
            {"name": "辽宁省", "value": [11164.0, 3.99, "辽宁省"]},
            {"name": "四川省", "value": [10562.0, 3.78, "四川省"]},
            {"name": "北京市", "value": [9847.0, 3.52, "北京市"]},
            {"name": "湖南省", "value": [9440.0, 3.37, "湖南省"]},
            {"name": "湖北省", "value": [9333.0, 3.34, "湖北省"]},
            {"name": "福建省", "value": [9249.0, 3.31, "福建省"]},
            {"name": "安徽省", "value": [7361.0, 2.63, "安徽省"]},
            {"name": "黑龙江省", "value": [7104.0, 2.54, "黑龙江省"]},
            {"name": "内蒙古", "value": [6423.0, 2.3, "内蒙古"]},
            {"name": "山西省", "value": [6024.0, 2.15, "山西省"]},
            {"name": "广西壮族自治区", "value": [5823.0, 2.08, "广西壮族自治区"]},
            {"name": "江西省", "value": [5800.0, 2.07, "江西省"]},
            {"name": "陕西省", "value": [5757.0, 2.06, "陕西省"]},
            {"name": "吉林省", "value": [5285.0, 1.89, "吉林省"]},
            {"name": "天津市", "value": [5253.0, 1.88, "天津市"]},
            {"name": "云南省", "value": [4773.0, 1.71, "云南省"]},
            {"name": "重庆市", "value": [4676.0, 1.67, "重庆市"]},
            {"name": "新疆维吾尔自治区", "value": [3523.0, 1.26, "新疆维吾尔自治区"]},
            {"name": "贵州省", "value": [2884.0, 1.03, "贵州省"]},
            {"name": "甘肃省", "value": [2704.0, 0.97, "甘肃省"]},
            {"name": "海南省", "value": [1254.0, 0.45, "海南省"]},
            {"name": "宁夏回族自治区", "value": [919.0, 0.33, "宁夏回族自治区"]},
            {"name": "青海省", "value": [797.0, 0.28, "青海省"]},
            {"name": "西藏自治区", "value": [341.0, 0.12, "西藏自治区"]},
        ],
    },
    {
        "time": "2008年",
        "data": [
            {"name": "广东省", "value": [36797.0, 11.04, "广东省"]},
            {"name": "江苏省", "value": [30982.0, 9.3, "江苏省"]},
            {"name": "山东省", "value": [30933.0, 9.28, "山东省"]},
            {"name": "浙江省", "value": [21463.0, 6.44, "浙江省"]},
            {"name": "河南省", "value": [18019.0, 5.41, "河南省"]},
            {"name": "河北省", "value": [16012.0, 4.8, "河北省"]},
            {"name": "上海市", "value": [14070.0, 4.22, "上海市"]},
            {"name": "辽宁省", "value": [13669.0, 4.1, "辽宁省"]},
            {"name": "四川省", "value": [12601.0, 3.78, "四川省"]},
            {"name": "湖南省", "value": [11555.0, 3.47, "湖南省"]},
            {"name": "湖北省", "value": [11329.0, 3.4, "湖北省"]},
            {"name": "北京市", "value": [11115.0, 3.33, "北京市"]},
            {"name": "福建省", "value": [10823.0, 3.25, "福建省"]},
            {"name": "安徽省", "value": [8852.0, 2.66, "安徽省"]},
            {"name": "内蒙古", "value": [8496.0, 2.55, "内蒙古"]},
            {"name": "黑龙江省", "value": [8314.0, 2.49, "黑龙江省"]},
            {"name": "山西省", "value": [7315.0, 2.19, "山西省"]},
            {"name": "陕西省", "value": [7315.0, 2.19, "陕西省"]},
            {"name": "广西壮族自治区", "value": [7021.0, 2.11, "广西壮族自治区"]},
            {"name": "江西省", "value": [6971.0, 2.09, "江西省"]},
            {"name": "天津市", "value": [6719.0, 2.02, "天津市"]},
            {"name": "吉林省", "value": [6426.0, 1.93, "吉林省"]},
            {"name": "重庆市", "value": [5794.0, 1.74, "重庆市"]},
            {"name": "云南省", "value": [5692.0, 1.71, "云南省"]},
            {"name": "新疆维吾尔自治区", "value": [4183.0, 1.25, "新疆维吾尔自治区"]},
            {"name": "贵州省", "value": [3562.0, 1.07, "贵州省"]},
            {"name": "甘肃省", "value": [3167.0, 0.95, "甘肃省"]},
            {"name": "海南省", "value": [1503.0, 0.45, "海南省"]},
            {"name": "宁夏回族自治区", "value": [1204.0, 0.36, "宁夏回族自治区"]},
            {"name": "青海省", "value": [1019.0, 0.31, "青海省"]},
            {"name": "西藏自治区", "value": [395.0, 0.12, "西藏自治区"]},
        ],
    },
    {
        "time": "2009年",
        "data": [
            {"name": "广东省", "value": [39483.0, 10.81, "广东省"]},
            {"name": "江苏省", "value": [34457.0, 9.43, "江苏省"]},
            {"name": "山东省", "value": [33897.0, 9.28, "山东省"]},
            {"name": "浙江省", "value": [22990.0, 6.29, "浙江省"]},
            {"name": "河南省", "value": [19480.0, 5.33, "河南省"]},
            {"name": "河北省", "value": [17235.0, 4.72, "河北省"]},
            {"name": "辽宁省", "value": [15212.0, 4.16, "辽宁省"]},
            {"name": "上海市", "value": [15046.0, 4.12, "上海市"]},
            {"name": "四川省", "value": [14151.0, 3.87, "四川省"]},
            {"name": "湖南省", "value": [13060.0, 3.58, "湖南省"]},
            {"name": "湖北省", "value": [12961.0, 3.55, "湖北省"]},
            {"name": "福建省", "value": [12237.0, 3.35, "福建省"]},
            {"name": "北京市", "value": [12153.0, 3.33, "北京市"]},
            {"name": "安徽省", "value": [10063.0, 2.75, "安徽省"]},
            {"name": "内蒙古", "value": [9740.0, 2.67, "内蒙古"]},
            {"name": "黑龙江省", "value": [8587.0, 2.35, "黑龙江省"]},
            {"name": "陕西省", "value": [8170.0, 2.24, "陕西省"]},
            {"name": "广西壮族自治区", "value": [7759.0, 2.12, "广西壮族自治区"]},
            {"name": "江西省", "value": [7655.0, 2.1, "江西省"]},
            {"name": "天津市", "value": [7522.0, 2.06, "天津市"]},
            {"name": "山西省", "value": [7358.0, 2.01, "山西省"]},
            {"name": "吉林省", "value": [7279.0, 1.99, "吉林省"]},
            {"name": "重庆市", "value": [6530.0, 1.79, "重庆市"]},
            {"name": "云南省", "value": [6170.0, 1.69, "云南省"]},
            {"name": "新疆维吾尔自治区", "value": [4277.0, 1.17, "新疆维吾尔自治区"]},
            {"name": "贵州省", "value": [3913.0, 1.07, "贵州省"]},
            {"name": "甘肃省", "value": [3388.0, 0.93, "甘肃省"]},
            {"name": "海南省", "value": [1654.0, 0.45, "海南省"]},
            {"name": "宁夏回族自治区", "value": [1353.0, 0.37, "宁夏回族自治区"]},
            {"name": "青海省", "value": [1081.0, 0.3, "青海省"]},
            {"name": "西藏自治区", "value": [441.0, 0.12, "西藏自治区"]},
        ],
    },
    {
        "time": "2010年",
        "data": [
            {"name": "广东省", "value": [46013.0, 10.53, "广东省"]},
            {"name": "江苏省", "value": [41425.0, 9.48, "江苏省"]},
            {"name": "山东省", "value": [39170.0, 8.96, "山东省"]},
            {"name": "浙江省", "value": [27722.0, 6.34, "浙江省"]},
            {"name": "河南省", "value": [23092.0, 5.28, "河南省"]},
            {"name": "河北省", "value": [20394.0, 4.67, "河北省"]},
            {"name": "辽宁省", "value": [18457.0, 4.22, "辽宁省"]},
            {"name": "四川省", "value": [17185.0, 3.93, "四川省"]},
            {"name": "上海市", "value": [17166.0, 3.93, "上海市"]},
            {"name": "湖南省", "value": [16038.0, 3.67, "湖南省"]},
            {"name": "湖北省", "value": [15968.0, 3.65, "湖北省"]},
            {"name": "福建省", "value": [14737.0, 3.37, "福建省"]},
            {"name": "北京市", "value": [14114.0, 3.23, "北京市"]},
            {"name": "安徽省", "value": [12359.0, 2.83, "安徽省"]},
            {"name": "内蒙古", "value": [11672.0, 2.67, "内蒙古"]},
            {"name": "黑龙江省", "value": [10369.0, 2.37, "黑龙江省"]},
            {"name": "陕西省", "value": [10123.0, 2.32, "陕西省"]},
            {"name": "广西壮族自治区", "value": [9570.0, 2.19, "广西壮族自治区"]},
            {"name": "江西省", "value": [9451.0, 2.16, "江西省"]},
            {"name": "天津市", "value": [9224.0, 2.11, "天津市"]},
            {"name": "山西省", "value": [9201.0, 2.11, "山西省"]},
            {"name": "吉林省", "value": [8668.0, 1.98, "吉林省"]},
            {"name": "重庆市", "value": [7926.0, 1.81, "重庆市"]},
            {"name": "云南省", "value": [7224.0, 1.65, "云南省"]},
            {"name": "新疆维吾尔自治区", "value": [5437.0, 1.24, "新疆维吾尔自治区"]},
            {"name": "贵州省", "value": [4602.0, 1.05, "贵州省"]},
            {"name": "甘肃省", "value": [4121.0, 0.94, "甘肃省"]},
            {"name": "海南省", "value": [2065.0, 0.47, "海南省"]},
            {"name": "宁夏回族自治区", "value": [1690.0, 0.39, "宁夏回族自治区"]},
            {"name": "青海省", "value": [1350.0, 0.31, "青海省"]},
            {"name": "西藏自治区", "value": [507.0, 0.12, "西藏自治区"]},
        ],
    },
    {
        "time": "2011年",
        "data": [
            {"name": "广东省", "value": [53210.0, 10.2, "广东省"]},
            {"name": "江苏省", "value": [49110.0, 9.42, "江苏省"]},
            {"name": "山东省", "value": [45362.0, 8.7, "山东省"]},
            {"name": "浙江省", "value": [32319.0, 6.2, "浙江省"]},
            {"name": "河南省", "value": [26931.0, 5.16, "河南省"]},
            {"name": "河北省", "value": [24516.0, 4.7, "河北省"]},
            {"name": "辽宁省", "value": [22227.0, 4.26, "辽宁省"]},
            {"name": "四川省", "value": [21027.0, 4.03, "四川省"]},
            {"name": "湖南省", "value": [19670.0, 3.77, "湖南省"]},
            {"name": "湖北省", "value": [19632.0, 3.76, "湖北省"]},
            {"name": "上海市", "value": [19196.0, 3.68, "上海市"]},
            {"name": "福建省", "value": [17560.0, 3.37, "福建省"]},
            {"name": "北京市", "value": [16252.0, 3.12, "北京市"]},
            {"name": "安徽省", "value": [15301.0, 2.93, "安徽省"]},
            {"name": "内蒙古", "value": [14360.0, 2.75, "内蒙古"]},
            {"name": "黑龙江省", "value": [12582.0, 2.41, "黑龙江省"]},
            {"name": "陕西省", "value": [12512.0, 2.4, "陕西省"]},
            {"name": "广西壮族自治区", "value": [11721.0, 2.25, "广西壮族自治区"]},
            {"name": "江西省", "value": [11703.0, 2.24, "江西省"]},
            {"name": "天津市", "value": [11307.0, 2.17, "天津市"]},
            {"name": "山西省", "value": [11238.0, 2.16, "山西省"]},
            {"name": "吉林省", "value": [10569.0, 2.03, "吉林省"]},
            {"name": "重庆市", "value": [10011.0, 1.92, "重庆市"]},
            {"name": "云南省", "value": [8893.0, 1.71, "云南省"]},
            {"name": "新疆维吾尔自治区", "value": [6610.0, 1.27, "新疆维吾尔自治区"]},
            {"name": "贵州省", "value": [5702.0, 1.09, "贵州省"]},
            {"name": "甘肃省", "value": [5020.0, 0.96, "甘肃省"]},
            {"name": "海南省", "value": [2523.0, 0.48, "海南省"]},
            {"name": "宁夏回族自治区", "value": [2102.0, 0.4, "宁夏回族自治区"]},
            {"name": "青海省", "value": [1670.0, 0.32, "青海省"]},
            {"name": "西藏自治区", "value": [606.0, 0.12, "西藏自治区"]},
        ],
    },
    {
        "time": "2012年",
        "data": [
            {"name": "广东省", "value": [57068.0, 9.9, "广东省"]},
            {"name": "江苏省", "value": [54058.0, 9.38, "江苏省"]},
            {"name": "山东省", "value": [50013.0, 8.67, "山东省"]},
            {"name": "浙江省", "value": [34665.0, 6.01, "浙江省"]},
            {"name": "河南省", "value": [29599.0, 5.13, "河南省"]},
            {"name": "河北省", "value": [26575.0, 4.61, "河北省"]},
            {"name": "辽宁省", "value": [24846.0, 4.31, "辽宁省"]},
            {"name": "四川省", "value": [23873.0, 4.14, "四川省"]},
            {"name": "湖北省", "value": [22250.0, 3.86, "湖北省"]},
            {"name": "湖南省", "value": [22154.0, 3.84, "湖南省"]},
            {"name": "上海市", "value": [20182.0, 3.5, "上海市"]},
            {"name": "福建省", "value": [19702.0, 3.42, "福建省"]},
            {"name": "北京市", "value": [17879.0, 3.1, "北京市"]},
            {"name": "安徽省", "value": [17212.0, 2.99, "安徽省"]},
            {"name": "内蒙古", "value": [15881.0, 2.75, "内蒙古"]},
            {"name": "陕西省", "value": [14454.0, 2.51, "陕西省"]},
            {"name": "黑龙江省", "value": [13692.0, 2.37, "黑龙江省"]},
            {"name": "广西壮族自治区", "value": [13035.0, 2.26, "广西壮族自治区"]},
            {"name": "江西省", "value": [12949.0, 2.25, "江西省"]},
            {"name": "天津市", "value": [12894.0, 2.24, "天津市"]},
            {"name": "山西省", "value": [12113.0, 2.1, "山西省"]},
            {"name": "吉林省", "value": [11939.0, 2.07, "吉林省"]},
            {"name": "重庆市", "value": [11410.0, 1.98, "重庆市"]},
            {"name": "云南省", "value": [10309.0, 1.79, "云南省"]},
            {"name": "新疆维吾尔自治区", "value": [7505.0, 1.3, "新疆维吾尔自治区"]},
            {"name": "贵州省", "value": [6852.0, 1.19, "贵州省"]},
            {"name": "甘肃省", "value": [5650.0, 0.98, "甘肃省"]},
            {"name": "海南省", "value": [2856.0, 0.5, "海南省"]},
            {"name": "宁夏回族自治区", "value": [2341.0, 0.41, "宁夏回族自治区"]},
            {"name": "青海省", "value": [1894.0, 0.33, "青海省"]},
            {"name": "西藏自治区", "value": [701.0, 0.12, "西藏自治区"]},
        ],
    },
    {
        "time": "2013年",
        "data": [
            {"name": "广东省", "value": [62475.0, 9.85, "广东省"]},
            {"name": "江苏省", "value": [59753.0, 9.42, "江苏省"]},
            {"name": "山东省", "value": [55230.0, 8.71, "山东省"]},
            {"name": "浙江省", "value": [37757.0, 5.95, "浙江省"]},
            {"name": "河南省", "value": [32191.0, 5.07, "河南省"]},
            {"name": "河北省", "value": [28443.0, 4.48, "河北省"]},
            {"name": "辽宁省", "value": [27213.0, 4.29, "辽宁省"]},
            {"name": "四川省", "value": [26392.0, 4.16, "四川省"]},
            {"name": "湖北省", "value": [24792.0, 3.91, "湖北省"]},
            {"name": "湖南省", "value": [24622.0, 3.88, "湖南省"]},
            {"name": "福建省", "value": [21868.0, 3.45, "福建省"]},
            {"name": "上海市", "value": [21818.0, 3.44, "上海市"]},
            {"name": "北京市", "value": [19801.0, 3.12, "北京市"]},
            {"name": "安徽省", "value": [19229.0, 3.03, "安徽省"]},
            {"name": "内蒙古", "value": [16917.0, 2.67, "内蒙古"]},
            {"name": "陕西省", "value": [16205.0, 2.55, "陕西省"]},
            {"name": "黑龙江省", "value": [14455.0, 2.28, "黑龙江省"]},
            {"name": "广西壮族自治区", "value": [14450.0, 2.28, "广西壮族自治区"]},
            {"name": "天津市", "value": [14442.0, 2.28, "天津市"]},
            {"name": "江西省", "value": [14410.0, 2.27, "江西省"]},
            {"name": "吉林省", "value": [13046.0, 2.06, "吉林省"]},
            {"name": "重庆市", "value": [12783.0, 2.02, "重庆市"]},
            {"name": "山西省", "value": [12665.0, 2.0, "山西省"]},
            {"name": "云南省", "value": [11832.0, 1.87, "云南省"]},
            {"name": "新疆维吾尔自治区", "value": [8444.0, 1.33, "新疆维吾尔自治区"]},
            {"name": "贵州省", "value": [8087.0, 1.27, "贵州省"]},
            {"name": "甘肃省", "value": [6331.0, 1.0, "甘肃省"]},
            {"name": "海南省", "value": [3178.0, 0.5, "海南省"]},
            {"name": "宁夏回族自治区", "value": [2578.0, 0.41, "宁夏回族自治区"]},
            {"name": "青海省", "value": [2122.0, 0.33, "青海省"]},
            {"name": "西藏自治区", "value": [816.0, 0.13, "西藏自治区"]},
        ],
    },
    {
        "time": "2014年",
        "data": [
            {"name": "广东省", "value": [67810.0, 9.91, "广东省"]},
            {"name": "江苏省", "value": [65088.0, 9.51, "江苏省"]},
            {"name": "山东省", "value": [59427.0, 8.68, "山东省"]},
            {"name": "浙江省", "value": [40173.0, 5.87, "浙江省"]},
            {"name": "河南省", "value": [34938.0, 5.11, "河南省"]},
            {"name": "河北省", "value": [29421.0, 4.3, "河北省"]},
            {"name": "辽宁省", "value": [28627.0, 4.18, "辽宁省"]},
            {"name": "四川省", "value": [28537.0, 4.17, "四川省"]},
            {"name": "湖北省", "value": [27379.0, 4.0, "湖北省"]},
            {"name": "湖南省", "value": [27037.0, 3.95, "湖南省"]},
            {"name": "福建省", "value": [24056.0, 3.52, "福建省"]},
            {"name": "上海市", "value": [23568.0, 3.44, "上海市"]},
            {"name": "北京市", "value": [21331.0, 3.12, "北京市"]},
            {"name": "安徽省", "value": [20849.0, 3.05, "安徽省"]},
            {"name": "内蒙古", "value": [17770.0, 2.6, "内蒙古"]},
            {"name": "陕西省", "value": [17690.0, 2.58, "陕西省"]},
            {"name": "天津市", "value": [15727.0, 2.3, "天津市"]},
            {"name": "江西省", "value": [15715.0, 2.3, "江西省"]},
            {"name": "广西壮族自治区", "value": [15673.0, 2.29, "广西壮族自治区"]},
            {"name": "黑龙江省", "value": [15039.0, 2.2, "黑龙江省"]},
            {"name": "重庆市", "value": [14263.0, 2.08, "重庆市"]},
            {"name": "吉林省", "value": [13803.0, 2.02, "吉林省"]},
            {"name": "云南省", "value": [12815.0, 1.87, "云南省"]},
            {"name": "山西省", "value": [12761.0, 1.86, "山西省"]},
            {"name": "新疆维吾尔自治区", "value": [9273.0, 1.36, "新疆维吾尔自治区"]},
            {"name": "贵州省", "value": [9266.0, 1.35, "贵州省"]},
            {"name": "甘肃省", "value": [6837.0, 1.0, "甘肃省"]},
            {"name": "海南省", "value": [3501.0, 0.51, "海南省"]},
            {"name": "宁夏回族自治区", "value": [2752.0, 0.4, "宁夏回族自治区"]},
            {"name": "青海省", "value": [2303.0, 0.34, "青海省"]},
            {"name": "西藏自治区", "value": [921.0, 0.13, "西藏自治区"]},
        ],
    },
    {
        "time": "2015年",
        "data": [
            {"name": "广东省", "value": [72813.0, 10.07, "广东省"]},
            {"name": "江苏省", "value": [70116.0, 9.7, "江苏省"]},
            {"name": "山东省", "value": [63002.0, 8.72, "山东省"]},
            {"name": "浙江省", "value": [42886.0, 5.93, "浙江省"]},
            {"name": "河南省", "value": [37002.0, 5.12, "河南省"]},
            {"name": "四川省", "value": [30053.0, 4.16, "四川省"]},
            {"name": "河北省", "value": [29806.0, 4.12, "河北省"]},
            {"name": "湖北省", "value": [29550.0, 4.09, "湖北省"]},
            {"name": "湖南省", "value": [28902.0, 4.0, "湖南省"]},
            {"name": "辽宁省", "value": [28669.0, 3.97, "辽宁省"]},
            {"name": "福建省", "value": [25980.0, 3.59, "福建省"]},
            {"name": "上海市", "value": [25123.0, 3.48, "上海市"]},
            {"name": "北京市", "value": [23015.0, 3.18, "北京市"]},
            {"name": "安徽省", "value": [22006.0, 3.04, "安徽省"]},
            {"name": "陕西省", "value": [18022.0, 2.49, "陕西省"]},
            {"name": "内蒙古", "value": [17832.0, 2.47, "内蒙古"]},
            {"name": "广西壮族自治区", "value": [16803.0, 2.32, "广西壮族自治区"]},
            {"name": "江西省", "value": [16724.0, 2.31, "江西省"]},
            {"name": "天津市", "value": [16538.0, 2.29, "天津市"]},
            {"name": "重庆市", "value": [15717.0, 2.17, "重庆市"]},
            {"name": "黑龙江省", "value": [15084.0, 2.09, "黑龙江省"]},
            {"name": "吉林省", "value": [14063.0, 1.95, "吉林省"]},
            {"name": "云南省", "value": [13619.0, 1.88, "云南省"]},
            {"name": "山西省", "value": [12766.0, 1.77, "山西省"]},
            {"name": "贵州省", "value": [10503.0, 1.45, "贵州省"]},
            {"name": "新疆维吾尔自治区", "value": [9325.0, 1.29, "新疆维吾尔自治区"]},
            {"name": "甘肃省", "value": [6790.0, 0.94, "甘肃省"]},
            {"name": "海南省", "value": [3703.0, 0.51, "海南省"]},
            {"name": "宁夏回族自治区", "value": [2912.0, 0.4, "宁夏回族自治区"]},
            {"name": "青海省", "value": [2417.0, 0.33, "青海省"]},
            {"name": "西藏自治区", "value": [1026.0, 0.14, "西藏自治区"]},
        ],
    },
    {
        "time": "2016年",
        "data": [
            {"name": "广东省", "value": [80855.0, 10.37, "广东省"]},
            {"name": "江苏省", "value": [77388.0, 9.92, "江苏省"]},
            {"name": "山东省", "value": [68024.0, 8.72, "山东省"]},
            {"name": "浙江省", "value": [47251.0, 6.06, "浙江省"]},
            {"name": "河南省", "value": [40472.0, 5.19, "河南省"]},
            {"name": "四川省", "value": [32935.0, 4.22, "四川省"]},
            {"name": "湖北省", "value": [32665.0, 4.19, "湖北省"]},
            {"name": "河北省", "value": [32070.0, 4.11, "河北省"]},
            {"name": "湖南省", "value": [31551.0, 4.04, "湖南省"]},
            {"name": "福建省", "value": [28811.0, 3.69, "福建省"]},
            {"name": "上海市", "value": [28179.0, 3.61, "上海市"]},
            {"name": "北京市", "value": [25669.0, 3.29, "北京市"]},
            {"name": "安徽省", "value": [24408.0, 3.13, "安徽省"]},
            {"name": "辽宁省", "value": [22247.0, 2.85, "辽宁省"]},
            {"name": "陕西省", "value": [19400.0, 2.49, "陕西省"]},
            {"name": "江西省", "value": [18499.0, 2.37, "江西省"]},
            {"name": "广西壮族自治区", "value": [18318.0, 2.35, "广西壮族自治区"]},
            {"name": "内蒙古", "value": [18128.0, 2.32, "内蒙古"]},
            {"name": "天津市", "value": [17885.0, 2.29, "天津市"]},
            {"name": "重庆市", "value": [17741.0, 2.27, "重庆市"]},
            {"name": "黑龙江省", "value": [15386.0, 1.97, "黑龙江省"]},
            {"name": "云南省", "value": [14788.0, 1.9, "云南省"]},
            {"name": "吉林省", "value": [14777.0, 1.89, "吉林省"]},
            {"name": "山西省", "value": [13050.0, 1.67, "山西省"]},
            {"name": "贵州省", "value": [11777.0, 1.51, "贵州省"]},
            {"name": "新疆维吾尔自治区", "value": [9650.0, 1.24, "新疆维吾尔自治区"]},
            {"name": "甘肃省", "value": [7200.0, 0.92, "甘肃省"]},
            {"name": "海南省", "value": [4053.0, 0.52, "海南省"]},
            {"name": "宁夏回族自治区", "value": [3169.0, 0.41, "宁夏回族自治区"]},
            {"name": "青海省", "value": [2572.0, 0.33, "青海省"]},
            {"name": "西藏自治区", "value": [1151.0, 0.15, "西藏自治区"]},
        ],
    },
    {
        "time": "2017年",
        "data": [
            {"name": "广东省", "value": [89705.0, 10.59, "广东省"]},
            {"name": "江苏省", "value": [85870.0, 10.14, "江苏省"]},
            {"name": "山东省", "value": [72634.0, 8.57, "山东省"]},
            {"name": "浙江省", "value": [51768.0, 6.11, "浙江省"]},
            {"name": "河南省", "value": [44553.0, 5.26, "河南省"]},
            {"name": "四川省", "value": [36980.0, 4.37, "四川省"]},
            {"name": "湖北省", "value": [35478.0, 4.19, "湖北省"]},
            {"name": "河北省", "value": [34016.0, 4.02, "河北省"]},
            {"name": "湖南省", "value": [33903.0, 4.0, "湖南省"]},
            {"name": "福建省", "value": [32182.0, 3.8, "福建省"]},
            {"name": "上海市", "value": [30633.0, 3.62, "上海市"]},
            {"name": "北京市", "value": [28015.0, 3.31, "北京市"]},
            {"name": "安徽省", "value": [27018.0, 3.19, "安徽省"]},
            {"name": "辽宁省", "value": [23409.0, 2.76, "辽宁省"]},
            {"name": "陕西省", "value": [21899.0, 2.59, "陕西省"]},
            {"name": "江西省", "value": [20006.0, 2.36, "江西省"]},
            {"name": "重庆市", "value": [19425.0, 2.29, "重庆市"]},
            {"name": "天津市", "value": [18549.0, 2.19, "天津市"]},
            {"name": "广西壮族自治区", "value": [18523.0, 2.19, "广西壮族自治区"]},
            {"name": "云南省", "value": [16376.0, 1.93, "云南省"]},
            {"name": "内蒙古", "value": [16096.0, 1.9, "内蒙古"]},
            {"name": "黑龙江省", "value": [15903.0, 1.88, "黑龙江省"]},
            {"name": "山西省", "value": [15528.0, 1.83, "山西省"]},
            {"name": "吉林省", "value": [14945.0, 1.76, "吉林省"]},
            {"name": "贵州省", "value": [13541.0, 1.6, "贵州省"]},
            {"name": "新疆维吾尔自治区", "value": [10882.0, 1.28, "新疆维吾尔自治区"]},
            {"name": "甘肃省", "value": [7460.0, 0.88, "甘肃省"]},
            {"name": "海南省", "value": [4463.0, 0.53, "海南省"]},
            {"name": "宁夏回族自治区", "value": [3444.0, 0.41, "宁夏回族自治区"]},
            {"name": "青海省", "value": [2625.0, 0.31, "青海省"]},
            {"name": "西藏自治区", "value": [1311.0, 0.15, "西藏自治区"]},
        ],
    },
    {
        "time": "2018年",
        "data": [
            {"name": "广东省", "value": [97278.0, 10.63, "广东省"]},
            {"name": "江苏省", "value": [92595.0, 10.12, "江苏省"]},
            {"name": "山东省", "value": [76470.0, 8.36, "山东省"]},
            {"name": "浙江省", "value": [56197.0, 6.14, "浙江省"]},
            {"name": "河南省", "value": [48056.0, 5.25, "河南省"]},
            {"name": "四川省", "value": [40678.0, 4.45, "四川省"]},
            {"name": "湖北省", "value": [39367.0, 4.3, "湖北省"]},
            {"name": "湖南省", "value": [36426.0, 3.98, "湖南省"]},
            {"name": "河北省", "value": [36010.0, 3.94, "河北省"]},
            {"name": "福建省", "value": [35804.0, 3.91, "福建省"]},
            {"name": "上海市", "value": [32680.0, 3.57, "上海市"]},
            {"name": "北京市", "value": [30320.0, 3.31, "北京市"]},
            {"name": "安徽省", "value": [30007.0, 3.28, "安徽省"]},
            {"name": "辽宁省", "value": [25315.0, 2.77, "辽宁省"]},
            {"name": "陕西省", "value": [24438.0, 2.67, "陕西省"]},
            {"name": "江西省", "value": [21985.0, 2.4, "江西省"]},
            {"name": "重庆市", "value": [20363.0, 2.23, "重庆市"]},
            {"name": "广西壮族自治区", "value": [20353.0, 2.23, "广西壮族自治区"]},
            {"name": "天津市", "value": [18810.0, 2.06, "天津市"]},
            {"name": "云南省", "value": [17881.0, 1.95, "云南省"]},
            {"name": "内蒙古", "value": [17289.0, 1.89, "内蒙古"]},
            {"name": "山西省", "value": [16818.0, 1.84, "山西省"]},
            {"name": "黑龙江省", "value": [16362.0, 1.79, "黑龙江省"]},
            {"name": "吉林省", "value": [15075.0, 1.65, "吉林省"]},
            {"name": "贵州省", "value": [14806.0, 1.62, "贵州省"]},
            {"name": "新疆维吾尔自治区", "value": [12199.0, 1.33, "新疆维吾尔自治区"]},
            {"name": "甘肃省", "value": [8246.0, 0.9, "甘肃省"]},
            {"name": "海南省", "value": [4832.0, 0.53, "海南省"]},
            {"name": "宁夏回族自治区", "value": [3705.0, 0.41, "宁夏回族自治区"]},
            {"name": "青海省", "value": [2865.0, 0.31, "青海省"]},
            {"name": "西藏自治区", "value": [1478.0, 0.16, "西藏自治区"]},
        ],
    },
]

time_list = [str(d) + "年" for d in range(1993, 2019)]

total_num = [
    3.4,
    4.5,
    5.8,
    6.8,
    7.6,
    8.3,
    8.8,
    9.9,
    10.9,
    12.1,
    14,
    16.8,
    19.9,
    23.3,
    28,
    33.3,
    36.5,
    43.7,
    52.1,
    57.7,
    63.4,
    68.4,
    72.3,
    78,
    84.7,
    91.5,
]
maxNum = 97300
minNum = 30


def get_year_chart(year: str):
    map_data = [
        [[x["name"], x["value"]] for x in d["data"]] for d in data if d["time"] == year
    ][0]
    min_data, max_data = (minNum, maxNum)
    data_mark: List = []
    i = 0
    for x in time_list:
        if x == year:
            data_mark.append(total_num[i])
        else:
            data_mark.append("")
        i = i + 1

    map_chart = (
        Map()
        .add(
            series_name="",
            data_pair=map_data,
            zoom=1,
            center=[119.5, 34.5],
            is_map_symbol_show=False,
            itemstyle_opts={
                "normal": {"areaColor": "#323c48", "borderColor": "#404a59"},
                "emphasis": {
                    "label": {"show": Timeline},
                    "areaColor": "rgba(255,255,255, 0.5)",
                },
            },
        )
        .set_global_opts(
            title_opts=opts.TitleOpts(
                title="" + str(year) + "全国分地区GPD情况（单位：亿） 数据来源：国家统计局",
                subtitle="",
                pos_left="center",
                pos_top="top",
                title_textstyle_opts=opts.TextStyleOpts(
                    font_size=25, color="rgba(255,255,255, 0.9)"
                ),
            ),
            tooltip_opts=opts.TooltipOpts(
                is_show=True,
                formatter=JsCode(
                    """function(params) {
                    if ('value' in params.data) {
                        return params.data.value[2] + ': ' + params.data.value[0];
                    }
                }"""
                ),
            ),
            visualmap_opts=opts.VisualMapOpts(
                is_calculable=True,
                dimension=0,
                pos_left="30",
                pos_top="center",
                range_text=["High", "Low"],
                range_color=["lightskyblue", "yellow", "orangered"],
                textstyle_opts=opts.TextStyleOpts(color="#ddd"),
                min_=min_data,
                max_=max_data,
            ),
        )
    )

    line_chart = (
        Line()
        .add_xaxis(time_list)
        .add_yaxis("", total_num)
        .add_yaxis(
            "",
            data_mark,
            markpoint_opts=opts.MarkPointOpts(data=[opts.MarkPointItem(type_="max")]),
        )
        .set_series_opts(label_opts=opts.LabelOpts(is_show=False))
        .set_global_opts(
            title_opts=opts.TitleOpts(
                title="全国GDP总量1993-2018年（单位：万亿）", pos_left="72%", pos_top="5%"
            )
        )
    )
    bar_x_data = [x[0] for x in map_data]
    bar_y_data = [{"name": x[0], "value": x[1][0]} for x in map_data]
    bar = (
        Bar()
        .add_xaxis(xaxis_data=bar_x_data)
        .add_yaxis(
            series_name="",
            y_axis=bar_y_data,
            label_opts=opts.LabelOpts(
                is_show=True, position="right", formatter="{b} : {c}"
            ),
        )
        .reversal_axis()
        .set_global_opts(
            xaxis_opts=opts.AxisOpts(
                max_=maxNum, axislabel_opts=opts.LabelOpts(is_show=False)
            ),
            yaxis_opts=opts.AxisOpts(axislabel_opts=opts.LabelOpts(is_show=False)),
            tooltip_opts=opts.TooltipOpts(is_show=False),
            visualmap_opts=opts.VisualMapOpts(
                is_calculable=True,
                dimension=0,
                pos_left="10",
                pos_top="top",
                range_text=["High", "Low"],
                range_color=["lightskyblue", "yellow", "orangered"],
                textstyle_opts=opts.TextStyleOpts(color="#ddd"),
                min_=min_data,
                max_=max_data,
            ),
        )
    )

    pie_data = [[x[0], x[1][0]] for x in map_data]
    pie = (
        Pie()
        .add(
            series_name="",
            data_pair=pie_data,
            radius=["15%", "35%"],
            center=["80%", "82%"],
            itemstyle_opts=opts.ItemStyleOpts(
                border_width=1, border_color="rgba(0,0,0,0.3)"
            ),
        )
        .set_global_opts(
            tooltip_opts=opts.TooltipOpts(is_show=True, formatter="{b} {d}%"),
            legend_opts=opts.LegendOpts(is_show=False),
        )
    )

    grid_chart = (
        Grid()
        .add(
            bar,
            grid_opts=opts.GridOpts(
                pos_left="10", pos_right="45%", pos_top="50%", pos_bottom="5"
            ),
        )
        .add(
            line_chart,
            grid_opts=opts.GridOpts(
                pos_left="65%", pos_right="80", pos_top="10%", pos_bottom="50%"
            ),
        )
        .add(pie, grid_opts=opts.GridOpts(pos_left="45%", pos_top="60%"))
        .add(map_chart, grid_opts=opts.GridOpts())
    )

    return grid_chart


c6 = Timeline(
    init_opts=opts.InitOpts(width="1600px", height="900px", theme=ThemeType.DARK)
)
for y in time_list:
    g = get_year_chart(year=y)
    c6.add(g, time_point=str(y))

c6.add_schema(
    orient="vertical",
    is_auto_play=True,
    is_inverse=True,
    play_interval=5000,
    pos_left="null",
    pos_right="5",
    pos_top="20",
    pos_bottom="20",
    width="60",
    label_opts=opts.LabelOpts(is_show=True, color="#fff"),
)

# ---------------------------------------------- Map - China_gdp_from_1980 ----------------------------------------------
import pyecharts.options as opts
from pyecharts.globals import ThemeType
from pyecharts.commons.utils import JsCode
from pyecharts.charts import Timeline, Grid, Bar, Map, Pie

"""
Gallery 使用 pyecharts 1.0.0
参考地址: https://gallery.echartsjs.com/editor.html?c=xSkGI6zLmb

目前无法实现的功能:

1、
"""

data = [
    {
        "time": 1980,
        "data": [
            {"name": "台湾省", "value": [633.76, 12.28, "台湾省"]},
            {"name": "香港特别行政区", "value": [432.47, 8.38, "香港特别行政区"]},
            {"name": "江苏省", "value": [319.8, 6.2, "江苏省"]},
            {"name": "上海市", "value": [311.89, 6.05, "上海市"]},
            {"name": "山东省", "value": [292.13, 5.66, "山东省"]},
            {"name": "辽宁省", "value": [281, 5.45, "辽宁省"]},
            {"name": "广东省", "value": [249.65, 4.84, "广东省"]},
            {"name": "四川省", "value": [229.31, 4.44, "四川省"]},
            {"name": "河南省", "value": [229.16, 4.44, "河南省"]},
            {"name": "黑龙江省", "value": [221, 4.28, "黑龙江省"]},
        ],
    },
    {
        "time": 2000,
        "data": [
            {"name": "台湾省", "value": [27435.15, 19.47, "台湾省"]},
            {"name": "香港特别行政区", "value": [14201.59, 10.08, "香港特别行政区"]},
            {"name": "广东省", "value": [10741.25, 7.62, "广东省"]},
            {"name": "江苏省", "value": [8553.69, 6.07, "江苏省"]},
            {"name": "山东省", "value": [8337.47, 5.92, "山东省"]},
            {"name": "浙江省", "value": [6141.03, 4.36, "浙江省"]},
            {"name": "河南省", "value": [5052.99, 3.59, "河南省"]},
            {"name": "河北省", "value": [5043.96, 3.58, "河北省"]},
            {"name": "上海市", "value": [4771.17, 3.39, "上海市"]},
            {"name": "辽宁省", "value": [4669.1, 3.31, "辽宁省"]},
        ],
    },
    {
        "time": 2005,
        "data": [
            {"name": "台湾省", "value": [30792.89, 12.52, "台湾省"]},
            {"name": "广东省", "value": [22527.37, 9.16, "广东省"]},
            {"name": "江苏省", "value": [18598.69, 7.56, "江苏省"]},
            {"name": "山东省", "value": [18366.87, 7.47, "山东省"]},
            {"name": "香港特别行政区", "value": [14869.68, 6.05, "香港特别行政区"]},
            {"name": "浙江省", "value": [13417.68, 5.46, "浙江省"]},
            {"name": "河南省", "value": [10587.42, 4.3, "河南省"]},
            {"name": "河北省", "value": [10043.42, 4.08, "河北省"]},
            {"name": "上海市", "value": [9247.66, 3.76, "上海市"]},
            {"name": "辽宁省", "value": [8047.3, 3.27, "辽宁省"]},
        ],
    },
    {
        "time": 2010,
        "data": [
            {"name": "广东省", "value": [46036.25, 9.49, "广东省"]},
            {"name": "江苏省", "value": [41425.48, 8.54, "江苏省"]},
            {"name": "山东省", "value": [39169.92, 8.08, "山东省"]},
            {"name": "台湾省", "value": [30205.64, 6.23, "台湾省"]},
            {"name": "浙江省", "value": [27747.65, 5.72, "浙江省"]},
            {"name": "河南省", "value": [23092.36, 4.76, "河南省"]},
            {"name": "河北省", "value": [20394.26, 4.21, "河北省"]},
            {"name": "辽宁省", "value": [18457.3, 3.81, "辽宁省"]},
            {"name": "四川省", "value": [17185.48, 3.54, "四川省"]},
            {"name": "上海市", "value": [17165.98, 3.54, "上海市"]},
        ],
    },
    {
        "time": 2015,
        "data": [
            {"name": "广东省", "value": [72812.55, 9.35, "广东省"]},
            {"name": "江苏省", "value": [70116.38, 9, "江苏省"]},
            {"name": "山东省", "value": [63002.3, 8.09, "山东省"]},
            {"name": "浙江省", "value": [42886, 5.51, "浙江省"]},
            {"name": "河南省", "value": [37010.25, 4.75, "河南省"]},
            {"name": "台湾省", "value": [32604.52, 4.19, "台湾省"]},
            {"name": "四川省", "value": [30103.1, 3.87, "四川省"]},
            {"name": "河北省", "value": [29806.1, 3.83, "河北省"]},
            {"name": "湖北省", "value": [29550.19, 3.8, "湖北省"]},
            {"name": "湖南省", "value": [29047.2, 3.73, "湖南省"]},
        ],
    },
]


def get_year_chart(year: int):
    map_data = [
        [[x["name"], x["value"]] for x in d["data"]] for d in data if d["time"] == year
    ][0]
    min_data, max_data = (
        min([d[1][0] for d in map_data]),
        max([d[1][0] for d in map_data]),
    )
    map_chart = (
        Map()
        .add(
            series_name="",
            data_pair=map_data,
            label_opts=opts.LabelOpts(is_show=False),
            is_map_symbol_show=False,
            itemstyle_opts={
                "normal": {"areaColor": "#323c48", "borderColor": "#404a59"},
                "emphasis": {
                    "label": {"show": Timeline},
                    "areaColor": "rgba(255,255,255, 0.5)",
                },
            },
        )
        .set_global_opts(
            title_opts=opts.TitleOpts(
                title="1980年以来中国各省GDP排名变化情况",
                subtitle="GDP单位:亿元",
                pos_left="center",
                pos_top="top",
                title_textstyle_opts=opts.TextStyleOpts(
                    font_size=25, color="rgba(255,255,255, 0.9)"
                ),
            ),
            tooltip_opts=opts.TooltipOpts(
                is_show=True,
                formatter=JsCode(
                    """function(params) {
                    if ('value' in params.data) {
                        return params.data.value[2] + ': ' + params.data.value[0];
                    }
                }"""
                ),
            ),
            visualmap_opts=opts.VisualMapOpts(
                is_calculable=True,
                dimension=0,
                pos_left="10",
                pos_top="center",
                range_text=["High", "Low"],
                range_color=["lightskyblue", "yellow", "orangered"],
                textstyle_opts=opts.TextStyleOpts(color="#ddd"),
                min_=min_data,
                max_=max_data,
            ),
        )
    )

    bar_x_data = [x[0] for x in map_data]

    # 这里注释的部分会导致 label 和 value 与 饼图不一致
    # 使用下面的 List[Dict] 就可以解决这个问题了。
    # bar_y_data = [x[1][0] for x in map_data]
    bar_y_data = [{"name": x[0], "value": x[1][0]} for x in map_data]
    bar = (
        Bar()
        .add_xaxis(xaxis_data=bar_x_data)
        .add_yaxis(
            series_name="",
            yaxis_index=1,
            y_axis=bar_y_data,
            label_opts=opts.LabelOpts(
                is_show=True, position="right", formatter="{b}: {c}"
            ),
        )
        .reversal_axis()
        .set_global_opts(
            xaxis_opts=opts.AxisOpts(axislabel_opts=opts.LabelOpts(is_show=False)),
            yaxis_opts=opts.AxisOpts(axislabel_opts=opts.LabelOpts(is_show=False)),
            tooltip_opts=opts.TooltipOpts(is_show=False),
            visualmap_opts=opts.VisualMapOpts(
                is_calculable=True,
                dimension=0,
                pos_left="10",
                pos_top="center",
                range_text=["High", "Low"],
                range_color=["lightskyblue", "yellow", "orangered"],
                textstyle_opts=opts.TextStyleOpts(color="#ddd"),
                min_=min_data,
                max_=max_data,
            ),
            graphic_opts=[
                opts.GraphicGroup(
                    graphic_item=opts.GraphicItem(
                        rotation=JsCode("Math.PI / 4"),
                        bounding="raw",
                        right=110,
                        bottom=110,
                        z=100,
                    ),
                    children=[
                        opts.GraphicRect(
                            graphic_item=opts.GraphicItem(
                                left="center", top="center", z=100
                            ),
                            graphic_shape_opts=opts.GraphicShapeOpts(
                                width=400, height=50
                            ),
                            graphic_basicstyle_opts=opts.GraphicBasicStyleOpts(
                                fill="rgba(0,0,0,0.3)"
                            ),
                        ),
                        opts.GraphicText(
                            graphic_item=opts.GraphicItem(
                                left="center", top="center", z=100
                            ),
                            graphic_textstyle_opts=opts.GraphicTextStyleOpts(
                                text=f"{str(year)} 年",
                                font="bold 26px Microsoft YaHei",
                                graphic_basicstyle_opts=opts.GraphicBasicStyleOpts(
                                    fill="#fff"
                                ),
                            ),
                        ),
                    ],
                )
            ],
        )
    )

    pie_data = [[x[0], x[1][0]] for x in map_data]
    percent_sum = sum([x[1][1] for x in map_data])
    rest_value = 0
    for d in map_data:
        rest_percent = 100.0
        rest_percent = rest_percent - percent_sum
        rest_value = d[1][0] * (rest_percent / d[1][1])
    pie_data.append(["其他省份", rest_value])
    pie = (
        Pie()
        .add(
            series_name="",
            data_pair=pie_data,
            radius=["12%", "20%"],
            center=["75%", "85%"],
            itemstyle_opts=opts.ItemStyleOpts(
                border_width=1, border_color="rgba(0,0,0,0.3)"
            ),
        )
        .set_global_opts(
            tooltip_opts=opts.TooltipOpts(is_show=True, formatter="{b} {d}%"),
            legend_opts=opts.LegendOpts(is_show=False),
        )
    )

    grid_chart = (
        Grid()
        .add(
            bar,
            grid_opts=opts.GridOpts(
                pos_left="10", pos_right="45%", pos_top="70%", pos_bottom="5"
            ),
        )
        .add(pie, grid_opts=opts.GridOpts())
        .add(map_chart, grid_opts=opts.GridOpts())
    )

    return grid_chart


# Draw Timeline
time_list = [1980, 2000, 2005, 2010, 2015]
c7 = Timeline(
    init_opts=opts.InitOpts(width="1200px", height="800px", theme=ThemeType.DARK)
)
for y in time_list:
    g = get_year_chart(year=y)
    c7.add(g, time_point=str(y))

c7.add_schema(
    orient="vertical",
    is_auto_play=True,
    is_inverse=True,
    play_interval=5000,
    pos_left="null",
    pos_right="5",
    pos_top="20",
    pos_bottom="20",
    width="50",
    label_opts=opts.LabelOpts(is_show=True, color="#fff"),
)

# ---------------------------------------------- Map - Population_density_of_hongkong_v2 ----------------------------------------------
import ssl

import pyecharts.options as opts
from pyecharts.charts import Map
from pyecharts.datasets import register_url

"""
Gallery 使用 pyecharts 1.1.0 和 echarts-china-cities-js
参考地址: https://echarts.apache.org/examples/editor.html?c=map-HK
"""
ssl._create_default_https_context = ssl._create_unverified_context
# 与 pyecharts 注册，当画香港地图的时候，用 echarts-china-cities-js
# register_url("https://echarts-maps.github.io/echarts-china-cities-js")

WIKI_LINK = (
    "http://zh.wikipedia.org/wiki/"
    "%E9%A6%99%E6%B8%AF%E8%A1%8C%E6%94%BF%E5%8D%80%E5%8A%83#cite_note-12"
)
MAP_DATA = [
    ["中西区", 20057.34],
    ["湾仔", 15477.48],
    ["东区", 31686.1],
    ["南区", 6992.6],
    ["油尖旺", 44045.49],
    ["深水埗", 40689.64],
    ["九龙城", 37659.78],
    ["黄大仙", 45180.97],
    ["观塘", 55204.26],
    ["葵青", 21900.9],
    ["荃湾", 4918.26],
    ["屯门", 5881.84],
    ["元朗", 4178.01],
    ["北区", 2227.92],
    ["大埔", 2180.98],
    ["沙田", 9172.94],
    ["西贡", 3368],
    ["离岛", 806.98],
]


NAME_MAP_DATA = {
    # "key": "value"
    # "name on the hong kong map": "name in the MAP DATA",
    "中西区": "中西区",
    "东区": "东区",
    "离岛区": "离岛",
    "九龙城区": "九龙城",
    "葵青区": "葵青",
    "观塘区": "观塘",
    "北区": "北区",
    "西贡区": "西贡",
    "沙田区": "沙田",
    "深水埗区": "深水埗",
    "南区": "南区",
    "大埔区": "大埔",
    "荃湾区": "荃湾",
    "屯门区": "屯门",
    "湾仔区": "湾仔",
    "黄大仙区": "黄大仙",
    "油尖旺区": "油尖旺",
    "元朗区": "元朗",
}

c8 = (
    Map()
    .add(
        series_name="香港18区人口密度",
        maptype="香港",
        data_pair=MAP_DATA,
        name_map=NAME_MAP_DATA,
        is_map_symbol_show=False,
    )
    .set_global_opts(
        title_opts=opts.TitleOpts(
            title="香港18区人口密度 （2011）",
            subtitle="人口密度数据来自Wikipedia",
            subtitle_link=WIKI_LINK,
        ),
        tooltip_opts=opts.TooltipOpts(
            trigger="item", formatter="{b}<br/>{c} (p / km2)"
        ),
        visualmap_opts=opts.VisualMapOpts(
            min_=800,
            max_=50000,
            range_text=["High", "Low"],
            is_calculable=True,
            range_color=["lightskyblue", "yellow", "orangered"],
        ),
    )
)

# ---------------------------------------------- Map - Population_density_of_hongkong ----------------------------------------------
import asyncio
from aiohttp import TCPConnector, ClientSession

import pyecharts.options as opts
from pyecharts.charts import Map

"""
Gallery 使用 pyecharts 1.1.0
参考地址: https://echarts.apache.org/examples/editor.html?c=map-HK
"""

WIKI_LINK = (
    "http://zh.wikipedia.org/wiki/"
    "%E9%A6%99%E6%B8%AF%E8%A1%8C%E6%94%BF%E5%8D%80%E5%8A%83#cite_note-12"
)


async def get_json_data(url: str) -> dict:
    async with ClientSession(connector=TCPConnector(ssl=False)) as session:
        async with session.get(url=url) as response:
            return await response.json()


# 下载香港地图
data = asyncio.run(
    get_json_data(url="https://echarts.apache.org/examples/data/asset/geo/HK.json")
)

MAP_DATA = [
    ["中西区", 20057.34],
    ["湾仔", 15477.48],
    ["东区", 31686.1],
    ["南区", 6992.6],
    ["油尖旺", 44045.49],
    ["深水埗", 40689.64],
    ["九龙城", 37659.78],
    ["黄大仙", 45180.97],
    ["观塘", 55204.26],
    ["葵青", 21900.9],
    ["荃湾", 4918.26],
    ["屯门", 5881.84],
    ["元朗", 4178.01],
    ["北区", 2227.92],
    ["大埔", 2180.98],
    ["沙田", 9172.94],
    ["西贡", 3368],
    ["离岛", 806.98],
]


NAME_MAP_DATA = {
    # "key": "value"
    # "name on the hong kong map": "name in the MAP DATA",
    "Central and Western": "中西区",
    "Eastern": "东区",
    "Islands": "离岛",
    "Kowloon City": "九龙城",
    "Kwai Tsing": "葵青",
    "Kwun Tong": "观塘",
    "North": "北区",
    "Sai Kung": "西贡",
    "Sha Tin": "沙田",
    "Sham Shui Po": "深水埗",
    "Southern": "南区",
    "Tai Po": "大埔",
    "Tsuen Wan": "荃湾",
    "Tuen Mun": "屯门",
    "Wan Chai": "湾仔",
    "Wong Tai Sin": "黄大仙",
    "Yau Tsim Mong": "油尖旺",
    "Yuen Long": "元朗",
}

c9 = (
    Map()
    .add_js_funcs("echarts.registerMap('HK', {});".format(data))
    .add(
        series_name="香港18区人口密度",
        maptype="HK",
        data_pair=MAP_DATA,
        name_map=NAME_MAP_DATA,
        is_map_symbol_show=False,
    )
    .set_global_opts(
        title_opts=opts.TitleOpts(
            title="香港18区人口密度 （2011）",
            subtitle="人口密度数据来自Wikipedia",
            subtitle_link=WIKI_LINK,
        ),
        tooltip_opts=opts.TooltipOpts(
            trigger="item", formatter="{b}<br/>{c} (p / km2)"
        ),
        visualmap_opts=opts.VisualMapOpts(
            min_=800,
            max_=50000,
            range_text=["High", "Low"],
            is_calculable=True,
            range_color=["lightskyblue", "yellow", "orangered"],
        ),
    )
)

# ---------------------------------------------- Map - Map_without_label ----------------------------------------------
from pyecharts import options as opts
from pyecharts.charts import Map
from pyecharts.faker import Faker

c10 = (
    Map()
    .add("商家A", [list(z) for z in zip(Faker.provinces, Faker.values())], "china")
    .set_series_opts(label_opts=opts.LabelOpts(is_show=False))
    .set_global_opts(title_opts=opts.TitleOpts(title="Map-不显示Label"))
)

# ---------------------------------------------- Map - Map_visualmap ----------------------------------------------
from pyecharts import options as opts
from pyecharts.charts import Map
from pyecharts.faker import Faker

c11 = (
    Map()
    .add("商家A", [list(z) for z in zip(Faker.provinces, Faker.values())], "china")
    .set_global_opts(
        title_opts=opts.TitleOpts(title="Map-VisualMap（连续型）"),
        visualmap_opts=opts.VisualMapOpts(max_=200),
    )
)

import swanlab

swanlab.init(
    project="echarts-test",
    experiment_name="map",
    public=True,
)

swanlab.log(
    {
        "Map - Map_base": c1,
        "Map - Map_guangdong": c2,
        "Map - Map_china_cities": c3,
        "Map - Map_visualmap_piecewise": c4,
        "Map - Map_world": c5,
        "Map - China_gdp_from_1993_to_2018": c6,
        "Map - China_gdp_from_1980": c7,
        "Map - Population_density_of_hongkong_v2": c8,
        "Map - Population_density_of_hongkong": c9,
        "Map - Map_without_label": c10,
        "Map - Map_visualmap": c11
    }
)
