"""
@author: cunyue
@file: wordcloud.py
@time: 2025/5/25 21:49
@description: echarts wordcloud chart test cases
"""

# ---------------------------------- Wordcloud - Wordcloud_custom_mask_image ----------------------------------

# words = [
#     ("花鸟市场", 1446),
#     ("汽车", 928),
#     ("视频", 906),
#     ("电视", 825),
#     ("Lover Boy 88", 514),
#     ("动漫", 486),
#     ("音乐", 53),
#     ("直播", 163),
#     ("广播电台", 86),
#     ("戏曲曲艺", 17),
#     ("演出票务", 6),
#     ("给陌生的你听", 1),
#     ("资讯", 1437),
#     ("商业财经", 422),
#     ("娱乐八卦", 353),
#     ("军事", 331),
#     ("科技资讯", 313),
#     ("社会时政", 307),
#     ("时尚", 43),
#     ("网络奇闻", 15),
#     ("旅游出行", 438),
#     ("景点类型", 957),
#     ("国内游", 927),
#     ("远途出行方式", 908),
#     ("酒店", 693),
#     ("关注景点", 611),
#     ("旅游网站偏好", 512),
#     ("出国游", 382),
#     ("交通票务", 312),
#     ("旅游方式", 187),
#     ("旅游主题", 163),
#     ("港澳台", 104),
#     ("本地周边游", 3),
#     ("小卖家", 1331),
#     ("全日制学校", 941),
#     ("基础教育科目", 585),
#     ("考试培训", 473),
#     ("语言学习", 358),
#     ("留学", 246),
#     ("K12课程培训", 207),
#     ("艺术培训", 194),
#     ("技能培训", 104),
#     ("IT培训", 87),
#     ("高等教育专业", 63),
#     ("家教", 48),
#     ("体育培训", 23),
#     ("职场培训", 5),
#     ("金融财经", 1328),
#     ("银行", 765),
#     ("股票", 452),
#     ("保险", 415),
#     ("贷款", 253),
#     ("基金", 211),
#     ("信用卡", 180),
#     ("外汇", 138),
#     ("P2P", 116),
#     ("贵金属", 98),
#     ("债券", 93),
#     ("网络理财", 92),
#     ("信托", 90),
#     ("征信", 76),
#     ("期货", 76),
#     ("公积金", 40),
#     ("银行理财", 36),
#     ("银行业务", 30),
#     ("典当", 7),
#     ("海外置业", 1),
#     ("汽车", 1309),
#     ("汽车档次", 965),
#     ("汽车品牌", 900),
#     ("汽车车型", 727),
#     ("购车阶段", 461),
#     ("二手车", 309),
#     ("汽车美容", 260),
#     ("新能源汽车", 173),
#     ("汽车维修", 155),
#     ("租车服务", 136),
#     ("车展", 121),
#     ("违章查询", 76),
#     ("汽车改装", 62),
#     ("汽车用品", 37),
#     ("路况查询", 32),
#     ("汽车保险", 28),
#     ("陪驾代驾", 4),
#     ("网络购物", 1275),
#     ("做我的猫", 1088),
#     ("只想要你知道", 907),
#     ("团购", 837),
#     ("比价", 201),
#     ("海淘", 195),
#     ("移动APP购物", 179),
#     ("支付方式", 119),
#     ("代购", 43),
#     ("体育健身", 1234),
#     ("体育赛事项目", 802),
#     ("运动项目", 405),
#     ("体育类赛事", 337),
#     ("健身项目", 199),
#     ("健身房健身", 78),
#     ("运动健身", 77),
#     ("家庭健身", 36),
#     ("健身器械", 29),
#     ("办公室健身", 3),
#     ("商务服务", 1201),
#     ("法律咨询", 508),
#     ("化工材料", 147),
#     ("广告服务", 125),
#     ("会计审计", 115),
#     ("人员招聘", 101),
#     ("印刷打印", 66),
#     ("知识产权", 32),
#     ("翻译", 22),
#     ("安全安保", 9),
#     ("公关服务", 8),
#     ("商旅服务", 2),
#     ("展会服务", 2),
#     ("特许经营", 1),
#     ("休闲爱好", 1169),
#     ("收藏", 412),
#     ("摄影", 393),
#     ("温泉", 230),
#     ("博彩彩票", 211),
#     ("美术", 207),
#     ("书法", 139),
#     ("DIY手工", 75),
#     ("舞蹈", 23),
#     ("钓鱼", 21),
#     ("棋牌桌游", 17),
#     ("KTV", 6),
#     ("密室", 5),
#     ("采摘", 4),
#     ("电玩", 1),
#     ("真人CS", 1),
#     ("轰趴", 1),
#     ("家电数码", 1111),
#     ("手机", 885),
#     ("电脑", 543),
#     ("大家电", 321),
#     ("家电关注品牌", 253),
#     ("网络设备", 162),
#     ("摄影器材", 149),
#     ("影音设备", 133),
#     ("办公数码设备", 113),
#     ("生活电器", 67),
#     ("厨房电器", 54),
#     ("智能设备", 45),
#     ("个人护理电器", 22),
#     ("服饰鞋包", 1047),
#     ("服装", 566),
#     ("饰品", 289),
#     ("鞋", 184),
#     ("箱包", 168),
#     ("奢侈品", 137),
#     ("母婴亲子", 1041),
#     ("孕婴保健", 505),
#     ("母婴社区", 299),
#     ("早教", 103),
#     ("奶粉辅食", 66),
#     ("童车童床", 41),
#     ("关注品牌", 271),
#     ("宝宝玩乐", 30),
#     ("母婴护理服务", 25),
#     ("纸尿裤湿巾", 16),
#     ("妈妈用品", 15),
#     ("宝宝起名", 12),
#     ("童装童鞋", 9),
#     ("胎教", 8),
#     ("宝宝安全", 1),
#     ("宝宝洗护用品", 1),
#     ("软件应用", 1018),
#     ("系统工具", 896),
#     ("理财购物", 440),
#     ("生活实用", 365),
#     ("影音图像", 256),
#     ("社交通讯", 214),
#     ("手机美化", 39),
#     ("办公学习", 28),
#     ("应用市场", 23),
#     ("母婴育儿", 14),
#     ("游戏", 946),
#     ("手机游戏", 565),
#     ("PC游戏", 353),
#     ("网页游戏", 254),
#     ("游戏机", 188),
#     ("模拟辅助", 166),
#     ("个护美容", 942),
#     ("护肤品", 177),
#     ("彩妆", 133),
#     ("美发", 80),
#     ("香水", 50),
#     ("个人护理", 46),
#     ("美甲", 26),
#     ("SPA美体", 21),
#     ("花鸟萌宠", 914),
#     ("绿植花卉", 311),
#     ("狗", 257),
#     ("其他宠物", 131),
#     ("水族", 125),
#     ("猫", 122),
#     ("动物", 81),
#     ("鸟", 67),
#     ("宠物用品", 41),
#     ("宠物服务", 26),
#     ("书籍阅读", 913),
#     ("网络小说", 483),
#     ("关注书籍", 128),
#     ("文学", 105),
#     ("报刊杂志", 77),
#     ("人文社科", 22),
#     ("建材家居", 907),
#     ("装修建材", 644),
#     ("家具", 273),
#     ("家居风格", 187),
#     ("家居家装关注品牌", 140),
#     ("家纺", 107),
#     ("厨具", 47),
#     ("灯具", 43),
#     ("家居饰品", 29),
#     ("家居日常用品", 10),
#     ("生活服务", 883),
#     ("物流配送", 536),
#     ("家政服务", 108),
#     ("摄影服务", 49),
#     ("搬家服务", 38),
#     ("物业维修", 37),
#     ("婚庆服务", 24),
#     ("二手回收", 24),
#     ("鲜花配送", 3),
#     ("维修服务", 3),
#     ("殡葬服务", 1),
#     ("求职创业", 874),
#     ("创业", 363),
#     ("目标职位", 162),
#     ("目标行业", 50),
#     ("兼职", 21),
#     ("期望年薪", 20),
#     ("实习", 16),
#     ("雇主类型", 10),
#     ("星座运势", 789),
#     ("星座", 316),
#     ("算命", 303),
#     ("解梦", 196),
#     ("风水", 93),
#     ("面相分析", 47),
#     ("手相", 32),
#     ("公益", 90),
# ]
#
# with open("wordcloud_image_base64.json", "r", encoding="utf-8") as f:
#     j = json.load(f)
#
#
# c = (
#     WordCloud()
#     .add("", words, word_size_range=[12, 55], mask_image=j["base64"])
#     .set_global_opts(title_opts=opts.TitleOpts(title="WordCloud-自定义图片"))
# )

# ---------------------------------- Wordcloud - Basic_wordcloud ----------------------------------

import pyecharts.options as opts
from pyecharts.charts import WordCloud

"""
Gallery 使用 pyecharts 1.1.0
参考地址: https://gallery.echartsjs.com/editor.html?c=xS1jMxuOVm

目前无法实现的功能:

1、暂无
"""

data = [
    ("生活资源", "999"),
    ("供热管理", "888"),
    ("供气质量", "777"),
    ("生活用水管理", "688"),
    ("一次供水问题", "588"),
    ("交通运输", "516"),
    ("城市交通", "515"),
    ("环境保护", "483"),
    ("房地产管理", "462"),
    ("城乡建设", "449"),
    ("社会保障与福利", "429"),
    ("社会保障", "407"),
    ("文体与教育管理", "406"),
    ("公共安全", "406"),
    ("公交运输管理", "386"),
    ("出租车运营管理", "385"),
    ("供热管理", "375"),
    ("市容环卫", "355"),
    ("自然资源管理", "355"),
    ("粉尘污染", "335"),
    ("噪声污染", "324"),
    ("土地资源管理", "304"),
    ("物业服务与管理", "304"),
    ("医疗卫生", "284"),
    ("粉煤灰污染", "284"),
    ("占道", "284"),
    ("供热发展", "254"),
    ("农村土地规划管理", "254"),
    ("生活噪音", "253"),
    ("供热单位影响", "253"),
    ("城市供电", "223"),
    ("房屋质量与安全", "223"),
    ("大气污染", "223"),
    ("房屋安全", "223"),
    ("文化活动", "223"),
    ("拆迁管理", "223"),
    ("公共设施", "223"),
    ("供气质量", "223"),
    ("供电管理", "223"),
    ("燃气管理", "152"),
    ("教育管理", "152"),
    ("医疗纠纷", "152"),
    ("执法监督", "152"),
    ("设备安全", "152"),
    ("政务建设", "152"),
    ("县区、开发区", "152"),
    ("宏观经济", "152"),
    ("教育管理", "112"),
    ("社会保障", "112"),
    ("生活用水管理", "112"),
    ("物业服务与管理", "112"),
    ("分类列表", "112"),
    ("农业生产", "112"),
    ("二次供水问题", "112"),
    ("城市公共设施", "92"),
    ("拆迁政策咨询", "92"),
    ("物业服务", "92"),
    ("物业管理", "92"),
    ("社会保障保险管理", "92"),
    ("低保管理", "92"),
    ("文娱市场管理", "72"),
    ("城市交通秩序管理", "72"),
    ("执法争议", "72"),
    ("商业烟尘污染", "72"),
    ("占道堆放", "71"),
    ("地上设施", "71"),
    ("水质", "71"),
    ("无水", "71"),
    ("供热单位影响", "71"),
    ("人行道管理", "71"),
    ("主网原因", "71"),
    ("集中供热", "71"),
    ("客运管理", "71"),
    ("国有公交（大巴）管理", "71"),
    ("工业粉尘污染", "71"),
    ("治安案件", "71"),
    ("压力容器安全", "71"),
    ("身份证管理", "71"),
    ("群众健身", "41"),
    ("工业排放污染", "41"),
    ("破坏森林资源", "41"),
    ("市场收费", "41"),
    ("生产资金", "41"),
    ("生产噪声", "41"),
    ("农村低保", "41"),
    ("劳动争议", "41"),
    ("劳动合同争议", "41"),
    ("劳动报酬与福利", "41"),
    ("医疗事故", "21"),
    ("停供", "21"),
    ("基础教育", "21"),
    ("职业教育", "21"),
    ("物业资质管理", "21"),
    ("拆迁补偿", "21"),
    ("设施维护", "21"),
    ("市场外溢", "11"),
    ("占道经营", "11"),
    ("树木管理", "11"),
    ("农村基础设施", "11"),
    ("无水", "11"),
    ("供气质量", "11"),
    ("停气", "11"),
    ("市政府工作部门（含部门管理机构、直属单位）", "11"),
    ("燃气管理", "11"),
    ("市容环卫", "11"),
    ("新闻传媒", "11"),
    ("人才招聘", "11"),
    ("市场环境", "11"),
    ("行政事业收费", "11"),
    ("食品安全与卫生", "11"),
    ("城市交通", "11"),
    ("房地产开发", "11"),
    ("房屋配套问题", "11"),
    ("物业服务", "11"),
    ("物业管理", "11"),
    ("占道", "11"),
    ("园林绿化", "11"),
    ("户籍管理及身份证", "11"),
    ("公交运输管理", "11"),
    ("公路（水路）交通", "11"),
    ("房屋与图纸不符", "11"),
    ("有线电视", "11"),
    ("社会治安", "11"),
    ("林业资源", "11"),
    ("其他行政事业收费", "11"),
    ("经营性收费", "11"),
    ("食品安全与卫生", "11"),
    ("体育活动", "11"),
    ("有线电视安装及调试维护", "11"),
    ("低保管理", "11"),
    ("劳动争议", "11"),
    ("社会福利及事务", "11"),
    ("一次供水问题", "11"),
]


c1 = (
    WordCloud()
    .add(series_name="热点分析", data_pair=data, word_size_range=[6, 66])
    .set_global_opts(
        title_opts=opts.TitleOpts(title="热点分析", title_textstyle_opts=opts.TextStyleOpts(font_size=23)),
        tooltip_opts=opts.TooltipOpts(is_show=True),
    )
)

# ---------------------------------- Wordcloud - Wordcloud_diamond ----------------------------------
from pyecharts import options as opts
from pyecharts.charts import WordCloud
from pyecharts.globals import SymbolType


words = [
    ("Sam S Club", 10000),
    ("Macys", 6181),
    ("Amy Schumer", 4386),
    ("Jurassic World", 4055),
    ("Charter Communications", 2467),
    ("Chick Fil A", 2244),
    ("Planet Fitness", 1868),
    ("Pitch Perfect", 1484),
    ("Express", 1112),
    ("Home", 865),
    ("Johnny Depp", 847),
    ("Lena Dunham", 582),
    ("Lewis Hamilton", 555),
    ("KXAN", 550),
    ("Mary Ellen Mark", 462),
    ("Farrah Abraham", 366),
    ("Rita Ora", 360),
    ("Serena Williams", 282),
    ("NCAA baseball tournament", 273),
    ("Point Break", 265),
]
c3 = (
    WordCloud()
    .add("", words, word_size_range=[20, 100], shape=SymbolType.DIAMOND)
    .set_global_opts(title_opts=opts.TitleOpts(title="WordCloud-shape-diamond"))
)

# ---------------------------------- Wordcloud - Wordcloud_custom_font_style ----------------------------------

from pyecharts import options as opts
from pyecharts.charts import WordCloud

words = [
    ("花鸟市场", 1446),
    ("汽车", 928),
    ("视频", 906),
    ("电视", 825),
    ("Lover Boy 88", 514),
    ("动漫", 486),
    ("音乐", 53),
    ("直播", 163),
    ("广播电台", 86),
    ("戏曲曲艺", 17),
    ("演出票务", 6),
    ("给陌生的你听", 1),
    ("资讯", 1437),
    ("商业财经", 422),
    ("娱乐八卦", 353),
    ("军事", 331),
    ("科技资讯", 313),
    ("社会时政", 307),
    ("时尚", 43),
    ("网络奇闻", 15),
    ("旅游出行", 438),
    ("景点类型", 957),
    ("国内游", 927),
    ("远途出行方式", 908),
    ("酒店", 693),
    ("关注景点", 611),
    ("旅游网站偏好", 512),
    ("出国游", 382),
    ("交通票务", 312),
    ("旅游方式", 187),
    ("旅游主题", 163),
    ("港澳台", 104),
    ("本地周边游", 3),
    ("小卖家", 1331),
    ("全日制学校", 941),
    ("基础教育科目", 585),
    ("考试培训", 473),
    ("语言学习", 358),
    ("留学", 246),
    ("K12课程培训", 207),
    ("艺术培训", 194),
    ("技能培训", 104),
    ("IT培训", 87),
    ("高等教育专业", 63),
    ("家教", 48),
    ("体育培训", 23),
    ("职场培训", 5),
    ("金融财经", 1328),
    ("银行", 765),
    ("股票", 452),
    ("保险", 415),
    ("贷款", 253),
    ("基金", 211),
    ("信用卡", 180),
    ("外汇", 138),
    ("P2P", 116),
    ("贵金属", 98),
    ("债券", 93),
    ("网络理财", 92),
    ("信托", 90),
    ("征信", 76),
    ("期货", 76),
    ("公积金", 40),
    ("银行理财", 36),
    ("银行业务", 30),
    ("典当", 7),
    ("海外置业", 1),
    ("汽车", 1309),
    ("汽车档次", 965),
    ("汽车品牌", 900),
    ("汽车车型", 727),
    ("购车阶段", 461),
    ("二手车", 309),
    ("汽车美容", 260),
    ("新能源汽车", 173),
    ("汽车维修", 155),
    ("租车服务", 136),
    ("车展", 121),
    ("违章查询", 76),
    ("汽车改装", 62),
    ("汽车用品", 37),
    ("路况查询", 32),
    ("汽车保险", 28),
    ("陪驾代驾", 4),
    ("网络购物", 1275),
    ("做我的猫", 1088),
    ("只想要你知道", 907),
    ("团购", 837),
    ("比价", 201),
    ("海淘", 195),
    ("移动APP购物", 179),
    ("支付方式", 119),
    ("代购", 43),
    ("体育健身", 1234),
    ("体育赛事项目", 802),
    ("运动项目", 405),
    ("体育类赛事", 337),
    ("健身项目", 199),
    ("健身房健身", 78),
    ("运动健身", 77),
    ("家庭健身", 36),
    ("健身器械", 29),
    ("办公室健身", 3),
    ("商务服务", 1201),
    ("法律咨询", 508),
    ("化工材料", 147),
    ("广告服务", 125),
    ("会计审计", 115),
    ("人员招聘", 101),
    ("印刷打印", 66),
    ("知识产权", 32),
    ("翻译", 22),
    ("安全安保", 9),
    ("公关服务", 8),
    ("商旅服务", 2),
    ("展会服务", 2),
    ("特许经营", 1),
    ("休闲爱好", 1169),
    ("收藏", 412),
    ("摄影", 393),
    ("温泉", 230),
    ("博彩彩票", 211),
    ("美术", 207),
    ("书法", 139),
    ("DIY手工", 75),
    ("舞蹈", 23),
    ("钓鱼", 21),
    ("棋牌桌游", 17),
    ("KTV", 6),
    ("密室", 5),
    ("采摘", 4),
    ("电玩", 1),
    ("真人CS", 1),
    ("轰趴", 1),
    ("家电数码", 1111),
    ("手机", 885),
    ("电脑", 543),
    ("大家电", 321),
    ("家电关注品牌", 253),
    ("网络设备", 162),
    ("摄影器材", 149),
    ("影音设备", 133),
    ("办公数码设备", 113),
    ("生活电器", 67),
    ("厨房电器", 54),
    ("智能设备", 45),
    ("个人护理电器", 22),
    ("服饰鞋包", 1047),
    ("服装", 566),
    ("饰品", 289),
    ("鞋", 184),
    ("箱包", 168),
    ("奢侈品", 137),
    ("母婴亲子", 1041),
    ("孕婴保健", 505),
    ("母婴社区", 299),
    ("早教", 103),
    ("奶粉辅食", 66),
    ("童车童床", 41),
    ("关注品牌", 271),
    ("宝宝玩乐", 30),
    ("母婴护理服务", 25),
    ("纸尿裤湿巾", 16),
    ("妈妈用品", 15),
    ("宝宝起名", 12),
    ("童装童鞋", 9),
    ("胎教", 8),
    ("宝宝安全", 1),
    ("宝宝洗护用品", 1),
    ("软件应用", 1018),
    ("系统工具", 896),
    ("理财购物", 440),
    ("生活实用", 365),
    ("影音图像", 256),
    ("社交通讯", 214),
    ("手机美化", 39),
    ("办公学习", 28),
    ("应用市场", 23),
    ("母婴育儿", 14),
    ("游戏", 946),
    ("手机游戏", 565),
    ("PC游戏", 353),
    ("网页游戏", 254),
    ("游戏机", 188),
    ("模拟辅助", 166),
    ("个护美容", 942),
    ("护肤品", 177),
    ("彩妆", 133),
    ("美发", 80),
    ("香水", 50),
    ("个人护理", 46),
    ("美甲", 26),
    ("SPA美体", 21),
    ("花鸟萌宠", 914),
    ("绿植花卉", 311),
    ("狗", 257),
    ("其他宠物", 131),
    ("水族", 125),
    ("猫", 122),
    ("动物", 81),
    ("鸟", 67),
    ("宠物用品", 41),
    ("宠物服务", 26),
    ("书籍阅读", 913),
    ("网络小说", 483),
    ("关注书籍", 128),
    ("文学", 105),
    ("报刊杂志", 77),
    ("人文社科", 22),
    ("建材家居", 907),
    ("装修建材", 644),
    ("家具", 273),
    ("家居风格", 187),
    ("家居家装关注品牌", 140),
    ("家纺", 107),
    ("厨具", 47),
    ("灯具", 43),
    ("家居饰品", 29),
    ("家居日常用品", 10),
    ("生活服务", 883),
    ("物流配送", 536),
    ("家政服务", 108),
    ("摄影服务", 49),
    ("搬家服务", 38),
    ("物业维修", 37),
    ("婚庆服务", 24),
    ("二手回收", 24),
    ("鲜花配送", 3),
    ("维修服务", 3),
    ("殡葬服务", 1),
    ("求职创业", 874),
    ("创业", 363),
    ("目标职位", 162),
    ("目标行业", 50),
    ("兼职", 21),
    ("期望年薪", 20),
    ("实习", 16),
    ("雇主类型", 10),
    ("星座运势", 789),
    ("星座", 316),
    ("算命", 303),
    ("解梦", 196),
    ("风水", 93),
    ("面相分析", 47),
    ("手相", 32),
    ("公益", 90),
]

c4 = (
    WordCloud()
    .add(
        "",
        words,
        word_size_range=[20, 100],
        textstyle_opts=opts.TextStyleOpts(font_family="cursive"),
    )
    .set_global_opts(title_opts=opts.TitleOpts(title="WordCloud-自定义文字样式"))
)

import swanlab

swanlab.init(project="echarts-test", experiment_name="wordcloud", public=True)

swanlab.log(
    {
        # 'wordcloud-1': c,
        'wordcloud-2': c1,
        'wordcloud-3': c3,
        'wordcloud-4': c4,
    }
)
