"""
Shared setup, constants, and imports for all E2E tests.
"""
import os
import sys

# --- PATH SETUP ---
# Ensure the SDK source is in the Python path
_current_dir = os.path.dirname(os.path.abspath(__file__))
_src_path = os.path.abspath(os.path.join(_current_dir, '..', 'src'))
if _src_path not in sys.path:
    sys.path.insert(0, _src_path)

# --- ENVIRONMENT CONFIGURATION ---
os.environ.setdefault('SPHERE_BACKEND_BASE_URL', "http://localhost:8080")

# --- SDK IMPORTS ---
# Centralized import with error handling
try:
    from sphere_sdk.sphere_client import (
        SphereTradingClientSDK,
        SDKInitializationError,
        LoginFailedError,
        TradeOrderFailedError,
        GetInstrumentsFailedError,
        GetExpiriesFailedError,
        GetBrokersFailedError,
        GetClearingOptionsFailedError,
        TradingClientError,
        NotLoggedInError,
        CreateOrderFailedError,
        CancelOrderFailedError,
        UpdateOrderFailedError
    )
    from sphere_sdk import sphere_sdk_types_pb2
except ImportError as e:
    print(f"CRITICAL: Failed to import Sphere SDK components. "
          f"Ensure 'Client/PythonSdk/src/' is in sys.path (attempted: '{_src_path}'), "
          f"that 'Client/PythonSdk/src/sphere_sdk/' is a Python package (contains __init__.py), "
          f"and all dependencies like 'sphere_sdk_types_pb2.py' are present in 'sphere_sdk/'. Error: {e}",
          file=sys.stderr)
    sys.exit(1)

# --- SHARED CONSTANTS ---
VALID_USERNAME = os.environ.get("SPHERE_E2E_USERNAME", "testuser@onsphere.com")
VALID_PASSWORD = os.environ.get("SPHERE_E2E_PASSWORD", "p@ssw\"rd\\123")
INVALID_PASSWORD = "wrong_password_for_e2e_test"
INVALID_USERNAME = "nonexistentuser_for_e2e_test@example.com"