import os
from unittest import mock

from cumulusci.tasks.salesforce import UninstallLocalBundles
from cumulusci.utils import temporary_dir

from .util import create_task


class TestUninstallLocalBundles:
    def test_run_task(self):
        with temporary_dir() as path:
            os.mkdir("bundle")
            with open(os.path.join(path, "file"), "w"):
                pass
            task = create_task(UninstallLocalBundles, {"path": path})
            task._get_api = mock.Mock()
            task()
            task._get_api.assert_called_once()
