"""Auto-generated by generate.sh script."""

# generated by datamodel-codegen:
#   filename:  openapi.json
#   timestamp: 2025-07-10T20:02:21+00:00

from __future__ import annotations

from datetime import datetime
from typing import Dict, List, Optional, Union

from pydantic import BaseModel, Field


class APIKey(BaseModel):
    id: str = Field(..., title="Id")
    user_id: str = Field(..., title="User Id")
    name: str = Field(..., title="Name")
    key_hash: str = Field(..., title="Key Hash")
    permissions: List[str] = Field(..., title="Permissions")
    email: str = Field(..., title="Email")
    email_verified: bool = Field(..., title="Email Verified")
    created_at: datetime = Field(..., title="Created At")
    last_used_at: Optional[datetime] = Field(None, title="Last Used At")
    expires_at: Optional[datetime] = Field(None, title="Expires At")
    is_active: Optional[bool] = Field(True, title="Is Active")


class APIKeyRequest(BaseModel):
    num_hours: Optional[int] = Field(24, title="Num Hours")


class APIKeyResponse(BaseModel):
    api_key: str = Field(..., title="Api Key")


class APIKeySummaryResponse(BaseModel):
    id: str = Field(..., title="Id")
    name: str = Field(..., title="Name")
    permissions: List[str] = Field(..., title="Permissions")
    created_at: datetime = Field(..., title="Created At")
    last_used_at: Optional[datetime] = Field(..., title="Last Used At")
    expires_at: Optional[datetime] = Field(..., title="Expires At")
    is_active: bool = Field(..., title="Is Active")


class ActuatorMetadataInput(BaseModel):
    actuator_type: Optional[str] = Field(None, title="Actuator Type")
    sysid: Optional[str] = Field(None, title="Sysid")
    max_torque: Optional[Union[float, str]] = Field(None, title="Max Torque")
    armature: Optional[Union[float, str]] = Field(None, title="Armature")
    damping: Optional[Union[float, str]] = Field(None, title="Damping")
    frictionloss: Optional[Union[float, str]] = Field(None, title="Frictionloss")
    vin: Optional[Union[float, str]] = Field(None, title="Vin")
    kt: Optional[Union[float, str]] = Field(None, title="Kt")
    R: Optional[Union[float, str]] = Field(None, title="R")
    vmax: Optional[Union[float, str]] = Field(None, title="Vmax")
    amax: Optional[Union[float, str]] = Field(None, title="Amax")
    max_velocity: Optional[Union[float, str]] = Field(None, title="Max Velocity")
    max_pwm: Optional[Union[float, str]] = Field(None, title="Max Pwm")
    error_gain: Optional[Union[float, str]] = Field(None, title="Error Gain")


class ActuatorMetadataOutput(BaseModel):
    actuator_type: Optional[str] = Field(None, title="Actuator Type")
    sysid: Optional[str] = Field(None, title="Sysid")
    max_torque: Optional[str] = Field(None, title="Max Torque")
    armature: Optional[str] = Field(None, title="Armature")
    damping: Optional[str] = Field(None, title="Damping")
    frictionloss: Optional[str] = Field(None, title="Frictionloss")
    vin: Optional[str] = Field(None, title="Vin")
    kt: Optional[str] = Field(None, title="Kt")
    R: Optional[str] = Field(None, title="R")
    vmax: Optional[str] = Field(None, title="Vmax")
    amax: Optional[str] = Field(None, title="Amax")
    max_velocity: Optional[str] = Field(None, title="Max Velocity")
    max_pwm: Optional[str] = Field(None, title="Max Pwm")
    error_gain: Optional[str] = Field(None, title="Error Gain")


class AddRobotClassRequest(BaseModel):
    description: Optional[str] = Field(None, title="Description")


class AddRobotRequest(BaseModel):
    description: Optional[str] = Field(None, title="Description")
    class_name: str = Field(..., title="Class Name")


class Agent(BaseModel):
    id: str = Field(..., title="Id")
    user_id: str = Field(..., title="User Id")
    upload_time: str = Field(..., title="Upload Time")
    description: Optional[str] = Field(None, title="Description")
    num_downloads: Optional[int] = Field(0, title="Num Downloads")


class AgentDownloadResponse(BaseModel):
    url: str = Field(..., title="Url")
    md5_hash: str = Field(..., title="Md5 Hash")


class AgentUploadRequest(BaseModel):
    filename: str = Field(..., title="Filename")
    content_type: str = Field(..., title="Content Type")


class AgentUploadResponse(BaseModel):
    url: str = Field(..., title="Url")
    filename: str = Field(..., title="Filename")
    content_type: str = Field(..., title="Content Type")


class CreateAPIKeyRequest(BaseModel):
    name: str = Field(..., title="Name")
    permissions: List[str] = Field(..., title="Permissions")
    expires_at: Optional[datetime] = Field(None, title="Expires At")


class CreateAPIKeyResponse(BaseModel):
    api_key: APIKey
    plain_key: str = Field(..., title="Plain Key")


class CreateAgentRequest(BaseModel):
    description: Optional[str] = Field(None, title="Description")


class JointMetadataInput(BaseModel):
    id: Optional[int] = Field(None, title="Id")
    kp: Optional[Union[float, str]] = Field(None, title="Kp")
    kd: Optional[Union[float, str]] = Field(None, title="Kd")
    armature: Optional[Union[float, str]] = Field(None, title="Armature")
    friction: Optional[Union[float, str]] = Field(None, title="Friction")
    offset: Optional[Union[float, str]] = Field(None, title="Offset")
    flipped: Optional[bool] = Field(None, title="Flipped")
    actuator_type: Optional[str] = Field(None, title="Actuator Type")
    nn_id: Optional[int] = Field(None, title="Nn Id")
    soft_torque_limit: Optional[Union[float, str]] = Field(None, title="Soft Torque Limit")
    min_angle_deg: Optional[Union[float, str]] = Field(None, title="Min Angle Deg")
    max_angle_deg: Optional[Union[float, str]] = Field(None, title="Max Angle Deg")


class JointMetadataOutput(BaseModel):
    id: Optional[int] = Field(None, title="Id")
    kp: Optional[str] = Field(None, title="Kp")
    kd: Optional[str] = Field(None, title="Kd")
    armature: Optional[str] = Field(None, title="Armature")
    friction: Optional[str] = Field(None, title="Friction")
    offset: Optional[str] = Field(None, title="Offset")
    flipped: Optional[bool] = Field(None, title="Flipped")
    actuator_type: Optional[str] = Field(None, title="Actuator Type")
    nn_id: Optional[int] = Field(None, title="Nn Id")
    soft_torque_limit: Optional[str] = Field(None, title="Soft Torque Limit")
    min_angle_deg: Optional[str] = Field(None, title="Min Angle Deg")
    max_angle_deg: Optional[str] = Field(None, title="Max Angle Deg")


class OIDCInfo(BaseModel):
    authority: str = Field(..., title="Authority")
    client_id: str = Field(..., title="Client Id")


class Robot(BaseModel):
    id: str = Field(..., title="Id")
    robot_name: str = Field(..., title="Robot Name")
    description: str = Field(..., title="Description")
    user_id: str = Field(..., title="User Id")
    class_id: str = Field(..., title="Class Id")


class RobotDownloadURDFResponse(BaseModel):
    url: str = Field(..., title="Url")
    md5_hash: str = Field(..., title="Md5 Hash")


class RobotResponse(BaseModel):
    id: str = Field(..., title="Id")
    robot_name: str = Field(..., title="Robot Name")
    description: str = Field(..., title="Description")
    user_id: str = Field(..., title="User Id")
    class_name: str = Field(..., title="Class Name")


class RobotURDFMetadataInput(BaseModel):
    joint_name_to_metadata: Optional[Dict[str, JointMetadataInput]] = Field(None, title="Joint Name To Metadata")
    actuator_type_to_metadata: Optional[Dict[str, ActuatorMetadataInput]] = Field(
        None, title="Actuator Type To Metadata"
    )
    control_frequency: Optional[Union[float, str]] = Field(None, title="Control Frequency")


class RobotURDFMetadataOutput(BaseModel):
    joint_name_to_metadata: Optional[Dict[str, JointMetadataOutput]] = Field(None, title="Joint Name To Metadata")
    actuator_type_to_metadata: Optional[Dict[str, ActuatorMetadataOutput]] = Field(
        None, title="Actuator Type To Metadata"
    )
    control_frequency: Optional[str] = Field(None, title="Control Frequency")


class RobotUploadURDFRequest(BaseModel):
    filename: str = Field(..., title="Filename")
    content_type: str = Field(..., title="Content Type")


class RobotUploadURDFResponse(BaseModel):
    url: str = Field(..., title="Url")
    filename: str = Field(..., title="Filename")
    content_type: str = Field(..., title="Content Type")


class UpdateAPIKeyPermissionsRequest(BaseModel):
    permissions: List[str] = Field(..., title="Permissions")


class UpdateAgentRequest(BaseModel):
    description: Optional[str] = Field(None, title="Description")


class UpdateRobotClassRequest(BaseModel):
    new_class_name: Optional[str] = Field(None, title="New Class Name")
    new_description: Optional[str] = Field(None, title="New Description")
    new_metadata: Optional[RobotURDFMetadataInput] = None


class UpdateRobotRequest(BaseModel):
    new_robot_name: Optional[str] = Field(None, title="New Robot Name")
    new_description: Optional[str] = Field(None, title="New Description")


class UserResponse(BaseModel):
    user_id: str = Field(..., title="User Id")
    is_admin: bool = Field(..., title="Is Admin")
    can_upload: bool = Field(..., title="Can Upload")
    can_test: bool = Field(..., title="Can Test")


class ValidationError(BaseModel):
    loc: List[Union[str, int]] = Field(..., title="Location")
    msg: str = Field(..., title="Message")
    type: str = Field(..., title="Error Type")


class HTTPValidationError(BaseModel):
    detail: Optional[List[ValidationError]] = Field(None, title="Detail")


class ProfileResponse(BaseModel):
    email: str = Field(..., title="Email")
    email_verified: bool = Field(..., title="Email Verified")
    user: UserResponse


class RobotClass(BaseModel):
    id: str = Field(..., title="Id")
    class_name: str = Field(..., title="Class Name")
    description: str = Field(..., title="Description")
    user_id: str = Field(..., title="User Id")
    metadata: Optional[RobotURDFMetadataOutput] = None
    num_downloads: Optional[int] = Field(0, title="Num Downloads")
