# Документ требований

## Введение

Эта функция обеспечивает простую и современную дистрибуцию CLI инструмента `aa` через PyPI под именем `aa-cli`. Пользователи смогут запускать инструмент через `uvx aa-cli` без установки, или установить глобально через `uv tool install aa-cli`.

## Глоссарий

- **CLI Инструмент**: Консольное приложение `aa-cli` для управления ID задач в Asana
- **PyPI**: Python Package Index - официальный репозиторий Python пакетов
- **uvx**: Команда UV для запуска Python приложений без установки
- **uv tool**: Команда UV для установки Python CLI инструментов глобально

- **Package Name**: Имя пакета на PyPI (`aa-cli`)
- **Command Name**: Имя команды в терминале (`aa-cli`)
- **pyproject.toml**: Файл конфигурации Python проекта (PEP 621)

## Требования

### Требование 1

**Пользовательская история:** Как пользователь, я хочу запустить aa через uvx без установки, чтобы быстро попробовать инструмент или использовать его разово.

#### Критерии приемки

1. WHEN пользователь выполняет `uvx aa-cli --version` THEN Система SHALL скачать пакет из PyPI и вывести версию
2. WHEN пользователь выполняет `uvx aa-cli init` THEN Система SHALL создать конфигурационный файл
3. WHEN пользователь выполняет `uvx aa-cli` с любыми аргументами THEN Система SHALL выполнить команду без требования предварительной установки
4. WHEN uvx скачивает пакет THEN Система SHALL кешировать его для последующих запусков
5. WHEN пользователь запускает команду повторно THEN Система SHALL использовать кешированную версию для быстрого старта

### Требование 2

**Пользовательская история:** Как постоянный пользователь, я хочу установить aa-cli глобально, чтобы не указывать uvx каждый раз.

#### Критерии приемки

1. WHEN пользователь выполняет `uv tool install aa-cli` THEN Система SHALL установить пакет глобально
2. WHEN установка завершена THEN Команда `aa-cli` SHALL быть доступна в PATH пользователя
3. WHEN пользователь выполняет `aa-cli --version` THEN Система SHALL вывести версию без префикса uvx
4. WHEN пользователь выполняет `uv tool upgrade aa-cli` THEN Система SHALL обновить до последней версии
5. WHEN пользователь выполняет `uv tool uninstall aa-cli` THEN Система SHALL удалить инструмент

### Требование 3

**Пользовательская история:** Как разработчик, я хочу опубликовать пакет на PyPI под безопасным именем, чтобы избежать проблем с trademark и сделать установку простой.

#### Критерии приемки

1. WHEN пакет публикуется на PyPI THEN Имя пакета SHALL быть `aa-cli`
2. WHEN пакет публикуется THEN Команда в терминале SHALL быть `aa-cli`
3. WHEN пакет публикуется THEN Файл pyproject.toml SHALL содержать `name = "aa-cli"` и `[project.scripts] aa-cli = "aa.cli:main"`
4. WHEN пакет публикуется THEN Описание SHALL четко указывать что это инструмент для Asana
5. WHEN пакет публикуется THEN Метаданные SHALL включать ссылку на GitHub репозиторий

### Требование 4

**Пользовательская история:** Как разработчик, я хочу чтобы процесс публикации на PyPI был автоматизирован, чтобы не делать это вручную при каждом релизе.

#### Критерии приемки

1. WHEN разработчик пушит тег соответствующий паттерну `v*` THEN GitHub Actions SHALL автоматически запустить workflow публикации
2. WHEN workflow публикации запускается THEN Система SHALL собрать пакет используя `uv build`
3. WHEN пакет собран THEN Система SHALL опубликовать его на PyPI используя API token
4. WHEN публикация завершена THEN Система SHALL создать GitHub Release с release notes
5. IF публикация на PyPI падает THEN Система SHALL сообщить об ошибке и не создавать GitHub Release

### Требование 5

**Пользовательская история:** Как пользователь, я хочу четкие инструкции по установке в README, чтобы быстро понять как начать использовать инструмент.

#### Критерии приемки

1. WHEN пользователь просматривает README THEN Документация SHALL показывать команду `uvx aa-cli` как основной способ запуска
2. WHEN пользователь просматривает README THEN Документация SHALL показывать команду `uv tool install aa-cli` для постоянной установки
3. WHEN пользователь просматривает README THEN Документация SHALL включать примеры основных команд
4. WHEN пользователь просматривает README THEN Документация SHALL объяснять разницу между `uvx` (временный запуск) и `uv tool install` (постоянная установка)
5. WHEN пользователь просматривает README THEN Документация SHALL включать ссылку на установку UV для новых пользователей

### Требование 6

**Пользовательская история:** Как разработчик, я хочу чтобы структура проекта соответствовала стандартам Python packaging, чтобы пакет корректно работал с современными инструментами.

#### Критерии приемки

1. WHEN проект настроен THEN Файл pyproject.toml SHALL использовать формат PEP 621
2. WHEN проект настроен THEN Build system SHALL использовать hatchling
3. WHEN проект настроен THEN Секция `[project.scripts]` SHALL определять команду `aa`
4. WHEN проект настроен THEN Все зависимости SHALL быть указаны в `dependencies`
5. WHEN проект настроен THEN Версия SHALL управляться через `version` поле в pyproject.toml

### Требование 7

**Пользовательская история:** Как разработчик, я хочу четкую структуру репозитория, чтобы понимать где что находится.

#### Критерии приемки

1. WHEN система настроена THEN Репозиторий SHALL находиться по адресу `https://github.com/umaxfun/aa`
2. WHEN система настроена THEN Локальный путь к репозиторию SHALL быть `/Users/umaxfun/prj/aa`
3. WHEN пакет публикуется на PyPI THEN Он SHALL быть доступен по адресу `https://pypi.org/project/aa-cli/`
4. WHEN проект структурирован THEN Исходный код SHALL находиться в директории `aa/`
5. WHEN проект структурирован THEN GitHub Actions workflows SHALL находиться в `.github/workflows/`

### Требование 8

**Пользовательская история:** Как разработчик, я хочу понимать полную схему работы релиза, чтобы эффективно поддерживать систему дистрибуции.

#### Критерии приемки

1. WHEN разработчик создает и пушит тег `v0.1.0` THEN GitHub Actions SHALL автоматически собрать и опубликовать пакет на PyPI
2. WHEN пакет опубликован на PyPI THEN Пользователи SHALL немедленно получить доступ через `uvx aa-cli`
3. WHEN новая версия доступна на PyPI THEN Пользователи SHALL автоматически получить её при следующем запуске `uvx aa-cli`
4. WHEN пользователь установил через `uv tool install` THEN Он SHALL обновить через `uv tool upgrade aa-cli`
5. WHEN любой метод установки используется THEN Пользователь SHALL получить идентичный функционал

### Требование 9

**Пользовательская история:** Как пользователь, я хочу чтобы инструмент работал на всех основных платформах, чтобы использовать его независимо от операционной системы.

#### Критерии приемки

1. WHEN пакет установлен на Linux THEN Все функции SHALL работать корректно
2. WHEN пакет установлен на macOS THEN Все функции SHALL работать корректно
3. WHEN пакет установлен на Windows THEN Все функции SHALL работать корректно
4. WHEN пакет использует зависимости THEN Они SHALL быть pure Python или иметь wheels для всех платформ
5. WHEN пакет запускается THEN Он SHALL требовать Python 3.12 или выше
