# План реализации

- [x] 1. Подготовить проект для публикации на PyPI
  - Обновить `pyproject.toml`: изменить `name` на `"aa-cli"`
  - Убедиться что `[project.scripts]` содержит `aa = "aa.cli:main"`
  - Добавить метаданные: description, homepage, repository
  - Проверить что все зависимости указаны в `dependencies`
  - Локально собрать пакет: `uv build`
  - Проверить что в `dist/` появились файлы `.tar.gz` и `.whl`
  - _Requirements: 3.1, 3.2, 3.3, 6.1, 6.2, 6.3, 6.4, 6.5_

- [x] 2. Протестировать локальную установку
  - Установить локально: `uv tool install dist/aa_cli-0.1.0-py3-none-any.whl`
  - Запустить `aa --version` и проверить вывод
  - Запустить `aa init` и проверить что создается `.aa.yml`
  - Запустить `aa --help` и проверить список команд
  - Удалить: `uv tool uninstall aa-cli`
  - _Requirements: 2.1, 2.2, 2.3_

- [x] 3. Создать GitHub Actions workflow для публикации
  - Создать файл `.github/workflows/publish.yml`
  - Настроить триггер на теги `v*`
  - Добавить шаги: checkout, setup python, install uv
  - Добавить шаг сборки: `uv build`
  - Добавить шаг публикации: `uv publish` (с PYPI_TOKEN)
  - Добавить шаг создания GitHub Release
  - _Requirements: 4.1, 4.2, 4.3, 4.4_

- [x] 4. Настроить PyPI токен в GitHub Secrets
  - Зарегистрироваться на PyPI (если еще нет аккаунта)
  - Создать API token на PyPI
  - Добавить токен в GitHub Secrets как `PYPI_TOKEN`
  - Проверить что секрет доступен в workflow
  - _Requirements: 4.3_

- [x] 5. Создать тестовый релиз
  - Обновить версию в `pyproject.toml` на `0.1.0`
  - Закоммитить изменения
  - Создать тег: `git tag v0.1.0`
  - Запушить тег: `git push origin v0.1.0`
  - Проверить что GitHub Actions workflow запустился
  - Проверить что workflow завершился успешно
  - Проверить что пакет появился на PyPI: https://pypi.org/project/aa-cli/
  - Проверить что GitHub Release создан
  - _Requirements: 4.1, 4.5, 8.1, 8.2_

- [x] 6. Протестировать установку из PyPI
  - Запустить `uvx aa-cli --version` и проверить вывод
  - Запустить `uvx aa-cli init` и проверить что создается конфиг
  - Запустить `uvx aa-cli --help` и проверить список команд
  - Установить глобально: `uv tool install aa-cli`
  - Запустить `aa --version` без префикса uvx
  - Удалить: `uv tool uninstall aa-cli`
  - _Requirements: 1.1, 1.2, 1.3, 2.1, 2.2, 2.3, 8.2_

- [ ] 7. Обновить README с инструкциями по установке
  - Добавить секцию "Installation"
  - Показать команду `uvx aa-cli` как основной способ
  - Показать команду `uv tool install aa-cli` для постоянной установки
  - Объяснить разницу между uvx и uv tool
  - Добавить ссылку на установку UV: https://docs.astral.sh/uv/
  - Добавить примеры основных команд
  - Проверить что все команды в README работают
  - _Requirements: 5.1, 5.2, 5.3, 5.4, 5.5_

- [ ] 8. Протестировать на разных платформах
  - Протестировать на macOS (текущая система)
  - Протестировать на Linux (через Docker или VM)
  - Протестировать на Windows (через VM или WSL)
  - Убедиться что `uvx aa-cli` работает на всех платформах
  - Убедиться что все команды работают идентично
  - _Requirements: 9.1, 9.2, 9.3, 9.4, 9.5_

- [ ] 9. Протестировать процесс обновления
  - Создать новую версию `0.1.1` с небольшим изменением
  - Создать и запушить тег `v0.1.1`
  - Проверить что новая версия появилась на PyPI
  - Запустить `uvx aa-cli --version` и проверить что используется новая версия
  - Для установленного через `uv tool`: запустить `uv tool upgrade aa-cli`
  - Проверить что версия обновилась
  - _Requirements: 8.3, 8.4_

- [ ] 10. Финальная проверка
  - Убедиться что все команды из README работают
  - Убедиться что `uvx aa-cli` работает без установки
  - Убедиться что `uv tool install aa-cli` устанавливает команду `aa`
  - Убедиться что пакет доступен на PyPI
  - Убедиться что GitHub Releases содержат все версии
  - Убедиться что документация актуальна
  - _Requirements: все_
