# Правила для спецификаций

## Дизайн документ (design.md)

### Что ДОЛЖНО быть в дизайне:
- Архитектурные принципы и решения
- Описание компонентов и их взаимодействия
- Структуры данных и модели
- Correctness Properties для тестирования
- Стратегия обработки ошибок
- Общая стратегия тестирования

### Что НЕ ДОЛЖНО быть в дизайне:
- ❌ Большие куски финального кода
- ❌ Детальная реализация функций
- ❌ Конкретные имена переменных
- ❌ Полные листинги кода

### Принцип:
Дизайн должен содержать **очень точные принципы**, а не готовый код. Код пишется на этапе выполнения задач.

## Список задач (tasks.md)

### Критерий завершения задачи:
**ОБЯЗАТЕЛЬНО**: Каждая задача должна быть **финально проверяемая пользователем**.

### Что это значит:
- ✅ Пользователь может запустить команду и увидеть результат
- ✅ Пользователь может проверить что файл создан и содержит нужное
- ✅ Пользователь может протестировать функционал вручную
- ✅ Пользователь может увидеть что workflow запустился и прошел

### Что НЕ является достаточным:
- ❌ "Юнит-тесты прошли" - недостаточно
- ❌ "Код скомпилировался" - недостаточно
- ❌ "Синтетические тесты зеленые" - недостаточно

### Примеры правильных критериев приемки:

**Плохо ❌:**
```markdown
- [ ] 1. Создать GitHub Actions workflow
  - Написать .github/workflows/release.yml
  - Добавить matrix build
  - Юнит-тесты должны пройти
```

**Хорошо ✅:**
```markdown
- [ ] 1. Создать GitHub Actions workflow для сборки бинарников
  - Создать .github/workflows/release.yml с matrix build
  - Запушить тестовый тег и убедиться что workflow запустился
  - Проверить что в GitHub Releases появились все 5 бинарников
  - Скачать и запустить бинарник для своей платформы
  - Убедиться что `aa --version` работает
```

### Правило:
Задача считается выполненной только когда **пользователь может физически проверить** что функционал работает, а не только когда тесты зеленые.

## Тестирование

### Роль тестов:
- Тесты (unit, property-based, integration) - это **инструмент разработки**
- Тесты помогают убедиться что код работает правильно
- Но тесты **не заменяют** финальную проверку пользователем

### Workflow:
1. Разработчик пишет код
2. Разработчик пишет тесты
3. Тесты проходят ✅
4. **Пользователь проверяет функционал вручную** ✅✅
5. Только после этого задача считается выполненной

## Примеры

### Задача: Создать Homebrew formula

**Критерии приемки:**
- ✅ Создан репозиторий `homebrew-aa`
- ✅ Создан файл `Formula/aa.rb`
- ✅ Выполнена команда `brew tap umaxfun/aa` локально
- ✅ Выполнена команда `brew install aa` локально
- ✅ Команда `aa --version` работает после установки
- ✅ Команда `aa init` создает конфиг файл

### Задача: Настроить PyInstaller

**Критерии приемки:**
- ✅ Создан файл `aa.spec`
- ✅ Выполнена команда `pyinstaller aa.spec` локально
- ✅ Бинарник создан в `dist/aa`
- ✅ Запущен `./dist/aa --version` и вывод корректный
- ✅ Запущен `./dist/aa init` и конфиг создается
- ✅ Размер бинарника разумный (< 50MB)
