# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ExtensionArgs', 'Extension']

@pulumi.input_type
class ExtensionArgs:
    def __init__(__self__, *,
                 extension_objects: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 extension_schema: pulumi.Input[_builtins.str],
                 config: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_url: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Extension resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] extension_objects: This is the objects for which the extension applies (An array of service ids).
        :param pulumi.Input[_builtins.str] extension_schema: This is the schema for this extension.
        :param pulumi.Input[_builtins.str] config: The configuration of the service extension as string containing plain JSON-encoded data.
        :param pulumi.Input[_builtins.str] endpoint_url: The url of the extension.
               **Note:** The [endpoint URL is Optional API wise](https://api-reference.pagerduty.com/#!/Extensions/post_extensions) in most cases. But in some cases it is a _Required_ parameter. For example, `get_extension_schema` named `Generic V2 Webhook` doesn't accept `Extension` with no `endpoint_url`, but one with named `Slack` accepts.
        :param pulumi.Input[_builtins.str] name: The name of the service extension.
        """
        pulumi.set(__self__, "extension_objects", extension_objects)
        pulumi.set(__self__, "extension_schema", extension_schema)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if endpoint_url is not None:
            pulumi.set(__self__, "endpoint_url", endpoint_url)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="extensionObjects")
    def extension_objects(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        This is the objects for which the extension applies (An array of service ids).
        """
        return pulumi.get(self, "extension_objects")

    @extension_objects.setter
    def extension_objects(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "extension_objects", value)

    @_builtins.property
    @pulumi.getter(name="extensionSchema")
    def extension_schema(self) -> pulumi.Input[_builtins.str]:
        """
        This is the schema for this extension.
        """
        return pulumi.get(self, "extension_schema")

    @extension_schema.setter
    def extension_schema(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "extension_schema", value)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The configuration of the service extension as string containing plain JSON-encoded data.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter(name="endpointUrl")
    def endpoint_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The url of the extension.
        **Note:** The [endpoint URL is Optional API wise](https://api-reference.pagerduty.com/#!/Extensions/post_extensions) in most cases. But in some cases it is a _Required_ parameter. For example, `get_extension_schema` named `Generic V2 Webhook` doesn't accept `Extension` with no `endpoint_url`, but one with named `Slack` accepts.
        """
        return pulumi.get(self, "endpoint_url")

    @endpoint_url.setter
    def endpoint_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint_url", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the service extension.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _ExtensionState:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_url: Optional[pulumi.Input[_builtins.str]] = None,
                 extension_objects: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 extension_schema: Optional[pulumi.Input[_builtins.str]] = None,
                 html_url: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 summary: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Extension resources.
        :param pulumi.Input[_builtins.str] config: The configuration of the service extension as string containing plain JSON-encoded data.
        :param pulumi.Input[_builtins.str] endpoint_url: The url of the extension.
               **Note:** The [endpoint URL is Optional API wise](https://api-reference.pagerduty.com/#!/Extensions/post_extensions) in most cases. But in some cases it is a _Required_ parameter. For example, `get_extension_schema` named `Generic V2 Webhook` doesn't accept `Extension` with no `endpoint_url`, but one with named `Slack` accepts.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] extension_objects: This is the objects for which the extension applies (An array of service ids).
        :param pulumi.Input[_builtins.str] extension_schema: This is the schema for this extension.
        :param pulumi.Input[_builtins.str] html_url: URL at which the entity is uniquely displayed in the Web app
        :param pulumi.Input[_builtins.str] name: The name of the service extension.
        :param pulumi.Input[_builtins.str] summary: A short-form, server-generated string that provides succinct, important information about an object suitable for primary labeling of an entity in a client. In many cases, this will be identical to `name`, though it is not intended to be an identifier.
               
               **Note:** You can use the `get_extension_schema` data source to locate the appropriate extension vendor ID.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if endpoint_url is not None:
            pulumi.set(__self__, "endpoint_url", endpoint_url)
        if extension_objects is not None:
            pulumi.set(__self__, "extension_objects", extension_objects)
        if extension_schema is not None:
            pulumi.set(__self__, "extension_schema", extension_schema)
        if html_url is not None:
            pulumi.set(__self__, "html_url", html_url)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if summary is not None:
            pulumi.set(__self__, "summary", summary)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The configuration of the service extension as string containing plain JSON-encoded data.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter(name="endpointUrl")
    def endpoint_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The url of the extension.
        **Note:** The [endpoint URL is Optional API wise](https://api-reference.pagerduty.com/#!/Extensions/post_extensions) in most cases. But in some cases it is a _Required_ parameter. For example, `get_extension_schema` named `Generic V2 Webhook` doesn't accept `Extension` with no `endpoint_url`, but one with named `Slack` accepts.
        """
        return pulumi.get(self, "endpoint_url")

    @endpoint_url.setter
    def endpoint_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint_url", value)

    @_builtins.property
    @pulumi.getter(name="extensionObjects")
    def extension_objects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        This is the objects for which the extension applies (An array of service ids).
        """
        return pulumi.get(self, "extension_objects")

    @extension_objects.setter
    def extension_objects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "extension_objects", value)

    @_builtins.property
    @pulumi.getter(name="extensionSchema")
    def extension_schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This is the schema for this extension.
        """
        return pulumi.get(self, "extension_schema")

    @extension_schema.setter
    def extension_schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "extension_schema", value)

    @_builtins.property
    @pulumi.getter(name="htmlUrl")
    def html_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL at which the entity is uniquely displayed in the Web app
        """
        return pulumi.get(self, "html_url")

    @html_url.setter
    def html_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "html_url", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the service extension.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def summary(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A short-form, server-generated string that provides succinct, important information about an object suitable for primary labeling of an entity in a client. In many cases, this will be identical to `name`, though it is not intended to be an identifier.

        **Note:** You can use the `get_extension_schema` data source to locate the appropriate extension vendor ID.
        """
        return pulumi.get(self, "summary")

    @summary.setter
    def summary(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "summary", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("pagerduty:index/extension:Extension")
class Extension(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_url: Optional[pulumi.Input[_builtins.str]] = None,
                 extension_objects: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 extension_schema: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        An [extension](https://developer.pagerduty.com/api-reference/b3A6Mjc0ODEzMw-create-an-extension) can be associated with a service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_pagerduty as pagerduty

        webhook = pagerduty.get_extension_schema(name="Generic V2 Webhook")
        example = pagerduty.User("example",
            name="Howard James",
            email="howard.james@example.domain")
        example_escalation_policy = pagerduty.EscalationPolicy("example",
            name="Engineering Escalation Policy",
            num_loops=2,
            rules=[{
                "escalation_delay_in_minutes": 10,
                "targets": [{
                    "type": "user",
                    "id": example.id,
                }],
            }])
        example_service = pagerduty.Service("example",
            name="My Web App",
            auto_resolve_timeout="14400",
            acknowledgement_timeout="600",
            escalation_policy=example_escalation_policy.id)
        slack = pagerduty.Extension("slack",
            name="My Web App Extension",
            endpoint_url="https://generic_webhook_url/XXXXXX/BBBBBB",
            extension_schema=webhook.id,
            extension_objects=[example_service.id],
            config=\"\"\"{
        \\x09"restrict": "any",
        \\x09"notify_types": {
        \\x09\\x09\\x09"resolve": false,
        \\x09\\x09\\x09"acknowledge": false,
        \\x09\\x09\\x09"assignments": false
        \\x09},
        \\x09"access_token": "XXX"
        }
        \"\"\")
        ```

        ## Import

        Extensions can be imported using the id.e.g.

        ```sh
        $ pulumi import pagerduty:index/extension:Extension main PLBP09X
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] config: The configuration of the service extension as string containing plain JSON-encoded data.
        :param pulumi.Input[_builtins.str] endpoint_url: The url of the extension.
               **Note:** The [endpoint URL is Optional API wise](https://api-reference.pagerduty.com/#!/Extensions/post_extensions) in most cases. But in some cases it is a _Required_ parameter. For example, `get_extension_schema` named `Generic V2 Webhook` doesn't accept `Extension` with no `endpoint_url`, but one with named `Slack` accepts.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] extension_objects: This is the objects for which the extension applies (An array of service ids).
        :param pulumi.Input[_builtins.str] extension_schema: This is the schema for this extension.
        :param pulumi.Input[_builtins.str] name: The name of the service extension.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExtensionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An [extension](https://developer.pagerduty.com/api-reference/b3A6Mjc0ODEzMw-create-an-extension) can be associated with a service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_pagerduty as pagerduty

        webhook = pagerduty.get_extension_schema(name="Generic V2 Webhook")
        example = pagerduty.User("example",
            name="Howard James",
            email="howard.james@example.domain")
        example_escalation_policy = pagerduty.EscalationPolicy("example",
            name="Engineering Escalation Policy",
            num_loops=2,
            rules=[{
                "escalation_delay_in_minutes": 10,
                "targets": [{
                    "type": "user",
                    "id": example.id,
                }],
            }])
        example_service = pagerduty.Service("example",
            name="My Web App",
            auto_resolve_timeout="14400",
            acknowledgement_timeout="600",
            escalation_policy=example_escalation_policy.id)
        slack = pagerduty.Extension("slack",
            name="My Web App Extension",
            endpoint_url="https://generic_webhook_url/XXXXXX/BBBBBB",
            extension_schema=webhook.id,
            extension_objects=[example_service.id],
            config=\"\"\"{
        \\x09"restrict": "any",
        \\x09"notify_types": {
        \\x09\\x09\\x09"resolve": false,
        \\x09\\x09\\x09"acknowledge": false,
        \\x09\\x09\\x09"assignments": false
        \\x09},
        \\x09"access_token": "XXX"
        }
        \"\"\")
        ```

        ## Import

        Extensions can be imported using the id.e.g.

        ```sh
        $ pulumi import pagerduty:index/extension:Extension main PLBP09X
        ```

        :param str resource_name: The name of the resource.
        :param ExtensionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExtensionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_url: Optional[pulumi.Input[_builtins.str]] = None,
                 extension_objects: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 extension_schema: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExtensionArgs.__new__(ExtensionArgs)

            __props__.__dict__["config"] = config
            __props__.__dict__["endpoint_url"] = None if endpoint_url is None else pulumi.Output.secret(endpoint_url)
            if extension_objects is None and not opts.urn:
                raise TypeError("Missing required property 'extension_objects'")
            __props__.__dict__["extension_objects"] = extension_objects
            if extension_schema is None and not opts.urn:
                raise TypeError("Missing required property 'extension_schema'")
            __props__.__dict__["extension_schema"] = extension_schema
            __props__.__dict__["name"] = name
            __props__.__dict__["type"] = type
            __props__.__dict__["html_url"] = None
            __props__.__dict__["summary"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["endpointUrl"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Extension, __self__).__init__(
            'pagerduty:index/extension:Extension',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config: Optional[pulumi.Input[_builtins.str]] = None,
            endpoint_url: Optional[pulumi.Input[_builtins.str]] = None,
            extension_objects: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            extension_schema: Optional[pulumi.Input[_builtins.str]] = None,
            html_url: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            summary: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'Extension':
        """
        Get an existing Extension resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] config: The configuration of the service extension as string containing plain JSON-encoded data.
        :param pulumi.Input[_builtins.str] endpoint_url: The url of the extension.
               **Note:** The [endpoint URL is Optional API wise](https://api-reference.pagerduty.com/#!/Extensions/post_extensions) in most cases. But in some cases it is a _Required_ parameter. For example, `get_extension_schema` named `Generic V2 Webhook` doesn't accept `Extension` with no `endpoint_url`, but one with named `Slack` accepts.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] extension_objects: This is the objects for which the extension applies (An array of service ids).
        :param pulumi.Input[_builtins.str] extension_schema: This is the schema for this extension.
        :param pulumi.Input[_builtins.str] html_url: URL at which the entity is uniquely displayed in the Web app
        :param pulumi.Input[_builtins.str] name: The name of the service extension.
        :param pulumi.Input[_builtins.str] summary: A short-form, server-generated string that provides succinct, important information about an object suitable for primary labeling of an entity in a client. In many cases, this will be identical to `name`, though it is not intended to be an identifier.
               
               **Note:** You can use the `get_extension_schema` data source to locate the appropriate extension vendor ID.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExtensionState.__new__(_ExtensionState)

        __props__.__dict__["config"] = config
        __props__.__dict__["endpoint_url"] = endpoint_url
        __props__.__dict__["extension_objects"] = extension_objects
        __props__.__dict__["extension_schema"] = extension_schema
        __props__.__dict__["html_url"] = html_url
        __props__.__dict__["name"] = name
        __props__.__dict__["summary"] = summary
        __props__.__dict__["type"] = type
        return Extension(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def config(self) -> pulumi.Output[_builtins.str]:
        """
        The configuration of the service extension as string containing plain JSON-encoded data.
        """
        return pulumi.get(self, "config")

    @_builtins.property
    @pulumi.getter(name="endpointUrl")
    def endpoint_url(self) -> pulumi.Output[_builtins.str]:
        """
        The url of the extension.
        **Note:** The [endpoint URL is Optional API wise](https://api-reference.pagerduty.com/#!/Extensions/post_extensions) in most cases. But in some cases it is a _Required_ parameter. For example, `get_extension_schema` named `Generic V2 Webhook` doesn't accept `Extension` with no `endpoint_url`, but one with named `Slack` accepts.
        """
        return pulumi.get(self, "endpoint_url")

    @_builtins.property
    @pulumi.getter(name="extensionObjects")
    def extension_objects(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        This is the objects for which the extension applies (An array of service ids).
        """
        return pulumi.get(self, "extension_objects")

    @_builtins.property
    @pulumi.getter(name="extensionSchema")
    def extension_schema(self) -> pulumi.Output[_builtins.str]:
        """
        This is the schema for this extension.
        """
        return pulumi.get(self, "extension_schema")

    @_builtins.property
    @pulumi.getter(name="htmlUrl")
    def html_url(self) -> pulumi.Output[_builtins.str]:
        """
        URL at which the entity is uniquely displayed in the Web app
        """
        return pulumi.get(self, "html_url")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the service extension.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def summary(self) -> pulumi.Output[_builtins.str]:
        """
        A short-form, server-generated string that provides succinct, important information about an object suitable for primary labeling of an entity in a client. In many cases, this will be identical to `name`, though it is not intended to be an identifier.

        **Note:** You can use the `get_extension_schema` data source to locate the appropriate extension vendor ID.
        """
        return pulumi.get(self, "summary")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "type")

