# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['TagArgs', 'Tag']

@pulumi.input_type
class TagArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a Tag resource.
        :param pulumi.Input[_builtins.str] label: The label of the tag.
        """
        pulumi.set(__self__, "label", label)

    @_builtins.property
    @pulumi.getter
    def label(self) -> pulumi.Input[_builtins.str]:
        """
        The label of the tag.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "label", value)


@pulumi.input_type
class _TagState:
    def __init__(__self__, *,
                 html_url: Optional[pulumi.Input[_builtins.str]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 summary: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Tag resources.
        :param pulumi.Input[_builtins.str] html_url: URL at which the entity is uniquely displayed in the Web app.
        :param pulumi.Input[_builtins.str] label: The label of the tag.
        :param pulumi.Input[_builtins.str] summary: A short-form, server-generated string that provides succinct, important information about an object suitable for primary labeling of an entity in a client. In many cases, this will be identical to name, though it is not intended to be an identifier.
        """
        if html_url is not None:
            pulumi.set(__self__, "html_url", html_url)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if summary is not None:
            pulumi.set(__self__, "summary", summary)

    @_builtins.property
    @pulumi.getter(name="htmlUrl")
    def html_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL at which the entity is uniquely displayed in the Web app.
        """
        return pulumi.get(self, "html_url")

    @html_url.setter
    def html_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "html_url", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The label of the tag.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter
    def summary(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A short-form, server-generated string that provides succinct, important information about an object suitable for primary labeling of an entity in a client. In many cases, this will be identical to name, though it is not intended to be an identifier.
        """
        return pulumi.get(self, "summary")

    @summary.setter
    def summary(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "summary", value)


@pulumi.type_token("pagerduty:index/tag:Tag")
class Tag(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A [tag](https://developer.pagerduty.com/api-reference/b3A6Mjc0ODIxOA-create-a-tag) is applied to Escalation Policies, Teams or Users and can be used to filter them.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_pagerduty as pagerduty

        example = pagerduty.Tag("example", label="Product")
        ```

        ## Import

        Tags can be imported using the `id`, e.g.

        ```sh
        $ pulumi import pagerduty:index/tag:Tag main PLBP09X
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] label: The label of the tag.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TagArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A [tag](https://developer.pagerduty.com/api-reference/b3A6Mjc0ODIxOA-create-a-tag) is applied to Escalation Policies, Teams or Users and can be used to filter them.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_pagerduty as pagerduty

        example = pagerduty.Tag("example", label="Product")
        ```

        ## Import

        Tags can be imported using the `id`, e.g.

        ```sh
        $ pulumi import pagerduty:index/tag:Tag main PLBP09X
        ```

        :param str resource_name: The name of the resource.
        :param TagArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TagArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TagArgs.__new__(TagArgs)

            if label is None and not opts.urn:
                raise TypeError("Missing required property 'label'")
            __props__.__dict__["label"] = label
            __props__.__dict__["html_url"] = None
            __props__.__dict__["summary"] = None
        super(Tag, __self__).__init__(
            'pagerduty:index/tag:Tag',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            html_url: Optional[pulumi.Input[_builtins.str]] = None,
            label: Optional[pulumi.Input[_builtins.str]] = None,
            summary: Optional[pulumi.Input[_builtins.str]] = None) -> 'Tag':
        """
        Get an existing Tag resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] html_url: URL at which the entity is uniquely displayed in the Web app.
        :param pulumi.Input[_builtins.str] label: The label of the tag.
        :param pulumi.Input[_builtins.str] summary: A short-form, server-generated string that provides succinct, important information about an object suitable for primary labeling of an entity in a client. In many cases, this will be identical to name, though it is not intended to be an identifier.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TagState.__new__(_TagState)

        __props__.__dict__["html_url"] = html_url
        __props__.__dict__["label"] = label
        __props__.__dict__["summary"] = summary
        return Tag(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="htmlUrl")
    def html_url(self) -> pulumi.Output[_builtins.str]:
        """
        URL at which the entity is uniquely displayed in the Web app.
        """
        return pulumi.get(self, "html_url")

    @_builtins.property
    @pulumi.getter
    def label(self) -> pulumi.Output[_builtins.str]:
        """
        The label of the tag.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def summary(self) -> pulumi.Output[_builtins.str]:
        """
        A short-form, server-generated string that provides succinct, important information about an object suitable for primary labeling of an entity in a client. In many cases, this will be identical to name, though it is not intended to be an identifier.
        """
        return pulumi.get(self, "summary")

