# Copyright (c) Meta Platforms, Inc. and affiliates.
# All rights reserved.

# This source code is licensed under the license found in the
# LICENSE file in the root directory of this source tree.

from facebook_business.adobjects.abstractobject import AbstractObject

"""
This class is auto-generated.

For any issues or feature requests related to this class, please let us know on
github and we'll fix in our codegen framework. We'll not be able to accept
pull request for this class.
"""

class AdRuleHistory(
    AbstractObject,
):

    def __init__(self, api=None):
        super(AdRuleHistory, self).__init__()
        self._isAdRuleHistory = True
        self._api = api

    class Field(AbstractObject.Field):
        evaluation_spec = 'evaluation_spec'
        exception_code = 'exception_code'
        exception_message = 'exception_message'
        execution_spec = 'execution_spec'
        is_manual = 'is_manual'
        results = 'results'
        schedule_spec = 'schedule_spec'
        timestamp = 'timestamp'

    class Action:
        budget_not_redistributed = 'BUDGET_NOT_REDISTRIBUTED'
        changed_bid = 'CHANGED_BID'
        changed_budget = 'CHANGED_BUDGET'
        consolidate_asc_fragmentation = 'CONSOLIDATE_ASC_FRAGMENTATION'
        consolidate_fragmentation = 'CONSOLIDATE_FRAGMENTATION'
        convert_asc_cp_single_instance = 'CONVERT_ASC_CP_SINGLE_INSTANCE'
        email = 'EMAIL'
        enable_advantage_campaign_budget = 'ENABLE_ADVANTAGE_CAMPAIGN_BUDGET'
        enable_advantage_plus_audience = 'ENABLE_ADVANTAGE_PLUS_AUDIENCE'
        enable_advantage_plus_creative = 'ENABLE_ADVANTAGE_PLUS_CREATIVE'
        enable_advantage_plus_placements = 'ENABLE_ADVANTAGE_PLUS_PLACEMENTS'
        enable_autoflow = 'ENABLE_AUTOFLOW'
        enable_gen_uncrop = 'ENABLE_GEN_UNCROP'
        enable_landing_page_views = 'ENABLE_LANDING_PAGE_VIEWS'
        enable_music = 'ENABLE_MUSIC'
        enable_reels_placements = 'ENABLE_REELS_PLACEMENTS'
        enable_semantic_based_audience_expansion = 'ENABLE_SEMANTIC_BASED_AUDIENCE_EXPANSION'
        enable_shops_ads = 'ENABLE_SHOPS_ADS'
        endpoint_pinged = 'ENDPOINT_PINGED'
        error = 'ERROR'
        facebook_notification_sent = 'FACEBOOK_NOTIFICATION_SENT'
        message_sent = 'MESSAGE_SENT'
        not_changed = 'NOT_CHANGED'
        paused = 'PAUSED'
        unpaused = 'UNPAUSED'

    _field_types = {
        'evaluation_spec': 'AdRuleEvaluationSpec',
        'exception_code': 'int',
        'exception_message': 'string',
        'execution_spec': 'AdRuleExecutionSpec',
        'is_manual': 'bool',
        'results': 'list<AdRuleHistoryResult>',
        'schedule_spec': 'AdRuleScheduleSpec',
        'timestamp': 'datetime',
    }
    @classmethod
    def _get_field_enum_info(cls):
        field_enum_info = {}
        field_enum_info['Action'] = AdRuleHistory.Action.__dict__.values()
        return field_enum_info


